/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.util.concurrent;

import org.apache.yoko.util.Cache;
import org.apache.yoko.util.KeyedFactory;
import org.apache.yoko.util.concurrent.CountedEntry;
import org.apache.yoko.util.concurrent.ReferenceCountedCache;
import org.apache.yoko.util.concurrent.WeakConcurrentFifo;

public class WeakCountedCache<K, V>
extends ReferenceCountedCache<K, V> {
    private final WeakConcurrentFifo<CountedEntry.ValueReference> referenceTracker = new WeakConcurrentFifo<CountedEntry.ValueReference>(new CleanupFactory());

    public WeakCountedCache(Cache.Cleaner<V> cleaner, int threshold, int sweep) {
        super(cleaner, threshold, sweep);
    }

    @Override
    protected CountedEntry.ValueReference track(CountedEntry.ValueReference ref) {
        if (ref != null) {
            this.referenceTracker.put(ref);
        }
        return ref;
    }

    private final class CleanupFactory
    implements KeyedFactory<CountedEntry.ValueReference, Runnable> {
        private CleanupFactory() {
        }

        @Override
        public Runnable create(CountedEntry.ValueReference key) {
            return key.getCloserTask();
        }
    }
}

