/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channelfw.internal.ConnectionDescriptorImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.tcpchannel.internal.ConnectionManager;
import com.ibm.ws.tcpchannel.internal.SimpleSync;
import com.ibm.ws.tcpchannel.internal.SocketIOChannel;
import com.ibm.ws.tcpchannel.internal.TCPChannel;
import com.ibm.ws.tcpchannel.internal.TCPChannelConfiguration;
import com.ibm.ws.tcpchannel.internal.TCPProxyConnLink;
import com.ibm.ws.tcpchannel.internal.TCPProxyResponse;
import com.ibm.ws.tcpchannel.internal.TCPReadRequestContextImpl;
import com.ibm.ws.tcpchannel.internal.TCPWriteRequestContextImpl;
import com.ibm.wsspi.channelfw.ConnectionDescriptor;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.OutboundConnectionLink;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.SSLConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPConnectRequestContext;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TCPConnLink
extends TCPProxyConnLink
implements ConnectionLink,
OutboundConnectionLink,
TCPConnectionContext,
FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register(TCPConnLink.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    private TCPChannelConfiguration config;
    private TCPChannel tcpChannel = null;
    private int numReads = 0;
    private int numWrites = 0;
    private TCPReadRequestContextImpl reader;
    private TCPWriteRequestContextImpl writer;
    private SocketIOChannel socketIOChannel;
    private SimpleSync syncObject = null;
    private IOException syncError = null;
    private TCPProxyResponse proxy = null;
    private boolean callCompleteLocal = false;
    private boolean closed = false;
    private int inUseIndex = 0;

    public TCPConnLink(VirtualConnection vc, TCPChannel channel, TCPChannelConfiguration cfg, int index) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"TCPConnLink", (Object[])new Object[0]);
        }
        this.init(vc);
        this.inUseIndex = index;
        this.tcpChannel = channel;
        this.config = cfg;
        this.reader = channel.createReadInterface(this);
        this.writer = channel.createWriteInterface(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TCPConnLink");
        }
    }

    @Override
    public void ready(VirtualConnection inVC) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Invalid call to ready: " + inVC), (Object[])new Object[0]);
        }
    }

    @Override
    public Object getChannelAccessor() {
        return this;
    }

    public TCPChannel getTCPChannel() {
        return this.tcpChannel;
    }

    @Override
    public TCPReadRequestContext getReadInterface() {
        return this.reader;
    }

    @Override
    public TCPWriteRequestContext getWriteInterface() {
        return this.writer;
    }

    protected TCPReadRequestContextImpl getTCPReadConnLink() {
        return this.reader;
    }

    protected TCPWriteRequestContextImpl getTCPWriteConnLink() {
        return this.writer;
    }

    @Override
    public void connect(Object context) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connect", (Object[])new Object[0]);
        }
        this.syncObject = new SimpleSync();
        if (this.proxy != null) {
            this.proxy.setIsProxyResponseValid(false);
        }
        this.syncError = null;
        this.connectCommon((TCPConnectRequestContext)context);
        if (this.syncError != null) {
            throw this.syncError;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connect");
        }
    }

    @Override
    public void connectAsynch(Object context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connectAsynch", (Object[])new Object[0]);
        }
        this.syncObject = null;
        if (this.proxy != null) {
            this.proxy.setIsProxyResponseValid(false);
        }
        this.connectCommon((TCPConnectRequestContext)context);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connectAsynch");
        }
    }

    protected void connectCommon(TCPConnectRequestContext context) {
        ConnectionManager connMgr = this.getTCPChannel().getConnMgr();
        TCPConnectRequestContext connectContext = context;
        SocketIOChannel ioSocket = null;
        if (this.socketIOChannel != null) {
            this.socketIOChannel.close();
            this.socketIOChannel = null;
        }
        try {
            this.callCompleteLocal = false;
            ioSocket = connMgr.getConnection(connectContext, this, this.syncObject);
            if (this.callCompleteLocal) {
                this.connectComplete(ioSocket);
            }
        }
        catch (IOException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("SocketChannel connect failed, local: " + connectContext.getLocalAddress() + " remote: " + connectContext.getRemoteAddress() + " ioe=" + e), (Object[])new Object[0]);
            }
            this.connectFailed(e);
        }
    }

    protected void connectComplete(SocketIOChannel socket) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connectComplete", (Object[])new Object[0]);
        }
        this.setSocketIOChannel(socket);
        Socket s = socket.getSocket();
        InetAddress remote = s.getInetAddress();
        InetAddress local = s.getLocalAddress();
        ConnectionDescriptor cd = this.getVirtualConnection().getConnectionDescriptor();
        if (cd != null) {
            cd.setAddrs(remote, local);
        } else {
            ConnectionDescriptorImpl cdi = new ConnectionDescriptorImpl(remote, local);
            this.getVirtualConnection().setConnectionDescriptor(cdi);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Connection Complete for: " + this.getVirtualConnection().getConnectionDescriptor()), (Object[])new Object[0]);
        }
        this.getVirtualConnection().attemptToSetFileChannelCapable(2);
        socket.connectActions();
        Object forwardProxyConnectObj = this.getVirtualConnection().getStateMap().get("FORWARD_PROXY_CONNECT");
        if (null != forwardProxyConnectObj) {
            if (this.proxy == null) {
                this.proxy = new TCPProxyResponse(this);
            }
            boolean rc = false;
            try {
                rc = this.proxy.setForwardProxyBuffers((Map)forwardProxyConnectObj);
            }
            catch (ClassCastException cce) {
                FFDCFilter.processException((Throwable)cce, (String)(this.getClass().getName() + ".connectComplete"), (String)"300");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Incorrect forward proxy setup: " + cce), (Object[])new Object[0]);
                }
                this.connectFailed(new IOException(cce.getMessage()));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"connectComplete");
                }
                return;
            }
            if (rc) {
                this.proxy.writeAndShake();
            }
        } else if (this.syncObject == null) {
            this.getApplicationCallback().ready(this.getVirtualConnection());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connectComplete");
        }
    }

    @Override
    protected boolean isAsyncConnect() {
        return null == this.syncObject;
    }

    @Override
    protected boolean isSyncError() {
        return null != this.syncError;
    }

    protected void setCallCompleteLocal(boolean newValue) {
        this.callCompleteLocal = newValue;
    }

    @Override
    protected void connectFailed(IOException e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connectFailed", (Object[])new Object[0]);
        }
        if (this.socketIOChannel != null) {
            this.socketIOChannel.close();
            this.socketIOChannel = null;
        }
        if (this.isAsyncConnect()) {
            this.close(this.getVirtualConnection(), e);
        } else {
            this.syncError = e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connectFailed");
        }
    }

    protected void setSocketIOChannel(SocketIOChannel s) {
        this.socketIOChannel = s;
    }

    public SocketIOChannel getSocketIOChannel() {
        return this.socketIOChannel;
    }

    public TCPChannelConfiguration getConfig() {
        return this.config;
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.socketIOChannel.getSocket().getInetAddress();
    }

    @Override
    public int getRemotePort() {
        return this.socketIOChannel.getSocket().getPort();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.socketIOChannel.getSocket().getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.socketIOChannel.getSocket().getLocalPort();
    }

    @Override
    public SSLConnectionContext getSSLContext() {
        return null;
    }

    protected int getNumReads() {
        return this.numReads;
    }

    protected int getNumWrites() {
        return this.numWrites;
    }

    public void incrementNumReads() {
        ++this.numReads;
    }

    public void incrementNumWrites() {
        ++this.numWrites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(VirtualConnection inVC, Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("close(), " + this), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            try {
                if (inVC != null) {
                    Tr.debug((TraceComponent)tc, (String)("Closing the connection: " + inVC.getConnectionDescriptor()), (Object[])new Object[0]);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        boolean processClose = true;
        TCPConnLink tCPConnLink = this;
        synchronized (tCPConnLink) {
            if (this.closed) {
                processClose = false;
            }
            this.closed = true;
        }
        if (processClose) {
            super.close(inVC, e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close()");
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void destroy(Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            if (e == null) {
                Tr.entry((TraceComponent)tc, (String)"destroy(null)", (Object[])new Object[0]);
            } else {
                Tr.entry((TraceComponent)tc, (String)("destroy(Exc) " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && this.getVirtualConnection().getConnectionDescriptor() != null) {
            Tr.debug((TraceComponent)tc, (String)("Destroying the connection: " + this.getVirtualConnection().getConnectionDescriptor()), (Object[])new Object[0]);
        }
        if (this.socketIOChannel != null) {
            this.socketIOChannel.close();
            this.tcpChannel.decrementConnectionCount();
        }
        this.socketIOChannel = null;
        this.reader = null;
        this.writer = null;
        super.destroy(e);
        this.tcpChannel.releaseConnectionLink(this, this.inUseIndex);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy()");
        }
    }

    public List<String> introspect() {
        LinkedList<String> rc = new LinkedList<String>();
        String prefix = this.getClass().getSimpleName() + "@" + this.hashCode() + ": ";
        rc.add(prefix + "tcpChannel=" + this.tcpChannel);
        rc.add(prefix + "closed=" + this.closed);
        rc.add(prefix + "socketIOChannel=" + this.socketIOChannel);
        if (null != this.socketIOChannel) {
            rc.addAll(this.socketIOChannel.introspect());
        }
        rc.add(prefix + "numReads=" + this.numReads);
        rc.add(prefix + "numWrites=" + this.numWrites);
        rc.add(prefix + "callCompleteLocal=" + this.callCompleteLocal);
        return rc;
    }

    public String[] introspectSelf() {
        List<String> rc = this.introspect();
        return rc.toArray(new String[rc.size()]);
    }
}

