/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal.chains;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channelfw.internal.ChainDataImpl;
import com.ibm.ws.channelfw.internal.RuntimeState;
import com.ibm.ws.channelfw.internal.chains.StopChainTask;
import com.ibm.wsspi.channelfw.Channel;

public abstract class Chain {
    private static final TraceComponent tc = Tr.register(Chain.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    protected Channel[] channels = null;
    protected ChainDataImpl chainData = null;
    protected RuntimeState state = RuntimeState.UNINITIALIZED;
    protected ChannelData[] channelDataArray = null;
    private StopChainTask stopChainTask = null;

    public Chain(ChainData config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"constructor", (Object[])new Object[0]);
        }
        this.chainData = (ChainDataImpl)config;
        this.state = RuntimeState.UNINITIALIZED;
        this.channelDataArray = new ChannelData[this.chainData.getChannelList().length];
        for (int i = 0; i < this.channelDataArray.length; ++i) {
            this.channelDataArray[i] = this.chainData.getChannelList()[i];
            this.channelDataArray[i].getPropertyBag().put("chainData", config);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"constructor");
        }
    }

    public String getName() {
        return this.chainData.getName();
    }

    public ChainData getChainData() {
        return this.chainData;
    }

    public Channel[] getChannels() {
        return this.channels;
    }

    public ChannelData[] getChannelsData() {
        return this.channelDataArray;
    }

    public RuntimeState getState() {
        return this.state;
    }

    public boolean containsChannel(String channelName) {
        boolean found = false;
        for (int i = 0; i < this.channels.length; ++i) {
            if (!this.channels[i].getName().equals(channelName)) continue;
            found = true;
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("containsChannel: " + channelName + "=" + found), (Object[])new Object[0]);
        }
        return found;
    }

    public void setStopTask(StopChainTask task) {
        this.stopChainTask = task;
    }

    public StopChainTask getStopTask() {
        return this.stopChainTask;
    }

    public void init() {
        this.state = RuntimeState.INITIALIZED;
        this.chainData.chainInitialized();
    }

    public void start() {
        this.state = RuntimeState.STARTED;
        this.chainData.chainStarted();
    }

    public void quiesce() {
        this.state = RuntimeState.QUIESCED;
        this.chainData.chainQuiesced();
    }

    public void stop() {
        this.state = RuntimeState.INITIALIZED;
        this.chainData.chainStopped();
    }

    public void destroy() {
        this.state = RuntimeState.UNINITIALIZED;
        this.chainData.chainDestroyed();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Chain: ");
        sb.append(this.chainData.getName());
        sb.append("\r\n\ttype = ").append(this.chainData.getType().getOrdinal());
        sb.append("\r\n\tstate: ").append(this.state.ordinal);
        return sb.toString();
    }
}

