/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.persistent.htod;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.HTODDynacache;
import com.ibm.ws.cache.PrimitiveArrayPool;
import com.ibm.ws.cache.persistent.filemgr.FileManager;
import com.ibm.ws.cache.persistent.filemgr.FileManagerException;
import com.ibm.ws.cache.persistent.filemgr.FileManagerImpl;
import com.ibm.ws.cache.persistent.htod.HashHeader;
import com.ibm.ws.cache.persistent.htod.HashtableAction;
import com.ibm.ws.cache.persistent.htod.HashtableEntry;
import com.ibm.ws.cache.persistent.htod.HashtableInitInterface;
import com.ibm.ws.cache.persistent.htod.HashtableOnDiskException;
import com.ibm.ws.cache.persistent.htod.Rehash;
import com.ibm.ws.cache.persistent.htod.Semaphore;
import com.ibm.ws.cache.persistent.util.ByteArrayPlusOutputStream;
import com.ibm.ws.cache.persistent.util.ProfTimer;
import com.ibm.ws.cache.util.SerializationUtility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class HashtableOnDisk {
    private static final boolean IS_UNIT_TEST = false;
    private static final int RETRIEVE_KEY = 1;
    private static final int RETRIEVE_KEY_VALUE = 2;
    private static final int RETRIEVE_ALL = 3;
    public static final boolean HAS_CACHE_VALUE = true;
    public static final boolean CHECK_EXPIRED = true;
    public static final boolean ALIAS_ID = true;
    static TraceComponent tc = Tr.register(HashtableOnDisk.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    HashHeader header = null;
    HTODDynacache htoddc = null;
    int defaulttablesize = 477551;
    long[] htindex = null;
    long[] new_htindex = null;
    int threshold;
    Semaphore iterationLock;
    FileManager filemgr = null;
    long currentTable = 0L;
    String filename = null;
    boolean debug = false;
    ByteArrayPlusOutputStream dataout = null;
    byte[] databuf = null;
    ByteArrayPlusOutputStream keyout = null;
    byte[] keybuf = null;
    HashtableInitInterface item_initialize = null;
    boolean readonly = false;
    byte[] headeroutbuf = null;
    ByteArrayOutputStream headeroutbytestream = null;
    DataOutputStream headerout = null;
    byte[] headerinbuf = null;
    ByteArrayInputStream headerinbytestream = null;
    DataInputStream headerin = null;
    ArrayList<Integer> rangeIndexList = new ArrayList();
    public int rangeExpiredIndex = 0;
    static final int DWORDSIZE = 8;
    static final int SWORDSIZE = 4;
    static final int magic = 71750002;
    static final long HTENTRY_MAGIC = 1326310090260611072L;
    static final long HTENTRY_VERSION = 0x10000000000L;
    static final long HTENTRY_MAGIC_MASK = -281474976710656L;
    static final long HTENTRY_VERSION_MASK = 0xFF0000000000L;
    static final long HTENTRY_FLAGS_MASK = 0xFF00000000L;
    static final long HTENTRY_DATA_SIZE_MASK = 0xFFFFFFFFL;
    static final long HTENTRY_HASHCODE_MASK = 0xFFFFFFFFL;
    static final long HTENTRY_ALIAS_ID = 0x100000000L;
    public static final int HTENTRY_OVERHEAD_SIZE = 68;
    public static final int HT_INITIAL_OVERHEAD_SIZE = 16900;
    int collisions = 0;
    int read_requests = 0;
    int read_hits = 0;
    int write_replacements = 0;
    int write_requests = 0;
    long bytes_deserialized = 0L;
    long bytes_serialized = 0L;
    int removes = 0;
    int clears = 0;
    boolean auto_rehash = false;
    ProfTimer serializeTimer = null;
    ProfTimer deserializeTimer = null;
    long serialize_time = 0L;
    long deserialize_time = 0L;
    public int tempTableSize = 0;
    public boolean bHasCacheValue = false;

    public void setDebug(boolean d) {
        this.debug = d;
    }

    protected HashtableOnDisk(FileManager fm, boolean auto_rehash, long instanceid, boolean hasCacheValue, HTODDynacache htoddc) throws FileManagerException, ClassNotFoundException, IOException, HashtableOnDiskException {
        this.init(fm, auto_rehash, instanceid, null, hasCacheValue, htoddc);
    }

    protected HashtableOnDisk(FileManager fm, boolean auto_rehash, long instanceid, HashtableInitInterface initfn, boolean hasCacheValue, HTODDynacache htoddc) throws FileManagerException, ClassNotFoundException, IOException, HashtableOnDiskException {
        this.init(fm, auto_rehash, instanceid, initfn, hasCacheValue, htoddc);
    }

    protected void init(FileManager filemgr, boolean auto_rehash, long instanceid, HashtableInitInterface item_initialize, boolean hasCacheValue, HTODDynacache htoddc) throws FileManagerException, ClassNotFoundException, IOException, HashtableOnDiskException {
        this.filemgr = filemgr;
        this.filename = filemgr.filename();
        this.item_initialize = item_initialize;
        this.readonly = filemgr.isReadOnly();
        this.auto_rehash = auto_rehash;
        this.bHasCacheValue = hasCacheValue;
        this.htoddc = htoddc;
        this.header = new HashHeader(filemgr, instanceid);
        if (this.header.magic != 71750002) {
            throw new HashtableOnDiskException("Invalid magic string. Expected 71750002 received " + this.header.magic);
        }
        this.currentTable = this.header.currentTable();
        this.threshold = this.header.loadFactor * this.header.tablesize() / 100;
        this.cacheHTIndex();
        this.serializeTimer = new ProfTimer();
        this.deserializeTimer = new ProfTimer();
        this.iterationLock = new Semaphore();
        if (this.header.rehashInProgress != 0L) {
            this.recover();
            this.cacheHTIndex();
            this.iterationLock.p();
            this.iterationLock.v();
        }
        if (this.header.num_objects() == 0) {
            this.countObjects();
        }
        filemgr.flush();
    }

    void cacheHTIndex() throws IOException {
        PrimitiveArrayPool.PoolEntry longPoolEntry = this.htoddc.longArrayPool.allocate(this.header.tablesize());
        this.htindex = (long[])longPoolEntry.getArray();
        PrimitiveArrayPool.PoolEntry bytePoolEntry = this.htoddc.byteArrayPool.allocate(this.header.tablesize() * 8);
        byte[] tmp = (byte[])bytePoolEntry.getArray();
        this.filemgr.seek(this.currentTable);
        this.filemgr.read(tmp);
        DataInputStream das = new DataInputStream(new ByteArrayInputStream(tmp));
        for (int i = 0; i < this.header.tablesize(); ++i) {
            this.htindex[i] = das.readLong();
        }
        das.close();
        this.htoddc.byteArrayPool.returnToPool(bytePoolEntry);
    }

    public static HashtableOnDisk getInstance(FileManager filemgr, boolean auto_rehash, long instanceid, boolean hasCacheValue, HTODDynacache htoddc) throws FileManagerException, ClassNotFoundException, IOException, HashtableOnDiskException {
        return HashtableOnDisk.getStaticInstance(filemgr, auto_rehash, instanceid, null, hasCacheValue, htoddc);
    }

    public static HashtableOnDisk getStaticInstance(FileManager filemgr, boolean auto_rehash, long instanceid, HashtableInitInterface initfn, boolean hasCacheValue, HTODDynacache htoddc) throws FileManagerException, ClassNotFoundException, IOException, HashtableOnDiskException {
        if (instanceid == 0L) {
            instanceid = filemgr.start();
        }
        HashtableOnDisk answer = null;
        try {
            answer = new HashtableOnDisk(filemgr, auto_rehash, instanceid, initfn, hasCacheValue, htoddc);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return answer;
    }

    public static long createInstance(FileManager fm, int tablesize, int load) throws IOException, HashtableOnDiskException {
        HashHeader header = new HashHeader(fm, 71750002, load, tablesize);
        return header.disklocation;
    }

    public static void destroyInstance(FileManager fm, long instanceid) throws IOException, HashtableOnDiskException {
        if (instanceid == 0L) {
            throw new HashtableOnDiskException("Attempt to destroy instance 0");
        }
        fm.deallocate(instanceid);
    }

    public FileManager getFileManager() {
        return this.filemgr;
    }

    public static boolean exists(String filename, int type) {
        File checkfile = type == 1 ? new File(filename + "." + 0) : new File(filename);
        return checkfile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.iterationLock.p();
        try {
            HashtableOnDisk hashtableOnDisk = this;
            synchronized (hashtableOnDisk) {
                this.header.write();
                this.filemgr = null;
            }
        }
        finally {
            this.releaseMemoryToPool();
            this.iterationLock.v();
        }
    }

    public synchronized int size() {
        return this.header.num_objects();
    }

    public int tablesize() {
        return this.header.tablesize();
    }

    public int getNextRangeIndex() {
        int length = this.rangeIndexList.size();
        if (length > 0) {
            Integer rindex = this.rangeIndexList.get(length - 1);
            return rindex;
        }
        return 0;
    }

    public int getPreviousRangeIndex() {
        int length = this.rangeIndexList.size();
        if (length == 2) {
            this.rangeIndexList.remove(1);
            return 0;
        }
        if (length == 1) {
            return 0;
        }
        this.rangeIndexList.remove(length - 1);
        this.rangeIndexList.remove(length - 2);
        Integer rindex = this.rangeIndexList.get(length - 3);
        return rindex;
    }

    public void addRangeIndex(int index) {
        this.rangeIndexList.add(new Integer(index));
    }

    public void initRangeIndex() {
        this.rangeIndexList.clear();
        this.rangeIndexList.add(new Integer(0));
    }

    public String getFilename() {
        return this.filename;
    }

    public int load() {
        return this.header.loadFactor;
    }

    public void dump_filemgr_header(Writer out) throws IOException {
        this.filemgr.dump_stats_header(out);
    }

    public void dump_filemgr_stats(Writer out, boolean labels) throws IOException {
        this.filemgr.dump_stats(out, labels);
    }

    public void dump_filemgr_memory(Writer out) throws IOException {
        this.filemgr.dump_memory(out);
    }

    public void dump_filemgr_disk(Writer out) throws IOException {
        this.filemgr.dump_disk_memory(out);
    }

    public static boolean isByteArray(Object x) {
        Class<?> ct;
        if (x == null) {
            return false;
        }
        Class<?> c = x.getClass();
        return c.isArray() && (ct = c.getComponentType()) == Byte.TYPE;
    }

    public synchronized boolean containsKey(Object key) throws FileManagerException, ClassNotFoundException, IOException, HashtableOnDiskException {
        if (this.filemgr == null) {
            throw new HashtableOnDiskException("No Filemanager");
        }
        HashtableEntry e = this.findEntry(key, 1, false);
        boolean found = e != null;
        this.htoddc.returnToHashtableEntryPool(e);
        return found;
    }

    public synchronized Object get(Object key) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        HashtableEntry e;
        if (this.filemgr == null) {
            throw new HashtableOnDiskException("No Filemanager");
        }
        Object answer = null;
        if (answer == null && (e = this.findEntry(key, 3, false)) != null) {
            answer = e.value;
            this.htoddc.returnToHashtableEntryPool(e);
        }
        ++this.read_requests;
        if (answer != null) {
            ++this.read_hits;
        }
        return answer;
    }

    public synchronized HashtableEntry getHashTableEntry(Object key, boolean checkExpired) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (this.filemgr == null) {
            throw new HashtableOnDiskException("No Filemanager");
        }
        HashtableEntry e = this.findEntry(key, 3, checkExpired);
        ++this.read_requests;
        if (e != null) {
            ++this.read_hits;
        }
        return e;
    }

    public synchronized Object getCacheKey(HTODDynacache.EvictionTableEntry evt) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        Object key = null;
        if (this.filemgr == null) {
            throw new HashtableOnDiskException("No Filemanager");
        }
        HashtableEntry e = this.findEntry(evt, 1);
        if (e != null) {
            key = e.getKey();
        }
        return key;
    }

    public synchronized boolean put(Object key, byte[] value, int len, long expirationTime) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (key == null) {
            return false;
        }
        this.mapPut(key, value, len, expirationTime, -1L, null, null, 0, false);
        return true;
    }

    public synchronized HashtableEntry put(Object key, Object value, int len, long expirationTime, long validatorExpirationTime, byte[] serializedKey, byte[] serializedCacheValue, int valueHashcode, boolean isAliasId) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (key == null) {
            return null;
        }
        return this.mapPut(key, value, len, expirationTime, validatorExpirationTime, serializedKey, serializedCacheValue, valueHashcode, isAliasId);
    }

    public synchronized boolean put(Object key, Object value, long expirationTime) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (key == null) {
            return false;
        }
        this.mapPut(key, value, -1, expirationTime, -1L, null, null, 0, false);
        return true;
    }

    public synchronized boolean put(Object key, byte[] value, int len) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (key == null) {
            return false;
        }
        if (value == null) {
            len = -1;
        }
        this.mapPut(key, value, len, -1L, -1L, null, null, 0, false);
        return true;
    }

    public synchronized boolean put(Object key, Object value) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (key == null) {
            return false;
        }
        this.mapPut(key, value, -1, -1L, -1L, null, null, 0, false);
        return true;
    }

    protected HashtableEntry mapPut(Object key, Object value, int length, long expirationTime, long validatorExpirationTime, byte[] serializedKey, byte[] serializedCacheValue, int valueHashcode, boolean isAliasId) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        HashtableEntry e;
        if (this.filemgr == null) {
            throw new HashtableOnDiskException("No Filemanager");
        }
        ++this.write_requests;
        if (key == null) {
            return null;
        }
        if (this.auto_rehash && this.header.num_objects() + 1 > this.threshold && this.header.rehashInProgress == 0L) {
            this.rehash();
        }
        if ((e = this.findEntry(key, 1, false)) != null) {
            if (value == null) {
                return null;
            }
            HashtableEntry oldEntry = this.htoddc.getFromHashtableEntryPool();
            oldEntry.key = e.key;
            oldEntry.size = e.size;
            oldEntry.expiration = e.expiration;
            long old_location = e.location;
            e.value = value;
            e.valuelen = length;
            e.expiration = expirationTime;
            e.serializedKey = serializedKey;
            e.serializedCacheValue = serializedCacheValue;
            e.bAliasId = isAliasId;
            e.validatorExpiration = validatorExpirationTime;
            e.cacheValueHashcode = valueHashcode;
            if (this.getHtindex(e.index, e.tableid) == e.location) {
                this.updateHtindex(e.index, e.next, e.tableid);
            }
            e.location = 0L;
            this.writeEntry(e);
            this.filemgr.deallocate(old_location);
            this.filemgr.flush();
            ++this.write_replacements;
            this.htoddc.returnToHashtableEntryPool(e);
            return oldEntry;
        }
        int tableid = this.header.getTableidForNewEntry();
        HashtableEntry newEntry = this.htoddc.getFromHashtableEntryPool();
        newEntry.copy(key, value, this.header.tablesize(tableid), tableid, length, 0L, expirationTime, validatorExpirationTime, serializedKey, serializedCacheValue, valueHashcode, isAliasId);
        this.writeEntry(newEntry);
        this.header.incrementObjectCount();
        this.filemgr.flush();
        this.htoddc.returnToHashtableEntryPool(newEntry);
        return null;
    }

    public synchronized boolean remove(Object key) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (this.filemgr == null) {
            throw new HashtableOnDiskException("No Filemanager");
        }
        if (key == null) {
            return false;
        }
        HashtableEntry e = this.findEntry(key, 1, false);
        if (e == null) {
            return false;
        }
        boolean answer = this.remove(e);
        this.htoddc.returnToHashtableEntryPool(e);
        return answer;
    }

    public synchronized HashtableEntry getAndRemove(Object key, boolean bRetrieveCacheValue) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (this.filemgr == null) {
            throw new HashtableOnDiskException("No Filemanager");
        }
        if (key == null) {
            return null;
        }
        HashtableEntry hte = null;
        hte = bRetrieveCacheValue ? (key instanceof HTODDynacache.EvictionTableEntry ? this.findEntry((HTODDynacache.EvictionTableEntry)key, 3) : this.findEntry(key, 3, false)) : (key instanceof HTODDynacache.EvictionTableEntry ? this.findEntry((HTODDynacache.EvictionTableEntry)key, 2) : this.findEntry(key, 2, false));
        if (hte != null) {
            this.remove(hte);
        }
        return hte;
    }

    public synchronized boolean updateExpirationInHeader(Object key, long expirationTime, long validatorExpirationTime) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (this.filemgr == null) {
            throw new HashtableOnDiskException("No Filemanager");
        }
        if (key == null) {
            return false;
        }
        HashtableEntry entry = this.findEntry(key, 1, false);
        if (entry == null) {
            return false;
        }
        this.filemgr.seek(entry.location + 8L + 4L);
        this.filemgr.writeLong(validatorExpirationTime);
        this.htoddc.returnToHashtableEntryPool(entry);
        return true;
    }

    protected Object mapRemove(Object key) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (key == null) {
            return null;
        }
        HashtableEntry e = this.findEntry(key, 1, false);
        if (e == null) {
            return null;
        }
        Object answer = e.getValue();
        if (!this.remove(e)) {
            answer = null;
        }
        this.htoddc.returnToHashtableEntryPool(e);
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException, EOFException, FileManagerException {
        this.iterationLock.p();
        try {
            HashtableOnDisk hashtableOnDisk = this;
            synchronized (hashtableOnDisk) {
                if (this.filemgr == null) {
                    throw new HashtableOnDiskException("No Filemanager");
                }
                int tableid = this.header.currentTableId();
                ++this.clears;
                for (int i = 0; i < this.header.tablesize(); ++i) {
                    this.filemgr.seek(this.header.calcOffset(i, tableid));
                    long location = this.filemgr.readLong();
                    while (location != 0L) {
                        this.filemgr.seek(location);
                        long next = this.filemgr.readLong();
                        this.header.decrementObjectCount();
                        this.filemgr.deallocate(location);
                        location = next;
                    }
                    this.writeHashIndex(i, 0L, tableid);
                }
            }
        }
        finally {
            this.iterationLock.v();
        }
    }

    public int iterateObjects(HashtableAction action, int index, int length) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        return this.walkHash(action, 3, index, length);
    }

    public int iterateKeys(HashtableAction action, int index, int length) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        return this.walkHash(action, 1, index, length);
    }

    public void startRehash(int newsize) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (this.header.rehashInProgress == 0L) {
            this.doRehash(newsize);
        }
    }

    private boolean remove(HashtableEntry entry) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (entry == null) {
            throw new HashtableOnDiskException("remove: Internal error, null entry.");
        }
        ++this.removes;
        if (entry.location == this.getHtindex(entry.index, entry.tableid)) {
            this.writeHashIndex(entry.index, entry.next, entry.tableid);
        } else {
            this.updatePointer(entry.previous, entry.next);
        }
        this.header.decrementObjectCount();
        this.filemgr.deallocate(entry.location);
        this.filemgr.flush();
        return true;
    }

    private void writeHashIndex(int index, long value, int tableid) throws IOException {
        long diskloc = this.header.calcOffset(index, tableid);
        this.filemgr.seek(diskloc);
        this.filemgr.writeLong(value);
        this.updateHtindex(index, value, tableid);
    }

    void updateHtindex(int index, long value, int tableid) {
        if (tableid == this.header.currentTableId()) {
            this.htindex[index] = value;
        } else {
            this.new_htindex[index] = value;
        }
    }

    long getHtindex(int index, int tableid) {
        if (tableid == this.header.currentTableId()) {
            return this.htindex[index];
        }
        return this.new_htindex[index];
    }

    private void updatePointer(long next_ptr, long next_value) throws IOException, EOFException {
        this.filemgr.seek(next_ptr);
        this.filemgr.writeLong(next_value);
    }

    private void initWriteBuffer() throws IOException {
        if (this.headeroutbuf == null) {
            int buflen = 56;
            this.headeroutbuf = new byte[buflen];
            this.headeroutbytestream = new ByteArrayPlusOutputStream(this.headeroutbuf);
            this.headerout = new DataOutputStream(this.headeroutbytestream);
        }
        this.headeroutbytestream.reset();
    }

    private void initReadBuffer(long seek) throws IOException {
        if (this.headerinbuf == null) {
            int buflen = 56;
            this.headerinbuf = new byte[buflen];
            this.headerinbytestream = new ByteArrayInputStream(this.headerinbuf);
            this.headerin = new DataInputStream(this.headerinbytestream);
        }
        this.filemgr.seek(seek);
        this.filemgr.read(this.headerinbuf);
        this.headerinbytestream.reset();
    }

    private void updateEntry(HashtableEntry entry) throws IOException, EOFException, FileManagerException, ClassNotFoundException {
        ObjectOutputStream out;
        byte[] serializedKey = entry.serializedKey;
        int keySize = 0;
        byte[] serializedValue = null;
        int valueSize = -1;
        int bytes = 0;
        byte[] serializedCacheValue = entry.serializedCacheValue;
        int cacheValueSize = -1;
        int dataSize = 68;
        if (serializedKey == null) {
            if (this.keyout == null) {
                this.keyout = new ByteArrayPlusOutputStream(500);
            } else {
                this.keyout.reset();
            }
            this.serializeTimer.reset();
            out = new ObjectOutputStream(this.keyout);
            out.writeObject(entry.key);
            out.close();
            serializedKey = this.keyout.getTheBuffer();
            keySize = this.keyout.size();
            this.bytes_serialized += (long)keySize;
        } else {
            keySize = entry.serializedKey.length;
        }
        dataSize += keySize;
        if (entry.value != null) {
            if (HashtableOnDisk.isByteArray(entry.value)) {
                bytes = 1;
                serializedValue = (byte[])entry.value;
                valueSize = entry.valuelen != -1 ? entry.valuelen : serializedValue.length;
            } else {
                if (this.dataout == null) {
                    this.dataout = new ByteArrayPlusOutputStream(500);
                } else {
                    this.dataout.reset();
                }
                out = new ObjectOutputStream(this.dataout);
                out.writeObject(entry.value);
                out.close();
                serializedValue = this.dataout.getTheBuffer();
                valueSize = this.dataout.size();
                this.bytes_serialized += (long)valueSize;
                if (valueSize > 100000) {
                    this.dataout = null;
                }
            }
        }
        this.serialize_time += this.serializeTimer.elapsed();
        int allocateSize = 56 + keySize + 4 + 4;
        if (valueSize != -1) {
            allocateSize += valueSize;
            dataSize += valueSize;
        }
        if (this.bHasCacheValue && !entry.bAliasId) {
            allocateSize += 4;
            if (serializedCacheValue != null) {
                cacheValueSize = serializedCacheValue.length;
                allocateSize += cacheValueSize;
                dataSize += cacheValueSize;
            }
        }
        if (dataSize % 512 != 0) {
            dataSize = (dataSize / 512 + 1) * 512;
        }
        long tempData = 0L;
        tempData = entry.bAliasId ? 1326311194067206144L + (long)dataSize : 1326311189772238848L + (long)dataSize;
        entry.location = this.filemgr.allocate(allocateSize);
        this.initWriteBuffer();
        this.headerout.writeLong(entry.next);
        this.headerout.writeInt(entry.hash);
        this.headerout.writeLong(entry.validatorExpiration);
        this.headerout.writeInt(0);
        this.headerout.writeInt(entry.cacheValueHashcode);
        this.headerout.writeLong(entry.first_created);
        this.headerout.writeLong(entry.expiration);
        this.headerout.writeLong(tempData);
        this.headerout.writeInt(keySize);
        this.headerout.flush();
        this.filemgr.seek(entry.location);
        this.filemgr.write(this.headeroutbuf);
        this.filemgr.write(serializedKey, 0, keySize);
        this.filemgr.writeInt(bytes);
        this.filemgr.writeInt(valueSize);
        if (valueSize != -1) {
            this.filemgr.write(serializedValue, 0, valueSize);
        }
        if (this.bHasCacheValue) {
            this.filemgr.writeInt(cacheValueSize);
            if (cacheValueSize != -1) {
                this.filemgr.write(serializedCacheValue, 0, cacheValueSize);
            }
        }
    }

    private void writeEntry(HashtableEntry entry) throws IOException, EOFException, FileManagerException, ClassNotFoundException {
        long index = this.getHtindex(entry.index, entry.tableid);
        if (index == 0L) {
            this.updateEntry(entry);
            this.writeHashIndex(entry.index, entry.location, entry.tableid);
        } else if (index == entry.location) {
            this.updateEntry(entry);
            this.writeHashIndex(entry.index, entry.location, entry.tableid);
        } else if (entry.previous == 0L) {
            entry.next = index;
            this.updateEntry(entry);
            this.writeHashIndex(entry.index, entry.location, entry.tableid);
        } else if (entry.location == 0L) {
            this.updateEntry(entry);
            this.updatePointer(entry.previous, entry.location);
        } else {
            this.updateEntry(entry);
        }
    }

    private void deallocate(HashtableEntry entry) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (entry.location == 0L) {
            throw new HashtableOnDiskException("deallocate:  space not allocated.");
        }
        this.filemgr.deallocate(entry.location);
        entry.location = 0L;
    }

    private Object readDataField(int bytes, int datalen) throws IOException, ClassNotFoundException {
        Object value = null;
        this.deserializeTimer.reset();
        if (bytes == 0) {
            if (this.databuf == null || this.databuf.length < datalen) {
                this.databuf = new byte[datalen];
            }
            this.deserialize_time += this.deserializeTimer.elapsed();
            this.filemgr.read(this.databuf, 0, datalen);
            this.deserializeTimer.reset();
            value = SerializationUtility.deserialize(Arrays.copyOf(this.databuf, datalen), this.htoddc.cacheName);
            this.bytes_deserialized += (long)datalen;
        } else {
            value = new byte[datalen];
            this.deserialize_time += this.deserializeTimer.elapsed();
            this.filemgr.read((byte[])value);
            this.deserializeTimer.reset();
        }
        this.deserialize_time += this.deserializeTimer.elapsed();
        if (datalen > 100000) {
            this.databuf = null;
        }
        return value;
    }

    protected HashtableEntry readEntry(long location, long previous, int retrieveMode, boolean checkExpired, int tableid) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (location == 0L) {
            return null;
        }
        long next = 0L;
        int hash = 0;
        this.initReadBuffer(location);
        next = this.headerin.readLong();
        hash = this.headerin.readInt();
        return this.readEntry2(location, next, hash, previous, retrieveMode, checkExpired, tableid, null, null);
    }

    protected HashtableEntry readEntry2(long location, long next, int hash, long previous, int retrieveMode, boolean checkExpired, int tableid, Object matchKey, HTODDynacache.EvictionTableEntry matchEVT) throws IOException, ClassNotFoundException {
        long last_modified = 0L;
        long last_referenced = 0L;
        long first_created = 0L;
        long expiration = -1L;
        long validatorExpiration = -1L;
        long tempData = -1L;
        int dataSize = -1;
        int keySize = -1;
        Serializable key = null;
        int valueSize = -1;
        int bytes = 0;
        Object value = null;
        int cacheValueSize = 0;
        int cacheValueHashcode = 0;
        byte[] serializedCacheValue = null;
        boolean isAliasId = false;
        boolean isValidHashcodeForValue = true;
        HashtableEntry htEntry = this.htoddc.getFromHashtableEntryPool();
        last_modified = this.headerin.readLong();
        if (last_modified == (last_referenced = this.headerin.readLong())) {
            isValidHashcodeForValue = false;
            cacheValueHashcode = 0;
            validatorExpiration = -1L;
        } else {
            cacheValueHashcode = (int)(last_referenced & 0xFFFFFFFFL);
            validatorExpiration = last_modified;
        }
        first_created = this.headerin.readLong();
        expiration = this.headerin.readLong();
        tempData = this.headerin.readLong();
        if (tempData != -1L) {
            if (tempData == 0L) {
                isAliasId = true;
            } else {
                dataSize = (int)(tempData & 0xFFFFFFFFL);
                boolean bl = isAliasId = (tempData & 0x100000000L) > 0L;
            }
        }
        if (matchEVT != null) {
            long expTime = expiration;
            if (expiration <= 0L) {
                expTime = Long.MAX_VALUE;
            }
            if (expTime != matchEVT.expirationTime || dataSize != matchEVT.size) {
                return null;
            }
        }
        keySize = this.headerin.readInt();
        if (this.keybuf == null || this.keybuf.length < keySize) {
            this.keybuf = new byte[keySize];
        }
        this.filemgr.read(this.keybuf, 0, keySize);
        this.deserializeTimer.reset();
        key = SerializationUtility.deserialize(Arrays.copyOf(this.keybuf, keySize), this.htoddc.cacheName);
        this.deserialize_time += this.deserializeTimer.elapsed();
        this.bytes_deserialized += (long)keySize;
        if (matchKey != null && key != null && !key.equals(matchKey)) {
            return null;
        }
        if (checkExpired && expiration > 0L && System.currentTimeMillis() - expiration >= 0L) {
            retrieveMode = 1;
        }
        if (retrieveMode == 3 || retrieveMode == 2) {
            bytes = this.filemgr.readInt();
            valueSize = this.filemgr.readInt();
            if (valueSize != -1) {
                value = this.readDataField(bytes, valueSize);
            }
            if (this.bHasCacheValue && dataSize > 0) {
                cacheValueSize = dataSize - keySize - valueSize;
            }
        }
        if (this.bHasCacheValue && !isAliasId && dataSize > 0 && retrieveMode == 3 && (cacheValueSize = this.filemgr.readInt()) != -1) {
            serializedCacheValue = (byte[])this.readDataField(1, cacheValueSize);
        }
        htEntry.copy(location, first_created, key, value, next, previous, this.header.tablesize(tableid), tableid, valueSize, expiration, validatorExpiration, dataSize, serializedCacheValue, cacheValueSize, cacheValueHashcode, isAliasId, isValidHashcodeForValue);
        return htEntry;
    }

    private HashtableEntry findEntry(Object key, int retrieveMode, boolean checkExpired) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (key == null) {
            return null;
        }
        int hashcode = key.hashCode();
        int index = this.header.getHtIndex(hashcode, this.header.currentTableId());
        long current = 0L;
        HashtableEntry answer = null;
        if (this.header.rehashInProgress == 1L) {
            if (this.debug) {
                this.print("*");
            }
            if (this.htindex[index] != 0L) {
                if (this.debug) {
                    this.print("A");
                }
                if ((current = this.htindex[index]) == 0L) {
                    throw new IllegalStateException("findEntry: ht pointer is null");
                }
                answer = this.findEntry(key, hashcode, retrieveMode, checkExpired, current, this.header.currentTableId());
                if (answer != null) {
                    return answer;
                }
            }
            if (this.new_htindex[index = this.header.getHtIndex(hashcode, this.header.alternateTableId())] != 0L) {
                if (this.debug) {
                    this.print("B ");
                }
                if ((current = this.new_htindex[index]) == 0L) {
                    throw new IllegalStateException("findEntry: ht pointer is null");
                }
                return this.findEntry(key, hashcode, retrieveMode, checkExpired, current, this.header.alternateTableId());
            }
            return null;
        }
        if (this.htindex[index] == 0L) {
            return null;
        }
        int tableid = this.header.currentTableId();
        current = this.htindex[index];
        if (current == 0L) {
            throw new IllegalStateException("findEntry: ht pointer is null");
        }
        return this.findEntry(key, hashcode, retrieveMode, checkExpired, current, tableid);
    }

    private HashtableEntry findEntry(HTODDynacache.EvictionTableEntry evt, int retrieveMode) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (evt == null) {
            return null;
        }
        int hashcode = evt.hashcode;
        int index = this.header.getHtIndex(hashcode, this.header.currentTableId());
        long current = 0L;
        HashtableEntry answer = null;
        if (this.header.rehashInProgress == 1L) {
            if (this.debug) {
                this.print("*");
            }
            if (this.htindex[index] != 0L) {
                if (this.debug) {
                    this.print("A");
                }
                if ((current = this.htindex[index]) == 0L) {
                    throw new IllegalStateException("findEntry: ht pointer is null");
                }
                answer = this.findEntry(evt, retrieveMode, current, this.header.currentTableId());
                if (answer != null) {
                    return answer;
                }
            }
            if (this.new_htindex[index = this.header.getHtIndex(hashcode, this.header.alternateTableId())] != 0L) {
                if (this.debug) {
                    this.print("B ");
                }
                if ((current = this.new_htindex[index]) == 0L) {
                    throw new IllegalStateException("findEntry: ht pointer is null");
                }
                return this.findEntry(evt, retrieveMode, current, this.header.alternateTableId());
            }
            return null;
        }
        if (this.htindex[index] == 0L) {
            return null;
        }
        int tableid = this.header.currentTableId();
        current = this.htindex[index];
        if (current == 0L) {
            throw new IllegalStateException("findEntry: ht pointer is null");
        }
        return this.findEntry(evt, retrieveMode, current, tableid);
    }

    private HashtableEntry findEntry(HTODDynacache.EvictionTableEntry evt, int retrieveMode, long current, int tableid) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        int hashcode = evt.hashcode;
        long previous = 0L;
        long next = 0L;
        int hash = 0;
        this.initReadBuffer(current);
        next = this.headerin.readLong();
        hash = this.headerin.readInt();
        while (current != 0L) {
            HashtableEntry entry;
            if (hash == hashcode && (entry = this.readEntry2(current, next, hash, previous, retrieveMode, false, tableid, null, evt)) != null) {
                return entry;
            }
            ++this.collisions;
            previous = current;
            current = next;
            if (current == 0L) continue;
            this.initReadBuffer(current);
            next = this.headerin.readLong();
            hash = this.headerin.readInt();
        }
        return null;
    }

    private HashtableEntry findEntry(Object key, int hashcode, int retrieveMode, boolean checkExpired, long current, int tableid) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        long previous = 0L;
        long next = 0L;
        int hash = 0;
        this.initReadBuffer(current);
        next = this.headerin.readLong();
        hash = this.headerin.readInt();
        while (current != 0L) {
            HashtableEntry entry;
            if (hash == hashcode && (entry = this.readEntry2(current, next, hash, previous, retrieveMode, checkExpired, tableid, key, null)) != null) {
                return entry;
            }
            ++this.collisions;
            previous = current;
            current = next;
            if (current == 0L) continue;
            this.initReadBuffer(current);
            next = this.headerin.readLong();
            hash = this.headerin.readInt();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int walkHash(HashtableAction action, int retrieveMode, int index, int length) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        this.iterationLock.p();
        int tindex = -1;
        int tableSize = this.header.tablesize();
        try {
            int j = 0;
            for (int i = index; i < tableSize; ++i) {
                boolean result = true;
                HashtableOnDisk hashtableOnDisk = this;
                synchronized (hashtableOnDisk) {
                    long location = this.getHtindex(i, this.header.currentTableId());
                    long previous = 0L;
                    long next = 0L;
                    int hash = 0;
                    this.initReadBuffer(location);
                    next = this.headerin.readLong();
                    hash = this.headerin.readInt();
                    while (location != 0L) {
                        HashtableEntry e = this.readEntry2(location, next, hash, previous, retrieveMode, false, this.header.currentTableId(), null, null);
                        if (e == null) continue;
                        ++j;
                        try {
                            Object id = e.getKey();
                            result = action.execute(e);
                            if (!result) {
                                this.traceDebug("walkHash()", "cacheName=" + this.htoddc.cacheName + " id=" + id + " action.execute() returns false.");
                                break;
                            }
                        }
                        catch (Exception xcp) {
                            throw new HashtableOnDiskException("HashtableAction: " + xcp.toString());
                        }
                        previous = location;
                        location = next;
                        if (location == 0L) continue;
                        this.initReadBuffer(location);
                        next = this.headerin.readLong();
                        hash = this.headerin.readInt();
                    }
                    if (!result) {
                        break;
                    }
                    if (j >= length) {
                        tindex = i + 1;
                        break;
                    }
                    continue;
                }
            }
        }
        finally {
            this.iterationLock.v();
        }
        if (tindex == -1) {
            tindex = tableSize;
        }
        return tindex;
    }

    public void releaseMemoryToPool() {
        if (this.htindex != null) {
            this.htoddc.longArrayPool.returnToPool(new PrimitiveArrayPool.PoolEntry(this.htindex));
            this.htindex = null;
        }
        if (this.new_htindex != null) {
            this.htoddc.longArrayPool.returnToPool(new PrimitiveArrayPool.PoolEntry(this.new_htindex));
            this.new_htindex = null;
        }
    }

    public void listfiles(Writer o) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        ListAction act = new ListAction(o);
        this.walkHash(act, 1, 0, -1);
    }

    public synchronized void reset_stats() {
        this.filemgr.reset_stats();
        this.collisions = 0;
        this.read_hits = 0;
        this.write_replacements = 0;
        this.serialize_time = 0L;
        this.deserialize_time = 0L;
        this.read_requests = 0;
        this.write_requests = 0;
        this.removes = 0;
        this.clears = 0;
        this.bytes_serialized = 0L;
        this.bytes_deserialized = 0L;
    }

    public void dump_stats_header(Writer out) throws IOException {
        out.write("Header-Loc\t");
        out.write("Header-Size\t");
        out.write("Magic\t");
        out.write("Cur-Table\t");
        out.write("Num-Objects\t");
        out.write("Load-Factor\t");
        out.write("Auto_rehash\t");
        out.write("Rehash\t");
        out.write("Collisions\t");
        out.write("Read-Requests\t");
        out.write("Read-Hits\t");
        out.write("Write-Replacements\t");
        out.write("Write-Requests\t");
        out.write("Serialize-Time\t");
        out.write("Deserialize_time\t");
        out.write("Bytes-Serialized\t");
        out.write("Bytes-deSerialized\t");
        out.write("Removes\t");
        out.write("Clears\t");
    }

    public synchronized void dump_htod_stats(Writer out, boolean labels) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (labels) {
            int physical_size;
            long true_location;
            out.write("\n\n");
            out.write("--------------------------------------------------\n");
            out.write("HTOD Header:\n");
            out.write("--------------------------------------------------\n");
            out.write("Header location = " + (this.header.disklocation - 4L) + "\n");
            out.write("Header size = " + this.filemgr.grain_size() + "\n");
            out.write("Magic string = " + this.header.magic + "\n");
            out.write("currentTablePtr = " + this.header.currentTablePtr + "\n");
            out.write("num_objects = " + this.header.num_objects() + "\n");
            out.write("loadFactor = " + this.header.loadFactor + "\n");
            out.write("auto_rehash = " + this.auto_rehash + "\n");
            out.write("rehashInProgress = " + this.header.rehashInProgress + "\n");
            if (this.header.tableLocation[0] == 0L) {
                out.write("Hashtable[0] is empty\n");
            } else {
                out.write("Hashtable[0].tablesize = " + this.header.tablesize[0] + "\n");
                true_location = this.header.tableLocation[0] - 4L;
                physical_size = this.header.tablesize[0];
                out.write("Hashtable[0] physical location, size = " + true_location + " " + physical_size + "\n");
            }
            if (this.header.tableLocation[1] == 0L) {
                out.write("Hashtable[1] is empty\n");
            } else {
                out.write("Hashtable[1].tablesize = " + this.header.tablesize[1] + "\n");
                true_location = this.header.tableLocation[1] - 4L;
                physical_size = this.header.tablesize[1];
                out.write("Hashtable[1] physical location, size = " + true_location + " " + physical_size + "\n");
            }
            out.write("collisions: " + this.collisions + "\n");
            out.write("read_requests " + this.read_requests + "\n");
            out.write("read_hits " + this.read_hits + "\n");
            out.write("write_replacements: " + this.write_replacements + "\n");
            out.write("write_requests: " + this.write_requests + "\n");
            out.write("serialize time: " + this.serialize_time + "\n");
            out.write("deserialize time: " + this.deserialize_time + "\n");
            out.write("bytes serialized: " + this.bytes_serialized + "\n");
            out.write("bytes deserialized: " + this.bytes_deserialized + "\n");
            out.write("removes: " + this.removes + "\n");
            out.write("clears: " + this.clears + "\n");
            out.write("--------------------------------------------------\n");
        } else {
            out.write(this.header.disklocation - 4L + "\t");
            out.write(this.filemgr.grain_size() + "\t");
            out.write(this.header.magic + "\t");
            out.write(this.header.currentTablePtr + "\t");
            out.write(this.header.num_objects() + "\t");
            out.write(this.header.loadFactor + "\t");
            out.write(this.auto_rehash + "\t");
            out.write(this.header.rehashInProgress + "\t");
            out.write(this.collisions + "\t");
            out.write(this.read_requests + "\t");
            out.write(this.read_hits + "\t");
            out.write(this.write_replacements + "\t");
            out.write(this.write_requests + "\t");
            out.write(this.serialize_time + "\t");
            out.write(this.deserialize_time + "\t");
            out.write(this.bytes_serialized + "\t");
            out.write(this.bytes_deserialized + "\t");
            out.write(this.removes + "\t");
            out.write(this.clears + "\t");
        }
    }

    public void dumpFilemgr(Writer out) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        this.filemgr.dump_memory(out);
        this.filemgr.dump_disk_memory(out);
    }

    public void analyzeHash(boolean full) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        int physical_size;
        boolean totalsize = false;
        long true_location = this.header.disklocation - 4L;
        this.filemgr.seek(true_location);
        int header_size = this.filemgr.readInt();
        this.println("\n\n");
        this.println("--------------------------------------------------");
        this.println("Header information:\n");
        this.println("--------------------------------------------------");
        this.println("Header location = " + true_location);
        this.println("Header size = " + header_size);
        this.println("Magic string = " + this.header.magic);
        this.println("currentTablePtr = " + this.header.currentTablePtr);
        this.println("num_objects = " + this.header.num_objects());
        this.println("loadFactor = " + this.header.loadFactor);
        this.println("rehashInProgress = " + this.header.rehashInProgress);
        this.println("currentTablePtr = " + this.header.currentTablePtr);
        if (this.header.tableLocation[0] == 0L) {
            this.println("Hashtable[0] is empty\n");
        } else {
            this.println("Hashtable[0].tablesize = " + this.header.tablesize[0]);
            true_location = this.header.tableLocation[0] - 4L;
            this.filemgr.seek(true_location);
            physical_size = this.filemgr.readInt();
            this.println("Hashtable[0] physical location, size = " + true_location + " " + physical_size);
        }
        if (this.header.tableLocation[1] == 0L) {
            this.println("Hashtable[1] is empty\n");
        } else {
            this.println("Hashtable[1].tablesize = " + this.header.tablesize[1]);
            true_location = this.header.tableLocation[1] - 4L;
            this.filemgr.seek(true_location);
            physical_size = this.filemgr.readInt();
            this.println("Hashtable[1] physical location, size = " + true_location + " " + physical_size);
        }
        this.println("--------------------------------------------------");
    }

    private void countAndVerifyObjects() throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        this.println("countAndVerifyObjects(): Hashtable " + this.filename + " was not closed properly.  Validating ");
        this.header.set_num_objects(0);
        HashtableAction act = new HashtableAction(){

            @Override
            public boolean execute(HashtableEntry e) throws IOException {
                if (HashtableOnDisk.this.header.num_objects() % 100 == 0) {
                    HashtableOnDisk.this.print(".");
                }
                HashtableOnDisk.this.header.incrementObjectCount();
                if (HashtableOnDisk.this.item_initialize != null) {
                    HashtableOnDisk.this.item_initialize.initialize(e.getKey(), e.getValue());
                }
                return true;
            }
        };
        this.walkHash(act, 3, 0, -1);
        this.header.write();
        this.println("countAndVerifyObjects(): done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countObjects() throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        this.println("countObjects(): Hashtable " + this.filename + " was not closed properly.  Validating ");
        this.iterationLock.p();
        int count = 0;
        try {
            for (int i = 0; i < this.header.tablesize(); ++i) {
                long next = this.getHtindex(i, this.header.currentTableId());
                while (next != 0L) {
                    if (++count % 100 == 0 && this.debug) {
                        this.print(".");
                    }
                    this.filemgr.seek(next);
                    next = this.filemgr.readLong();
                }
            }
            this.header.set_num_objects(count);
            this.header.write();
        }
        finally {
            this.iterationLock.v();
        }
        this.println("countObjects(): done[" + count + "]");
    }

    private void rehash() throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        int size = this.header.tablesize() * 2 + 1;
        if (this.tempTableSize > size) {
            this.doRehash(this.tempTableSize);
            this.tempTableSize = 0;
        } else {
            this.doRehash(size);
        }
    }

    private void doRehash(int new_table_size) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        this.iterationLock.p();
        long new_table = 0L;
        this.header.setRehashFlag(1L);
        new_table = this.filemgr.allocateAndClear(new_table_size * 8);
        this.header.initNewTable(new_table_size, new_table);
        PrimitiveArrayPool.PoolEntry longPoolEntry = this.htoddc.longArrayPool.allocate(new_table_size);
        this.new_htindex = (long[])longPoolEntry.getArray();
        Rehash rehash = new Rehash(this, new_table, new_table_size);
        Thread t = new Thread(rehash);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rehashAllEntries(long new_table, int new_table_size) throws IOException, ClassNotFoundException, FileManagerException, HashtableOnDiskException {
        String methodName = "rehashAllEntries()";
        this.traceDebug("rehashAllEntries()", "cacheName=" + this.htoddc.cacheName + " new_table=" + new_table + " new_table_size=" + new_table_size);
        long start = System.nanoTime();
        try {
            int tableid = this.header.currentTableId();
            for (int i = 0; i < this.header.tablesize(); ++i) {
                Thread.yield();
                HashtableOnDisk hashtableOnDisk = this;
                synchronized (hashtableOnDisk) {
                    long old_bucket_pointer = this.header.calcOffset(i, tableid);
                    this.filemgr.seek(old_bucket_pointer);
                    long location = this.filemgr.readLong();
                    HashtableEntry e = this.readEntry(location, 0L, 1, false, tableid);
                    long new_next = 0L;
                    while (e != null) {
                        int newindex = (e.hash & Integer.MAX_VALUE) % new_table_size;
                        long diskloc = new_table + (long)(newindex * 8);
                        this.filemgr.seek(diskloc);
                        new_next = this.filemgr.readLong();
                        if (new_next != 0L) {
                            this.header.setRehashFlag(new_next);
                        }
                        this.filemgr.seek(diskloc);
                        this.filemgr.writeLong(e.location);
                        this.new_htindex[newindex] = e.location;
                        this.filemgr.seek(old_bucket_pointer);
                        this.filemgr.writeLong(e.next);
                        this.htindex[i] = e.next;
                        long tempnext = e.next;
                        e.next = new_next;
                        this.updatePointer(e.location, e.next);
                        this.header.setRehashFlag(1L);
                        this.htoddc.returnToHashtableEntryPool(e);
                        e = this.readEntry(tempnext, 0L, 1, false, tableid);
                        if (!this.debug) continue;
                        this.print(".");
                    }
                    this.header.updateRehashIndex(i);
                    continue;
                }
            }
            HashtableOnDisk hashtableOnDisk = this;
            synchronized (hashtableOnDisk) {
                this.header.swapTables();
                this.threshold = this.header.loadFactor * this.header.tablesize() / 100;
                if (this.htindex != null) {
                    this.htoddc.longArrayPool.returnToPool(new PrimitiveArrayPool.PoolEntry(this.htindex));
                }
                this.htindex = this.new_htindex;
                this.new_htindex = null;
            }
        }
        finally {
            this.iterationLock.v();
        }
        this.traceDebug("rehashAllEntries()", "cacheName=" + this.htoddc.cacheName + " done - new_table=" + new_table + " elapsed=" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void recover() throws HashtableOnDiskException, FileManagerException, ClassNotFoundException, IOException, EOFException {
        this.println("recover(): Hashtable recover starts");
        boolean done = false;
        if (this.header.tableLocation[0] == 0L) {
            if (this.header.currentTablePtr != 1) throw new HashtableOnDiskException("Cannot recover hashtable, current table pointer is invalid.");
            if (this.header.tableLocation[1] == 0L) throw new HashtableOnDiskException("Cannot recover hashtable, no valid table pointers.");
            this.header.tableLocation[0] = 0L;
            this.header.tablesize[0] = 0;
            done = true;
        } else if (this.header.tableLocation[1] == 0L) {
            if (this.header.currentTablePtr != 0) throw new HashtableOnDiskException("Cannot recover hashtable, current table pointer is invalid.");
            if (this.header.tableLocation[0] == 0L) throw new HashtableOnDiskException("Cannot recover hashtable, no valid table pointers.");
            this.header.tableLocation[1] = 0L;
            this.header.tablesize[1] = 0;
            done = true;
        }
        if (done) {
            this.println("Recover(): ended - previous rehash did not enter critical section.");
            this.header.set_num_objects(0);
            this.header.rehashInProgress = 0L;
            this.header.write();
            return;
        }
        long new_table = this.header.alternateTable();
        int new_table_size = this.header.alternateSize();
        this.new_htindex = new long[new_table_size];
        this.println("Recover(): clearing inconsistencies");
        this.clearInconsistencies(new_table, new_table_size);
        this.println("Recover(): resuming rehash.");
        this.iterationLock.p();
        Rehash rehash = new Rehash(this, new_table, new_table_size);
        Thread t = new Thread(rehash);
        t.start();
    }

    void clearInconsistencies(long newtable, int newsize) throws IOException, EOFException, ClassNotFoundException, FileManagerException, HashtableOnDiskException {
        for (int i = 0; i < newsize; ++i) {
            long diskloc = newtable + (long)(i * 8);
            this.filemgr.seek(diskloc);
            long location = this.filemgr.readLong();
            if (this.header.rehashInProgress == location) {
                this.header.setRehashFlag(1L);
                return;
            }
            HashtableEntry e = this.readEntry(location, 0L, 1, false, this.header.alternateTableId());
            while (e != null) {
                HashtableEntry oe = this.findEntry(e.key, e.hash, 1, false, 0L, this.header.currentTableId());
                if (oe == null) {
                    if (e.next == 0L) {
                        if (this.header.rehashInProgress != 1L) {
                            e.next = this.header.rehashInProgress;
                        }
                        this.updatePointer(e.location, e.next);
                        this.header.setRehashFlag(1L);
                        this.htoddc.returnToHashtableEntryPool(e);
                        return;
                    }
                    HashtableEntry ne = this.readEntry(e.next, 0L, 1, false, this.header.alternateTableId());
                    oe = this.findEntry(ne.key, ne.hash, 1, false, 0L, this.header.currentTableId());
                    this.htoddc.returnToHashtableEntryPool(ne);
                    if (oe != null) {
                        e.next = this.header.rehashInProgress == 1L ? 0L : this.header.rehashInProgress;
                        this.updatePointer(e.location, e.next);
                        this.header.setRehashFlag(1L);
                        this.htoddc.returnToHashtableEntryPool(oe);
                        this.htoddc.returnToHashtableEntryPool(e);
                        return;
                    }
                } else {
                    this.filemgr.seek(diskloc);
                    if (this.header.rehashInProgress == 1L) {
                        this.filemgr.writeLong(0L);
                    } else {
                        this.filemgr.writeLong(this.header.rehashInProgress);
                    }
                    this.header.setRehashFlag(1L);
                    this.htoddc.returnToHashtableEntryPool(oe);
                    this.htoddc.returnToHashtableEntryPool(e);
                    return;
                }
                long nextLocation = e.next;
                this.htoddc.returnToHashtableEntryPool(e);
                e = this.readEntry(nextLocation, 0L, 1, false, this.header.alternateTableId());
            }
        }
    }

    void println(String msg) {
        Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
    }

    void print(String msg) {
        Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
    }

    private void traceDebug(String methodName, String message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " " + message), (Object[])new Object[0]);
        }
    }

    static void usage() {
        System.out.println("filemgr.HashtableOnDisk <fn> <instance> [-full]");
        System.exit(0);
    }

    public static void main(String[] args) {
        String filename = null;
        int instance = -1;
        boolean full = false;
        if (args.length < 2) {
            HashtableOnDisk.usage();
        }
        if (args.length == 2) {
            filename = args[0];
            instance = Integer.parseInt(args[1]);
            full = false;
        } else if (args.length == 3) {
            filename = args[0];
            instance = Integer.parseInt(args[1]);
            if (args[2].equals("-full")) {
                full = true;
            } else {
                HashtableOnDisk.usage();
            }
        } else {
            HashtableOnDisk.usage();
        }
        System.out.println("filename = " + filename);
        System.out.println("full = " + full);
        try {
            HTODDynacache hdc = new HTODDynacache();
            FileManagerImpl mgr = new FileManagerImpl(filename, false, "r", 1, hdc);
            HashtableOnDisk ht = new HashtableOnDisk(mgr, true, instance, true, hdc);
            ht.analyzeHash(full);
            ht.close();
            mgr.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    class ListAction
    implements HashtableAction {
        Writer out;

        ListAction(Writer o) {
            this.out = o;
        }

        @Override
        public boolean execute(HashtableEntry e) throws IOException {
            this.out.write(e.getKey().toString());
            this.out.write("\n");
            this.out.flush();
            return true;
        }
    }

    class AnalyzeStruct {
        Object object;
        int buffersize;
        int objectsize;
        long location;

        AnalyzeStruct(Object o, long loc, int bs, int os) {
            this.object = o;
            this.buffersize = bs;
            this.objectsize = os;
            this.location = loc;
        }
    }
}

