/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.cache.CacheOnDisk;
import com.ibm.ws.cache.ExplicitIdData;
import com.ibm.ws.cache.HTODDynacache;
import com.ibm.ws.cache.ValueSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class HTODInvalidationBuffer {
    private static TraceComponent tc = Tr.register(HTODInvalidationBuffer.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static final boolean IS_UNIT_TEST = false;
    public static final boolean SCAN = true;
    public static final boolean FIRE_EVENT = true;
    public static final boolean CHECK_FULL = true;
    public static final boolean ALIAS_ID = true;
    public static final int SCAN_BUFFER = 1;
    public static final int EXPLICIT_BUFFER = 2;
    public static final int GC_BUFFER = 3;
    public static final byte STATUS_FIRE_EVENT = -128;
    public static final byte STATUS_FROM_DEPID_TEMPLATE = 64;
    public static final byte STATUS_ALIAS = 32;
    public static final byte STATUS_REMOTE = 16;
    public static final byte STATUS_CAUSE_MASK = 15;
    private CacheOnDisk cod = null;
    private HashMap explicitBuffer = null;
    private ValueSet scanBuffer = null;
    private ArrayList garbageCollectorBuffer = null;
    private boolean cleanupDiskPending = false;
    private boolean loopOnce = false;
    private boolean stopping = false;
    private boolean diskClearInProgress = false;
    private int maxInvalidationBufferSize = 0;
    private int maxInvalidationBufferLife = 0;
    private long lastRemoveTime = 0L;
    private long lastWaitTime = 0L;

    private HTODInvalidationBuffer() {
    }

    public HTODInvalidationBuffer(CacheOnDisk cod) {
        this.cod = cod;
        this.maxInvalidationBufferSize = cod.invalidationBufferSize;
        this.maxInvalidationBufferLife = cod.invalidationBufferLife;
        this.explicitBuffer = new HashMap(this.maxInvalidationBufferSize);
        this.scanBuffer = new ValueSet(this.maxInvalidationBufferSize);
        this.garbageCollectorBuffer = this.cod.evictionPolicy != 0 ? new ArrayList(this.maxInvalidationBufferSize) : new ArrayList();
        this.cleanupDiskPending = false;
        this.loopOnce = false;
        this.stopping = false;
    }

    protected synchronized void add(Object id, int bufferType, int cause, int source, boolean fromDepIdTemplateInvalidation, boolean fireEvent, boolean isAlias) {
        String methodName = "add(Object)";
        if (id == null) {
            return;
        }
        if (bufferType == 2) {
            byte info = 0;
            if (cause != 0 && source != 0) {
                info = (byte)cause;
                if (source == 2) {
                    info = (byte)(info | 0x10);
                }
                if (fromDepIdTemplateInvalidation) {
                    info = (byte)(info | 0x40);
                }
                if (isAlias) {
                    info = (byte)(info | 0x20);
                }
                if (fireEvent) {
                    info = (byte)(info | 0xFFFFFF80);
                }
            }
            this.explicitBuffer.put(id, new Byte(info));
            this.scanBuffer.remove(id);
        } else if (bufferType == 1) {
            if (!this.explicitBuffer.containsKey(id)) {
                this.scanBuffer.add(id);
            }
        } else if (bufferType == 3) {
            this.garbageCollectorBuffer.add(id);
        }
        this.traceDebug("add(Object)", "cacheName=" + this.cod.cacheName + " id=" + id + " bufferType=" + bufferType + " ExplicitBuffer=" + this.explicitBuffer.size() + " ScanBuffer=" + this.scanBuffer.size() + " GCBuffer=" + this.garbageCollectorBuffer.size() + " cause=" + cause + " source=" + source + " fireEvent=" + fireEvent);
        if (this.isFull() || bufferType == 3) {
            this.invokeBackgroundInvalidation(false);
        }
    }

    protected synchronized void add(ValueSet idSet, int bufferType, int cause, int source, boolean fromDepIdTemplateInvalidation, boolean fireEvent, boolean checkFull) {
        String methodName = "add(ValueSet)";
        if (idSet == null || idSet.isEmpty()) {
            return;
        }
        int size = idSet.size();
        if (bufferType == 2) {
            byte info = 0;
            if (cause != 0 && source != 0) {
                info = (byte)cause;
                if (source == 2) {
                    info = (byte)(info | 0x10);
                }
                if (fromDepIdTemplateInvalidation) {
                    info = (byte)(info | 0x40);
                }
                if (fireEvent) {
                    info = (byte)(info | 0xFFFFFF80);
                }
            }
            for (Object entryId : idSet) {
                this.explicitBuffer.put(entryId, new Byte(info));
            }
            if (!this.scanBuffer.isEmpty()) {
                this.filter(this.scanBuffer, idSet);
            }
        } else if (bufferType == 1) {
            if (!this.explicitBuffer.isEmpty()) {
                this.filter(idSet, this.explicitBuffer);
            }
            this.scanBuffer.addAll(idSet);
        } else if (bufferType == 3) {
            this.garbageCollectorBuffer.addAll(idSet);
        }
        this.traceDebug("add(ValueSet)", "cacheName=" + this.cod.cacheName + " idSet=" + size + " idSetFilter=" + idSet.size() + " bufferType=" + bufferType + " explicitBuffer=" + this.explicitBuffer.size() + " scanBuffer=" + this.scanBuffer.size() + " GCBuffer=" + this.garbageCollectorBuffer.size());
        if (checkFull && this.isFull() || bufferType == 3) {
            this.invokeBackgroundInvalidation(false);
        }
    }

    protected synchronized void add(ArrayList evictionSet, int bufferType) {
        String methodName = "add(evictionSet)";
        if (evictionSet == null || evictionSet.isEmpty()) {
            return;
        }
        if (bufferType == 3) {
            this.garbageCollectorBuffer.addAll(evictionSet);
            this.traceDebug("add(evictionSet)", "cacheName=" + this.cod.cacheName + " evictionSet=" + evictionSet.size() + " explicitBuffer=" + this.explicitBuffer.size() + " scanBuffer=" + this.scanBuffer.size() + " GCBuffer=" + this.garbageCollectorBuffer.size());
            this.invokeBackgroundInvalidation(false);
        }
    }

    protected synchronized Object get(int bufferType) {
        Object id = null;
        if (bufferType == 2) {
            if (!this.explicitBuffer.isEmpty()) {
                Set s = this.explicitBuffer.keySet();
                Iterator it = s.iterator();
                ExplicitIdData idData = new ExplicitIdData();
                while (it.hasNext()) {
                    idData.id = it.next();
                    idData.info = (Byte)this.explicitBuffer.get(idData.id);
                    if ((idData.info & 0x20) != 0) continue;
                    id = idData;
                    break;
                }
            }
        } else if (bufferType == 1) {
            if (!this.scanBuffer.isEmpty()) {
                id = this.scanBuffer.getOne();
            }
        } else if (bufferType == 3 && !this.garbageCollectorBuffer.isEmpty()) {
            id = this.garbageCollectorBuffer.get(0);
        }
        return id;
    }

    protected synchronized Object getAndRemove(int bufferType) {
        String methodName = "getAndRemove(bufferType)";
        Object id = null;
        if (bufferType == 2) {
            if (!this.explicitBuffer.isEmpty()) {
                Set s = this.explicitBuffer.keySet();
                Iterator it = s.iterator();
                ExplicitIdData idData = new ExplicitIdData();
                while (it.hasNext()) {
                    idData.id = it.next();
                    idData.info = (Byte)this.explicitBuffer.get(idData.id);
                    if ((idData.info & 0x20) != 0) continue;
                    id = idData;
                    this.explicitBuffer.remove(idData.id);
                    break;
                }
            }
        } else if (bufferType == 1) {
            if (!this.scanBuffer.isEmpty() && (id = this.scanBuffer.getOne()) != null) {
                this.scanBuffer.remove(id);
            }
        } else if (bufferType == 3 && !this.garbageCollectorBuffer.isEmpty() && (id = this.garbageCollectorBuffer.get(0)) != null) {
            this.remove(id, bufferType, false);
        }
        return id;
    }

    protected synchronized void remove(Object id, int bufferType) {
        this.remove(id, bufferType, true);
    }

    protected synchronized void remove(Object id, int bufferType, boolean returnToPool) {
        if (id == null) {
            return;
        }
        if (bufferType == 2) {
            this.explicitBuffer.remove(id);
        } else if (bufferType == 1) {
            this.scanBuffer.remove(id);
        } else if (bufferType == 3 && id instanceof HTODDynacache.EvictionTableEntry) {
            HTODDynacache.EvictionTableEntry evt;
            int i;
            HTODDynacache.EvictionTableEntry evt1 = (HTODDynacache.EvictionTableEntry)id;
            for (i = 0; i < this.garbageCollectorBuffer.size() && (evt = (HTODDynacache.EvictionTableEntry)this.garbageCollectorBuffer.get(i)) != evt1; ++i) {
            }
            if (i < this.garbageCollectorBuffer.size()) {
                this.garbageCollectorBuffer.remove(i);
            }
            if (returnToPool) {
                this.cod.htod.evictionEntryPool.add(id);
            }
        }
    }

    protected synchronized void remove(Object id) {
        if (id == null) {
            return;
        }
        this.explicitBuffer.remove(id);
        this.scanBuffer.remove(id);
    }

    protected synchronized ValueSet getAndRemoveFromExplicitBuffer() {
        String methodName = "getAndRemoveFromExplicitBuffer()";
        ValueSet valueSet = null;
        if (this.explicitBuffer.size() == 0) {
            valueSet = new ValueSet(1);
        } else {
            valueSet = new ValueSet(this.explicitBuffer.size());
            for (Object current : this.explicitBuffer.keySet()) {
                byte info = (Byte)this.explicitBuffer.get(current);
                if ((info & 0x20) != 0) continue;
                valueSet.add(current);
            }
            this.explicitBuffer.clear();
        }
        this.traceDebug("getAndRemoveFromExplicitBuffer()", "cacheName=" + this.cod.cacheName + " bufferSize=" + valueSet.size());
        return valueSet;
    }

    protected synchronized boolean findAndRemoveFromGCBuffer(long expirationTime, int hashcode, int size) {
        int i;
        HTODDynacache.EvictionTableEntry evt = null;
        for (i = 0; i < this.garbageCollectorBuffer.size(); ++i) {
            evt = (HTODDynacache.EvictionTableEntry)this.garbageCollectorBuffer.get(i);
            if (evt.expirationTime == expirationTime && evt.hashcode == hashcode && evt.size == size) break;
        }
        if (i < this.garbageCollectorBuffer.size()) {
            this.garbageCollectorBuffer.remove(i);
            if (evt != null) {
                this.cod.htod.evictionEntryPool.add(evt);
            }
            return true;
        }
        return false;
    }

    protected synchronized void clear(int bufferType) {
        String methodName = "clear()";
        if (bufferType == 2) {
            this.explicitBuffer.clear();
        } else if (bufferType == 1) {
            this.scanBuffer.clear();
        } else if (bufferType == 3) {
            for (int i = 0; i < this.garbageCollectorBuffer.size(); ++i) {
                HTODDynacache.EvictionTableEntry evt = (HTODDynacache.EvictionTableEntry)this.garbageCollectorBuffer.get(i);
                this.cod.htod.evictionEntryPool.add(evt);
            }
            this.garbageCollectorBuffer.clear();
        }
        this.traceDebug("clear()", "cacheName=" + this.cod.cacheName + " bufferType=" + bufferType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void invokeBackgroundInvalidation(boolean scan) {
        String methodName = "invokeBackgroundInvalidation()";
        if (!this.stopping) {
            Object object = this.cod.diskCleanupThread.dcMonitor;
            synchronized (object) {
                if (this.cod.diskCleanupThread.currentThread != null) {
                    this.cod.invokeDiskCleanup(scan);
                } else if (scan) {
                    this.traceDebug("invokeBackgroundInvalidation()", "cacheName=" + this.cod.cacheName + " set cleanupDiskPending to true");
                    this.cleanupDiskPending = true;
                }
            }
        }
    }

    protected synchronized boolean contains(Object id) {
        boolean found = false;
        if (this.explicitBuffer.containsKey(id) || this.scanBuffer.contains(id)) {
            found = true;
        }
        return found;
    }

    @Trivial
    public synchronized boolean isFull() {
        boolean isFull = false;
        int size = this.explicitBuffer.size() + this.scanBuffer.size() + this.garbageCollectorBuffer.size();
        if (size > this.maxInvalidationBufferSize || System.currentTimeMillis() - this.lastRemoveTime >= (long)this.maxInvalidationBufferLife) {
            isFull = true;
            this.setlastRemoveTime();
        }
        return isFull;
    }

    protected synchronized void filter(ValueSet filterValueSet) {
        boolean explicitBufferEmpty = this.explicitBuffer.isEmpty();
        boolean scanBufferEmpty = this.scanBuffer.isEmpty();
        if (!(filterValueSet == null || filterValueSet.isEmpty() || explicitBufferEmpty && scanBufferEmpty)) {
            Iterator it = filterValueSet.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!explicitBufferEmpty && this.explicitBuffer.containsKey(o)) {
                    it.remove();
                    continue;
                }
                if (scanBufferEmpty || !this.scanBuffer.contains(o)) continue;
                it.remove();
            }
        }
    }

    private void filter(ValueSet filterValueSet, ValueSet valueSet) {
        if (filterValueSet != null && valueSet != null && !filterValueSet.isEmpty() && !valueSet.isEmpty()) {
            Iterator it = filterValueSet.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!valueSet.contains(o)) continue;
                it.remove();
            }
        }
    }

    private void filter(ValueSet filterValueSet, HashMap hashmap) {
        if (filterValueSet != null && hashmap != null && !filterValueSet.isEmpty() && !hashmap.isEmpty()) {
            Iterator it = filterValueSet.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!hashmap.containsKey(o)) continue;
                it.remove();
            }
        }
    }

    @Trivial
    protected synchronized int size(int bufferType) {
        if (bufferType == 2) {
            return this.explicitBuffer.size();
        }
        if (bufferType == 1) {
            return this.scanBuffer.size();
        }
        if (bufferType == 3) {
            return this.garbageCollectorBuffer.size();
        }
        return 0;
    }

    @Trivial
    protected synchronized int size() {
        return this.explicitBuffer.size() + this.scanBuffer.size();
    }

    protected synchronized boolean isCleanupPending() {
        return this.cleanupDiskPending;
    }

    protected synchronized void resetCleanupPending() {
        String methodName = "resetCleanupPending()";
        this.cleanupDiskPending = false;
        this.traceDebug("resetCleanupPending()", "cacheName=" + this.cod.cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean isBackgroundInvalidationInProgress() {
        boolean cleanupThreadRunning = false;
        if (this.cod.diskCleanupThread != null) {
            Object object = this.cod.diskCleanupThread.dcMonitor;
            synchronized (object) {
                cleanupThreadRunning = this.cod.diskCleanupThread.currentThread != null;
            }
        }
        boolean garbageCollectorThreadRunning = false;
        if (this.cod.garbageCollectionThread != null) {
            Object object = this.cod.garbageCollectionThread.gcMonitor;
            synchronized (object) {
                garbageCollectorThreadRunning = this.cod.garbageCollectionThread.currentThread != null;
            }
        }
        return cleanupThreadRunning || garbageCollectorThreadRunning;
    }

    protected synchronized boolean isLoopOnce() {
        String methodName = "isLoopOnce()";
        if (this.loopOnce) {
            this.traceDebug("isLoopOnce()", "cacheName=" + this.cod.cacheName + " isLoopOnce=" + this.loopOnce + " explicitBuffer=" + this.explicitBuffer.size() + " scanBuffer=" + this.scanBuffer.size());
        }
        return this.loopOnce;
    }

    protected synchronized void setLoopOnce(boolean loopOnce) {
        String methodName = "setLoopOnce()";
        this.loopOnce = loopOnce;
        this.traceDebug("setLoopOnce()", "cacheName=" + this.cod.cacheName + " loopOnce=" + loopOnce + " explicitBuffer=" + this.explicitBuffer.size() + " scanBuffer=" + this.scanBuffer.size());
    }

    @Trivial
    protected synchronized void setlastRemoveTime() {
        this.lastRemoveTime = System.currentTimeMillis();
    }

    protected synchronized void setStopping(boolean stopping) {
        String methodName = "setStopping()";
        this.stopping = stopping;
        this.traceDebug("setStopping()", "cacheName=" + this.cod.cacheName + " stopping=" + this.stopping);
    }

    protected synchronized boolean isDiskClearInProgress() {
        return this.diskClearInProgress;
    }

    protected synchronized void setDiskClearInProgress(boolean inProgress) {
        this.diskClearInProgress = inProgress;
    }

    private void traceDebug(String methodName, String message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " " + message), (Object[])new Object[0]);
        }
    }
}

