/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.cache.DistributedObjectCache;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.cache.Scheduler;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.intf.DCacheConfig;
import com.ibm.ws.cache.util.FieldInitializer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cache.CacheConfig;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

public class CacheConfig
implements DCacheConfig,
Cloneable {
    private static TraceComponent tc = Tr.register(CacheConfig.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public static final String CACHE_NAME = "com.ibm.ws.cache.CacheConfig.cacheName";
    public static final String CACHE_SIZE = "com.ibm.ws.cache.CacheConfig.cacheSize";
    public static final String ENABLE_DISK_OFFLOAD = "com.ibm.ws.cache.CacheConfig.enableDiskOffload";
    public static final String DISK_OFFLOAD_LOCATION = "com.ibm.ws.cache.CacheConfig.diskOffloadLocation";
    public static final String USE_LISTENER_CONTEXT = "com.ibm.ws.cache.CacheConfig.useListenerContext";
    public static final String FLUSH_TO_DISK_ON_STOP = "com.ibm.ws.cache.CacheConfig.flushToDiskOnStop";
    public static final String ENABLE_LOCKING_SUPPORT = "com.ibm.ws.cache.CacheConfig.enableLockingSupport";
    public static final String DISABLE_DEPENDENCY_ID = "com.ibm.ws.cache.CacheConfig.disableDependencyId";
    public static final String DISABLE_TEMPLATES_SUPPORT = "com.ibm.ws.cache.CacheConfig.disableTemplatesSupport";
    public static final String ENABLE_NIO_SUPPORT = "com.ibm.ws.cache.CacheConfig.enableNioSupport";
    public static final String ENABLE_REPLICATION_ACKS = "com.ibm.ws.cache.CacheConfig.enableReplicationAcks";
    public static final String ENABLE_CACHE_REPLICATION = "com.ibm.ws.cache.CacheConfig.enableCacheReplication";
    public static final String REPLICATION_DOMAIN = "com.ibm.ws.cache.CacheConfig.replicationDomain";
    public static final String DISK_CLEANUP_FREQUENCY = "com.ibm.ws.cache.CacheConfig.htodCleanupFrequency";
    public static final String DISK_DELAY_OFFLOAD = "com.ibm.ws.cache.CacheConfig.htodDelayOffload";
    public static final String DISK_DELAY_OFFLOAD_ENTRIES_LIMIT = "com.ibm.ws.cache.CacheConfig.htodDelayOffloadEntriesLimit";
    public static final String DISK_DELAY_OFFLOAD_DEPID_BUCKETS = "com.ibm.ws.cache.CacheConfig.htodDelayOffloadDepIdBuckets";
    public static final String DISK_DELAY_OFFLOAD_TEMPLATE_BUCKETS = "com.ibm.ws.cache.CacheConfig.htodDelayOffloadTemplateBuckets";
    public static final String IGNORE_VALUE_IN_INVALIDATION_EVENT = "com.ibm.ws.cache.CacheConfig.ignoreValueInInvalidationEvent";
    public static final String DISKCACHE_PERFORMANCE_LEVEL = "com.ibm.ws.cache.CacheConfig.diskCachePerformanceLevel";
    public static final String DISKCACHE_EVICTION_POLICY = "com.ibm.ws.cache.CacheConfig.diskCacheEvictionPolicy";
    public static final String DISKCACHE_HIGH_THRESHOLD = "com.ibm.ws.cache.CacheConfig.diskCacheHighThreshold";
    public static final String DISKCACHE_LOW_THRESHOLD = "com.ibm.ws.cache.CacheConfig.diskCacheLowThreshold";
    public static final String DISKCACHE_SIZE = "com.ibm.ws.cache.CacheConfig.diskCacheSize";
    public static final String DISKCACHE_SIZE_GB = "com.ibm.ws.cache.CacheConfig.diskCacheSizeInGB";
    public static final String DISKCACHE_ENTRY_SIZE_MB = "com.ibm.ws.cache.CacheConfig.diskCacheEntrySizeInMB";
    public static final String USE_SERVER_CLASSLOADER = "com.ibm.ws.cache.CacheConfig.useServerClassLoader";
    public static final String DISKCACHE_EXPLICIT_BUFFER_LIMIT_ON_STOP = "com.ibm.ws.cache.CacheConfig.explicitBufferLimitOnStop";
    public static final String DISABLE_STORE_COOKIES = "com.ibm.ws.cache.CacheConfig.disableStoreCookies";
    public static final String FILTER_TIMEOUT_INVALIDATION = "com.ibm.ws.cache.CacheConfig.filterTimeOutInvalidation";
    public static final String FILTER_LRU_INVALIDATION = "com.ibm.ws.cache.CacheConfig.filterLRUInvalidation";
    public static final String FILTER_INACTIVITY_INVALIDATION = "com.ibm.ws.cache.CacheConfig.filterInactivityInvalidation";
    public static final String LRU_TO_DISK_TRIGGER_TIME = "com.ibm.ws.cache.CacheConfig.lruToDiskTriggerTime";
    public static final String LRU_TO_DISK_TRIGGER_PERCENT = "com.ibm.ws.cache.CacheConfig.lruToDiskTriggerPercent";
    public static final String CACHE_ENTRY_WINDOW = "com.ibm.ws.cache.CacheConfig.cacheEntryWindow";
    public static final String CACHE_PERCENTAGE_WINDOW = "com.ibm.ws.cache.CacheConfig.cachePercentageWindow";
    public static final String CACHE_INVALIDATE_ENTRY_WINDOW = "com.ibm.ws.cache.CacheConfig.cacheInvalidateEntryWindow";
    public static final String CACHE_INVALIDATE_PERCENT_WINDOW = "com.ibm.ws.cache.CacheConfig.cacheInvalidatePercentWindow";
    public static final String BATCH_UPDATE_MILLISECONDS = "com.ibm.ws.cache.CacheConfig.batchUpdateMilliseconds";
    public static final String CASCADE_CACHESPEC_PROPERTIES = "com.ibm.ws.cache.CacheConfig.cascadeCachespecProperties";
    public static final String CACHE_PROVIDER_NAME = "com.ibm.ws.cache.CacheConfig.cacheProviderName";
    public static final String MEMORY_CACHE_SIZE_IN_MB = "com.ibm.ws.cache.CacheConfig.memoryCacheSizeInMB";
    public static final String MEMORY_CACHE_HIGH_THRESHOLD = "com.ibm.ws.cache.CacheConfig.memoryCacheHighThreshold";
    public static final String MEMORY_CACHE_LOW_THRESHOLD = "com.ibm.ws.cache.CacheConfig.memoryCacheLowThreshold";
    public static final String CREATE_CACHE_AT_SERVER_STARTUP = "com.ibm.ws.cache.CacheConfig.createCacheAtServerStartup";
    public static final String REPLICATION_PAYLOAD_SIZE_IN_MB = "com.ibm.ws.cache.CacheConfig.replicationPayloadSizeInMB";
    public static final String CACHE_PROVIDER_OBJECT_GRID = "com.ibm.ws.objectgrid.dynacache.CacheProviderImpl";
    public static final String CACHE_PROVIDER_RESTORE_DYNACACHE_DEFAULTS = "com.ibm.ws.cache.CacheConfig.restoreDynacacheDefaults";
    public static final String AUTO_FLUSH_IMPORTS = "com.ibm.ws.cache.CacheConfig.autoFlushIncludes";
    public static final String PROPOGATE_INVALIDATIONS_NOT_SHARED = "com.ibm.ws.cache.CacheConfig.propogateInvalidationsNotShared";
    public static final String ALWAYS_SET_SURROGATE_CONTROL_HDR = "com.ibm.ws.cache.CacheConfig.alwaysSetSurrogateControlHdr";
    public static final String DISCARD_JSP_CONTENT = "discardJSPContent";
    public static final String CACHE_PROVIDER_DYNACACHE = "default";
    public static final String USE_602_REQUIRED_ATTR_COMPATIBILITY = "com.ibm.ws.use602RequiredAttrCompatibility";
    public static final String ALWAYS_TRIGGER_COMMAND_INVALIDATIONS = "com.ibm.ws.CacheConfig.alwaysTriggerCommandInvalidations";
    public static final String CACHE_ENTRY_REF_COUNT_TRACKING = "com.ibm.ws.cache.CacheConfig.refCountTracking";
    public static final String ENABLE_INTER_CELL_INVALIDATION = "com.ibm.ws.cache.CacheConfig.enableInterCellInvalidation";
    public static final String ALWAYS_SYNCHRONIZE_ON_GETS = "com.ibm.ws.cache.CacheConfig.alwaysSynchronizeOnGets";
    public static final String FILTERED_STATUS_CODES = "com.ibm.ws.cache.CacheConfig.filteredStatusCodes";
    public static final String IGNORE_CACHEABLE_COMMAND_SERIALIZATION_EXCEPTION = "com.ibm.ws.cache.CacheConfig.ignoreCacheableCommandDeserializationException";
    public static final String DISK_DEPENDENCY_CACHE_INDEX_ENABLED = "com.ibm.ws.cache.CacheConfig.htodDependencyCacheIndexEnabled";
    public static final String LIBRARY_REF = "com.ibm.ws.cache.CacheConfig.libraryRef";
    public static final String WEBSERVICES_SET_REQUIRED_TRUE = "com.ibm.ws.cache.CacheConfig.webservicesSetRequiredTrue";
    public static final int CACHE_UNITS_ENTRIES = 1;
    public static final int CACHE_UNITS_KILOBYTES = 2;
    public static final int HIGH = 3;
    public static final int CUSTOM = 2;
    public static final int BALANCED = 1;
    public static final int LOW = 0;
    public static final int EVICTION_NONE = 0;
    public static final int EVICTION_RANDOM = 1;
    public static final int EVICTION_SIZE_BASED = 2;
    boolean filterTimeOutInvalidation = false;
    boolean filterLRUInvalidation = false;
    boolean filterInactivityInvalidation = false;
    public static final int DEFAULT_DISABLE_CACHE_SIZE_MB = -1;
    public static final int DEFAULT_DISKCACHE_PERFORMANCE_LEVEL = 1;
    public static final int DEFAULT_DISKCACHE_EVICTION_POLICY = 0;
    public static final boolean DEFAULT_DISKCACHE_DELAY_OFFLOAD = true;
    public static final int DEFAULT_DISKCACHE_CLEANUP_FREQUENCY = 0;
    public static final int DEFAULT_MAX_BUFFERED_CACHE_IDS_PER_METADATA = 1000;
    public static final int DEFAULT_MAX_BUFFERED_DEPENDENCY_IDS = 1000;
    public static final int DEFAULT_MAX_BUFFERED_TEMPLATES = 100;
    public static final int DEFAULT_HIGH_THRESHOLD = 80;
    public static final int DEFAULT_LOW_THRESHOLD = 70;
    public static final int DEFAULT_DISKCACHE_SIZE = 0;
    public static final int DEFAULT_DISKCACHE_SIZE_GB = 0;
    public static final int DEFAULT_DISKCACHE_ENTRY_SIZE_MB = 0;
    public static final int DEFAULT_DISKCACHE_POOL_ENTRY_LIFE = 300000;
    public static final int DEFAULT_EXPLICIT_BUFFER_LIMIT_ON_STOP = 0;
    public static final int DEFAULT_ENTRY_WINDOW = 50;
    public static final int DEFAULT_PERCENTAGE_WINDOW = 2;
    public static final int DEFAULT_TLD_TIME_GRANULARITY = 5;
    public static final int DEFAULT_LRU_TO_DISK_TRIGGER_TIME = 5000;
    public static final int DEFAULT_LRU_TO_DISK_TRIGGER_PERCENT = 0;
    public static final int DEFAULT_LRU_TO_DISK_TRIGGER_TIME_FOR_TRIMCACHE = 1000;
    public static final int DEFAULT_REPLICATION_PAYLOAD_SIZE_IN_MB = 10;
    public static final int MAX_DISKCACHE_PERFORMANCE_LEVEL = 3;
    public static final int MIN_DISKCACHE_PERFORMANCE_LEVEL = 0;
    public static final int MAX_CLEANUP_FREQUENCY = 1440;
    public static final int MIN_CLEANUP_FREQUENCY = 0;
    public static final int MAX_DISKCACHE_BUFFERED_CACHE_IDS_PER_METADATA = Integer.MAX_VALUE;
    public static final int MIN_DISKCACHE_BUFFERED_CACHE_IDS_PER_METADATA = 100;
    public static final int MAX_DISKCACHE_BUFFERED_DEPENDENCY_IDS = Integer.MAX_VALUE;
    public static final int MIN_DISKCACHE_BUFFERED_DEPENDENCY_IDS = 100;
    public static final int MAX_DISKCACHE_BUFFERED_TEMPLATES = Integer.MAX_VALUE;
    public static final int MIN_DISKCACHE_BUFFERED_TEMPLATES = 10;
    public static final int MAX_DISKCACHE_EVICTION_POLICY = 2;
    public static final int MIN_DISKCACHE_EVICTION_POLICY = 0;
    public static final int MAX_DISKCACHE_SIZE = Integer.MAX_VALUE;
    public static final int MIN_DISKCACHE_SIZE = 20;
    public static final int MAX_DISKCACHE_SIZE_GB = Integer.MAX_VALUE;
    public static final int MIN_DISKCACHE_SIZE_GB = 3;
    public static final int MAX_DISKCACHE_ENTRY_SIZE_MB = Integer.MAX_VALUE;
    public static final int MIN_DISKCACHE_ENTRY_SIZE_MB = 0;
    public static final int MAX_HIGH_THRESHOLD = 100;
    public static final int MIN_HIGH_THRESHOLD = 1;
    public static final int MAX_LOW_THRESHOLD = 100;
    public static final int MIN_LOW_THRESHOLD = 1;
    public static final int MAX_LRU_TO_DISK_TRIGGER_TIME = 5000;
    public static final int MIN_LRU_TO_DISK_TRIGGER_TIME = 1;
    public static final int MAX_LRU_TO_DISK_TRIGGER_PERCENT = 100;
    public static final int MIN_LRU_TO_DISK_TRIGGER_PERCENT = 0;
    public static int DEFAULT_PRIORITY = 1;
    public static int MAX_PRIORITY = 16;
    String cacheProviderName = "default";
    boolean restoreDynacacheDefaults = true;
    boolean defaultProvider = true;
    boolean createCacheAtServerStartup = false;
    boolean autoFlushIncludes = false;
    String cacheName = null;
    String jndiName = null;
    String tempDir = null;
    String dtdDir = null;
    String serverServerName = null;
    int cachePriority = DEFAULT_PRIORITY;
    int jspCachePriority = DEFAULT_PRIORITY;
    int commandCachePriority = DEFAULT_PRIORITY;
    int diskHashBuckets = 1024;
    boolean webservicesSetRequiredTrue = true;
    int cacheSize = 2000;
    int memoryCacheSizeInMB = -1;
    int memoryCacheHighThreshold = 95;
    int memoryCacheLowThreshold = 80;
    String replicationDomain = null;
    boolean enableCacheReplication = false;
    int replicationType = 0;
    int defaultShareType = 1;
    int pushFrequency = 1;
    int batchUpdateInterval = 1000;
    int batchUpdateMilliseconds = -1;
    boolean drsDisabled = false;
    boolean drsBootstrapEnabled = true;
    int congestionSleepTimeMilliseconds = 250;
    int replicationPayloadSizeInMB = 10;
    boolean enableDiskOffload = false;
    String diskOffloadLocation = null;
    boolean flushToDiskOnStop = false;
    int htodCleanupFrequency = 0;
    int diskCachePerformanceLevel = 3;
    int diskCacheEntrySizeInMB = 0;
    int diskCacheSizeInGB = 0;
    int diskCacheSize = 0;
    int diskCacheEvictionPolicy = 1;
    int diskCacheHighThreshold = 80;
    int diskCacheLowThreshold = 70;
    List<ExternalCacheGroup> externalGroups = new ArrayList<ExternalCacheGroup>();
    boolean useListenerContext = false;
    boolean disableDependencyId = false;
    boolean enableLockingSupport = false;
    boolean disableTemplatesSupport = false;
    boolean enableReplicationAcks = false;
    boolean enableNioSupport = false;
    boolean enableServletSupport = true;
    boolean propogateInvalidationsNotShared = false;
    boolean alwaysSetSurrogateControlHdr = false;
    String filteredStatusCodes = null;
    int maxTimeLimitInSeconds = 86400;
    int configReloadInterval = 5000;
    int timeGranularityInSeconds = 5;
    int lruToDiskTriggerTime = 5000;
    int lruToDiskTriggerPercent = 0;
    int timeHoldingInvalidations = 200000;
    int htodCleanupHour = 0;
    long htodInvalInterval = 86400000L;
    boolean htodDelayOffload = true;
    int htodDelayOffloadDepIdBuckets = 1000;
    int htodDelayOffloadTemplateBuckets = 100;
    int htodDelayOffloadEntriesLimit = 1000;
    int htodDataHashtableSize = 477551;
    int htodDepIdHashtableSize = 47743;
    int htodTemplateHashtableSize = 1031;
    int htodNumberOfPools = 20;
    int htodPoolSize = 2;
    int htodPoolEntryLife = 300000;
    int htodInvalidationBufferSize = 1000;
    int htodInvalidationBufferLife = 10000;
    boolean htodDependencyCacheIndexEnabled = false;
    int explicitBufferLimitOnStop = 0;
    int cacheEntryWindow = 50;
    int cachePercentageWindow = 2;
    int cacheInvalidateEntryWindow = 50;
    int cacheInvalidatePercentWindow = 2;
    public boolean disableTemplateInvalidation = false;
    boolean ignoreValueInInvalidationEvent = false;
    boolean useServerClassLoader = false;
    boolean cascadeCachespecProperties = false;
    boolean use602RequiredAttrCompatibility = false;
    boolean alwaysTriggerCommandInvalidations = false;
    boolean alwaysSynchronizeOnGets = false;
    boolean ignoreCacheableCommandDeserializationException = false;
    String disableStoreCookies = "none";
    boolean cacheInstanceStoreCookies = true;
    String topology = "";
    String libraryRef = null;
    DistributedObjectCache distributedObjectCache = null;
    DCache cache = null;
    ConcurrentHashMap _passedInProperties = new ConcurrentHashMap();
    boolean refCountTracking = false;
    boolean enableInterCellInvalidation = false;
    int[] statusCodesArray = null;

    public static Properties convert(Map<String, Object> map) {
        Properties p = new Properties();
        Set<Map.Entry<String, Object>> set = map.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            p.put(entry.getKey(), entry.getValue());
        }
        return p;
    }

    public CacheConfig() {
        FieldInitializer.initFromSystemProperties(this);
        this.determineCacheProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheConfig(Map<String, Object> map) {
        Properties props;
        FieldInitializer.initFromSystemProperties(this);
        this.overrideCacheConfig(CacheConfig.convert(map));
        this.determineCacheProvider();
        this._passedInProperties.putAll(map);
        Properties properties = props = System.getProperties();
        synchronized (properties) {
            this._passedInProperties.putAll(props);
        }
        WsLocationAdmin locAdmin = Scheduler.getLocationAdmin();
        if (locAdmin != null) {
            this.serverServerName = locAdmin.getServerName();
        }
        if (this.filteredStatusCodes != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("filteredStatusCodes: " + this.filteredStatusCodes), (Object[])new Object[0]);
            }
            StringTokenizer st = new StringTokenizer(this.filteredStatusCodes);
            this.statusCodesArray = new int[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                try {
                    this.statusCodesArray[i] = Integer.parseInt(st.nextToken());
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("added filteredStatusCodes: " + this.statusCodesArray[i]), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException ex) {
                    Tr.error((TraceComponent)tc, (String)("Error parsing filteredStatusCodes: " + this.filteredStatusCodes), (Object[])new Object[0]);
                    this.statusCodesArray[i] = -1;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheConfig(Properties properties, CacheConfig config) {
        Properties props;
        this.serverServerName = Scheduler.getLocationAdmin().getServerName();
        this.cachePriority = config.cachePriority;
        this.jspCachePriority = config.jspCachePriority;
        this.commandCachePriority = config.commandCachePriority;
        this.diskHashBuckets = config.diskHashBuckets;
        this.cacheSize = config.cacheSize;
        this.cacheProviderName = config.cacheProviderName;
        this.cacheProviderName = config.cacheProviderName;
        this.enableCacheReplication = config.enableCacheReplication;
        this.replicationType = config.replicationType;
        this.setBatchUpdateInterval(config, config.pushFrequency);
        this.enableDiskOffload = false;
        this.flushToDiskOnStop = false;
        this.diskCacheSizeInGB = config.diskCacheSizeInGB;
        this.diskCacheSize = config.diskCacheSize;
        this.diskCacheEntrySizeInMB = config.diskCacheEntrySizeInMB;
        this.diskCachePerformanceLevel = config.diskCachePerformanceLevel;
        this.htodCleanupFrequency = config.htodCleanupFrequency;
        this.diskCacheEvictionPolicy = config.diskCacheEvictionPolicy;
        this.diskCacheHighThreshold = config.diskCacheHighThreshold;
        this.diskCacheLowThreshold = config.diskCacheLowThreshold;
        this.htodDelayOffloadEntriesLimit = config.htodDelayOffloadEntriesLimit;
        this.htodDelayOffloadDepIdBuckets = config.htodDelayOffloadDepIdBuckets;
        this.htodDelayOffloadTemplateBuckets = config.htodDelayOffloadTemplateBuckets;
        FieldInitializer.initFromSystemProperties(this);
        this.overrideCacheConfig(properties);
        this._passedInProperties.putAll(properties);
        Properties properties2 = props = System.getProperties();
        synchronized (properties2) {
            this._passedInProperties.putAll(props);
        }
        this.determineCacheProvider();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CacheConfig():1 cacheName=" + this.cacheName), (Object[])new Object[0]);
        }
    }

    protected void reset() {
        this.tempDir = null;
        this.dtdDir = null;
        this.diskOffloadLocation = null;
        this.cacheName = null;
        this.distributedObjectCache = null;
        this.cache = null;
        this.serverServerName = null;
        if (this.externalGroups != null) {
            this.externalGroups.clear();
        }
    }

    private void processOffloadDirectory() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processOffloadDirectory", (Object[])new Object[]{this.diskOffloadLocation, this.enableDiskOffload});
        }
        if (null == this.tempDir) {
            WsLocationAdmin locationAdmin = Scheduler.getLocationAdmin();
            this.tempDir = null == locationAdmin ? System.getProperty("java.io.tmpdir") : Scheduler.getLocationAdmin().resolveString("${server.workarea.dir}/");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"cache default dir ", (Object[])new Object[]{this.tempDir});
            }
        }
        if (this.enableDiskOffload) {
            this.diskOffloadLocation = this.diskOffloadLocation != null && !this.diskOffloadLocation.isEmpty() ? Scheduler.getLocationAdmin().resolveString(this.diskOffloadLocation) : this.tempDir + "_dynacache";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processOffloadDirectory", (Object)this.diskOffloadLocation);
        }
    }

    public void overrideCacheConfig(Properties properties) {
        if (properties != null) {
            FieldInitializer.initFromSystemProperties(this, properties);
        }
        this.processOffloadDirectory();
        if (!this.enableServletSupport) {
            this.disableTemplatesSupport = true;
        }
    }

    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.CacheConfig", (String)"314");
        }
        ((CacheConfig)o).cacheName = null;
        ((CacheConfig)o).jndiName = null;
        ((CacheConfig)o).cache = null;
        ((CacheConfig)o).distributedObjectCache = null;
        ((CacheConfig)o).enableServletSupport = false;
        ((CacheConfig)o).enableDiskOffload = false;
        ((CacheConfig)o).flushToDiskOnStop = false;
        ((CacheConfig)o).disableDependencyId = false;
        ((CacheConfig)o).disableTemplatesSupport = false;
        return o;
    }

    @Override
    public int getBatchUpdateInterval() {
        return this.batchUpdateInterval;
    }

    @Override
    public int getCachePriority() {
        return this.cachePriority;
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    public int getCacheSizeInMB() {
        return this.memoryCacheSizeInMB;
    }

    @Override
    public int getCleanupFrequency() {
        return this.htodCleanupFrequency;
    }

    @Override
    public int getDelayOffloadDepIdBuckets() {
        return this.htodDelayOffloadDepIdBuckets;
    }

    @Override
    public int getDelayOffloadEntriesLimit() {
        return this.htodDelayOffloadEntriesLimit;
    }

    @Override
    public int getDelayOffloadTemplateBuckets() {
        return this.htodDelayOffloadTemplateBuckets;
    }

    @Override
    public int getDiskCacheEntrySizeInMB() {
        return this.diskCacheEntrySizeInMB;
    }

    @Override
    public int getDiskCacheEvictionPolicy() {
        return this.diskCacheEvictionPolicy;
    }

    @Override
    public int getDiskCacheHighThreshold() {
        return this.diskCacheHighThreshold;
    }

    @Override
    public int getDiskCacheLowThreshold() {
        return this.diskCacheLowThreshold;
    }

    @Override
    public int getDiskCachePerformanceLevel() {
        return this.diskCachePerformanceLevel;
    }

    @Override
    public int getDiskCacheSize() {
        return this.diskCacheSize;
    }

    @Override
    public int getDiskCacheSizeInGB() {
        return this.diskCacheSizeInGB;
    }

    @Override
    public int getEntryWindow() {
        return this.cacheEntryWindow;
    }

    @Override
    public int getHighThresholdCacheSizeInMB() {
        return this.memoryCacheHighThreshold;
    }

    @Override
    public int getLowThresholdCacheSizeInMB() {
        return this.memoryCacheLowThreshold;
    }

    @Override
    public int getInvalidateEntryWindow() {
        return this.cacheInvalidateEntryWindow;
    }

    @Override
    public int getInvalidatePercentageWindow() {
        return this.cacheInvalidatePercentWindow;
    }

    @Override
    public int getLruToDiskTriggerPercent() {
        return this.lruToDiskTriggerPercent;
    }

    @Override
    public int getLruToDiskTriggerTime() {
        return this.lruToDiskTriggerTime;
    }

    @Override
    public long getMaxCacheSize() {
        return this.cacheSize;
    }

    @Override
    public long getMaxCacheSizeInMB() {
        return this.memoryCacheSizeInMB;
    }

    @Override
    public int getPercentageWindow() {
        return this.cachePercentageWindow;
    }

    @Override
    public int getCongestionSleepTimeMilliseconds() {
        return this.congestionSleepTimeMilliseconds;
    }

    @Override
    public boolean isCacheInstanceStoreCookies() {
        return this.cacheInstanceStoreCookies;
    }

    @Override
    public boolean isCascadeCachespecProperties() {
        return this.cascadeCachespecProperties;
    }

    @Override
    public boolean isDelayOffload() {
        return this.htodDelayOffload;
    }

    @Override
    public boolean isDrsBootstrapEnabled() {
        return this.drsBootstrapEnabled;
    }

    @Override
    public boolean isDrsDisabled() {
        return this.drsDisabled;
    }

    @Override
    public boolean isEnableCacheReplication() {
        return this.enableCacheReplication;
    }

    @Override
    public boolean isEnableDiskOffload() {
        return this.enableDiskOffload;
    }

    @Override
    public boolean isEnableServletSupport() {
        return this.enableServletSupport;
    }

    @Override
    public boolean isFilterLRUInvalidation() {
        return this.filterLRUInvalidation;
    }

    @Override
    public boolean isFilterTimeOutInvalidation() {
        return this.filterTimeOutInvalidation;
    }

    @Override
    public boolean isFilterInactivityInvalidation() {
        return this.filterInactivityInvalidation;
    }

    @Override
    public boolean isFlushToDiskOnStop() {
        return this.flushToDiskOnStop;
    }

    @Override
    public boolean isUseServerClassLoader() {
        return this.useServerClassLoader;
    }

    @Override
    public void setCacheInstanceStoreCookies(boolean cacheInstanceStoreCookies) {
        this.cacheInstanceStoreCookies = cacheInstanceStoreCookies;
    }

    @Override
    public void setCachePriority(int cachePriority) {
        if (cachePriority < 0) {
            cachePriority = DEFAULT_PRIORITY;
        }
        this.cachePriority = cachePriority;
    }

    public void setDiskOffloadLocation(String s) {
        this.diskOffloadLocation = s;
    }

    @Override
    public void setDrsBootstrapEnabled(boolean drsBootstrapEnabled) {
        this.drsBootstrapEnabled = drsBootstrapEnabled;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setDRSBootstrap() cacheName=" + this.cacheName + " drsBootstrap=" + drsBootstrapEnabled), (Object[])new Object[0]);
        }
    }

    @Override
    public void setDrsDisabled(boolean drsDisabled) {
        this.drsDisabled = drsDisabled;
    }

    public void setEnableDiskOffload(boolean b) {
        this.enableDiskOffload = b;
        this.processOffloadDirectory();
    }

    public void setEnableNioSupport(boolean b) {
        this.enableNioSupport = b;
    }

    public void setMaxCacheSize(int size) {
        this.cacheSize = size;
    }

    public void setOffloadOffloadLocationAndProcess(String s) {
        this.diskOffloadLocation = s;
        this.processOffloadDirectory();
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public int getDefaultShareType() {
        return this.defaultShareType;
    }

    @Override
    public boolean isDisableDependencyId() {
        return this.disableDependencyId;
    }

    @Override
    public boolean isEnableNioSupport() {
        return this.enableNioSupport;
    }

    @Override
    public String getServerServerName() {
        return this.serverServerName;
    }

    @Override
    public CacheConfig.EvictorAlgorithmType getEvictorAlgorithmType() {
        return CacheConfig.EvictorAlgorithmType.LRUEvictor;
    }

    @Override
    public boolean isDistributed() {
        return this.isEnableCacheReplication();
    }

    @Override
    public int getReplicationPayloadSizeInMB() {
        return this.replicationPayloadSizeInMB;
    }

    @Override
    public String getCacheProviderName() {
        return this.cacheProviderName;
    }

    @Override
    public boolean isAutoFlushIncludes() {
        return this.autoFlushIncludes;
    }

    @Override
    public boolean alwaysSetSurrogateControlHdr() {
        return this.alwaysSetSurrogateControlHdr;
    }

    @Override
    public boolean isUse602RequiredAttrCompatibility() {
        return this.use602RequiredAttrCompatibility;
    }

    @Override
    public boolean alwaysTriggerCommandInvalidations() {
        return this.alwaysTriggerCommandInvalidations;
    }

    @Override
    public boolean alwaysSynchronizeOnGets() {
        return this.alwaysSynchronizeOnGets;
    }

    @Override
    public void setAlwaysSynchronizeOnGets(boolean alwaysSynchronizeOnGets) {
        this.alwaysSynchronizeOnGets = alwaysSynchronizeOnGets;
    }

    @Override
    public int[] getFilteredStatusCodes() {
        return this.statusCodesArray;
    }

    @Trivial
    public boolean isRefCountTrackingEnabled() {
        return this.refCountTracking;
    }

    @Override
    public boolean isEnableInterCellInvalidation() {
        return this.enableInterCellInvalidation;
    }

    @Override
    public boolean isWebservicesSetRequiredTrue() {
        return this.webservicesSetRequiredTrue;
    }

    public void determineCacheProvider() {
        this.defaultProvider = true;
        if (this.cacheProviderName.equals("")) {
            this.cacheProviderName = CACHE_PROVIDER_DYNACACHE;
        }
        if (!this.cacheProviderName.equals(CACHE_PROVIDER_DYNACACHE)) {
            this.defaultProvider = false;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Alternate CacheProvider " + this.cacheProviderName + " set for " + this.cacheName), (Object[])new Object[0]);
            }
        }
    }

    @Override
    @Trivial
    public boolean isDefaultCacheProvider() {
        return this.defaultProvider;
    }

    public void resetProvider(String cacheName) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Reverting to the default Dynacache cache provider", (Object[])new Object[0]);
        }
        this.cacheProviderName = CACHE_PROVIDER_DYNACACHE;
        this.enableCacheReplication = false;
        this.defaultProvider = true;
        this.cacheName = cacheName;
    }

    void restoreDynacacheProviderDefaults() {
        if (this.restoreDynacacheDefaults && this.cacheProviderName != CACHE_PROVIDER_DYNACACHE) {
            this.cacheProviderName = CACHE_PROVIDER_DYNACACHE;
            this.enableCacheReplication = false;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("OVERRIDING Object Grid default for " + this.cacheName), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public boolean isIgnoreCacheableCommandDeserializationException() {
        return this.ignoreCacheableCommandDeserializationException;
    }

    private void setBatchUpdateInterval(Object config, int pushFrequency) {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setBatchUpdateInterval", (Object[])new Object[]{config});
        }
        if (pushFrequency < 1) {
            pushFrequency = 1;
        }
        if (this.batchUpdateMilliseconds == -1) {
            this.batchUpdateInterval = pushFrequency * 1000;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setBatchUpdateInterval", (Object)new Integer(this.batchUpdateInterval));
        }
    }

    public void setDiskCacheEvictionPolicy(int evictionPolicy) {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setDiskCacheEvictionPolicy", (Object[])new Object[]{new Integer(evictionPolicy)});
        }
        if (evictionPolicy >= 0 && evictionPolicy <= 2) {
            this.diskCacheEvictionPolicy = evictionPolicy;
        }
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setDiskCacheEvictionPolicy", (Object[])new Object[]{new Integer(this.diskCacheEvictionPolicy)});
        }
    }

    @Override
    public String getServerNodeName() {
        return null;
    }

    @Override
    public Map<String, String> getProperties() {
        return this._passedInProperties;
    }

    public String toString() {
        return "CacheConfig [   cacheName=" + this.cacheName + ", jndiName=" + this.jndiName + ", cacheSize=" + this.cacheSize + ", cache=" + this.cache + ", libraryRef=" + this.libraryRef + ", createCacheAtServerStartup=" + this.createCacheAtServerStartup + ", distributedObjectCache=" + this.distributedObjectCache + ", defaultProvider=" + this.defaultProvider + ", enableCacheReplication=" + this.enableCacheReplication + ", enableDiskOffload=" + this.enableDiskOffload + ", enableNioSupport=" + this.enableNioSupport + ", alwaysSetSurrogateControlHdr=" + this.alwaysSetSurrogateControlHdr + ", externalGroups=" + this.externalGroups + ", alwaysSynchronizeOnGets=" + this.alwaysSynchronizeOnGets + ", alwaysTriggerCommandInvalidations=" + this.alwaysTriggerCommandInvalidations + ", cacheInstanceStoreCookies=" + this.cacheInstanceStoreCookies + ", cachePercentageWindow=" + this.cachePercentageWindow + ", cachePriority=" + this.cachePriority + ", cacheProviderName=" + this.cacheProviderName + ", cascadeCachespecProperties=" + this.cascadeCachespecProperties + ", commandCachePriority=" + this.commandCachePriority + ", configReloadInterval=" + this.configReloadInterval + ", disableDependencyId=" + this.disableDependencyId + ", disableStoreCookies=" + this.disableStoreCookies + ", disableTemplateInvalidation=" + this.disableTemplateInvalidation + ", disableTemplatesSupport=" + this.disableTemplatesSupport + ", diskCacheEntrySizeInMB=" + this.diskCacheEntrySizeInMB + ", diskCacheEvictionPolicy=" + this.diskCacheEvictionPolicy + ", diskCacheHighThreshold=" + this.diskCacheHighThreshold + ", diskCacheLowThreshold=" + this.diskCacheLowThreshold + ", diskCachePerformanceLevel=" + this.diskCachePerformanceLevel + ", diskCacheSize=" + this.diskCacheSize + ", diskCacheSizeInGB=" + this.diskCacheSizeInGB + ", diskHashBuckets=" + this.diskHashBuckets + ", diskOffloadLocation=" + this.diskOffloadLocation + ", htodCleanupFrequency=" + this.htodCleanupFrequency + ", htodCleanupHour=" + this.htodCleanupHour + ", htodDataHashtableSize=" + this.htodDataHashtableSize + ", htodDelayOffload=" + this.htodDelayOffload + ", htodDelayOffloadDepIdBuckets=" + this.htodDelayOffloadDepIdBuckets + ", htodDelayOffloadEntriesLimit=" + this.htodDelayOffloadEntriesLimit + ", htodDelayOffloadTemplateBuckets=" + this.htodDelayOffloadTemplateBuckets + ", htodDepIdHashtableSize=" + this.htodDepIdHashtableSize + ", htodDependencyCacheIndexEnabled=" + this.htodDependencyCacheIndexEnabled + ", htodInvalInterval=" + this.htodInvalInterval + ", htodInvalidationBufferLife=" + this.htodInvalidationBufferLife + ", htodInvalidationBufferSize=" + this.htodInvalidationBufferSize + ", htodNumberOfPools=" + this.htodNumberOfPools + ", htodPoolEntryLife=" + this.htodPoolEntryLife + ", htodPoolSize=" + this.htodPoolSize + ", htodTemplateHashtableSize=" + this.htodTemplateHashtableSize + ", lruToDiskTriggerPercent=" + this.lruToDiskTriggerPercent + ", lruToDiskTriggerTime=" + this.lruToDiskTriggerTime + ", explicitBufferLimitOnStop=" + this.explicitBufferLimitOnStop + ", drsBootstrapEnabled=" + this.drsBootstrapEnabled + ", drsDisabled=" + this.drsDisabled + ", dtdDir=" + this.dtdDir + ", filterInactivityInvalidation=" + this.filterInactivityInvalidation + ", filterLRUInvalidation=" + this.filterLRUInvalidation + ", filterTimeOutInvalidation=" + this.filterTimeOutInvalidation + ", filteredStatusCodes=" + this.filteredStatusCodes + ", flushToDiskOnStop=" + this.flushToDiskOnStop + ", ignoreCacheableCommandDeserializationException=" + this.ignoreCacheableCommandDeserializationException + ", ignoreValueInInvalidationEvent=" + this.ignoreValueInInvalidationEvent + ", jspCachePriority=" + this.jspCachePriority + ", memoryCacheHighThreshold=" + this.memoryCacheHighThreshold + ", memoryCacheLowThreshold=" + this.memoryCacheLowThreshold + ", memoryCacheSizeInMB=" + this.memoryCacheSizeInMB + ", refCountTracking=" + this.refCountTracking + ", serverServerName=" + this.serverServerName + ", statusCodesArray=" + Arrays.toString(this.statusCodesArray) + ", tempDir=" + this.tempDir + ", batchUpdateInterval=" + this.batchUpdateInterval + ", batchUpdateMilliseconds=" + this.batchUpdateMilliseconds + ", timeGranularityInSeconds=" + this.timeGranularityInSeconds + ", maxTimeLimitInSeconds=" + this.maxTimeLimitInSeconds + ", timeHoldingInvalidations=" + this.timeHoldingInvalidations + ", getClass()=" + this.getClass() + ", hashCode()=" + this.hashCode() + ", toString()=" + super.toString() + "]";
    }

    public boolean isCreateCacheAtServerStartup() {
        return this.createCacheAtServerStartup;
    }

    public DistributedObjectCache getDistributedObjectCache() {
        return this.distributedObjectCache;
    }

    public void setDistributedObjectCache(DistributedObjectCache cache) {
        this.distributedObjectCache = cache;
    }

    public DCache getCache() {
        return this.cache;
    }

    public void setCache(DCache cache) {
        this.cache = cache;
    }

    public List<ExternalCacheGroup> getExternalGroups() {
        return this.externalGroups;
    }

    public int getJspCachePriority() {
        return this.jspCachePriority;
    }

    public static class ExternalCacheGroupMember {
        public String address;
        public String beanName;
    }

    public static class ExternalCacheGroup {
        public String name;
        public int type;
        public List<ExternalCacheGroupMember> members = new ArrayList<ExternalCacheGroupMember>(0);
    }
}

