/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.util.ObjectSizer;
import com.ibm.ws.cache.util.SerializationUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class AliasEntry
extends CacheEntry {
    private static final long serialVersionUID = 9023191210978622958L;
    public static final String ADD_ALIAS = "AddAlias";
    public static final String REMOVE_ALIAS = "RemoveAlias";

    public AliasEntry() {
    }

    public AliasEntry(Object id, Object value, int sharingPolicy, Object[] aliasArray) {
        this.id = id;
        this.sharingPolicy = sharingPolicy;
        this.aliasList = aliasArray;
        this.setValue(value);
    }

    public Object[] getAliasArray() {
        return this.aliasList;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (!this.prepareForSerialization()) {
            throw new IOException("Object not serializable: " + (this.value == null ? "null object" : this.value.getClass().getName()));
        }
        if (this.serializedId != null) {
            out.writeInt(this.serializedId.length);
            out.write(this.serializedId);
        } else {
            out.writeInt(-1);
        }
        if (this.serializedValue != null) {
            out.writeInt(this.serializedValue.length);
            out.write(this.serializedValue);
        } else {
            out.writeInt(-1);
        }
        out.writeInt(this.timeLimit);
        out.writeLong(this.expirationTime);
        out.writeLong(this.timeStamp);
        out.writeLong(this.drsClock);
        out.writeInt(this.sharingPolicy);
        if (this.serializedAliasList != null) {
            out.writeInt(this.serializedAliasList.length);
            for (int i = 0; i < this.serializedAliasList.length; ++i) {
                byte[] aid = (byte[])this.serializedAliasList[i];
                out.writeInt(aid.length);
                out.write(aid);
            }
        } else {
            out.writeInt(-1);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        try {
            int i;
            int len;
            int keyLength = in.readInt();
            if (keyLength > 0) {
                this.serializedId = new byte[keyLength];
                in.readFully(this.serializedId);
            } else {
                this.serializedId = null;
            }
            if (this.serializedId != null) {
                try {
                    this.id = SerializationUtility.deserialize(this.serializedId, this.cacheName);
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.AliasEntry.readExternal", (String)"366", (Object)this);
                }
            } else {
                this.id = null;
            }
            if ((len = in.readInt()) > 0) {
                this.serializedValue = new byte[len];
                in.readFully(this.serializedValue);
            } else {
                this.serializedValue = null;
            }
            this.value = null;
            this.timeLimit = in.readInt();
            this.expirationTime = in.readLong();
            this.timeStamp = in.readLong();
            this.drsClock = in.readLong();
            this.sharingPolicy = in.readInt();
            int size = in.readInt();
            if (size > 0) {
                this.serializedAliasList = new Object[size];
                for (i = 0; i < size; ++i) {
                    len = in.readInt();
                    this.serializedAliasList[i] = new byte[len];
                    in.readFully((byte[])this.serializedAliasList[i]);
                }
            } else {
                this.serializedAliasList = null;
            }
            if (this.serializedAliasList != null) {
                this.aliasList = new Object[this.serializedAliasList.length];
                try {
                    for (i = 0; i < this.serializedAliasList.length; ++i) {
                        this.aliasList[i] = SerializationUtility.deserialize((byte[])this.serializedAliasList[i], this.cacheName);
                    }
                    this.serializedAliasList = null;
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.AliasEntry.readExternal", (String)"428", (Object)this);
                    this.aliasList = EMPTY_OBJECT_ARRAY;
                }
            } else {
                this.aliasList = EMPTY_OBJECT_ARRAY;
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.AliasEntry.readExternal", (String)"468", (Object)this);
        }
    }

    @Override
    public long getSerializedSize() {
        long totalSize = 0L;
        if (this.serializedId != null) {
            totalSize += ObjectSizer.getSize(this.serializedId);
        }
        if (this.serializedValue != null) {
            totalSize += ObjectSizer.getSize(this.serializedValue);
        }
        if (this.serializedAliasList != null && this.serializedAliasList.length > 0) {
            for (int i = 0; i < this.serializedAliasList.length; ++i) {
                totalSize += ObjectSizer.getSize(this.serializedAliasList[i]);
            }
        }
        return totalSize;
    }
}

