/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.Constants;
import com.ibm.ws.ssl.SSLPropertyUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class LibertySSLSocketFactoryWrapper
extends SSLSocketFactory {
    private static final TraceComponent tc = Tr.register(LibertySSLSocketFactoryWrapper.class, (String)"SSL", (String)"com.ibm.ws.ssl");
    private SSLSocketFactory delegate = null;
    private final Properties props;

    public LibertySSLSocketFactoryWrapper(SSLSocketFactory sslSocketFactory) {
        this.delegate = sslSocketFactory;
        this.props = SSLPropertyUtils.lookupProperties();
    }

    public LibertySSLSocketFactoryWrapper(SSLSocketFactory sslSocketFactory, String alias) {
        this.delegate = sslSocketFactory;
        this.props = SSLPropertyUtils.lookupProperties(alias);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        String securityLevel = this.props.getProperty("com.ibm.ssl.securityLevel");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("securityLevel from properties is " + securityLevel));
        }
        if (securityLevel == null) {
            securityLevel = "HIGH";
        }
        return Constants.adjustSupportedCiphersToSecurityLevel(this.delegate.getSupportedCipherSuites(), securityLevel);
    }

    @Override
    public Socket createSocket() throws IOException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket();
        SSLPropertyUtils.setSSLPropertiesOnSocket(this.props, socket);
        return socket;
    }

    @Override
    public Socket createSocket(Socket s, InputStream consumed, boolean autoClose) throws IOException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket(s, consumed, autoClose);
        SSLPropertyUtils.setSSLPropertiesOnSocket(this.props, socket);
        return socket;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket(s, host, port, autoClose);
        SSLPropertyUtils.setSSLPropertiesOnSocket(this.props, socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket(host, port);
        SSLPropertyUtils.setSSLPropertiesOnSocket(this.props, socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket(host, port, localHost, localPort);
        SSLPropertyUtils.setSSLPropertiesOnSocket(this.props, socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket(host, port);
        SSLPropertyUtils.setSSLPropertiesOnSocket(this.props, socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket(address, port, localAddress, localPort);
        SSLPropertyUtils.setSSLPropertiesOnSocket(this.props, socket);
        return socket;
    }
}

