/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.diagnostics.class_scanner.ano;

import com.ibm.ws.jpa.diagnostics.class_scanner.ano.ClassScannerException;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ClassInformationType;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;

public class EntityMappingsScannerResults {
    public static final String KEY_MD5HASH = "MD5HASH";
    public static final String KEY_CITXML = "CITXML";
    private final ClassInformationType cit;
    private final URL targetArchive;

    EntityMappingsScannerResults(ClassInformationType cit, URL targetArchive) {
        this.cit = cit;
        this.targetArchive = targetArchive;
    }

    public ClassInformationType getCit() {
        return this.cit;
    }

    public URL getTargetArchive() {
        return this.targetArchive;
    }

    public final Map<String, Object> produceXMLWithHash() throws ClassScannerException {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            JAXBContext jaxbCtx = JAXBContext.newInstance((String)"com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10");
            Marshaller marshaller = jaxbCtx.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MessageDigest md = MessageDigest.getInstance("MD5");
            try (DigestOutputStream dos = new DigestOutputStream(baos, md);){
                marshaller.marshal((Object)this.cit, (OutputStream)baos);
                BigInteger digestBigInt = new BigInteger(1, md.digest());
                String hashStr = digestBigInt.toString(16);
                retMap.put(KEY_MD5HASH, hashStr);
                retMap.put(KEY_CITXML, baos.toByteArray());
            }
        }
        catch (Exception e) {
            throw new ClassScannerException(e);
        }
        return retMap;
    }

    public final byte[] produceXML() throws ClassScannerException {
        try {
            JAXBContext jaxbCtx = JAXBContext.newInstance((String)"com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10");
            Marshaller marshaller = jaxbCtx.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            marshaller.marshal((Object)this.cit, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new ClassScannerException(e);
        }
    }

    public final <T> T produceXML(Class<T> type) throws ClassScannerException {
        byte[] xmlByteData = this.produceXML();
        if (type.isAssignableFrom(String.class)) {
            return (T)new String(xmlByteData);
        }
        if (type.isAssignableFrom(byte[].class)) {
            return (T)xmlByteData;
        }
        if (type.isAssignableFrom(InputStream.class)) {
            return (T)new ByteArrayInputStream(xmlByteData);
        }
        throw new ClassScannerException("EntityMappingsScannerResults.produceXML() does not support type: " + type.getName());
    }

    public String toString() {
        return "EntityMappingsScannerResults [cit=" + this.cit + ", targetArchive=" + this.targetArchive + "]";
    }
}

