/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.beanvalidation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.SetContextClassLoaderPrivileged;
import com.ibm.ws.beanvalidation.AbstractBeanValidation;
import com.ibm.ws.beanvalidation.MessageHelper;
import com.ibm.ws.beanvalidation.config.ValidationConfigurationInterface;
import com.ibm.ws.beanvalidation.service.BeanValidationExtensionHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ThreadContextAccessor;
import jakarta.validation.Configuration;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.Validation;
import jakarta.validation.ValidationException;
import jakarta.validation.ValidatorFactory;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ValidatorFactoryAccessor {
    private static final String CLASS_NAME = ValidatorFactoryAccessor.class.getName();
    private static final TraceComponent tc = Tr.register((String)CLASS_NAME, (String)"BeanValidation", (String)"com.ibm.ws.beanvalidation.resources.nls.BVNLSMessages");
    private static final PrivilegedAction<ThreadContextAccessor> getThreadContextAccessorAction = new PrivilegedAction<ThreadContextAccessor>(){

        @Override
        public ThreadContextAccessor run() {
            return ThreadContextAccessor.getThreadContextAccessor();
        }
    };

    public static ValidatorFactory getValidatorFactory() throws ValidationException {
        return ValidatorFactoryAccessor.getValidatorFactory((ClassLoader)null);
    }

    public static ValidatorFactory getValidatorFactory(ValidationConfigurationInterface validationConfigurator) {
        return ValidatorFactoryAccessor.getValidatorFactory(validationConfigurator, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ValidatorFactory getValidatorFactory(ValidationConfigurationInterface validationConfigurator, boolean skip) throws ValidationException, IllegalArgumentException {
        AbstractBeanValidation.ClassLoaderTuple tuple;
        ValidatorFactory factory;
        block18: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getValidatorFactory", (Object)validationConfigurator);
            }
            SetContextClassLoaderPrivileged setClassLoader = null;
            ClassLoader oldClassLoader = null;
            factory = null;
            Configuration<?> configuration = null;
            ClassLoader classLoader = validationConfigurator.getAppClassLoader();
            tuple = AbstractBeanValidation.instance().configureBvalClassloader(classLoader);
            try {
                classLoader = BeanValidationExtensionHelper.newValidationClassLoader(tuple.classLoader);
                ThreadContextAccessor tca = System.getSecurityManager() == null ? ThreadContextAccessor.getThreadContextAccessor() : AccessController.doPrivileged(getThreadContextAccessorAction);
                setClassLoader = new SetContextClassLoaderPrivileged(tca);
                oldClassLoader = setClassLoader.execute(classLoader);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Calling setClassLoader if different old " + oldClassLoader + " new " + classLoader));
                }
                configuration = validationConfigurator.configure();
                if (!skip) {
                    factory = configuration.buildValidatorFactory();
                }
                if (setClassLoader == null) break block18;
            }
            catch (ValidationException e) {
                try {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getValidatorFactory"), (String)"182", (Object[])new Object[]{configuration, oldClassLoader, classLoader, validationConfigurator, skip});
                    String msg = MessageHelper.getMessage("BVKEY_UNABLE_TO_CREATE_VALIDATION_FACTORY", new Object[]{e});
                    ValidationException valExcep = new ValidationException(msg, (Throwable)e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Unable to create a configuration object to create the ValidationFactory", (Object)((Object)e));
                    }
                    throw valExcep;
                    catch (IllegalArgumentException ie) {
                        FFDCFilter.processException((Throwable)ie, (String)(CLASS_NAME + ".getValidatorFactory"), (String)"190", (Object[])new Object[]{configuration, oldClassLoader, classLoader, validationConfigurator, skip});
                        msg = MessageHelper.getMessage("BVKEY_UNABLE_TO_CREATE_VALIDATION_FACTORY", new Object[]{ie});
                        IllegalArgumentException iae = new IllegalArgumentException(msg, ie);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Unable to create a ValidationFactory", (Object)ie);
                        }
                        throw iae;
                    }
                    catch (IOException ioe) {
                        FFDCFilter.processException((Throwable)ioe, (String)(CLASS_NAME + ".getValidatorFactory"), (String)"328", (Object[])new Object[]{configuration, oldClassLoader, classLoader, validationConfigurator, skip});
                        msg = MessageHelper.getMessage("BVKEY_UNABLE_TO_CREATE_VALIDATION_FACTORY", new Object[]{ioe});
                        valExcep = new ValidationException(msg, (Throwable)ioe);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Unable to create a configuration object to create the ValidationFactory", (Object)ioe);
                        }
                        throw valExcep;
                    }
                }
                catch (Throwable throwable) {
                    if (setClassLoader != null) {
                        setClassLoader.execute(oldClassLoader);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader));
                        }
                    }
                    AbstractBeanValidation.instance().releaseLoader(tuple);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"getValidatorFactory - closing mapping files");
                    }
                    validationConfigurator.closeMappingFiles();
                    validationConfigurator.clearClassLoader();
                    throw throwable;
                }
            }
            setClassLoader.execute(oldClassLoader);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader));
            }
        }
        AbstractBeanValidation.instance().releaseLoader(tuple);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getValidatorFactory - closing mapping files");
        }
        validationConfigurator.closeMappingFiles();
        validationConfigurator.clearClassLoader();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getValidatorFactory", (Object)factory);
        }
        return factory;
    }

    public static ValidatorFactory getValidatorFactory(ClassLoader classLoader) throws ValidationException {
        return ValidatorFactoryAccessor.getValidatorFactory(classLoader, true, false);
    }

    public static ValidatorFactory getValidatorFactory(ClassLoader classLoader, boolean bVal11OrHigher) throws ValidationException {
        return ValidatorFactoryAccessor.getValidatorFactory(classLoader, bVal11OrHigher, false);
    }

    public static ValidatorFactory getValidatorFactory(ClassLoader classLoader, boolean bVal11OrHigher, boolean skipBuildingFactory) throws ValidationException {
        AbstractBeanValidation.ClassLoaderTuple tuple;
        ValidatorFactory factory;
        block17: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getValidatorFactory", (Object)classLoader);
            }
            factory = null;
            SetContextClassLoaderPrivileged setClassLoader = null;
            ClassLoader oldClassLoader = null;
            tuple = null;
            try {
                tuple = AbstractBeanValidation.instance().configureBvalClassloader(classLoader);
                classLoader = bVal11OrHigher ? BeanValidationExtensionHelper.newValidationClassLoader(tuple.classLoader) : BeanValidationExtensionHelper.newValidation10ClassLoader(tuple.classLoader);
                ThreadContextAccessor tca = System.getSecurityManager() == null ? ThreadContextAccessor.getThreadContextAccessor() : AccessController.doPrivileged(getThreadContextAccessorAction);
                setClassLoader = new SetContextClassLoaderPrivileged(tca);
                oldClassLoader = setClassLoader.execute(classLoader);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Called setClassLoader with oldClassLoader of" + oldClassLoader + " and newClassLoader of " + classLoader));
                }
                if (!skipBuildingFactory) {
                    if (bVal11OrHigher) {
                        Configuration configuration = Validation.byDefaultProvider().configure();
                        ConstraintValidatorFactory cvf = AbstractBeanValidation.instance().getConstraintValidatorFactory(configuration);
                        if (cvf != null) {
                            configuration.constraintValidatorFactory(cvf);
                        }
                        factory = configuration.buildValidatorFactory();
                    } else {
                        factory = Validation.buildDefaultValidatorFactory();
                    }
                }
                if (setClassLoader == null) break block17;
            }
            catch (ValidationException e) {
                try {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getValidatorFactory"), (String)"67", (Object[])new Object[]{oldClassLoader, classLoader});
                    String msg = MessageHelper.getMessage("BVKEY_UNABLE_TO_CREATE_VALIDATION_FACTORY", new Object[]{e});
                    ValidationException valExcep = new ValidationException(msg, (Throwable)e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Unable to create a default ValidationFactory");
                    }
                    throw valExcep;
                }
                catch (Throwable throwable) {
                    if (setClassLoader != null) {
                        setClassLoader.execute(oldClassLoader);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader));
                        }
                    }
                    if (tuple != null && tuple.wasCreatedViaClassLoadingService) {
                        AbstractBeanValidation.instance().releaseLoader(tuple);
                    }
                    throw throwable;
                }
            }
            setClassLoader.execute(oldClassLoader);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader));
            }
        }
        if (tuple != null && tuple.wasCreatedViaClassLoadingService) {
            AbstractBeanValidation.instance().releaseLoader(tuple);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getValidatorFactory", (Object)factory);
        }
        return factory;
    }
}

