/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.csi;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.orb.csi.CSIInterceptorBase;
import org.apache.yoko.orb.csi.gssup.GSSUPPolicy;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.MARSHAL;
import org.omg.CSIIOP.AS_ContextSec;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.SAS_ContextSec;
import org.omg.CSIIOP.ServiceConfiguration;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.Security.DelegationDirective;
import org.omg.Security.RequiresSupports;
import org.omg.SecurityLevel2.DelegationDirectivePolicy;

public class GSSUPIORInterceptor
extends CSIInterceptorBase
implements IORInterceptor {
    private static final Logger log = Logger.getLogger(GSSUPIORInterceptor.class.getName());

    GSSUPIORInterceptor(Codec codec) {
        super(codec);
    }

    public void establish_components(IORInfo info) {
        TaggedComponent mechanism_list = this.constructMechList(info);
        if (mechanism_list != null) {
            info.add_ior_component(mechanism_list);
        }
    }

    public String name() {
        return "CSI IOR Interceptor";
    }

    private TaggedComponent constructMechList(IORInfo info) {
        byte[] mech_data;
        int as_target_requires = 0;
        int as_target_supports = 0;
        short sas_target_requires = 0;
        int sas_target_supports = 0;
        GSSUPPolicy gp = null;
        String gssup_realm = null;
        boolean has_security = false;
        try {
            gp = (GSSUPPolicy)info.get_effective_policy(8080);
            if (gp.mode() == RequiresSupports.SecRequires) {
                as_target_requires = (short)(as_target_requires | 0x40);
            }
            as_target_supports = (short)(as_target_supports | 0x40);
            gssup_realm = gp.domain();
            has_security = true;
        }
        catch (INV_POLICY iNV_POLICY) {
            // empty catch block
        }
        try {
            DelegationDirectivePolicy delegatePolicy = (DelegationDirectivePolicy)info.get_effective_policy(38);
            if (delegatePolicy != null && delegatePolicy.delegation_directive() == DelegationDirective.Delegate) {
                sas_target_supports = (short)(sas_target_supports | 0xC00);
                has_security = true;
            }
        }
        catch (INV_POLICY delegatePolicy) {
            // empty catch block
        }
        if (!has_security) {
            return null;
        }
        CompoundSecMech mech = new CompoundSecMech();
        AS_ContextSec as = new AS_ContextSec();
        as.target_supports = (short)as_target_supports;
        as.target_requires = (short)as_target_requires;
        if (as_target_supports != 0) {
            as.client_authentication_mech = GSSUP_OID;
            as.target_name = gssup_realm != null ? this.encodeGSSExportedName(gssup_realm) : EMPTY_BARR;
        } else {
            as.target_name = EMPTY_BARR;
            as.client_authentication_mech = EMPTY_BARR;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("AS.target_requires=" + as_target_requires);
            log.fine("AS.target_supports=" + as_target_supports);
            log.fine("SAS.target_requires=" + sas_target_requires);
            log.fine("SAS.target_supports=" + sas_target_supports);
        }
        SAS_ContextSec sas = new SAS_ContextSec();
        sas.target_supports = (short)sas_target_supports;
        sas.target_requires = sas_target_requires;
        sas.privilege_authorities = new ServiceConfiguration[0];
        sas.supported_naming_mechanisms = new byte[][]{GSSUP_OID};
        sas.supported_identity_types = 1;
        if (as_target_supports != 0) {
            sas.supported_identity_types |= 0;
        }
        if (sas_target_supports != 0) {
            sas.supported_identity_types |= 0xE;
        }
        mech.transport_mech = new TaggedComponent(34, EMPTY_BARR);
        mech.target_requires = (short)(as_target_requires | sas_target_requires);
        mech.as_context_mech = as;
        mech.sas_context_mech = sas;
        CompoundSecMechList mech_list = new CompoundSecMechList(false, new CompoundSecMech[]{mech});
        Any a = this.getOrb().create_any();
        CompoundSecMechListHelper.insert((Any)a, (CompoundSecMechList)mech_list);
        try {
            mech_data = this.codec.encode_value(a);
        }
        catch (InvalidTypeForEncoding e) {
            MARSHAL me = new MARSHAL("cannot encode security descriptor", 0, CompletionStatus.COMPLETED_NO);
            me.initCause((Throwable)e);
            throw me;
        }
        return new TaggedComponent(33, mech_data);
    }

    public void destroy() {
    }
}

