/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.PortableInterceptor;

import java.util.logging.Logger;
import org.apache.yoko.util.Assert;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.InvalidSlot;

public final class Current_impl
extends LocalObject
implements Current {
    static final Logger logger = Logger.getLogger(Current_impl.class.getName());
    private final ThreadLocal<SlotDataHolder> stateKey = new ThreadLocal();
    private final ORB orb_;
    private int maxSlots_;

    private SlotDataHolder establishTSD() {
        SlotDataHolder holder = this.stateKey.get();
        if (null == holder) {
            holder = new SlotDataHolder();
            this.stateKey.set(holder);
            Any[] slots = new Any[this.maxSlots_];
            holder.head = new SlotData(slots);
            holder.head.next = null;
        }
        return holder;
    }

    public Any get_slot(int id) throws InvalidSlot {
        if (id >= this.maxSlots_ || id < 0) {
            throw new InvalidSlot("No slot for id " + id);
        }
        logger.fine("getting slot " + id);
        SlotDataHolder holder = this.establishTSD();
        Any slot = holder.head.slots[id];
        if (slot == null) {
            return this.orb_.create_any();
        }
        return new org.apache.yoko.orb.CORBA.Any(slot);
    }

    public void set_slot(int id, Any any) throws InvalidSlot {
        if (id >= this.maxSlots_ || id < 0) {
            throw new InvalidSlot("No slot for id " + id);
        }
        logger.fine("setting slot " + id);
        SlotDataHolder holder = this.establishTSD();
        holder.head.slots[id] = new org.apache.yoko.orb.CORBA.Any(any);
    }

    public Current_impl(ORB orb) {
        this.orb_ = orb;
    }

    Any[] _OB_currentSlotData() {
        SlotDataHolder holder = this.establishTSD();
        Any[] data = new Any[holder.head.slots.length];
        for (int i = 0; i < holder.head.slots.length; ++i) {
            Any slot = holder.head.slots[i];
            if (slot == null) continue;
            data[i] = new org.apache.yoko.orb.CORBA.Any(slot);
        }
        return data;
    }

    void _OB_pushSlotData(Any[] slots) {
        logger.fine("pushing slot data");
        SlotDataHolder holder = this.establishTSD();
        SlotData newSlots = new SlotData(slots);
        newSlots.next = holder.head;
        holder.head = newSlots;
    }

    void _OB_popSlotData() {
        logger.fine("popping slot data");
        SlotDataHolder holder = this.establishTSD();
        holder.head = holder.head.next;
        Assert.ensure((holder.head != null ? 1 : 0) != 0);
    }

    Any[] _OB_newSlotTable() {
        return new Any[this.maxSlots_];
    }

    public void _OB_setMaxSlots(int max) {
        this.maxSlots_ = max;
    }

    private static class SlotDataHolder {
        SlotData head;

        private SlotDataHolder() {
        }
    }

    private static class SlotData {
        Any[] slots;
        SlotData next;

        SlotData(Any[] s) {
            this.slots = s;
        }
    }
}

