/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import org.apache.yoko.orb.CORBA.TypeCode;
import org.apache.yoko.util.Assert;
import org.apache.yoko.util.MinorCodes;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;

public final class TypeCodeFactory {
    private static org.omg.CORBA.TypeCode[] primitives_ = new org.omg.CORBA.TypeCode[34];
    private static final boolean CHECK_IDL_NAMES = false;

    private TypeCodeFactory() {
    }

    private static boolean checkId(String id) {
        int colon;
        return id.length() <= 0 || (colon = id.indexOf(58)) != -1 && colon != 0 && colon != id.length() - 1;
    }

    private static boolean checkName(String name) {
        return true;
    }

    private static boolean checkType(org.omg.CORBA.TypeCode type) {
        try {
            org.omg.CORBA.TypeCode origType = TypeCode._OB_getOrigType(type);
            TCKind kind = origType.kind();
            if (kind == TCKind.tk_null || kind == TCKind.tk_void || kind == TCKind.tk_except) {
                return false;
            }
        }
        catch (BAD_TYPECODE bAD_TYPECODE) {
            // empty catch block
        }
        return true;
    }

    private static boolean compareLabels(TCKind kind, Any a1, Any a2) {
        switch (kind.value()) {
            case 2: {
                return a1.extract_short() == a2.extract_short();
            }
            case 4: {
                return a1.extract_ushort() == a2.extract_ushort();
            }
            case 3: {
                return a1.extract_long() == a2.extract_long();
            }
            case 5: {
                return a1.extract_ulong() == a2.extract_ulong();
            }
            case 23: {
                return a1.extract_longlong() == a2.extract_longlong();
            }
            case 24: {
                return a1.extract_ulonglong() == a2.extract_ulonglong();
            }
            case 9: {
                return a1.extract_char() == a2.extract_char();
            }
            case 8: {
                return a1.extract_boolean() == a2.extract_boolean();
            }
            case 26: {
                return a1.extract_wchar() == a2.extract_wchar();
            }
            case 17: {
                return a1.create_input_stream().read_ulong() == a2.create_input_stream().read_ulong();
            }
        }
        throw Assert.fail((String)"Unsupported typecode for compare");
    }

    public static org.omg.CORBA.TypeCode createPrimitiveTC(TCKind kind) {
        org.omg.CORBA.TypeCode tc;
        Assert.ensure((kind.value() < primitives_.length ? 1 : 0) != 0);
        if (primitives_[kind.value()] != null) {
            return primitives_[kind.value()];
        }
        switch (kind.value()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                TypeCode p = new TypeCode();
                p.kind_ = kind;
                p.length_ = 0;
                tc = p;
                break;
            }
            case 14: {
                tc = TypeCodeFactory.createInterfaceTC("IDL:omg.org/CORBA/Object:1.0", "Object");
                break;
            }
            case 29: {
                tc = TypeCodeFactory.createValueTC("IDL:omg.org/CORBA/ValueBase:1.0", "ValueBase", (short)2, null, new ValueMember[0]);
                break;
            }
            default: {
                throw Assert.fail();
            }
        }
        TypeCodeFactory.primitives_[kind.value()] = tc;
        return tc;
    }

    public static org.omg.CORBA.TypeCode createStructTC(String id, String name, StructMember[] members) {
        Assert.ensure((id != null && name != null ? 1 : 0) != 0);
        if (!TypeCodeFactory.checkId(id)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446352) + ": " + id, 1330446352, CompletionStatus.COMPLETED_NO);
        }
        if (!TypeCodeFactory.checkName(name)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446351) + ": " + name, 1330446351, CompletionStatus.COMPLETED_NO);
        }
        for (int i = 0; i < members.length; ++i) {
            if (!TypeCodeFactory.checkName(members[i].name)) {
                throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446353) + ": " + members[i].name, 1330446353, CompletionStatus.COMPLETED_NO);
            }
            if (!TypeCodeFactory.checkType(members[i].type)) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446338) + ": " + members[i].name, 1330446338, CompletionStatus.COMPLETED_NO);
            }
            for (int j = i + 1; j < members.length; ++j) {
                if (members[i].name.length() <= 0 || !members[i].name.equalsIgnoreCase(members[j].name)) continue;
                throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446353) + ": " + members[i].name, 1330446353, CompletionStatus.COMPLETED_NO);
            }
        }
        TypeCode tc = new TypeCode();
        tc.kind_ = TCKind.tk_struct;
        tc.id_ = id;
        tc.name_ = name;
        tc.memberNames_ = new String[members.length];
        tc.memberTypes_ = new TypeCode[members.length];
        for (int i = 0; i < members.length; ++i) {
            tc.memberNames_[i] = members[i].name;
            try {
                tc.memberTypes_[i] = (TypeCode)members[i].type;
                continue;
            }
            catch (ClassCastException ex) {
                tc.memberTypes_[i] = TypeCode._OB_convertForeignTypeCode(members[i].type);
            }
        }
        TypeCode._OB_embedRecTC(tc);
        return tc;
    }

    public static org.omg.CORBA.TypeCode createUnionTC(String id, String name, org.omg.CORBA.TypeCode discriminator_type, UnionMember[] members) {
        Assert.ensure((id != null && name != null ? 1 : 0) != 0);
        if (!TypeCodeFactory.checkId(id)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446352) + ": " + id, 1330446352, CompletionStatus.COMPLETED_NO);
        }
        if (!TypeCodeFactory.checkName(name)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446351) + ": " + name, 1330446351, CompletionStatus.COMPLETED_NO);
        }
        org.omg.CORBA.TypeCode origDisc = TypeCode._OB_getOrigType(discriminator_type);
        switch (origDisc.kind().value()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 17: 
            case 23: 
            case 24: 
            case 26: {
                break;
            }
            default: {
                throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446356), 1330446356, CompletionStatus.COMPLETED_NO);
            }
        }
        for (int i = 0; i < members.length; ++i) {
            if (!TypeCodeFactory.checkName(members[i].name)) {
                throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446353) + ": " + members[i].name, 1330446353, CompletionStatus.COMPLETED_NO);
            }
            if (!TypeCodeFactory.checkType(members[i].type)) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446338) + ": " + members[i].name, 1330446338, CompletionStatus.COMPLETED_NO);
            }
            org.omg.CORBA.TypeCode labelType = members[i].label.type();
            org.omg.CORBA.TypeCode origLabelType = TypeCode._OB_getOrigType(labelType);
            TCKind kind = origLabelType.kind();
            if (kind != TCKind.tk_octet && !origLabelType.equivalent(discriminator_type)) {
                throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446355) + ": " + members[i].name, 1330446355, CompletionStatus.COMPLETED_NO);
            }
            for (int j = i + 1; j < members.length; ++j) {
                org.omg.CORBA.TypeCode otherLabelType;
                if (kind == TCKind.tk_octet || !origLabelType.equivalent(otherLabelType = members[j].label.type()) || !TypeCodeFactory.compareLabels(kind, members[i].label, members[j].label)) continue;
                throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446354) + ": " + members[i].name, 1330446354, CompletionStatus.COMPLETED_NO);
            }
        }
        TypeCode tc = new TypeCode();
        tc.kind_ = TCKind.tk_union;
        tc.id_ = id;
        tc.name_ = name;
        try {
            tc.discriminatorType_ = (TypeCode)discriminator_type;
        }
        catch (ClassCastException ex) {
            tc.discriminatorType_ = TypeCode._OB_convertForeignTypeCode(discriminator_type);
        }
        tc.labels_ = new org.apache.yoko.orb.CORBA.Any[members.length];
        tc.memberNames_ = new String[members.length];
        tc.memberTypes_ = new TypeCode[members.length];
        for (int i = 0; i < members.length; ++i) {
            try {
                tc.labels_[i] = (org.apache.yoko.orb.CORBA.Any)members[i].label;
            }
            catch (ClassCastException ex) {
                tc.labels_[i] = new org.apache.yoko.orb.CORBA.Any(members[i].label);
            }
            tc.memberNames_[i] = members[i].name;
            try {
                tc.memberTypes_[i] = (TypeCode)members[i].type;
                continue;
            }
            catch (ClassCastException ex) {
                tc.memberTypes_[i] = TypeCode._OB_convertForeignTypeCode(members[i].type);
            }
        }
        TypeCode._OB_embedRecTC(tc);
        return tc;
    }

    public static org.omg.CORBA.TypeCode createEnumTC(String id, String name, String[] members) {
        Assert.ensure((id != null && name != null ? 1 : 0) != 0);
        if (!TypeCodeFactory.checkId(id)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446352) + ": " + id, 1330446352, CompletionStatus.COMPLETED_NO);
        }
        if (!TypeCodeFactory.checkName(name)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446351) + ": " + name, 1330446351, CompletionStatus.COMPLETED_NO);
        }
        for (int i = 0; i < members.length; ++i) {
            if (!TypeCodeFactory.checkName(members[i])) {
                throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446353) + ": " + members[i], 1330446353, CompletionStatus.COMPLETED_NO);
            }
            for (int j = i + 1; j < members.length; ++j) {
                if (members[i].length() <= 0 || !members[i].equalsIgnoreCase(members[j])) continue;
                throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446353) + ": " + members[i], 1330446353, CompletionStatus.COMPLETED_NO);
            }
        }
        TypeCode tc = new TypeCode();
        tc.kind_ = TCKind.tk_enum;
        tc.id_ = id;
        tc.name_ = name;
        tc.memberNames_ = new String[members.length];
        System.arraycopy(members, 0, tc.memberNames_, 0, members.length);
        return tc;
    }

    public static org.omg.CORBA.TypeCode createAliasTC(String id, String name, org.omg.CORBA.TypeCode original_type) {
        Assert.ensure((id != null && name != null ? 1 : 0) != 0);
        if (!TypeCodeFactory.checkId(id)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446352) + ": " + id, 1330446352, CompletionStatus.COMPLETED_NO);
        }
        if (!TypeCodeFactory.checkName(name)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446351) + ": " + name, 1330446351, CompletionStatus.COMPLETED_NO);
        }
        if (!TypeCodeFactory.checkType(original_type)) {
            throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446338), 1330446338, CompletionStatus.COMPLETED_NO);
        }
        TypeCode tc = new TypeCode();
        tc.kind_ = TCKind.tk_alias;
        tc.id_ = id;
        tc.name_ = name;
        try {
            tc.contentType_ = (TypeCode)original_type;
        }
        catch (ClassCastException ex) {
            tc.contentType_ = TypeCode._OB_convertForeignTypeCode(original_type);
        }
        return tc;
    }

    public static org.omg.CORBA.TypeCode createExceptionTC(String id, String name, StructMember[] members) {
        Assert.ensure((id != null && name != null ? 1 : 0) != 0);
        if (!TypeCodeFactory.checkId(id)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446352) + ": " + id, 1330446352, CompletionStatus.COMPLETED_NO);
        }
        if (!TypeCodeFactory.checkName(name)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446351) + ": " + name, 1330446351, CompletionStatus.COMPLETED_NO);
        }
        for (int i = 0; i < members.length; ++i) {
            if (!TypeCodeFactory.checkName(members[i].name)) {
                throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446353) + ": " + members[i].name, 1330446353, CompletionStatus.COMPLETED_NO);
            }
            if (!TypeCodeFactory.checkType(members[i].type)) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446338) + ": " + members[i].name, 1330446338, CompletionStatus.COMPLETED_NO);
            }
            for (int j = i + 1; j < members.length; ++j) {
                if (members[i].name.length() <= 0 || !members[i].name.equalsIgnoreCase(members[j].name)) continue;
                throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446353) + ": " + members[i].name, 1330446353, CompletionStatus.COMPLETED_NO);
            }
        }
        TypeCode tc = new TypeCode();
        tc.kind_ = TCKind.tk_except;
        tc.id_ = id;
        tc.name_ = name;
        tc.memberNames_ = new String[members.length];
        tc.memberTypes_ = new TypeCode[members.length];
        for (int i = 0; i < members.length; ++i) {
            tc.memberNames_[i] = members[i].name;
            try {
                tc.memberTypes_[i] = (TypeCode)members[i].type;
                continue;
            }
            catch (ClassCastException ex) {
                tc.memberTypes_[i] = TypeCode._OB_convertForeignTypeCode(members[i].type);
            }
        }
        TypeCode._OB_embedRecTC(tc);
        return tc;
    }

    public static org.omg.CORBA.TypeCode createInterfaceTC(String id, String name) {
        Assert.ensure((id != null && name != null ? 1 : 0) != 0);
        if (!TypeCodeFactory.checkId(id)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446352) + ": " + id, 1330446352, CompletionStatus.COMPLETED_NO);
        }
        if (!TypeCodeFactory.checkName(name)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446351) + ": " + name, 1330446351, CompletionStatus.COMPLETED_NO);
        }
        TypeCode tc = new TypeCode();
        tc.kind_ = TCKind.tk_objref;
        tc.id_ = id;
        tc.name_ = name;
        return tc;
    }

    public static org.omg.CORBA.TypeCode createStringTC(int bound) {
        Assert.ensure((bound >= 0 ? 1 : 0) != 0);
        TypeCode tc = new TypeCode();
        tc.kind_ = TCKind.tk_string;
        tc.length_ = bound;
        return tc;
    }

    public static org.omg.CORBA.TypeCode createWStringTC(int bound) {
        Assert.ensure((bound >= 0 ? 1 : 0) != 0);
        TypeCode tc = new TypeCode();
        tc.kind_ = TCKind.tk_wstring;
        tc.length_ = bound;
        return tc;
    }

    public static org.omg.CORBA.TypeCode createFixedTC(short digits, short scale) {
        Assert.ensure((digits >= 0 ? 1 : 0) != 0);
        TypeCode tc = new TypeCode();
        tc.kind_ = TCKind.tk_fixed;
        tc.fixedDigits_ = digits;
        tc.fixedScale_ = scale;
        return tc;
    }

    public static org.omg.CORBA.TypeCode createSequenceTC(int bound, org.omg.CORBA.TypeCode element_type) {
        Assert.ensure((bound >= 0 ? 1 : 0) != 0);
        if (!TypeCodeFactory.checkType(element_type)) {
            throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446338), 1330446338, CompletionStatus.COMPLETED_NO);
        }
        TypeCode tc = new TypeCode();
        tc.kind_ = TCKind.tk_sequence;
        tc.length_ = bound;
        try {
            tc.contentType_ = (TypeCode)element_type;
        }
        catch (ClassCastException ex) {
            tc.contentType_ = TypeCode._OB_convertForeignTypeCode(element_type);
        }
        return tc;
    }

    public static org.omg.CORBA.TypeCode createRecursiveSequenceTC(int bound, int offset) {
        throw new NO_IMPLEMENT();
    }

    public static org.omg.CORBA.TypeCode createArrayTC(int length, org.omg.CORBA.TypeCode element_type) {
        Assert.ensure((length > 0 ? 1 : 0) != 0);
        if (!TypeCodeFactory.checkType(element_type)) {
            throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446338), 1330446338, CompletionStatus.COMPLETED_NO);
        }
        TypeCode tc = new TypeCode();
        tc.kind_ = TCKind.tk_array;
        tc.length_ = length;
        try {
            tc.contentType_ = (TypeCode)element_type;
        }
        catch (ClassCastException ex) {
            tc.contentType_ = TypeCode._OB_convertForeignTypeCode(element_type);
        }
        return tc;
    }

    public static org.omg.CORBA.TypeCode createValueTC(String id, String name, short type_modifier, org.omg.CORBA.TypeCode concrete_base, ValueMember[] members) {
        Assert.ensure((id != null && name != null ? 1 : 0) != 0);
        if (!TypeCodeFactory.checkId(id)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446352) + ": " + id, 1330446352, CompletionStatus.COMPLETED_NO);
        }
        if (!TypeCodeFactory.checkName(name)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446351) + ": " + name, 1330446351, CompletionStatus.COMPLETED_NO);
        }
        if (concrete_base != null) {
            try {
                org.omg.CORBA.TypeCode origBaseType = TypeCode._OB_getOrigType(concrete_base);
                if (origBaseType.kind() != TCKind.tk_value) {
                    throw new BAD_TYPECODE();
                }
            }
            catch (BAD_TYPECODE origBaseType) {
                // empty catch block
            }
        }
        for (int i = 0; i < members.length; ++i) {
            if (!TypeCodeFactory.checkName(members[i].name)) {
                throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446353) + ": " + members[i].name, 1330446353, CompletionStatus.COMPLETED_NO);
            }
            if (TypeCodeFactory.checkType(members[i].type)) continue;
            throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446338) + ": " + members[i].name, 1330446338, CompletionStatus.COMPLETED_NO);
        }
        TypeCode tc = new TypeCode();
        tc.kind_ = TCKind.tk_value;
        tc.id_ = id;
        tc.name_ = name;
        tc.typeModifier_ = type_modifier;
        try {
            tc.concreteBaseType_ = (TypeCode)concrete_base;
        }
        catch (ClassCastException ex) {
            tc.concreteBaseType_ = TypeCode._OB_convertForeignTypeCode(concrete_base);
        }
        tc.memberNames_ = new String[members.length];
        tc.memberTypes_ = new TypeCode[members.length];
        tc.memberVisibility_ = new short[members.length];
        for (int i = 0; i < members.length; ++i) {
            tc.memberNames_[i] = members[i].name;
            try {
                tc.memberTypes_[i] = (TypeCode)members[i].type;
            }
            catch (ClassCastException ex) {
                tc.memberTypes_[i] = TypeCode._OB_convertForeignTypeCode(members[i].type);
            }
            tc.memberVisibility_[i] = members[i].access;
        }
        TypeCode._OB_embedRecTC(tc);
        return tc;
    }

    public static org.omg.CORBA.TypeCode createValueBoxTC(String id, String name, org.omg.CORBA.TypeCode boxed_type) {
        Assert.ensure((id != null && name != null ? 1 : 0) != 0);
        if (!TypeCodeFactory.checkId(id)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446352) + ": " + id, 1330446352, CompletionStatus.COMPLETED_NO);
        }
        if (!TypeCodeFactory.checkName(name)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446351) + ": " + name, 1330446351, CompletionStatus.COMPLETED_NO);
        }
        if (!TypeCodeFactory.checkType(boxed_type)) {
            throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446338), 1330446338, CompletionStatus.COMPLETED_NO);
        }
        TypeCode tc = new TypeCode();
        tc.kind_ = TCKind.tk_value_box;
        tc.id_ = id;
        tc.name_ = name;
        try {
            tc.contentType_ = (TypeCode)boxed_type;
        }
        catch (ClassCastException ex) {
            tc.contentType_ = TypeCode._OB_convertForeignTypeCode(boxed_type);
        }
        return tc;
    }

    public static org.omg.CORBA.TypeCode createNativeTC(String id, String name) {
        Assert.ensure((id != null && name != null ? 1 : 0) != 0);
        if (!TypeCodeFactory.checkId(id)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446352) + ": " + id, 1330446352, CompletionStatus.COMPLETED_NO);
        }
        if (!TypeCodeFactory.checkName(name)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446351) + ": " + name, 1330446351, CompletionStatus.COMPLETED_NO);
        }
        TypeCode tc = new TypeCode();
        tc.kind_ = TCKind.tk_native;
        tc.id_ = id;
        tc.name_ = name;
        return tc;
    }

    public static org.omg.CORBA.TypeCode createRecursiveTC(String id) {
        Assert.ensure((id != null ? 1 : 0) != 0);
        if (!TypeCodeFactory.checkId(id)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446352) + ": " + id, 1330446352, CompletionStatus.COMPLETED_NO);
        }
        TypeCode tc = new TypeCode();
        tc.recId_ = id;
        return tc;
    }

    public static org.omg.CORBA.TypeCode createAbstractInterfaceTC(String id, String name) {
        Assert.ensure((id != null && name != null ? 1 : 0) != 0);
        if (!TypeCodeFactory.checkId(id)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446352) + ": " + id, 1330446352, CompletionStatus.COMPLETED_NO);
        }
        if (!TypeCodeFactory.checkName(name)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446351) + ": " + name, 1330446351, CompletionStatus.COMPLETED_NO);
        }
        TypeCode tc = new TypeCode();
        tc.kind_ = TCKind.tk_abstract_interface;
        tc.id_ = id;
        tc.name_ = name;
        return tc;
    }

    public static org.omg.CORBA.TypeCode createLocalInterfaceTC(String id, String name) {
        Assert.ensure((id != null && name != null ? 1 : 0) != 0);
        if (!TypeCodeFactory.checkId(id)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446352) + ": " + id, 1330446352, CompletionStatus.COMPLETED_NO);
        }
        if (!TypeCodeFactory.checkName(name)) {
            throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446351) + ": " + name, 1330446351, CompletionStatus.COMPLETED_NO);
        }
        TypeCode tc = new TypeCode();
        tc.kind_ = org.omg.CORBA_2_4.TCKind.tk_local_interface;
        tc.id_ = id;
        tc.name_ = name;
        return tc;
    }
}

