/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import org.apache.yoko.giop.MessageType;
import org.apache.yoko.io.Buffer;
import org.apache.yoko.io.ReadBuffer;
import org.apache.yoko.io.WriteBuffer;
import org.apache.yoko.logging.VerboseLogging;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.OB.Connection;
import org.apache.yoko.orb.OB.Downcall;
import org.apache.yoko.orb.OB.GIOPClient;
import org.apache.yoko.orb.OB.GIOPConnection;
import org.apache.yoko.orb.OB.GIOPIncomingMessage;
import org.apache.yoko.orb.OB.GIOPOutgoingMessage;
import org.apache.yoko.orb.OB.OAInterface;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.Upcall;
import org.apache.yoko.orb.OCI.GiopVersion;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.orb.OCI.SendReceiveMode;
import org.apache.yoko.orb.OCI.Transport;
import org.apache.yoko.orb.exceptions.Transients;
import org.apache.yoko.rmi.util.ObjectUtil;
import org.apache.yoko.util.Assert;
import org.apache.yoko.util.MinorCodes;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.GIOP.MsgType_1_1;

final class GIOPConnectionThreaded
extends GIOPConnection {
    private final ThreadGate gate = new ThreadGate();
    private final SendMutex sendMutex = new SendMutex();
    private final ReentrantReadWriteLock receiverLock = new ReentrantReadWriteLock(true);
    private boolean shuttingDown;
    private final String label = ObjectUtil.getNextObjectLabel(this.getClass());

    private void addReceiverThread() {
        this.getExecutor().submit(new Receiver());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void abortiveShutdown() {
        this.ACM_disableIdleMonitor();
        if (this.transport_.mode() != SendReceiveMode.ReceiveOnly) {
            try (OutputStream out = new OutputStream(12);){
                ProfileInfo profileInfo = new ProfileInfo();
                GIOPConnectionThreaded gIOPConnectionThreaded = this;
                synchronized (gIOPConnectionThreaded) {
                    profileInfo.major = this.giopVersion_.major;
                    profileInfo.minor = this.giopVersion_.minor;
                }
                GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
                outgoing.writeMessageHeader(MsgType_1_1.MessageError, false, 0);
                out.setPosition(0);
                SendMutex sendMutex = this.sendMutex;
                synchronized (sendMutex) {
                    ReadBuffer readBuffer = out.getBufferReader();
                    this.transport_.send(readBuffer, true);
                    Assert.ensure((boolean)readBuffer.isComplete());
                }
            }
            catch (SystemException ex) {
                this.processException(Connection.State.CLOSED, ex, false);
                return;
            }
        }
        this.processException(Connection.State.CLOSED, (SystemException)((Object)Transients.FORCED_SHUTDOWN.create()), false);
        this.arrive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void gracefulShutdown() {
        this.ACM_disableIdleMonitor();
        if (this.upcallsInProgress_ > 0 || this.getState() != Connection.State.CLOSING) {
            VerboseLogging.CONN_IN_LOG.info("pending upcalls: " + this.upcallsInProgress_ + " state: " + (Object)((Object)this.getState()));
            return;
        }
        if (this.canSendCloseConnection()) {
            try (OutputStream out = new OutputStream(12);){
                ProfileInfo profileInfo = new ProfileInfo();
                profileInfo.major = this.giopVersion_.major;
                profileInfo.minor = this.giopVersion_.minor;
                GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
                outgoing.writeMessageHeader(MsgType_1_1.CloseConnection, false, 0);
                this.messageQueue_.add(this.orbInstance_, out.getBufferReader());
            }
        } else {
            VerboseLogging.CONN_IN_LOG.fine("could not send close connection message");
        }
        try {
            if (this.shuttingDown) {
                return;
            }
            this.shuttingDown = true;
            try {
                this.getExecutor().submit(new Shutdown());
            }
            catch (RejectedExecutionException ree) {
                VerboseLogging.CONN_IN_LOG.log(Level.WARNING, "Could not submit shutdown task", ree);
            }
        }
        catch (OutOfMemoryError ex) {
            this.processException(Connection.State.CLOSED, (SystemException)new IMP_LIMIT(MinorCodes.describeImpLimit((int)1095974914), 1095974914, CompletionStatus.COMPLETED_NO), false);
        }
        finally {
            this.arrive();
        }
    }

    private void arrive() {
        if (this.isOutbound()) {
            this.orbInstance_.getClientPhaser().arriveAndDeregister();
        } else {
            this.orbInstance_.getServerPhaser().arriveAndDeregister();
        }
    }

    GIOPConnectionThreaded(ORBInstance orbInstance, Transport transport, GIOPClient client) {
        super(orbInstance, transport, client);
        orbInstance.getClientPhaser().register();
        this.start();
    }

    GIOPConnectionThreaded(ORBInstance orbInstance, Transport transport, OAInterface oa) {
        super(orbInstance, transport, oa);
        orbInstance.getServerPhaser().register();
    }

    private ExecutorService getExecutor() {
        if (this.isOutbound()) {
            return this.orbInstance_.getClientExecutor();
        }
        return this.orbInstance_.getServerExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execShutdown() {
        Object object;
        if (this.canSendCloseConnection() && this.transport_.mode() != SendReceiveMode.ReceiveOnly) {
            try {
                object = this;
                synchronized (object) {
                    while (this.messageQueue_.hasUnsent()) {
                        ReadBuffer readBuffer = this.messageQueue_.getFirstUnsentBuffer();
                        if (readBuffer == null) continue;
                        SendMutex sendMutex = this.sendMutex;
                        synchronized (sendMutex) {
                            this.transport_.send(readBuffer, true);
                        }
                        this.messageQueue_.moveFirstUnsentToPending();
                    }
                }
            }
            catch (SystemException ex) {
                this.processException(Connection.State.CLOSED, ex, false);
                return;
            }
        }
        object = this.sendMutex;
        synchronized (object) {
            this.transport_.shutdown();
        }
        try {
            this.receiverLock.writeLock().tryLock(this.shutdownTimeout_, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.processException(Connection.State.CLOSED, (SystemException)((Object)Transients.FORCED_SHUTDOWN.create()), false);
        }
        finally {
            if (this.receiverLock.isWriteLockedByCurrentThread()) {
                this.receiverLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void execReceive() {
        if (VerboseLogging.CONN_IN_LOG.isLoggable(Level.FINE)) {
            VerboseLogging.CONN_IN_LOG.fine("Receiving incoming message " + this);
        }
        GIOPIncomingMessage inMsg = new GIOPIncomingMessage(this.orbInstance_);
        while (true) {
            boolean receivedBidirContext;
            Upcall upcall;
            block20: {
                WriteBuffer writer = Buffer.createWriteBuffer((int)12);
                try {
                    VerboseLogging.CONN_IN_LOG.finest("Reading message header");
                    this.transport_.receive(writer, true);
                    Assert.ensure((boolean)writer.isComplete());
                }
                catch (SystemException ex) {
                    this.processException(Connection.State.CLOSED, ex, false);
                    return;
                }
                try {
                    inMsg.extractHeader(writer.readFromStart());
                    if (VerboseLogging.CONN_IN_LOG.isLoggable(Level.FINER)) {
                        VerboseLogging.CONN_IN_LOG.finer("Header received for message of size " + inMsg.size());
                    }
                    writer.ensureAvailable(inMsg.size());
                }
                catch (SystemException ex) {
                    this.processException(Connection.State.ERROR, ex, false);
                    return;
                }
                if (!writer.isComplete()) {
                    try {
                        if (VerboseLogging.CONN_IN_LOG.isLoggable(Level.FINER)) {
                            VerboseLogging.CONN_IN_LOG.finer("Receiving message body of size " + inMsg.size());
                        }
                        this.transport_.receive(writer, true);
                        Assert.ensure((boolean)writer.isComplete());
                    }
                    catch (SystemException ex) {
                        this.processException(Connection.State.CLOSED, ex, false);
                        return;
                    }
                }
                MessageType.logIncomingGiopMessage(writer);
                this.gate.admit();
                GIOPConnectionThreaded ex = this;
                synchronized (ex) {
                    if (this.getState().forbids(Connection.Access.READ)) {
                        return;
                    }
                }
                upcall = null;
                try {
                    if (!inMsg.consumeBuffer(writer)) break block20;
                    upcall = this.processMessage(inMsg);
                }
                catch (SystemException ex2) {
                    this.processException(Connection.State.ERROR, ex2, false);
                    return;
                }
            }
            if (upcall == null) continue;
            if (VerboseLogging.CONN_IN_LOG.isLoggable(Level.FINER)) {
                VerboseLogging.CONN_IN_LOG.finer("Processing message using upcall " + upcall.getClass().getName());
            }
            if (receivedBidirContext = this.transport_.get_info().received_bidir_service_context()) {
                if (VerboseLogging.CONN_IN_LOG.isLoggable(Level.FINER)) {
                    VerboseLogging.CONN_IN_LOG.finer("In bidirectional mode, so submitting a new receiver task");
                }
                this.addReceiverThread();
            }
            upcall.invoke();
            if (receivedBidirContext) return;
        }
    }

    @Override
    synchronized void ACM_callback() {
        if (this.acmTimer_ != null) {
            this.acmTimer_.cancel();
            this.acmTimer_ = null;
        }
        if (this.acmTask_ != null) {
            this.acmTask_.cancel();
            this.acmTask_ = null;
        }
        if (this.messageQueue_.hasUnsent() || this.upcallsInProgress_ > 0) {
            this.ACM_enableIdleMonitor();
            return;
        }
        this.setState(Connection.State.CLOSING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(Downcall down, boolean block) {
        block32: {
            Assert.ensure((this.transport_.mode() != SendReceiveMode.ReceiveOnly ? 1 : 0) != 0);
            Assert.ensure((boolean)down.unsent());
            if (VerboseLogging.REQ_OUT_LOG.isLoggable(Level.FINE)) {
                VerboseLogging.REQ_OUT_LOG.fine("Sending a request downcall=" + down + " transport=" + this.transport_);
            }
            boolean msgSentMarked = false;
            GIOPConnectionThreaded gIOPConnectionThreaded = this;
            synchronized (gIOPConnectionThreaded) {
                if (this.checkWriteProhibited(down)) {
                    return true;
                }
                if (down.responseExpected()) {
                    down.allowWaiting();
                }
                this.messageQueue_.add(this.orbInstance_, down);
                if (this.isRequestSent()) {
                    msgSentMarked = true;
                }
            }
            if (block) {
                int t = down.policies().requestTimeout;
                int msgcount = 0;
                while (true) {
                    Downcall nextDown;
                    ReadBuffer readBuffer;
                    Object object = this;
                    synchronized (object) {
                        if (!down.unsent()) {
                            break block32;
                        }
                        Assert.ensure((boolean)this.messageQueue_.hasUnsent());
                        readBuffer = this.messageQueue_.getFirstUnsentBuffer();
                        nextDown = this.messageQueue_.moveFirstUnsentToPending();
                    }
                    try {
                        object = this.sendMutex;
                        synchronized (object) {
                            if (t <= 0) {
                                this.transport_.send(readBuffer, true);
                                Assert.ensure((boolean)readBuffer.isComplete());
                            } else {
                                this.transport_.send_timeout(readBuffer, t);
                                if (!readBuffer.isComplete()) {
                                    throw new NO_RESPONSE();
                                }
                            }
                        }
                    }
                    catch (SystemException ex) {
                        this.processException(Connection.State.CLOSED, ex, false);
                        return true;
                    }
                    if (msgSentMarked || nextDown == null || nextDown.getVersion() == GiopVersion.GIOP1_0) continue;
                    msgSentMarked = true;
                    this.markRequestSent();
                    if (!VerboseLogging.REQ_OUT_LOG.isLoggable(Level.FINE)) continue;
                    VerboseLogging.REQ_OUT_LOG.fine(String.format("Sent message blocking=%s msgcount=%d size=%d", block, msgcount++, readBuffer.length()));
                }
            }
            gIOPConnectionThreaded = this;
            synchronized (gIOPConnectionThreaded) {
                boolean msgcount = false;
                while (down.unsent()) {
                    Assert.ensure((boolean)this.messageQueue_.hasUnsent());
                    ReadBuffer readBuffer = this.messageQueue_.getFirstUnsentBuffer();
                    try {
                        SendMutex nextDown = this.sendMutex;
                        synchronized (nextDown) {
                            this.transport_.send(readBuffer, false);
                        }
                    }
                    catch (SystemException ex) {
                        this.processException(Connection.State.CLOSED, ex, false);
                        return true;
                    }
                    if (!readBuffer.isComplete()) {
                        return false;
                    }
                    Downcall downcall = this.messageQueue_.moveFirstUnsentToPending();
                }
            }
        }
        if (VerboseLogging.REQ_OUT_LOG.isLoggable(Level.FINER)) {
            VerboseLogging.REQ_OUT_LOG.finer(" Request send completed downcall=" + down);
        }
        return !down.responseExpected();
    }

    private boolean checkWriteProhibited(Downcall down) {
        boolean writeProhibited;
        Connection.State state = this.getState();
        switch (state) {
            case ACTIVE: 
            case HOLDING: 
            case CLOSING: {
                writeProhibited = false;
                break;
            }
            case STALE: {
                down.notifyStaleConnection();
            }
            case CLOSED: {
                this.setState(Connection.State.STALE);
            }
            case ERROR: {
                VerboseLogging.CONN_LOG.fine("writing not enabled for this connection");
                down.setFailureException((SystemException)((Object)new TRANSIENT()));
                writeProhibited = true;
                break;
            }
            default: {
                throw Assert.fail((String)("Unknown connection state: " + (Object)((Object)state)));
            }
        }
        return writeProhibited;
    }

    @Override
    public boolean receive(Downcall down, boolean block) {
        if (VerboseLogging.REQ_OUT_LOG.isLoggable(Level.FINER)) {
            VerboseLogging.REQ_OUT_LOG.finer("Receiving response downcall=" + down + " transport=" + this.transport_);
        }
        try {
            boolean result = down.waitUntilCompleted(block);
            if (VerboseLogging.REQ_OUT_LOG.isLoggable(Level.FINE)) {
                VerboseLogging.REQ_OUT_LOG.fine("Received response downcall=" + down + " from transport " + this.transport_);
            }
            return result;
        }
        catch (SystemException ex) {
            this.processException(Connection.State.CLOSED, ex, false);
            return true;
        }
    }

    @Override
    public boolean sendReceive(Downcall down) {
        this.ACM_disableIdleMonitor();
        try {
            boolean bl = this.send(down, true) || this.receive(down, true);
            return bl;
        }
        finally {
            this.ACM_enableIdleMonitor();
        }
    }

    @Override
    void start() {
        block6: {
            this.gate.open();
            if (this.transport_.mode() != SendReceiveMode.SendOnly) {
                try {
                    if (!this.receiverLock.writeLock().tryLock()) break block6;
                    try {
                        this.addReceiverThread();
                    }
                    finally {
                        this.receiverLock.writeLock().unlock();
                    }
                }
                catch (OutOfMemoryError ex) {
                    IMP_LIMIT sysEx = new IMP_LIMIT(MinorCodes.describeImpLimit((int)1095974914), 1095974914, CompletionStatus.COMPLETED_NO);
                    sysEx.initCause((Throwable)ex);
                    this.processException(Connection.State.CLOSED, (SystemException)sysEx, false);
                    throw sysEx;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void refresh() {
        boolean msgSentMarked = false;
        this.gate.open();
        GIOPConnectionThreaded gIOPConnectionThreaded = this;
        synchronized (gIOPConnectionThreaded) {
            if (this.getState().forbids(Connection.Access.WRITE)) {
                return;
            }
            if (this.isRequestSent()) {
                msgSentMarked = true;
            }
        }
        if (this.transport_.mode() == SendReceiveMode.ReceiveOnly) {
            return;
        }
        block14: while (true) {
            try {
                Object object;
                Downcall dummy;
                do {
                    ReadBuffer readBuffer;
                    object = this;
                    synchronized (object) {
                        if (!this.messageQueue_.hasUnsent()) {
                            break block14;
                        }
                        readBuffer = this.messageQueue_.getFirstUnsentBuffer();
                        readBuffer.rewindToStart();
                        dummy = this.messageQueue_.moveFirstUnsentToPending();
                    }
                    object = this.sendMutex;
                    synchronized (object) {
                        this.transport_.send(readBuffer, true);
                    }
                    if (readBuffer.isComplete()) continue;
                    throw new COMM_FAILURE(MinorCodes.describeCommFailure((int)1095974914), 1095974914, CompletionStatus.COMPLETED_NO);
                } while (msgSentMarked || dummy == null || !dummy.responseExpected() || !dummy.operation().equals("_locate"));
                object = this;
                synchronized (object) {
                    msgSentMarked = true;
                    this.markRequestSent();
                }
            }
            catch (SystemException ex) {
                this.processException(Connection.State.CLOSED, ex, false);
                return;
            }
        }
    }

    @Override
    void pause() {
        this.gate.close();
    }

    public String toString() {
        return this.label + ": state = " + (Object)((Object)this.getState());
    }

    private final class Receiver
    implements Runnable {
        Receiver() {
            GIOPConnectionThreaded.this.receiverLock.readLock().lock();
        }

        @Override
        public void run() {
            try {
                GIOPConnectionThreaded.this.execReceive();
            }
            catch (RuntimeException ex) {
                throw Assert.fail((Throwable)ex);
            }
            finally {
                GIOPConnectionThreaded.this.receiverLock.readLock().unlock();
            }
        }
    }

    private static final class SendMutex {
        private SendMutex() {
        }
    }

    private final class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        @Override
        public void run() {
            try {
                GIOPConnectionThreaded.this.execShutdown();
            }
            catch (RuntimeException ex) {
                throw Assert.fail((Throwable)ex);
            }
        }
    }

    private static final class ThreadGate {
        private boolean closed = true;

        private ThreadGate() {
        }

        synchronized void admit() {
            while (this.closed) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        synchronized void open() {
            if (this.closed) {
                this.closed = false;
                this.notifyAll();
            }
        }

        synchronized void close() {
            this.closed = true;
        }
    }
}

