/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.Transaction.JTA.Util;

public final class TxPrimaryKey {
    private static final TraceComponent tc = Tr.register(TxPrimaryKey.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private final long _timestamp;
    private final int _epochNumber;
    private final int _sequenceNumber;
    private String _stringValue;

    public TxPrimaryKey(long epochAndSequence) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[]{Long.toHexString(epochAndSequence)});
        }
        this._epochNumber = (int)(epochAndSequence >>> 32);
        this._sequenceNumber = (int)(epochAndSequence & 0xFFFFFFFFL);
        this._timestamp = System.nanoTime();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public TxPrimaryKey(byte[] keyData) {
        this(keyData, 0);
    }

    @Trivial
    TxPrimaryKey(byte[] keyData, int offset) {
        byte[] _keyData = keyData;
        this._epochNumber = Util.getIntFromBytes(_keyData, 8, 4);
        this._sequenceNumber = Util.getIntFromBytes(_keyData, 12, 4);
        this._timestamp = ((long)Util.getIntFromBytes(_keyData, 0, 4) & 0xFFFFFFFFL) << 32 | (long)Util.getIntFromBytes(_keyData, 4, 4) & 0xFFFFFFFFL;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"TxPrimaryKey({0}, {1}): {2}", (Object[])new Object[]{keyData, offset, this});
        }
    }

    TxPrimaryKey(long sequence, int epoch) {
        this((int)sequence, epoch);
    }

    @Trivial
    TxPrimaryKey(int sequence, int epoch) {
        this._epochNumber = epoch;
        this._sequenceNumber = sequence;
        this._timestamp = System.currentTimeMillis();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TxPrimaryKey(" + sequence + ", {0}): {1}"), (Object[])new Object[]{epoch, this});
        }
    }

    public int getEpochNumber() {
        return this._epochNumber;
    }

    public int getSequenceNumber() {
        return this._sequenceNumber;
    }

    public long getTimeStamp() {
        return this._timestamp;
    }

    public int hashCode() {
        return this._sequenceNumber;
    }

    @Trivial
    public byte[] toBytes() {
        byte[] result = new byte[16];
        int t1 = (int)(this._timestamp >> 32 & 0xFFFFFFFFL);
        int t2 = (int)(this._timestamp & 0xFFFFFFFFL);
        Util.setBytesFromInt(result, 0, 4, t1);
        Util.setBytesFromInt(result, 4, 4, t2);
        Util.setBytesFromInt(result, 8, 4, this._epochNumber);
        Util.setBytesFromInt(result, 12, 4, this._sequenceNumber);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"toBytes: {0}", (Object[])new Object[]{Util.toHexString(result)});
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof TxPrimaryKey) {
            TxPrimaryKey that = (TxPrimaryKey)obj;
            if (this._timestamp == that._timestamp && this._sequenceNumber == that._sequenceNumber && this._epochNumber == that._epochNumber) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this._stringValue == null) {
            this._stringValue = super.toString() + ";" + Long.toHexString(this._timestamp).toUpperCase() + ":" + Integer.toHexString(this._epochNumber).toUpperCase() + ":" + Integer.toHexString(this._sequenceNumber).toUpperCase();
        }
        return this._stringValue;
    }
}

