/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.internal;

import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.GlobUtil;
import io.opentelemetry.sdk.internal.ScopeConfigurator;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class ScopeConfiguratorBuilder<T> {
    private final ScopeConfigurator<T> baseScopeConfigurator;
    @Nullable
    private T defaultScopeConfig;
    private final List<Condition<T>> conditions = new ArrayList<Condition<T>>();

    ScopeConfiguratorBuilder(ScopeConfigurator<T> baseScopeConfigurator) {
        this.baseScopeConfigurator = baseScopeConfigurator;
    }

    public ScopeConfiguratorBuilder<T> setDefault(T defaultScopeConfig) {
        this.defaultScopeConfig = defaultScopeConfig;
        return this;
    }

    public ScopeConfiguratorBuilder<T> addCondition(Predicate<InstrumentationScopeInfo> scopePredicate, T scopeConfig) {
        this.conditions.add(new Condition(scopePredicate, scopeConfig));
        return this;
    }

    public static Predicate<InstrumentationScopeInfo> nameMatchesGlob(String globPattern) {
        Predicate<String> globPredicate = GlobUtil.toGlobPatternPredicate(globPattern);
        return scopeInfo -> globPredicate.test(scopeInfo.getName());
    }

    public static Predicate<InstrumentationScopeInfo> nameEquals(String scopeName) {
        return scopeInfo -> scopeInfo.getName().equals(scopeName);
    }

    public ScopeConfigurator<T> build() {
        return scopeInfo -> {
            Object scopeConfig = this.baseScopeConfigurator.apply((InstrumentationScopeInfo)scopeInfo);
            if (scopeConfig != null) {
                return scopeConfig;
            }
            for (Condition<T> condition : this.conditions) {
                if (!((Condition)condition).scopeMatcher.test(scopeInfo)) continue;
                return ((Condition)condition).scopeConfig;
            }
            return this.defaultScopeConfig;
        };
    }

    private static final class Condition<T> {
        private final Predicate<InstrumentationScopeInfo> scopeMatcher;
        private final T scopeConfig;

        private Condition(Predicate<InstrumentationScopeInfo> scopeMatcher, T scopeConfig) {
            this.scopeMatcher = scopeMatcher;
            this.scopeConfig = scopeConfig;
        }
    }
}

