/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java8.internal;

import jakarta.annotation.Nullable;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;

public final class CpuMethods {
    private static final String OS_BEAN_J9 = "com.ibm.lang.management.OperatingSystemMXBean";
    private static final String OS_BEAN_HOTSPOT = "com.sun.management.OperatingSystemMXBean";
    private static final String METHOD_PROCESS_CPU_TIME = "getProcessCpuTime";
    private static final String METHOD_PROCESS_CPU_LOAD = "getProcessCpuLoad";
    private static final String METHOD_CPU_LOAD = "getCpuLoad";
    private static final String METHOD_SYSTEM_CPU_LOAD = "getSystemCpuLoad";
    @Nullable
    private static final Supplier<Long> processCpuTime;
    @Nullable
    private static final Supplier<Double> processCpuUtilization;
    @Nullable
    private static final Supplier<Double> systemCpuUtilization;

    @Nullable
    private static <T extends Number> Supplier<T> methodInvoker(OperatingSystemMXBean osBean, String osBeanClassName, String methodName, Class<T> returnType) {
        try {
            Class<?> osBeanClass = Class.forName(osBeanClassName);
            osBeanClass.cast(osBean);
            Method method = osBeanClass.getDeclaredMethod(methodName, new Class[0]);
            return () -> {
                try {
                    return (Number)returnType.cast(method.invoke((Object)osBean, new Object[0]));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    return null;
                }
            };
        }
        catch (ClassCastException | ClassNotFoundException | NoSuchMethodException e) {
            return null;
        }
    }

    public static Supplier<Long> processCpuTime() {
        return processCpuTime;
    }

    public static Supplier<Double> processCpuUtilization() {
        return processCpuUtilization;
    }

    public static Supplier<Double> systemCpuUtilization() {
        return systemCpuUtilization;
    }

    private CpuMethods() {
    }

    static {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        Supplier<Long> processCpuTimeSupplier = CpuMethods.methodInvoker(osBean, OS_BEAN_HOTSPOT, METHOD_PROCESS_CPU_TIME, Long.class);
        if (processCpuTimeSupplier == null) {
            processCpuTimeSupplier = CpuMethods.methodInvoker(osBean, OS_BEAN_J9, METHOD_PROCESS_CPU_TIME, Long.class);
        }
        processCpuTime = processCpuTimeSupplier;
        Supplier<Double> processCpuSupplier = CpuMethods.methodInvoker(osBean, OS_BEAN_HOTSPOT, METHOD_PROCESS_CPU_LOAD, Double.class);
        if (processCpuSupplier == null) {
            processCpuSupplier = CpuMethods.methodInvoker(osBean, OS_BEAN_J9, METHOD_PROCESS_CPU_LOAD, Double.class);
        }
        processCpuUtilization = processCpuSupplier;
        Supplier<Double> systemCpuSupplier = CpuMethods.methodInvoker(osBean, OS_BEAN_HOTSPOT, METHOD_CPU_LOAD, Double.class);
        if (systemCpuSupplier == null) {
            systemCpuSupplier = CpuMethods.methodInvoker(osBean, OS_BEAN_HOTSPOT, METHOD_SYSTEM_CPU_LOAD, Double.class);
        }
        if (systemCpuSupplier == null) {
            systemCpuSupplier = CpuMethods.methodInvoker(osBean, OS_BEAN_J9, METHOD_SYSTEM_CPU_LOAD, Double.class);
        }
        systemCpuUtilization = systemCpuSupplier;
    }
}

