/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.richclient.framework.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBufferPool;
import com.ibm.ws.sib.jfapchannel.framework.IOWriteCompletedCallback;
import com.ibm.ws.sib.jfapchannel.framework.IOWriteRequestContext;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnection;
import com.ibm.ws.sib.jfapchannel.richclient.buffer.impl.RichByteBufferPool;
import com.ibm.ws.sib.jfapchannel.richclient.framework.impl.CFWIOBaseContext;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;
import java.util.Arrays;

public class CFWIOWriteRequestContext
extends CFWIOBaseContext
implements IOWriteRequestContext {
    private static final TraceComponent tc = SibTr.register(CFWIOWriteRequestContext.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private TCPWriteRequestContext writeCtx = null;

    public CFWIOWriteRequestContext(NetworkConnection conn, TCPWriteRequestContext writeCtx) {
        super(conn);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{conn, writeCtx});
        }
        this.writeCtx = writeCtx;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public void setBuffer(WsByteBuffer buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBuffer", (Object)buffer);
        }
        if (buffer != null) {
            this.writeCtx.setBuffer((com.ibm.wsspi.bytebuffer.WsByteBuffer)buffer.getUnderlyingBuffer());
        } else {
            this.writeCtx.setBuffer(null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBuffer");
        }
    }

    @Override
    public void setBuffers(WsByteBuffer[] buffers) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBuffers", (Object)Arrays.toString(buffers));
        }
        if (buffers != null) {
            com.ibm.wsspi.bytebuffer.WsByteBuffer[] tcpBuffers = new com.ibm.wsspi.bytebuffer.WsByteBuffer[buffers.length];
            for (int x = 0; x < buffers.length; ++x) {
                tcpBuffers[x] = (com.ibm.wsspi.bytebuffer.WsByteBuffer)buffers[x].getUnderlyingBuffer();
            }
            this.writeCtx.setBuffers(tcpBuffers);
        } else {
            this.writeCtx.setBuffer(null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBuffers");
        }
    }

    @Override
    public WsByteBuffer getBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBuffer");
        }
        WsByteBuffer jfapByteBuffer = ((RichByteBufferPool)WsByteBufferPool.getInstance()).wrap(this.writeCtx.getBuffer());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBuffer", (Object)jfapByteBuffer);
        }
        return jfapByteBuffer;
    }

    @Override
    public WsByteBuffer[] getBuffers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBuffers");
        }
        com.ibm.wsspi.bytebuffer.WsByteBuffer[] tcpBuffers = this.writeCtx.getBuffers();
        Object[] jfapByteBuffers = null;
        if (tcpBuffers != null) {
            jfapByteBuffers = new WsByteBuffer[tcpBuffers.length];
            int nonNullCount = 0;
            for (com.ibm.wsspi.bytebuffer.WsByteBuffer buffer : tcpBuffers) {
                if (buffer == null) continue;
                jfapByteBuffers[nonNullCount++] = ((RichByteBufferPool)WsByteBufferPool.getInstance()).wrap(buffer);
            }
            if (nonNullCount < tcpBuffers.length) {
                WsByteBuffer[] compactedArray = new WsByteBuffer[nonNullCount];
                System.arraycopy(jfapByteBuffers, 0, compactedArray, 0, nonNullCount);
                jfapByteBuffers = compactedArray;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBuffers", (Object)Arrays.toString(jfapByteBuffers));
        }
        return jfapByteBuffers;
    }

    @Override
    public NetworkConnection write(int amountToWrite, final IOWriteCompletedCallback completionCallback, boolean queueRequest, int timeout) {
        VirtualConnection vc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"write", (Object)new Object[]{amountToWrite, completionCallback, queueRequest, timeout});
        }
        NetworkConnection retConn = null;
        final CFWIOWriteRequestContext me = this;
        TCPWriteCompletedCallback callback = new TCPWriteCompletedCallback(){

            public void complete(VirtualConnection vc, TCPWriteRequestContext ctx) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"complete", (Object)new Object[]{vc, ctx});
                }
                completionCallback.complete(CFWIOWriteRequestContext.this.getNetworkConnectionInstance(vc), me);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"complete");
                }
            }

            public void error(VirtualConnection vc, TCPWriteRequestContext ctx, IOException ioException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"error", (Object)new Object[]{vc, ctx, ioException});
                }
                completionCallback.error(CFWIOWriteRequestContext.this.getNetworkConnectionInstance(vc), me, ioException);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"error");
                }
            }
        };
        long dataToWrite = amountToWrite;
        if (amountToWrite == 0) {
            dataToWrite = -1L;
        }
        if ((vc = this.writeCtx.write(dataToWrite, callback, queueRequest, timeout)) != null) {
            retConn = this.getNetworkConnectionInstance(vc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"write", (Object)retConn);
        }
        return retConn;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/sib/jfapchannel/framework/impl/CFWIOWriteRequestContext.java, SIB.comms, WASX.SIB, uu1215.01 1.5");
        }
    }
}

