/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.MessageSenderInterceptor;
import org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ResponseTimeMessageOutInterceptor
extends AbstractMessageResponseTimeInterceptor {
    private EndingInterceptor ending = new EndingInterceptor();
    Logger log = Logger.getLogger(ResponseTimeMessageOutInterceptor.class.getName());
    static final long serialVersionUID = 2807067419646220876L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ResponseTimeMessageOutInterceptor() {
        super("prepare-send-ending");
        this.addBefore(MessageSenderInterceptor.MessageSenderEndingInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        Exchange ex = message.getExchange();
        boolean forceDisabled = this.getForceDisabled(ex);
        if (!forceDisabled && this.isServiceCounterEnabled(ex)) {
            if (ex.get(Exception.class) != null) {
                this.endHandlingMessage(ex);
                return;
            }
            if (Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.partial.response"))) {
                return;
            }
            if (this.isClient(message)) {
                if (ex.isOneWay()) {
                    message.getInterceptorChain().add((Interceptor)this.ending);
                }
                this.beginHandlingMessage(ex);
            } else {
                this.endHandlingMessage(ex);
            }
        }
    }

    private boolean getForceDisabled(Exchange ex) {
        String namespaceURI;
        boolean forceDisabled = Boolean.FALSE.equals(ex.get((Object)"org.apache.cxf.management.counter.enabled"));
        Object object = ex.get((Object)"jakarta.xml.ws.wsdl.interface");
        if (object != null && object instanceof QName && !(namespaceURI = ((QName)object).getNamespaceURI()).matches("[a-zA-Z0-9./:?_]*$")) {
            forceDisabled = true;
        }
        return forceDisabled;
    }

    public void handleFault(Message message) {
        Exchange ex = message.getExchange();
        if (ex.get((Object)"org.apache.cxf.management.counter.enabled") != null && !ex.isOneWay()) {
            FaultMode faultMode = (FaultMode)message.get(FaultMode.class);
            if (faultMode == null) {
                faultMode = FaultMode.RUNTIME_FAULT;
            }
            ex.put(FaultMode.class, (Object)faultMode);
            this.endHandlingMessage(ex);
        }
    }

    EndingInterceptor getEndingInterceptor() {
        return this.ending;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.management.interceptor.ResponseTimeMessageOutInterceptor", ResponseTimeMessageOutInterceptor.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class EndingInterceptor
    extends AbstractPhaseInterceptor<Message> {
        static final long serialVersionUID = -7817052344490911018L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public EndingInterceptor() {
            super("prepare-send-ending");
        }

        public void handleMessage(Message message) throws Fault {
            Exchange ex = message.getExchange();
            ResponseTimeMessageOutInterceptor.this.endHandlingMessage(ex);
        }

        public void handleFault(Message message) throws Fault {
            Exchange ex = message.getExchange();
            ResponseTimeMessageOutInterceptor.this.endHandlingMessage(ex);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.management.interceptor.ResponseTimeMessageOutInterceptor$EndingInterceptor", EndingInterceptor.class, null, null);
        }
    }
}

