/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.logging.hpel.LogRecordContext;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.app.manager.ApplicationStateCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ApplicationManager.class}, immediate=true, configurationPid={"com.ibm.ws.app.management"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public class ApplicationManager {
    private boolean expandApps;
    private boolean useJandex;
    private long startTimeout;
    private long stopTimeout;
    private String expandLocation;
    private File extractedLog;
    private final ConcurrentMap<String, ExtractedLogData> extractsDataLog = new ConcurrentHashMap<String, ExtractedLogData>();
    private static final String APPNAME_KEY = "appName";
    private static final LogRecordContext.Extension APPNAME_CALLBACK;
    static final long serialVersionUID = -4857646304502982718L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void activate(ComponentContext compcontext, Map<String, Object> properties) {
        this.modified(compcontext, properties);
        this.extractedLog = compcontext.getBundleContext().getBundle().getDataFile("expandApps");
        if (this.expandApps && this.extractedLog.exists()) {
            try {
                DataInputStream din;
                block8: {
                    din = new DataInputStream(new FileInputStream(this.extractedLog));
                    try {
                        long format = din.readLong();
                        if (format != 0L) break block8;
                        int len = din.readInt();
                        for (int i = 0; i < len; ++i) {
                            String id = din.readUTF();
                            long updated = din.readLong();
                            long size = din.readLong();
                            this.extractsDataLog.put(id, new ExtractedLogData(id, updated, size));
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.ApplicationManager", (String)"74", (Object)this, (Object[])new Object[]{compcontext, properties});
                        try {
                            din.close();
                        }
                        catch (Throwable throwable2) {
                            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.app.manager.ApplicationManager", (String)"74", (Object)this, (Object[])new Object[]{compcontext, properties});
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                din.close();
            }
            catch (IOException din) {
                FFDCFilter.processException((Throwable)din, (String)"com.ibm.ws.app.manager.ApplicationManager", (String)"85", (Object)this, (Object[])new Object[]{compcontext, properties});
                this.extractedLog.delete();
            }
        }
        LogRecordContext.registerExtension((String)APPNAME_KEY, (LogRecordContext.Extension)APPNAME_CALLBACK);
    }

    protected void deactivate(ComponentContext compcontext) {
        if (this.expandApps) {
            try {
                DataOutputStream dout = new DataOutputStream(new FileOutputStream(this.extractedLog));
                try {
                    dout.writeLong(0L);
                    dout.writeInt(this.extractsDataLog.size());
                    for (ExtractedLogData data : this.extractsDataLog.values()) {
                        dout.writeUTF(data.id);
                        dout.writeLong(data.lastUpdated);
                        dout.writeLong(data.size);
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.ApplicationManager", (String)"103", (Object)this, (Object[])new Object[]{compcontext});
                    try {
                        dout.close();
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.app.manager.ApplicationManager", (String)"103", (Object)this, (Object[])new Object[]{compcontext});
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                dout.close();
            }
            catch (IOException dout) {
                FFDCFilter.processException((Throwable)dout, (String)"com.ibm.ws.app.manager.ApplicationManager", (String)"111", (Object)this, (Object[])new Object[]{compcontext});
                this.extractedLog.delete();
            }
        } else if (this.extractedLog.exists()) {
            this.extractedLog.delete();
        }
        LogRecordContext.unregisterExtension((String)APPNAME_KEY);
    }

    @Modified
    protected void modified(ComponentContext compcontext, Map<String, Object> properties) {
        Boolean autoExpandValue = (Boolean)properties.get("autoExpand");
        this.setExpandApps(autoExpandValue == null ? false : autoExpandValue);
        Boolean useJandexValue = this.getProperty(properties, "useJandex", false);
        this.setUseJandex(useJandexValue == null ? false : useJandexValue);
        long startTimeoutValue = this.getProperty(properties, "startTimeout", 30L);
        this.setStartTimeout(startTimeoutValue);
        long stopTimeoutValue = this.getProperty(properties, "stopTimeout", 30L);
        this.setStopTimeout(stopTimeoutValue);
        ApplicationStateCoordinator.setApplicationStartTimeout(startTimeoutValue);
        ApplicationStateCoordinator.setApplicationStopTimeout(stopTimeoutValue);
        String expandLocationDir = (String)properties.get("expandLocation");
        this.setExpandLocation(expandLocationDir);
    }

    private <T> T getProperty(Map<String, Object> properties, String name, T deflt) {
        Object value = deflt;
        try {
            Object prop = properties.get(name);
            if (prop != null) {
                value = prop;
            }
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.app.manager.ApplicationManager", (String)"160", (Object)this, (Object[])new Object[]{properties, name, deflt});
        }
        return value;
    }

    public boolean shouldExpand(String id, File warFile, File expandedDir) {
        boolean result = true;
        long lastModified = -1L;
        long size = -1L;
        ExtractedLogData data = (ExtractedLogData)this.extractsDataLog.get(id);
        lastModified = warFile.lastModified();
        size = warFile.length();
        if (expandedDir.exists() && data != null) {
            boolean bl = result = data.lastUpdated != lastModified || data.size != size;
        }
        if (result) {
            this.extractsDataLog.put(id, new ExtractedLogData(id, lastModified, size));
        }
        return result;
    }

    public boolean getExpandApps() {
        return this.expandApps;
    }

    private void setExpandApps(boolean b) {
        this.expandApps = b;
    }

    public boolean getUseJandex() {
        return this.useJandex;
    }

    private void setUseJandex(boolean b) {
        this.useJandex = b;
    }

    public long getStartTimeout() {
        return this.startTimeout;
    }

    private void setStartTimeout(long b) {
        this.startTimeout = b;
    }

    public long getStopTimeout() {
        return this.stopTimeout;
    }

    private void setStopTimeout(long b) {
        this.stopTimeout = b;
    }

    private void setExpandLocation(String b) {
        this.expandLocation = b;
    }

    public String getExpandLocation() {
        return this.expandLocation;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ApplicationManager.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.ApplicationManager");
        APPNAME_CALLBACK = new LogRecordContext.Extension(){
            static final long serialVersionUID = -8454957860874155608L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Trivial
            public String getValue() {
                J2EEName name;
                ComponentMetaData metaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
                if (metaData != null && (name = metaData.getJ2EEName()) != null) {
                    return name.getApplication();
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.ApplicationManager$1");
            }
        };
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ExtractedLogData {
        private final String id;
        private final long lastUpdated;
        private final long size;
        static final long serialVersionUID = 2831098640941282205L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ExtractedLogData(String id, long updated, long size) {
            this.id = id;
            this.lastUpdated = updated;
            this.size = size;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ExtractedLogData.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.ApplicationManager$ExtractedLogData");
        }
    }
}

