/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.ltc.embeddable.impl;

import com.ibm.tx.jta.embeddable.EmbeddableTransactionManagerFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.UOWCallback;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import java.util.ArrayList;

public final class LTCCallbacks {
    private static LTCCallbacks _instance = new LTCCallbacks();
    private final ArrayList<UOWCallback> _callbacks = new ArrayList();
    private static final UOWCurrent _uowCurrent = EmbeddableTransactionManagerFactory.getUOWCurrent();
    private static final TraceComponent tc = Tr.register(LTCCallbacks.class, (String)"Transaction", (String)"com.ibm.ws.LocalTransaction.resources.LocalTranMsgs");

    private LTCCallbacks() {
    }

    public static LTCCallbacks instance() {
        return _instance;
    }

    public void registerCallback(UOWCallback callback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerCallback", (Object[])new Object[]{callback});
        }
        if (!this._callbacks.contains(callback)) {
            this._callbacks.add(callback);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Number of registered Callbacks: " + this._callbacks.size()), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerCallback");
        }
    }

    public void contextChange(int typeOfChange) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"contextChange", (Object[])new Object[]{Util.printUOWStatusChangeType((int)typeOfChange)});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"UOWCurrent", (Object[])new Object[]{_uowCurrent});
        }
        UOWCoordinator coord = null;
        if (typeOfChange == 1 || typeOfChange == 2) {
            coord = _uowCurrent.getUOWCoord();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Coordinator={0}", (Object[])new Object[]{coord});
        }
        IllegalStateException ex = null;
        for (int i = 0; i < this._callbacks.size(); ++i) {
            UOWCallback callback = this._callbacks.get(i);
            try {
                callback.contextChange(typeOfChange, coord);
                continue;
            }
            catch (IllegalStateException ise) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception caught during UOW callback at context change", (Object[])new Object[]{ise});
                }
                ex = ise;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"contextChange", ex);
        }
        if (ex != null) {
            throw ex;
        }
    }
}

