/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.embeddable.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.tx.jta.embeddable.EmbeddableTransactionManagerFactory;
import com.ibm.tx.jta.embeddable.impl.EmbeddableTranManagerSet;
import com.ibm.tx.jta.embeddable.impl.EmbeddableTransactionImpl;
import com.ibm.tx.jta.impl.UserTransactionImpl;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereUserTransaction;
import com.ibm.ws.uow.UOWScope;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;

public class EmbeddableUserTransactionImpl
extends UserTransactionImpl
implements EmbeddableWebSphereUserTransaction {
    private static final TraceComponent tc = Tr.register(EmbeddableUserTransactionImpl.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static volatile EmbeddableUserTransactionImpl _instance = new EmbeddableUserTransactionImpl();
    private static final ThreadLocal<Boolean> isEnabled = new ThreadLocal<Boolean>(){

        @Override
        public Boolean initialValue() {
            return Boolean.TRUE;
        }
    };

    public static EmbeddableUserTransactionImpl instance() {
        return _instance;
    }

    protected TransactionManager getTM() {
        if (_tm instanceof EmbeddableTranManagerSet) {
            return _tm;
        }
        _tm = EmbeddableTransactionManagerFactory.getTransactionManager();
        return _tm;
    }

    public static boolean isEnabled() {
        return isEnabled.get();
    }

    public static void setEnabled(boolean enabled) {
        isEnabled.set(enabled);
    }

    public void begin() throws NotSupportedException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"begin");
        }
        this.checkEnabled();
        super.begin();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"begin");
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        EmbeddableTransactionImpl tx;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit");
        }
        this.checkEnabled();
        UOWScope coord = (UOWScope)this.getTM().getTransaction();
        if (coord == null) {
            IllegalStateException ise = new IllegalStateException("No Global Transaction exists to commit.");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit", (Object)ise);
            }
            throw ise;
        }
        if (coord instanceof EmbeddableTransactionImpl && ((tx = (EmbeddableTransactionImpl)coord).isSubordinate() || tx.hasSuspendedAssociations())) {
            SecurityException se = new SecurityException("Attempted commit in subordinate");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit", (Object)se);
            }
            throw se;
        }
        super.commit();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"commit");
        }
    }

    public int getStatus() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getStatus");
        }
        this.checkEnabled();
        int ret = super.getStatus();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getStatus", (Object)ret);
        }
        return ret;
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        EmbeddableTransactionImpl tx;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rollback");
        }
        this.checkEnabled();
        UOWScope coord = (UOWScope)this.getTM().getTransaction();
        if (coord == null) {
            IllegalStateException ise = new IllegalStateException("No Global Transaction exists to commit.");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"rollback", (Object)ise);
            }
            throw ise;
        }
        if (coord instanceof EmbeddableTransactionImpl && ((tx = (EmbeddableTransactionImpl)coord).isSubordinate() || tx.hasSuspendedAssociations())) {
            SecurityException se = new SecurityException("Attempted rollback in subordinate");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"rollback", (Object)se);
            }
            throw se;
        }
        super.rollback();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"rollback");
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setRollbackOnly");
        }
        this.checkEnabled();
        super.setRollbackOnly();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setRollbackOnly");
        }
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setTransactionTimeout", (Object)seconds);
        }
        this.checkEnabled();
        super.setTransactionTimeout(seconds);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTransactionTimeout");
        }
    }

    private void checkEnabled() throws IllegalStateException {
        if (!isEnabled.get().booleanValue()) {
            IllegalStateException ise = new IllegalStateException("UserTransaction method forbidden in this context");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkEnabled", (Object)ise);
            }
            throw ise;
        }
    }
}

