/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.accesslists;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import io.openliberty.accesslists.filterlist.FilterList;
import java.net.Inet6Address;
import java.net.InetAddress;

public class AddressAccessLists {
    public static final TraceComponent tc = Tr.register(AddressAccessLists.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    public FilterList addressExcludeList = null;
    public FilterList addressIncludeList = null;

    public AddressAccessLists(FilterList _addressExcludeList, FilterList _addressIncludeList) {
        this.addressExcludeList = _addressExcludeList;
        this.addressIncludeList = _addressIncludeList;
    }

    public boolean accessDenied(InetAddress addr) {
        return this.nonEmptyIncludesAndNotFound(addr) || this.inExcludeList(addr);
    }

    protected boolean nonEmptyIncludesAndNotFound(InetAddress addr) {
        if (!this.addressIncludeList.getActive()) {
            return false;
        }
        if (this.inAddressIncludeList(addr)) {
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Address not in active include list, address: " + addr.getHostAddress()), (Object[])new Object[0]);
        }
        return true;
    }

    protected boolean inAddressIncludeList(InetAddress addr) {
        if (!this.addressIncludeList.getActive()) {
            return false;
        }
        if (addr instanceof Inet6Address) {
            return this.addressIncludeList.findInList6(addr.getAddress());
        }
        return this.addressIncludeList.findInList(addr.getAddress());
    }

    protected boolean inExcludeList(InetAddress addr) {
        return this.inAddressExcludeList(addr);
    }

    protected boolean inAddressExcludeList(InetAddress addr) {
        if (!this.addressExcludeList.getActive()) {
            return false;
        }
        if (addr instanceof Inet6Address) {
            if (this.addressExcludeList.findInList6(addr.getAddress())) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Address (IPv6) in exclude list, address: " + addr.getHostAddress()), (Object[])new Object[0]);
                }
                return true;
            }
        } else if (this.addressExcludeList.findInList(addr.getAddress())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Address in exclude list, address: " + addr.getHostAddress()), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }
}

