/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.jwt.Claims;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.structures.BoundedHashMap;
import io.openliberty.security.common.osgi.SecurityOSGiUtils;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JtiNonceCache {
    private static final TraceComponent tc = Tr.register(JtiNonceCache.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    private final PrivilegedAction<ScheduledExecutorService> getScheduledExecutorServiceAction = new GetScheduledExecutorServiceAction();
    private final Map<String, Object> primaryTable;
    private int entryLimit = 100000;
    private long timeoutInMilliSeconds = 600000L;
    private ScheduledExecutorService evictionSchedule;
    static final long serialVersionUID = 355863593085758387L;

    public JtiNonceCache() {
        this(0, 0L);
    }

    public JtiNonceCache(int entryLimit, long timeoutInMilliSeconds) {
        if (entryLimit > 0) {
            this.entryLimit = entryLimit;
        }
        this.primaryTable = Collections.synchronizedMap(new BoundedHashMap(this.entryLimit));
        if (timeoutInMilliSeconds > 0L) {
            this.timeoutInMilliSeconds = timeoutInMilliSeconds;
        }
        this.scheduleEvictionTask(this.timeoutInMilliSeconds);
    }

    public int size() {
        return this.entryLimit;
    }

    private void scheduleEvictionTask(long timeoutInMilliSeconds) {
        this.evictionSchedule = System.getSecurityManager() == null ? this.getScheduledExecutorService() : AccessController.doPrivileged(this.getScheduledExecutorServiceAction);
        if (this.evictionSchedule != null) {
            this.evictionSchedule.scheduleWithFixedDelay(new EvictionTask(), timeoutInMilliSeconds, timeoutInMilliSeconds, TimeUnit.MILLISECONDS);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Failed to obtain a ScheduledExecutorService", (Object[])new Object[0]);
        }
    }

    private ScheduledExecutorService getScheduledExecutorService() {
        return (ScheduledExecutorService)SecurityOSGiUtils.getService(this.getClass(), ScheduledExecutorService.class);
    }

    public void remove(Object key) {
        this.primaryTable.remove(key);
    }

    public Object get(String key) {
        Object curEntry = this.primaryTable.get(key);
        return curEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(JwtToken token) {
        if (token == null) {
            return false;
        }
        Claims claims = token.getClaims();
        if (claims == null) {
            return false;
        }
        String key = claims.getJwtId();
        if (key == null) {
            return false;
        }
        key = this.getCacheKey(token);
        long currentTimeMilliseconds = new Date().getTime();
        Map<String, Object> map = this.primaryTable;
        synchronized (map) {
            long tokenExp;
            Long exp = (Long)this.primaryTable.get(key);
            if (exp != null) {
                if (exp > currentTimeMilliseconds) {
                    return true;
                }
                this.primaryTable.remove(key);
            }
            if ((tokenExp = claims.getExpiration() * 1000L) == 0L) {
                tokenExp = currentTimeMilliseconds + 3600000L;
            }
            this.primaryTable.put(key, tokenExp);
        }
        return false;
    }

    public void cache(JwtToken token) {
        if (token == null) {
            return;
        }
        Claims claims = token.getClaims();
        if (claims == null) {
            return;
        }
        String jti = claims.getJwtId();
        if (jti == null) {
            return;
        }
        String key = this.getCacheKey(token);
        long tokenExp = claims.getExpiration() * 1000L;
        if (tokenExp == 0L) {
            tokenExp = new Date().getTime() + 3600000L;
        }
        this.primaryTable.put(key, tokenExp);
    }

    protected String getCacheKey(JwtToken token) {
        Claims claims = token.getClaims();
        if (claims == null) {
            return null;
        }
        String jti = claims.getJwtId();
        if (jti == null) {
            return null;
        }
        String key = claims.getIssuer() + ":" + jti;
        return key;
    }

    protected synchronized void evictStaleEntries() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            int size = this.primaryTable.size();
            Tr.debug((TraceComponent)tc, (String)("The current cache size is " + size), (Object[])new Object[0]);
        }
        HashMap<String, Object> secondaryTable = new HashMap<String, Object>();
        secondaryTable.putAll(this.primaryTable);
        Set<String> keysToRemove = this.findExpiredTokens(secondaryTable);
        this.removeExpiredTokens(keysToRemove);
        secondaryTable.clear();
    }

    protected Set<String> findExpiredTokens(Map<String, Object> allTokens) {
        Set<String> keys = allTokens.keySet();
        HashSet<String> keysToRemove = new HashSet<String>();
        long lCurrentTimeMilliseconds = new Date().getTime();
        for (String key : keys) {
            Long exp = (Long)allTokens.get(key);
            if (exp >= lCurrentTimeMilliseconds) continue;
            keysToRemove.add(key);
        }
        return keysToRemove;
    }

    protected void removeExpiredTokens(Set<String> keysToRemove) {
        for (String key : keysToRemove) {
            this.primaryTable.remove(key);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class GetScheduledExecutorServiceAction
    implements PrivilegedAction<ScheduledExecutorService> {
        static final long serialVersionUID = 5402807314769557253L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private GetScheduledExecutorServiceAction() {
        }

        @Override
        public ScheduledExecutorService run() {
            return JtiNonceCache.this.getScheduledExecutorService();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jwt.utils.JtiNonceCache$GetScheduledExecutorServiceAction", GetScheduledExecutorServiceAction.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class EvictionTask
    implements Runnable {
        static final long serialVersionUID = -8001483173224664142L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private EvictionTask() {
        }

        @Override
        public void run() {
            JtiNonceCache.this.evictStaleEntries();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jwt.utils.JtiNonceCache$EvictionTask", EvictionTask.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
        }
    }
}

