/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.impl.JWKSet;
import com.ibm.ws.security.jwt.config.ConsumerUtils;
import com.ibm.ws.security.jwt.config.JwtConfigUtil;
import com.ibm.ws.security.jwt.config.JwtConsumerConfig;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.ssl.SSLSupport;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={JwtConsumerConfig.class}, immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"com.ibm.ws.security.jwt.consumer"}, name="jwtConsumerConfig", property={"service.vendor=IBM"})
public class JwtConsumerConfigImpl
implements JwtConsumerConfig {
    private static final TraceComponent tc = Tr.register(JwtConsumerConfigImpl.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    private String id;
    private String issuer = null;
    @Sensitive
    private String sharedKey;
    private List<String> audiences;
    private String sigAlg;
    private String trustStoreRef;
    private String trustedAlias;
    private long clockSkewMilliSeconds;
    private boolean jwkEnabled;
    private String jwkEndpointUrl;
    private boolean validationRequired = true;
    private boolean useSystemPropertiesForHttpClientConnections = false;
    private List<String> amrClaim;
    private String keyManagementKeyAlias;
    String sslRef;
    private ConsumerUtils consumerUtil = null;
    private JWKSet jwkSet = null;
    public static final String KEY_KEYSTORE_SERVICE = "keyStoreService";
    private final AtomicServiceReference<KeyStoreService> keyStoreServiceRef = new AtomicServiceReference("keyStoreService");
    static final long serialVersionUID = -5077160589885862363L;

    @Reference(service=KeyStoreService.class, name="keyStoreService", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setKeyStoreService(ServiceReference<KeyStoreService> ref) {
        this.keyStoreServiceRef.setReference(ref);
    }

    protected void unsetKeyStoreService(ServiceReference<KeyStoreService> ref) {
        this.keyStoreServiceRef.unsetReference(ref);
    }

    @Activate
    protected void activate(Map<String, Object> properties, ComponentContext cc) {
        this.keyStoreServiceRef.activate(cc);
        this.process(properties);
    }

    @Modified
    protected void modify(Map<String, Object> properties) {
        this.process(properties);
    }

    @Deactivate
    protected void deactivate(int reason, ComponentContext cc) {
        this.keyStoreServiceRef.deactivate(cc);
        this.consumerUtil = null;
    }

    private void process(Map<String, Object> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        this.id = JwtUtils.trimIt((String)props.get("id"));
        this.issuer = JwtUtils.trimIt((String)props.get("issuer"));
        this.sharedKey = JwtConfigUtil.processProtectedString(props, "sharedKey");
        this.audiences = JwtUtils.trimIt((String[])props.get("audiences"));
        this.sigAlg = JwtConfigUtil.getSignatureAlgorithm(this.getId(), props, "signatureAlgorithm");
        this.trustStoreRef = JwtUtils.trimIt((String)props.get("trustStoreRef"));
        this.trustedAlias = JwtUtils.trimIt((String)props.get("trustedAlias"));
        this.clockSkewMilliSeconds = (Long)props.get("clockSkew");
        this.validationRequired = (Boolean)props.get("validationRequired");
        this.jwkEnabled = (Boolean)props.get("jwkEnabled");
        this.jwkEndpointUrl = JwtUtils.trimIt((String)props.get("jwkEndpointUrl"));
        this.sslRef = JwtUtils.trimIt((String)props.get("sslRef"));
        this.useSystemPropertiesForHttpClientConnections = (Boolean)props.get("useSystemPropertiesForHttpClientConnections");
        this.amrClaim = JwtUtils.trimIt((String[])props.get("amrValues"));
        this.keyManagementKeyAlias = JwtUtils.trimIt((String)props.get("keyManagementKeyAlias"));
        this.consumerUtil = new ConsumerUtils(this.keyStoreServiceRef);
        this.jwkSet = null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    @Sensitive
    public String getSharedKey() {
        return this.sharedKey;
    }

    @Override
    public List<String> getAudiences() {
        return this.audiences;
    }

    @Override
    public boolean ignoreAudClaimIfNotConfigured() {
        return false;
    }

    @Override
    public String getSignatureAlgorithm() {
        return this.sigAlg;
    }

    @Override
    public String getTrustStoreRef() {
        return this.trustStoreRef;
    }

    @Override
    public String getKeyStoreRef() {
        String keyStoreName = null;
        String sslRef = this.getSslRef();
        if (sslRef == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sslRef not configured, so will use server-wide keystore", (Object[])new Object[0]);
            }
            return null;
        }
        Properties sslConfigProps = this.getSslConfigProperties(sslRef);
        if (sslConfigProps != null) {
            keyStoreName = sslConfigProps.getProperty("com.ibm.ssl.keyStoreName");
        }
        return keyStoreName;
    }

    @FFDCIgnore(value={Exception.class})
    Properties getSslConfigProperties(final String sslRef) {
        Properties sslConfigProps;
        final SSLSupport sslSupportService = JwtUtils.getSSLSupportService();
        if (sslSupportService == null) {
            return null;
        }
        try {
            sslConfigProps = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -7973616266041212833L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws Exception {
                    return sslSupportService.getJSSEHelper().getProperties(sslRef);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jwt.internal.JwtConsumerConfigImpl$1", 1.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
                }
            });
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception getting SSL properties: " + e), (Object[])new Object[0]);
            }
            return null;
        }
        return sslConfigProps;
    }

    @Override
    public String getTrustedAlias() {
        return this.trustedAlias;
    }

    @Override
    public long getClockSkew() {
        return this.clockSkewMilliSeconds;
    }

    @Override
    public long getTokenAge() {
        return 0L;
    }

    @Override
    public boolean getJwkEnabled() {
        return this.jwkEnabled;
    }

    @Override
    public String getJwkEndpointUrl() {
        return this.jwkEndpointUrl;
    }

    @Override
    public ConsumerUtils getConsumerUtils() {
        return this.consumerUtil;
    }

    @Override
    public boolean isValidationRequired() {
        return this.validationRequired;
    }

    @Override
    public String getSslRef() {
        return this.sslRef;
    }

    @Override
    public boolean isHostNameVerificationEnabled() {
        return true;
    }

    @Override
    public JWKSet getJwkSet() {
        if (this.jwkSet == null) {
            this.jwkSet = new JWKSet();
        }
        return this.jwkSet;
    }

    @Override
    public boolean getTokenReuse() {
        return false;
    }

    @Override
    public boolean getUseSystemPropertiesForHttpClientConnections() {
        return this.useSystemPropertiesForHttpClientConnections;
    }

    @Override
    public List<String> getAMRClaim() {
        return this.amrClaim;
    }

    @Override
    public String getKeyManagementKeyAlias() {
        return this.keyManagementKeyAlias;
    }

    @Override
    public Key getJweDecryptionKey() throws GeneralSecurityException {
        String keyAlias = this.getKeyManagementKeyAlias();
        if (keyAlias != null) {
            String keyStoreRef = this.getKeyStoreRef();
            return JwtUtils.getPrivateKey(keyAlias, keyStoreRef);
        }
        return null;
    }
}

