/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import com.ibm.websphere.ras.annotation.Sensitive;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.StaxUtils;

public class StaxInEndingInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String STAX_IN_NOCLOSE = StaxInEndingInterceptor.class.getName() + ".dontClose";
    public static final StaxInEndingInterceptor INSTANCE = new StaxInEndingInterceptor();
    private static final Logger LOG = LogUtils.getL7dLogger(StaxInEndingInterceptor.class);

    public StaxInEndingInterceptor() {
        super("pre-invoke");
    }

    public StaxInEndingInterceptor(String phase) {
        super(phase);
    }

    @Override
    public void handleMessage(@Sensitive Message message) {
        XMLStreamReader xtr = message.getContent(XMLStreamReader.class);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("XMLStreamReader class: " + (xtr != null ? xtr.getClass().getCanonicalName() : "NULL"));
        }
        if (xtr != null && !MessageUtils.getContextualBoolean(message, STAX_IN_NOCLOSE, false)) {
            try {
                StaxUtils.close(xtr);
            }
            catch (XMLStreamException ex) {
                throw new Fault(ex);
            }
            message.removeContent(XMLStreamReader.class);
        }
    }
}

