/*
 * Decompiled with CFR 0.152.
 */
package web;

import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.registry.CustomRegistryException;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.NotImplementedException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.SearchResult;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.registry.UserRegistryService;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class UserRegistryServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    private UserRegistryService tryUserRegistryService(PrintWriter writer, BundleContext bundleContext) {
        String serviceName = UserRegistryService.class.getName();
        writer.println("No SecurityService found, trying UserRegistryService");
        serviceName = UserRegistryService.class.getName();
        writer.println("Looking up " + serviceName);
        ServiceReference ref = bundleContext.getServiceReference(serviceName);
        writer.println(serviceName + " reference is " + ref);
        UserRegistryService urServ = (UserRegistryService)bundleContext.getService(ref);
        return urServ;
    }

    private UserRegistryService trySecurityService(PrintWriter writer, BundleContext bundleContext) {
        try {
            String serviceName = SecurityService.class.getName();
            writer.println("Looking up " + serviceName);
            ServiceReference secServRef = bundleContext.getServiceReference(serviceName);
            writer.println(serviceName + " reference is " + secServRef);
            if (secServRef != null) {
                SecurityService secServ = (SecurityService)bundleContext.getService(secServRef);
                return secServ.getUserRegistryService();
            }
            return null;
        }
        catch (NoClassDefFoundError ncdfe) {
            writer.println("SecurityService resulted in NoClassDefFoundError");
            return null;
        }
    }

    private UserRegistryService getUserRegistryService(PrintWriter writer) {
        Bundle bundle = FrameworkUtil.getBundle(Servlet.class);
        if (bundle == null) {
            writer.println("Unable to determine bundle");
            return null;
        }
        BundleContext bundleContext = bundle.getBundleContext();
        if (bundleContext == null) {
            writer.println("Unable to determine bundle context");
            return null;
        }
        UserRegistryService ret = this.trySecurityService(writer, bundleContext);
        if (ret == null) {
            ret = this.tryUserRegistryService(writer, bundleContext);
        }
        if (ret == null) {
            throw new IllegalStateException("Unable to find UserRegistryService");
        }
        return ret;
    }

    private UserRegistry getCurrentUserRegistry(PrintWriter writer) throws RegistryException {
        UserRegistryService urServ = this.getUserRegistryService(writer);
        writer.println("UserRegistryService class is " + urServ.getClass());
        UserRegistry reg = urServ.getUserRegistry();
        writer.println("UserRegistry class is " + reg.getClass());
        writer.flush();
        return reg;
    }

    private void handleMethodRequest(HttpServletRequest req, PrintWriter pw, UserRegistry ur) {
        String response = null;
        String method = req.getParameter("method");
        try {
            if ("getRealm".equals(method)) {
                response = ur.getRealm();
            } else if ("checkPassword".equals(method)) {
                String userSecurityName = req.getParameter("userSecurityName");
                String password = req.getParameter("password");
                response = String.valueOf(ur.checkPassword(userSecurityName, password));
            } else if ("mapCertificate".equals(method)) {
                response = "mapCertificate is not supported via the servlet";
            } else if ("isValidUser".equals(method)) {
                String userSecurityName = req.getParameter("userSecurityName");
                response = String.valueOf(ur.isValidUser(userSecurityName));
            } else if ("getUsers".equals(method)) {
                String pattern = req.getParameter("pattern");
                int limit = Integer.valueOf(req.getParameter("limit"));
                response = UserRegistryServlet.convertFromSR(ur.getUsers(pattern, limit));
            } else if ("getUserDisplayName".equals(method)) {
                String userSecurityName = req.getParameter("userSecurityName");
                response = ur.getUserDisplayName(userSecurityName);
            } else if ("getUniqueUserId".equals(method)) {
                String userSecurityName = req.getParameter("userSecurityName");
                response = ur.getUniqueUserId(userSecurityName);
            } else if ("getUserSecurityName".equals(method)) {
                String uniqueUserId = req.getParameter("uniqueUserId");
                response = ur.getUserSecurityName(uniqueUserId);
            } else if ("isValidGroup".equals(method)) {
                String groupSecurityName = req.getParameter("groupSecurityName");
                response = String.valueOf(ur.isValidGroup(groupSecurityName));
            } else if ("getGroups".equals(method)) {
                String pattern = req.getParameter("pattern");
                int limit = Integer.valueOf(req.getParameter("limit"));
                response = UserRegistryServlet.convertFromSR(ur.getGroups(pattern, limit));
            } else if ("getGroupDisplayName".equals(method)) {
                String groupSecurityName = req.getParameter("groupSecurityName");
                response = ur.getGroupDisplayName(groupSecurityName);
            } else if ("getUniqueGroupId".equals(method)) {
                String groupSecurityName = req.getParameter("groupSecurityName");
                response = ur.getUniqueGroupId(groupSecurityName);
            } else if ("getGroupSecurityName".equals(method)) {
                String uniqueGroupId = req.getParameter("uniqueGroupId");
                response = ur.getGroupSecurityName(uniqueGroupId);
            } else if ("getUniqueGroupIdsForUser".equals(method)) {
                String uniqueUserId = req.getParameter("uniqueUserId");
                response = UserRegistryServlet.convertFromList(ur.getUniqueGroupIdsForUser(uniqueUserId));
            } else if ("getGroupsForUser".equals(method)) {
                String userSecurityName = req.getParameter("userSecurityName");
                response = UserRegistryServlet.convertFromList(ur.getGroupsForUser(userSecurityName));
            } else if ("getUsersForGroup".equals(method)) {
                String groupSecurityName = req.getParameter("groupSecurityName");
                int limit = Integer.valueOf(req.getParameter("limit"));
                response = UserRegistryServlet.convertFromSR(ur.getUsersForGroup(groupSecurityName, limit));
            } else {
                pw.println("Usage: url?method=name&paramName=paramValue&...");
            }
        }
        catch (RegistryException re) {
            response = re.toString();
        }
        catch (EntryNotFoundException enof) {
            response = enof.toString();
        }
        catch (NullPointerException npe) {
            response = npe.toString();
        }
        catch (RemoteException re) {
            response = re.toString();
        }
        catch (NotImplementedException nie) {
            response = nie.toString();
        }
        catch (CustomRegistryException cre) {
            response = cre.toString();
        }
        pw.println("Result from method: " + method);
        pw.println(response);
        pw.flush();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/plain");
        PrintWriter pw = resp.getWriter();
        try {
            this.handleMethodRequest(req, pw, this.getCurrentUserRegistry(pw));
        }
        catch (RegistryException e) {
            e.printStackTrace(pw);
            pw.println("getCurrentUserRegistry exception message:");
            pw.println((Object)e);
            pw.flush();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(pw);
            pw.println("getCurrentUserRegistry exception message:");
            pw.println(e);
            pw.flush();
        }
        catch (Exception e) {
            pw.println("Unexpected Exception during processing:");
            e.printStackTrace(pw);
        }
        pw.flush();
        pw.close();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/plain");
        PrintWriter pw = resp.getWriter();
        pw.print("use GET method");
    }

    private static String convertFromList(List<?> results) {
        System.out.println("UserRegistryServlet.converFromList(): " + results.getClass() + " " + results);
        if (results.isEmpty()) {
            return results.toString();
        }
        String delimiter = " :: ";
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        for (int idx = 0; idx < results.size(); ++idx) {
            sb.append(results.get(idx));
            if (idx >= results.size() - 1) continue;
            sb.append(" :: ");
        }
        sb.append(']');
        return sb.toString();
    }

    private static String convertFromSR(SearchResult results) {
        return "SearchResult hasMore=" + results.hasMore() + " " + UserRegistryServlet.convertFromList(results.getList());
    }
}

