/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.test;

import com.ibm.ws.security.registry.CertificateMapFailedException;
import com.ibm.ws.security.registry.CertificateMapNotSupportedException;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.SearchResult;
import com.ibm.ws.security.registry.UserRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UserRegistryServletConnection
implements UserRegistry {
    private static final Class<?> c = UserRegistryServletConnection.class;
    private final Logger logger;
    private final String servletURL;

    public UserRegistryServletConnection(String host, int port) {
        if (host == null || port == 0) {
            throw new IllegalArgumentException("Host (" + host + "is null or port (" + port + ") is zero");
        }
        this.servletURL = "http://" + host + ":" + port + "/userRegistry";
        this.logger = Logger.getLogger(c.getCanonicalName());
        this.logger.info("Servlet URL: " + this.servletURL);
    }

    private String do_makeServletMethodCall(String methodName, HttpURLConnection con) throws IOException {
        String line = null;
        String resultLine = null;
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            con.setReadTimeout(600000);
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestMethod("GET");
            is = con.getInputStream();
            isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            boolean foundResultLine = false;
            boolean populatedResultLine = false;
            while ((line = br.readLine()) != null) {
                this.logger.info("Read line: " + line);
                if (foundResultLine && !populatedResultLine) {
                    resultLine = line;
                    populatedResultLine = true;
                }
                if (line.startsWith("Result from method: " + methodName)) {
                    foundResultLine = true;
                }
                if (!line.startsWith("getCurrentUserRegistry exception message:")) continue;
                foundResultLine = true;
            }
            if (!foundResultLine || resultLine == null) {
                throw new IllegalStateException("Error: expected return line from servlet response not found");
            }
        }
        catch (SocketTimeoutException e) {
            Thread.dumpStack();
            throw e;
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException ioe) {
                this.logger.info(ioe.getMessage());
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {
                this.logger.info(ioe.getMessage());
            }
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ioe) {
                this.logger.info(ioe.getMessage());
            }
            if (con != null) {
                con.disconnect();
            }
        }
        this.logger.info("result line = " + resultLine);
        return resultLine;
    }

    protected String makeServletMethodCall(final String methodName, final String servletRequest) {
        this.logger.info("START servlet invocation for [" + methodName + "]");
        String result = null;
        try {
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    URL url = new URL(UserRegistryServletConnection.this.servletURL + servletRequest);
                    UserRegistryServletConnection.this.logger.info("Invocation URL=" + url);
                    HttpURLConnection con = (HttpURLConnection)url.openConnection();
                    return UserRegistryServletConnection.this.do_makeServletMethodCall(methodName, con);
                }
            });
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception occured while trying to access servlet", e);
            e.printStackTrace();
            result = e.toString();
        }
        this.logger.info("END servlet invocation for [" + methodName + "], returning [" + result + "]");
        return result;
    }

    private void throwIfRegistryException(String ret) throws RegistryException {
        if (!ret.startsWith(RegistryException.class.getName())) {
            return;
        }
        String[] split = ret.split(": ", 2);
        String msg = split.length == 2 ? split[1] : split[0];
        throw new RegistryException(msg);
    }

    private void throwIfEntryNotFoundException(String ret) throws EntryNotFoundException {
        if (!ret.startsWith(EntryNotFoundException.class.getName())) {
            return;
        }
        String[] split = ret.split(": ", 2);
        String msg = split.length == 2 ? split[1] : split[0];
        throw new EntryNotFoundException(msg);
    }

    private void throwIfIllegalArgumentException(String ret) throws IllegalArgumentException {
        if (!ret.startsWith(IllegalArgumentException.class.getName())) {
            return;
        }
        String[] split = ret.split(": ", 2);
        String msg = split.length == 2 ? split[1] : split[0];
        throw new IllegalArgumentException(msg);
    }

    protected String makeServletMethodCallWithException(String methodName, String servletRequest) throws RegistryException {
        String ret = this.makeServletMethodCall(methodName, servletRequest);
        this.throwIfRegistryException(ret);
        this.throwIfIllegalArgumentException(ret);
        if (ret.equals("null")) {
            return null;
        }
        return ret;
    }

    protected String makeServletMethodCallWithExceptions(String methodName, String servletRequest) throws RegistryException, EntryNotFoundException {
        String ret = this.makeServletMethodCall(methodName, servletRequest);
        this.throwIfRegistryException(ret);
        this.throwIfEntryNotFoundException(ret);
        this.throwIfIllegalArgumentException(ret);
        return ret;
    }

    private boolean convertToBoolean(String methodName, String str) {
        if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("false")) {
            return Boolean.parseBoolean(str);
        }
        throw new IllegalStateException(methodName + "expected either 'true' or 'false', but was: " + str);
    }

    private List<String> convertToList(String methodName, String str) {
        String delimiter = " :: ";
        ArrayList<String> list = new ArrayList<String>();
        if (str.startsWith("[") && str.endsWith("]")) {
            String[] contents;
            if (str.length() == 2) {
                return list;
            }
            for (String entry : contents = str.substring(1, str.length() - 1).split(" :: ")) {
                list.add(entry);
            }
            return list;
        }
        throw new IllegalStateException(methodName + "expected [...], but was: " + str);
    }

    private SearchResult convertToSearchResult(String methodName, String str) {
        String[] tokens = str.split(" ");
        if ("SearchResult".equals(tokens[0])) {
            boolean hasMore = this.convertToBoolean("convertToSearchResult, token[1]", tokens[1].split("=")[1]);
            String listStr = str.substring(str.indexOf(91), str.indexOf(93) + 1);
            List<String> list = this.convertToList("convertToSearchResult, listStr", listStr);
            return new SearchResult(list, hasMore);
        }
        throw new IllegalStateException(methodName + " expected a SearchResult response, but received [" + str + "]");
    }

    private String encodeForURI(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (Exception e) {
            throw new IllegalStateException("Error encoding string '" + string + "' for URI.", e);
        }
    }

    public String getRealm() {
        String methodName = "getRealm";
        String servletRequest = "?method=" + methodName;
        return this.makeServletMethodCall(methodName, servletRequest);
    }

    public String checkPassword(String userSecurityName, String password) throws RegistryException {
        String methodName = "checkPassword";
        String servletRequest = "?method=" + methodName + "&userSecurityName=" + this.encodeForURI(userSecurityName) + "&password=" + this.encodeForURI(password);
        return this.makeServletMethodCallWithException(methodName, servletRequest);
    }

    public String mapCertificate(X509Certificate[] chain) throws CertificateMapNotSupportedException, CertificateMapFailedException, RegistryException {
        throw new CertificateMapNotSupportedException("UserRegistry servlet does not support mapCertificate right now.");
    }

    public boolean isValidUser(String userSecurityName) throws RegistryException {
        String methodName = "isValidUser";
        String servletRequest = "?method=" + methodName + "&userSecurityName=" + this.encodeForURI(userSecurityName);
        String servletResponse = this.makeServletMethodCallWithException(methodName, servletRequest);
        return this.convertToBoolean(methodName, servletResponse);
    }

    public SearchResult getUsers(String pattern, int limit) throws RegistryException {
        String methodName = "getUsers";
        String servletRequest = "?method=" + methodName + "&pattern=" + this.encodeForURI(pattern) + "&limit=" + limit;
        String servletResponse = this.makeServletMethodCallWithException(methodName, servletRequest);
        return this.convertToSearchResult(methodName, servletResponse);
    }

    public String getUserDisplayName(String userSecurityName) throws EntryNotFoundException, RegistryException {
        String methodName = "getUserDisplayName";
        String servletRequest = "?method=" + methodName + "&userSecurityName=" + this.encodeForURI(userSecurityName);
        return this.makeServletMethodCallWithExceptions(methodName, servletRequest);
    }

    public String getUniqueUserId(String userSecurityName) throws EntryNotFoundException, RegistryException {
        String methodName = "getUniqueUserId";
        String servletRequest = "?method=" + methodName + "&userSecurityName=" + this.encodeForURI(userSecurityName);
        return this.makeServletMethodCallWithExceptions(methodName, servletRequest);
    }

    public String getUserSecurityName(String uniqueUserId) throws EntryNotFoundException, RegistryException {
        String methodName = "getUserSecurityName";
        String servletRequest = "?method=" + methodName + "&uniqueUserId=" + this.encodeForURI(uniqueUserId);
        return this.makeServletMethodCallWithExceptions(methodName, servletRequest);
    }

    public SearchResult getUsersForGroup(String groupSecurityName, int limit) throws EntryNotFoundException, RegistryException {
        String methodName = "getUsersForGroup";
        String servletRequest = "?method=" + methodName + "&groupSecurityName=" + this.encodeForURI(groupSecurityName) + "&limit=" + limit;
        String servletResponse = this.makeServletMethodCallWithExceptions(methodName, servletRequest);
        return this.convertToSearchResult(methodName, servletResponse);
    }

    public boolean isValidGroup(String groupSecurityName) throws RegistryException {
        String methodName = "isValidGroup";
        String servletRequest = "?method=" + methodName + "&groupSecurityName=" + this.encodeForURI(groupSecurityName);
        String servletResponse = this.makeServletMethodCallWithException(methodName, servletRequest);
        return this.convertToBoolean(methodName, servletResponse);
    }

    public SearchResult getGroups(String pattern, int limit) throws RegistryException {
        String methodName = "getGroups";
        String servletRequest = "?method=" + methodName + "&pattern=" + this.encodeForURI(pattern) + "&limit=" + limit;
        String servletResponse = this.makeServletMethodCallWithException(methodName, servletRequest);
        return this.convertToSearchResult(methodName, servletResponse);
    }

    public String getGroupDisplayName(String groupSecurityName) throws EntryNotFoundException, RegistryException {
        String methodName = "getGroupDisplayName";
        String servletRequest = "?method=" + methodName + "&groupSecurityName=" + this.encodeForURI(groupSecurityName);
        return this.makeServletMethodCallWithExceptions(methodName, servletRequest);
    }

    public String getUniqueGroupId(String groupSecurityName) throws EntryNotFoundException, RegistryException {
        String methodName = "getUniqueGroupId";
        String servletRequest = "?method=" + methodName + "&groupSecurityName=" + this.encodeForURI(groupSecurityName);
        return this.makeServletMethodCallWithExceptions(methodName, servletRequest);
    }

    public String getGroupSecurityName(String uniqueGroupId) throws EntryNotFoundException, RegistryException {
        String methodName = "getGroupSecurityName";
        String servletRequest = "?method=" + methodName + "&uniqueGroupId=" + this.encodeForURI(uniqueGroupId);
        return this.makeServletMethodCallWithExceptions(methodName, servletRequest);
    }

    public List<String> getUniqueGroupIdsForUser(String uniqueUserId) throws EntryNotFoundException, RegistryException {
        String methodName = "getUniqueGroupIdsForUser";
        String servletRequest = "?method=" + methodName + "&uniqueUserId=" + this.encodeForURI(uniqueUserId);
        String servletResponse = this.makeServletMethodCallWithExceptions(methodName, servletRequest);
        return this.convertToList(methodName, servletResponse);
    }

    public List<String> getGroupsForUser(String userSecurityName) throws EntryNotFoundException, RegistryException {
        String methodName = "getGroupsForUser";
        String servletRequest = "?method=" + methodName + "&userSecurityName=" + this.encodeForURI(userSecurityName);
        String servletResponse = this.makeServletMethodCallWithExceptions(methodName, servletRequest);
        return this.convertToList(methodName, servletResponse);
    }

    public String getType() {
        String methodName = "getType";
        String servletRequest = "?method=" + methodName;
        return this.makeServletMethodCall(methodName, servletRequest);
    }
}

