/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.framework.Version;

public class FeatureResolverImpl
implements FeatureResolver {
    private static final Object tc;

    @Override
    public FeatureResolver.Result resolveFeatures(FeatureResolver.Repository repository, Collection<String> rootFeatures, Set<String> preResolved, boolean allowMultipleVersions) {
        return this.resolveFeatures(repository, Collections.<ProvisioningFeatureDefinition>emptySet(), rootFeatures, preResolved, allowMultipleVersions, EnumSet.allOf(ProcessType.class));
    }

    @Override
    public FeatureResolver.Result resolveFeatures(FeatureResolver.Repository repository, Collection<ProvisioningFeatureDefinition> kernelFeatures, Collection<String> rootFeatures, Set<String> preResolved, boolean allowMultipleVersions) {
        return this.resolveFeatures(repository, kernelFeatures, rootFeatures, preResolved, allowMultipleVersions, EnumSet.allOf(ProcessType.class));
    }

    @Override
    public FeatureResolver.Result resolveFeatures(FeatureResolver.Repository repository, Collection<ProvisioningFeatureDefinition> kernelFeatures, Collection<String> rootFeatures, Set<String> preResolved, boolean allowMultipleVersions, EnumSet<ProcessType> supportedProcessTypes) {
        SelectionContext selectionContext = new SelectionContext(repository, allowMultipleVersions, supportedProcessTypes);
        preResolved = this.checkPreResolvedExistAndSetFullName(preResolved, selectionContext);
        rootFeatures = this.checkRootsAreAccessibleAndSetFullName(new ArrayList<String>(rootFeatures), selectionContext, preResolved);
        selectionContext.primeSelected(preResolved);
        selectionContext.primeSelected(rootFeatures);
        Set<String> autoFeaturesToInstall = Collections.emptySet();
        HashSet<String> seenAutoFeatures = new HashSet<String>();
        Set<String> resolved = Collections.emptySet();
        do {
            if (autoFeaturesToInstall.isEmpty()) continue;
            rootFeatures = autoFeaturesToInstall;
            selectionContext.primeSelected(autoFeaturesToInstall);
            preResolved = resolved;
            selectionContext.saveCurrentPreResolvedConflicts();
        } while (!(autoFeaturesToInstall = this.processAutoFeatures(kernelFeatures, resolved = this.doResolveFeatures(rootFeatures, preResolved, selectionContext), seenAutoFeatures, selectionContext)).isEmpty());
        return selectionContext.getResult();
    }

    private List<String> checkRootsAreAccessibleAndSetFullName(List<String> rootFeatures, SelectionContext selectionContext, Set<String> preResolved) {
        ListIterator<String> iRootFeatures = rootFeatures.listIterator();
        while (iRootFeatures.hasNext()) {
            String rootFeatureName = iRootFeatures.next();
            ProvisioningFeatureDefinition rootFeatureDef = selectionContext.getRepository().getFeature(rootFeatureName);
            if (rootFeatureDef != null) {
                if (rootFeatureDef.getVisibility() != Visibility.PUBLIC) {
                    selectionContext.getResult().addNonPublicRoot(rootFeatureName);
                    iRootFeatures.remove();
                    continue;
                }
                if (!FeatureResolverImpl.supportedProcessType(selectionContext._supportedProcessTypes, rootFeatureDef)) {
                    String rootSymbolicName = rootFeatureDef.getSymbolicName();
                    String[] nameAndVersion = FeatureResolverImpl.parseNameAndVersion(rootSymbolicName);
                    String preferredVersion = nameAndVersion[1];
                    FeatureResolver.Chain chain = new FeatureResolver.Chain(Collections.<String>emptyList(), Collections.singletonList(rootSymbolicName), preferredVersion, rootSymbolicName);
                    selectionContext.getResult().addWrongProcessType(rootFeatureName, chain);
                    iRootFeatures.remove();
                    continue;
                }
                if (preResolved.contains(rootFeatureDef.getSymbolicName())) {
                    iRootFeatures.remove();
                    continue;
                }
                iRootFeatures.set(rootFeatureDef.getSymbolicName());
                continue;
            }
            selectionContext.getResult().addMissing(rootFeatureName);
            iRootFeatures.remove();
        }
        return rootFeatures;
    }

    static final boolean supportedProcessType(EnumSet<ProcessType> supportedTypes, ProvisioningFeatureDefinition fd) {
        for (ProcessType processType : fd.getProcessTypes()) {
            if (!supportedTypes.contains((Object)processType)) continue;
            return true;
        }
        return false;
    }

    private Set<String> checkPreResolvedExistAndSetFullName(Set<String> preResolved, SelectionContext selectionContext) {
        LinkedHashSet<String> preResolvedSymbolicNames = new LinkedHashSet<String>(preResolved.size());
        for (String preResolvedFeatureName : preResolved) {
            ProvisioningFeatureDefinition preResolvedDef = selectionContext.getRepository().getFeature(preResolvedFeatureName);
            if (preResolvedDef == null) {
                return Collections.emptySet();
            }
            preResolvedSymbolicNames.add(preResolvedDef.getSymbolicName());
        }
        return preResolvedSymbolicNames;
    }

    private Set<String> doResolveFeatures(Collection<String> rootFeatures, Set<String> preResolved, SelectionContext selectionContext) {
        selectionContext.resetInitialBlockedCount();
        Set<String> result = this.processCurrentPermutation(rootFeatures, preResolved, selectionContext);
        if (selectionContext.getResult().getConflicts().isEmpty()) {
            selectionContext.selectCurrentPermutation();
            return result;
        }
        while (selectionContext.currentHasMoreThanInitialBlockedCount() && selectionContext.popPermutation()) {
            result = this.processCurrentPermutation(rootFeatures, preResolved, selectionContext);
        }
        selectionContext.restoreBestSolution();
        return selectionContext.getResult().getResolvedFeatures();
    }

    Set<String> processCurrentPermutation(Collection<String> rootFeatures, Set<String> preResolved, SelectionContext selectionContext) {
        Set<String> result;
        int numBlocked;
        do {
            selectionContext.processPostponed();
            numBlocked = selectionContext.getBlockedCount();
            result = this.processRoots(rootFeatures, preResolved, selectionContext);
        } while (selectionContext.hasPostponed() || numBlocked != selectionContext.getBlockedCount());
        ((SelectionContext)selectionContext)._current._result.setResolvedFeatures(result);
        selectionContext.checkForBestSolution();
        return result;
    }

    private Set<String> processRoots(Collection<String> rootFeatures, Set<String> preResolved, SelectionContext selectionContext) {
        ArrayDeque<String> chain = new ArrayDeque<String>();
        LinkedHashSet<String> result = new LinkedHashSet<String>(preResolved.size());
        for (String featureSymbolicName : preResolved) {
            ProvisioningFeatureDefinition featureDef = selectionContext._repository.getFeature(featureSymbolicName);
            result.add(featureDef.getFeatureName());
        }
        for (String rootFeatureName : rootFeatures) {
            ProvisioningFeatureDefinition rootFeatureDef = selectionContext.getRepository().getFeature(rootFeatureName);
            if (rootFeatureDef == null) {
                selectionContext.getResult().addMissing(rootFeatureName);
                continue;
            }
            this.processSelected(rootFeatureDef, null, chain, result, selectionContext);
        }
        selectionContext.setInitialRootBlockedCount();
        return result;
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    public static String[] parseNameAndVersion(String feature) {
        String baseName = feature;
        String version = null;
        int lastDash = feature.lastIndexOf(45);
        if (lastDash >= 0) {
            version = feature.substring(lastDash + 1);
            try {
                Version.parseVersion((String)version);
                baseName = feature.substring(0, lastDash);
            }
            catch (IllegalArgumentException e) {
                version = null;
            }
        }
        return new String[]{baseName, version};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSelected(ProvisioningFeatureDefinition selectedFeature, Set<String> allowedTolerations, Deque<String> chain, Set<String> result, SelectionContext selectionContext) {
        if (selectedFeature == null) {
            return;
        }
        String featureName = selectedFeature.getSymbolicName();
        String baseFeatureName = FeatureResolverImpl.parseNameAndVersion(featureName)[0];
        if (selectionContext.isBlocked(baseFeatureName)) {
            return;
        }
        if (!selectionContext._allowMultipleVersions && selectedFeature.isSingleton()) {
            String selectedFeatureName;
            FeatureResolver.Chain existingSelection = selectionContext.getSelected(baseFeatureName);
            String string = selectedFeatureName = existingSelection == null ? null : existingSelection.getCandidates().get(0);
            if (existingSelection == null || !featureName.equals(selectedFeatureName)) {
                throw new IllegalStateException("Expected feature \"" + featureName + "\" to be selected instead feature of \"" + selectedFeatureName);
            }
        }
        if (chain.contains(selectedFeature.getSymbolicName())) {
            return;
        }
        chain.addLast(selectedFeature.getSymbolicName());
        try {
            Collection<FeatureResource> includes = selectedFeature.getConstituents(SubsystemContentType.FEATURE_TYPE);
            boolean isRoot = chain.size() == 1;
            HashSet<String> includedBaseFeatureNames = new HashSet<String>();
            for (FeatureResource included : includes) {
                String symbolicName = included.getSymbolicName();
                if (symbolicName == null) continue;
                String[] nameAndVersion = FeatureResolverImpl.parseNameAndVersion(included.getSymbolicName());
                String baseName = nameAndVersion[0];
                includedBaseFeatureNames.add(baseName);
            }
            if (allowedTolerations == null) {
                if (!isRoot) {
                    throw new IllegalStateException("A null allowTolerations is only valid for root features.");
                }
            } else {
                includedBaseFeatureNames.retainAll(allowedTolerations);
            }
            allowedTolerations = includedBaseFeatureNames;
            for (FeatureResource included : includes) {
                this.processIncluded(selectedFeature, included, allowedTolerations, chain, result, selectionContext);
            }
        }
        finally {
            chain.removeLast();
            result.add(selectedFeature.getFeatureName());
        }
    }

    private void processIncluded(ProvisioningFeatureDefinition includingFeature, FeatureResource included, Set<String> allowedTolerations, Deque<String> chain, Set<String> result, SelectionContext selectionContext) {
        String symbolicName = included.getSymbolicName();
        if (symbolicName == null) {
            if (!chain.isEmpty()) {
                selectionContext.getResult().addMissing(chain.peekLast());
            }
            return;
        }
        String[] nameAndVersion = FeatureResolverImpl.parseNameAndVersion(symbolicName);
        String baseSymbolicName = nameAndVersion[0];
        String preferredVersion = nameAndVersion[1];
        boolean isSingleton = false;
        if (selectionContext.isBlocked(baseSymbolicName)) {
            return;
        }
        List<String> tolerates = included.getTolerates();
        List<String> overrideTolerates = selectionContext.getRepository().getConfiguredTolerates(baseSymbolicName);
        if (!overrideTolerates.isEmpty()) {
            tolerates = tolerates == null ? new ArrayList<String>() : new ArrayList<String>(tolerates);
            tolerates.addAll(overrideTolerates);
        }
        ArrayList<String> candidateNames = new ArrayList<String>(1 + (tolerates == null ? 0 : tolerates.size()));
        ProvisioningFeatureDefinition preferredCandidateDef = selectionContext.getRepository().getFeature(symbolicName);
        if (preferredCandidateDef != null && this.isAccessible(includingFeature, preferredCandidateDef)) {
            this.checkForFullSymbolicName(preferredCandidateDef, symbolicName, chain.getLast());
            isSingleton = preferredCandidateDef.isSingleton();
            candidateNames.add(symbolicName);
        }
        if (tolerates != null && (candidateNames.isEmpty() || isSingleton)) {
            for (String tolerate : tolerates) {
                if (selectionContext._allowMultipleVersions && !candidateNames.isEmpty()) break;
                String toleratedSymbolicName = baseSymbolicName + '-' + tolerate;
                ProvisioningFeatureDefinition toleratedCandidateDef = selectionContext.getRepository().getFeature(toleratedSymbolicName);
                if (toleratedCandidateDef == null || candidateNames.contains(toleratedCandidateDef.getSymbolicName()) || !this.isAccessible(includingFeature, toleratedCandidateDef)) continue;
                this.checkForFullSymbolicName(toleratedCandidateDef, toleratedSymbolicName, chain.getLast());
                isSingleton |= toleratedCandidateDef.isSingleton();
                if (!this.isAllowedToleration(selectionContext, toleratedCandidateDef, allowedTolerations, overrideTolerates, baseSymbolicName, tolerate)) continue;
                candidateNames.add(toleratedCandidateDef.getSymbolicName());
            }
        }
        if (!isSingleton && candidateNames.size() > 1) {
            candidateNames.retainAll(Collections.singleton(candidateNames.get(0)));
        }
        selectionContext.processCandidates(chain, candidateNames, symbolicName, baseSymbolicName, preferredVersion, isSingleton);
        if (candidateNames.size() == 1) {
            String selectedName = (String)candidateNames.get(0);
            this.processSelected(selectionContext.getRepository().getFeature(selectedName), allowedTolerations, chain, result, selectionContext);
        }
    }

    private boolean isAccessible(ProvisioningFeatureDefinition includingFeature, ProvisioningFeatureDefinition candidateDef) {
        return candidateDef.getVisibility() != Visibility.PRIVATE || includingFeature.getBundleRepositoryType().equals(candidateDef.getBundleRepositoryType());
    }

    private boolean isAllowedToleration(SelectionContext selectionContext, ProvisioningFeatureDefinition toleratedCandidateDef, Set<String> allowedTolerations, List<String> overrideTolerates, String baseSymbolicName, String tolerate) {
        if (selectionContext._allowMultipleVersions) {
            return true;
        }
        if (Visibility.PRIVATE == toleratedCandidateDef.getVisibility()) {
            return true;
        }
        if (allowedTolerations.contains(baseSymbolicName)) {
            return true;
        }
        return overrideTolerates.contains(tolerate);
    }

    private void checkForFullSymbolicName(ProvisioningFeatureDefinition candidateDef, String symbolicName, String includingFeature) {
        if (!symbolicName.equals(candidateDef.getSymbolicName())) {
            throw new IllegalArgumentException("A feature is not allowed to use short feature names when including other features. Detected short name \"" + symbolicName + "\" being used instead of \"" + candidateDef.getSymbolicName() + "\" by feature \"" + includingFeature + "\".");
        }
    }

    private Set<String> processAutoFeatures(Collection<ProvisioningFeatureDefinition> kernelFeatures, Set<String> result, Set<String> seenAutoFeatures, SelectionContext selectionContext) {
        HashSet<String> autoFeaturesToProcess = new HashSet<String>();
        HashSet<ProvisioningFeatureDefinition> filteredFeatureDefs = new HashSet<ProvisioningFeatureDefinition>(kernelFeatures);
        for (String feature : result) {
            filteredFeatureDefs.add(selectionContext.getRepository().getFeature(feature));
        }
        for (ProvisioningFeatureDefinition autoFeatureDef : selectionContext.getRepository().getAutoFeatures()) {
            String featureSymbolicName = autoFeatureDef.getSymbolicName();
            if (seenAutoFeatures.contains(featureSymbolicName) || !autoFeatureDef.isCapabilitySatisfied(filteredFeatureDefs)) continue;
            seenAutoFeatures.add(featureSymbolicName);
            if (!FeatureResolverImpl.supportedProcessType(selectionContext._supportedProcessTypes, autoFeatureDef)) continue;
            autoFeaturesToProcess.add(featureSymbolicName);
        }
        return autoFeaturesToProcess;
    }

    static void trace(String message) {
        if (tc != null && TraceComponent.isAnyTracingEnabled() && ((TraceComponent)tc).isDebugEnabled()) {
            Tr.debug((TraceComponent)((TraceComponent)tc), (String)message, (Object[])new Object[0]);
        }
    }

    static {
        TraceComponent temp = null;
        try {
            temp = Tr.register(FeatureResolverImpl.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        tc = temp;
    }

    static class ResultImpl
    implements FeatureResolver.Result {
        final Set<String> _resolved = new LinkedHashSet<String>();
        final Set<String> _missing = new HashSet<String>();
        final Set<String> _nonPublicRoots = new HashSet<String>();
        final Map<String, Collection<FeatureResolver.Chain>> _conflicts = new HashMap<String, Collection<FeatureResolver.Chain>>();
        final Map<String, FeatureResolver.Chain> _wrongProcessTypes = new HashMap<String, FeatureResolver.Chain>();

        ResultImpl() {
        }

        @Override
        public Set<String> getResolvedFeatures() {
            return this._resolved;
        }

        ResultImpl setResolvedFeatures(Collection<String> resolved) {
            this._resolved.addAll(resolved);
            return this;
        }

        @Override
        public Set<String> getMissing() {
            return this._missing;
        }

        void addMissing(String missingFeature) {
            if (this._missing.add(missingFeature)) {
                FeatureResolverImpl.trace("Missing a feature: " + missingFeature);
            }
        }

        @Override
        public Map<String, Collection<FeatureResolver.Chain>> getConflicts() {
            return this._conflicts;
        }

        void addConflict0(String baseFeatureName, Collection<FeatureResolver.Chain> conflicts) {
            FeatureResolverImpl.trace("Found a conflict for feature: \"" + baseFeatureName + "\" with conficts: " + conflicts);
            this._conflicts.put(baseFeatureName, conflicts);
        }

        @Override
        public Set<String> getNonPublicRoots() {
            return this._nonPublicRoots;
        }

        void addNonPublicRoot(String nonPublicRoot) {
            if (this._nonPublicRoots.add(nonPublicRoot)) {
                FeatureResolverImpl.trace("A non-public root feature is being used: " + nonPublicRoot);
            }
        }

        @Override
        public Map<String, FeatureResolver.Chain> getWrongProcessTypes() {
            return this._wrongProcessTypes;
        }

        void addWrongProcessType(String wrongProcessType, FeatureResolver.Chain chain) {
            if (this._wrongProcessTypes.put(wrongProcessType, chain) == null) {
                FeatureResolverImpl.trace("A feature with the wrong process type is being used: \"" + wrongProcessType + "\" from chain: " + chain);
            }
        }

        @Override
        public boolean hasErrors() {
            return !this._missing.isEmpty() || !this._nonPublicRoots.isEmpty() || !this._conflicts.isEmpty() || !this._wrongProcessTypes.isEmpty();
        }
    }

    static class Chains
    implements Comparator<FeatureResolver.Chain> {
        private final Set<String> _attempted = new HashSet<String>();
        private final List<FeatureResolver.Chain> _chains = new ArrayList<FeatureResolver.Chain>();

        Chains() {
        }

        void add(FeatureResolver.Chain chain) {
            int insertion = Collections.binarySearch(this._chains, chain, this);
            if (insertion < 0) {
                insertion = -insertion - 1;
            } else {
                FeatureResolver.Chain existing;
                while (insertion < this._chains.size() && (existing = this._chains.get(insertion)) != null && this.compare(existing, chain) == 0) {
                    ++insertion;
                }
            }
            this._chains.add(insertion, chain);
        }

        public Chains copy() throws DeadEndChain {
            if (this.noMoreCandidatesToTry()) {
                throw new DeadEndChain();
            }
            Chains copy = new Chains();
            copy._chains.addAll(this._chains);
            copy._attempted.addAll(this._attempted);
            return copy;
        }

        private boolean noMoreCandidatesToTry() {
            for (FeatureResolver.Chain chain : this._chains) {
                boolean allAttempted = true;
                for (String candidate : chain.getCandidates()) {
                    if (!(allAttempted &= this._attempted.contains(candidate))) break;
                }
                if (!allAttempted) continue;
                return true;
            }
            return false;
        }

        @Override
        public int compare(FeatureResolver.Chain o1, FeatureResolver.Chain o2) {
            return o1.getPreferredVersion().compareTo(o2.getPreferredVersion());
        }

        FeatureResolver.Chain select(String baseFeatureName, SelectionContext selectionContext) {
            for (FeatureResolver.Chain selectedChain : this._chains) {
                FeatureResolver.Chain match;
                String preferredCandidate = selectedChain.getCandidates().get(0);
                if (!this._attempted.add(preferredCandidate) || (match = this.match(preferredCandidate, selectedChain, selectionContext)) == null) continue;
                return match;
            }
            for (FeatureResolver.Chain selectedChain : this._chains) {
                for (String candidate : selectedChain.getCandidates()) {
                    FeatureResolver.Chain match;
                    if (!this._attempted.add(candidate) || (match = this.match(candidate, selectedChain, selectionContext)) == null) continue;
                    return match;
                }
            }
            selectionContext.addConflict(baseFeatureName, this._chains);
            return null;
        }

        private FeatureResolver.Chain match(String candidate, FeatureResolver.Chain selectedChain, SelectionContext selectionContext) {
            for (FeatureResolver.Chain checkChain : this._chains) {
                if (selectedChain == checkChain || checkChain.getCandidates().contains(candidate)) continue;
                return null;
            }
            selectionContext.pushPermutation();
            return new FeatureResolver.Chain(selectedChain.getChain(), Collections.singletonList(candidate), selectedChain.getPreferredVersion().toString(), selectedChain.getFeatureRequirement());
        }

        List<FeatureResolver.Chain> getChains() {
            return this._chains;
        }

        FeatureResolver.Chain findConflict(String candidate) {
            for (FeatureResolver.Chain chain : this._chains) {
                if (chain.getCandidates().contains(candidate)) continue;
                return chain;
            }
            return null;
        }
    }

    static class SelectionContext {
        private final FeatureResolver.Repository _repository;
        private final Deque<Permutation> _permutations = new ArrayDeque<Permutation>(Arrays.asList(new Permutation()));
        private final boolean _allowMultipleVersions;
        private final EnumSet<ProcessType> _supportedProcessTypes;
        private final AtomicInteger _initialBlockedCount = new AtomicInteger(-1);
        private final Map<String, Collection<FeatureResolver.Chain>> _preResolveConflicts = new HashMap<String, Collection<FeatureResolver.Chain>>();
        private Permutation _current = this._permutations.getFirst();

        SelectionContext(FeatureResolver.Repository repository, boolean allowMultipleVersions, EnumSet<ProcessType> supportedProcessTypes) {
            this._repository = repository;
            this._allowMultipleVersions = allowMultipleVersions;
            this._supportedProcessTypes = supportedProcessTypes;
        }

        void saveCurrentPreResolvedConflicts() {
            this._preResolveConflicts.clear();
            this._preResolveConflicts.putAll(this._current._result.getConflicts());
        }

        void resetInitialBlockedCount() {
            this._initialBlockedCount.set(-1);
        }

        boolean currentHasMoreThanInitialBlockedCount() {
            return this.getBlockedCount() > this._initialBlockedCount.get();
        }

        void setInitialRootBlockedCount() {
            this._initialBlockedCount.compareAndSet(-1, this.getBlockedCount());
        }

        void restoreBestSolution() {
            while (this.popPermutation()) {
            }
            this._current = this._permutations.getFirst();
        }

        void selectCurrentPermutation() {
            this._permutations.clear();
            this._permutations.addFirst(this._current);
        }

        void checkForBestSolution() {
            if (this._permutations.getLast()._result.getConflicts().size() > this._current._result.getConflicts().size()) {
                this._permutations.pollLast();
                this._permutations.addLast(this._current);
            }
        }

        boolean popPermutation() {
            Permutation popped;
            Permutation permutation = popped = this._permutations.size() > 1 ? this._permutations.pollFirst() : null;
            if (popped != null) {
                this._current = popped;
                return true;
            }
            return false;
        }

        @FFDCIgnore(value={DeadEndChain.class})
        void pushPermutation() {
            if (this._initialBlockedCount.get() == this.getBlockedCount()) {
                try {
                    this._permutations.addFirst(this._current.copy(this._preResolveConflicts));
                }
                catch (DeadEndChain deadEndChain) {
                    // empty catch block
                }
            }
        }

        FeatureResolver.Repository getRepository() {
            return this._repository;
        }

        boolean isBlocked(String baseSymbolicName) {
            return this._current._blockedFeatures.contains(baseSymbolicName);
        }

        int getBlockedCount() {
            return this._current._blockedFeatures.size();
        }

        ResultImpl getResult() {
            return this._current._result;
        }

        void processCandidates(Collection<String> chain, List<String> candidateNames, String symbolicName, String baseSymbolicName, String preferredVersion, boolean isSingleton) {
            Iterator<String> iCandidateNames = candidateNames.iterator();
            while (iCandidateNames.hasNext()) {
                ProvisioningFeatureDefinition fd = this._repository.getFeature(iCandidateNames.next());
                if (FeatureResolverImpl.supportedProcessType(this._supportedProcessTypes, fd)) continue;
                FeatureResolver.Chain c = new FeatureResolver.Chain(chain, candidateNames, preferredVersion, symbolicName);
                this._current._result.addWrongProcessType(symbolicName, c);
                iCandidateNames.remove();
            }
            if (candidateNames.isEmpty()) {
                this._current._result.addMissing(symbolicName);
                return;
            }
            if (this._allowMultipleVersions || !isSingleton) {
                return;
            }
            ArrayList<String> copyCandidates = new ArrayList<String>(candidateNames);
            FeatureResolver.Chain selectedChain = this.getSelected(baseSymbolicName);
            if (selectedChain != null) {
                candidateNames.retainAll(selectedChain.getCandidates());
                if (candidateNames.isEmpty()) {
                    this.addConflict(baseSymbolicName, new ArrayList<FeatureResolver.Chain>(Arrays.asList(selectedChain, new FeatureResolver.Chain(chain, copyCandidates, preferredVersion, symbolicName))));
                    return;
                }
            }
            if (candidateNames.size() > 1) {
                this.addPostponed(baseSymbolicName, new FeatureResolver.Chain(chain, candidateNames, preferredVersion, symbolicName));
                return;
            }
            String selectedName = candidateNames.get(0);
            FeatureResolver.Chain conflict = this.getPostponedConflict(baseSymbolicName, selectedName);
            if (conflict != null) {
                this.addConflict(baseSymbolicName, new ArrayList<FeatureResolver.Chain>(Arrays.asList(conflict, new FeatureResolver.Chain(chain, copyCandidates, preferredVersion, symbolicName))));
            }
            if (selectedChain == null) {
                this._current._selected.put(baseSymbolicName, new FeatureResolver.Chain(chain, Collections.singletonList(selectedName), preferredVersion, symbolicName));
            }
            this._current._postponed.remove(baseSymbolicName);
        }

        FeatureResolver.Chain getSelected(String baseName) {
            return this._current._selected.get(baseName);
        }

        boolean hasPostponed() {
            return !this._current._postponed.isEmpty();
        }

        void processPostponed() {
            if (this._current._postponed.isEmpty()) {
                return;
            }
            Map.Entry<String, Chains> firstPostponed = this._current._postponed.entrySet().iterator().next();
            FeatureResolver.Chain selected = firstPostponed.getValue().select(firstPostponed.getKey(), this);
            if (selected != null) {
                this._current._selected.put(firstPostponed.getKey(), selected);
            }
            this._current._postponed.clear();
        }

        void primeSelected(Collection<String> features) {
            if (this._allowMultipleVersions) {
                return;
            }
            HashMap<String, String> conflicts = new HashMap<String, String>();
            Iterator<String> iFeatures = features.iterator();
            while (iFeatures.hasNext()) {
                String featureName = iFeatures.next();
                ProvisioningFeatureDefinition featureDef = this._repository.getFeature(featureName);
                if (featureDef == null || !featureDef.isSingleton()) continue;
                String featureSymbolicName = featureDef.getSymbolicName();
                String[] nameAndVersion = FeatureResolverImpl.parseNameAndVersion(featureSymbolicName);
                String base = nameAndVersion[0];
                String preferredVersion = nameAndVersion[1];
                FeatureResolver.Chain selectedChain = this._current._selected.get(base);
                if (selectedChain != null) {
                    iFeatures.remove();
                    String selectedFeature = selectedChain.getCandidates().get(0);
                    if (!features.contains(selectedFeature)) continue;
                    FeatureResolver.Chain conflictedFeatureChain = new FeatureResolver.Chain(Collections.<String>emptyList(), Collections.singletonList(featureSymbolicName), preferredVersion, featureSymbolicName);
                    this.addConflict(base, new ArrayList<FeatureResolver.Chain>(Arrays.asList(selectedChain, conflictedFeatureChain)));
                    conflicts.put(selectedFeature, base);
                    continue;
                }
                this._current._selected.put(base, new FeatureResolver.Chain(Collections.<String>emptyList(), Collections.singletonList(featureSymbolicName), preferredVersion, featureSymbolicName));
            }
            for (Map.Entry conflict : conflicts.entrySet()) {
                features.remove(conflict.getKey());
                this._current._selected.remove(conflict.getValue());
            }
        }

        void addPostponed(String baseName, FeatureResolver.Chain chain) {
            Chains existing = this._current._postponed.get(baseName);
            if (existing == null) {
                existing = new Chains();
                this._current._postponed.put(baseName, existing);
            }
            existing.add(chain);
        }

        FeatureResolver.Chain getPostponedConflict(String baseName, String selectedName) {
            Chains postponedChains = this._current._postponed.get(baseName);
            return postponedChains == null ? null : postponedChains.findConflict(selectedName);
        }

        void addConflict(String baseFeatureName, List<FeatureResolver.Chain> conflicts) {
            this._current._blockedFeatures.add(baseFeatureName);
            this._current._result.addConflict0(baseFeatureName, conflicts);
        }

        static class Permutation {
            final Map<String, FeatureResolver.Chain> _selected = new HashMap<String, FeatureResolver.Chain>();
            final Map<String, Chains> _postponed = new LinkedHashMap<String, Chains>();
            final Set<String> _blockedFeatures = new HashSet<String>();
            final ResultImpl _result = new ResultImpl();

            Permutation() {
            }

            Permutation copy(Map<String, Collection<FeatureResolver.Chain>> preResolveConflicts) throws DeadEndChain {
                Permutation copy = new Permutation();
                copy._selected.putAll(this._selected);
                copy._result._conflicts.putAll(preResolveConflicts);
                copy._result._missing.addAll(this._result.getMissing());
                copy._result._nonPublicRoots.addAll(this._result.getNonPublicRoots());
                for (Map.Entry<String, Chains> chainsEntry : this._postponed.entrySet()) {
                    copy._postponed.put(chainsEntry.getKey(), chainsEntry.getValue().copy());
                }
                return copy;
            }
        }
    }

    static class DeadEndChain
    extends Exception {
        private static final long serialVersionUID = 1L;

        DeadEndChain() {
        }
    }
}

