/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.crypto;

import com.ibm.websphere.crypto.InvalidPasswordDecodingException;
import com.ibm.websphere.crypto.InvalidPasswordEncodingException;
import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.crypto.util.InvalidPasswordCipherException;
import com.ibm.ws.crypto.util.MessageUtils;
import com.ibm.ws.crypto.util.PasswordCipherUtil;
import com.ibm.ws.crypto.util.PasswordHashGenerator;
import com.ibm.wsspi.security.crypto.EncryptedInfo;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PasswordUtil {
    public static final String PROPERTY_CRYPTO_KEY = "crypto.key";
    public static final String PROPERTY_NO_TRIM = "option.notrim";
    public static final String PROPERTY_HASH_ALGORITHM = "hash.algorithm";
    public static final String PROPERTY_HASH_ITERATION = "hash.iteration";
    public static final String PROPERTY_HASH_SALT = "hash.salt";
    public static final String PROPERTY_HASH_ENCODED = "hash.encoded";
    public static final String PROPERTY_HASH_LENGTH = "hash.length";
    public static final String PROPERTY_KEYRING = "keyring";
    public static final String PROPERTY_KEYRING_TYPE = "keyring.type";
    public static final String PROPERTY_KEY_LABEL = "key.label";
    private static final Class<?> CLASS_NAME = PasswordUtil.class;
    private static final String RB = "com.ibm.ws.crypto.util.internal.resources.Messages";
    private static final Logger logger = Logger.getLogger(CLASS_NAME.getCanonicalName(), "com.ibm.ws.crypto.util.internal.resources.Messages");
    private static final String CRYPTO_ALGORITHM_STARTED = "{";
    private static final String CRYPTO_ALGORITHM_STOPPED = "}";
    private static final String EMPTY_STRING = "";
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static final String getDefaultEncoding() {
        return PasswordCipherUtil.getSupportedCryptoAlgorithms()[0];
    }

    public static String decode(String encoded_string) throws InvalidPasswordDecodingException, UnsupportedCryptoAlgorithmException {
        if (encoded_string == null) {
            throw new InvalidPasswordDecodingException();
        }
        String crypto_algorithm = PasswordUtil.getCryptoAlgorithm(encoded_string);
        if (crypto_algorithm == null) {
            throw new InvalidPasswordDecodingException();
        }
        logger.logp(Level.FINEST, PasswordUtil.class.getName(), "decode", "before invoking decode_password : crypto_algorithm : " + crypto_algorithm + "\nencoded_string : " + encoded_string);
        String decoded_string = PasswordUtil.decode_password(PasswordUtil.removeCryptoAlgorithmTag(encoded_string), crypto_algorithm);
        if (decoded_string == null) {
            if (!PasswordUtil.isValidCryptoAlgorithm(crypto_algorithm)) {
                throw new UnsupportedCryptoAlgorithmException();
            }
            throw new InvalidPasswordDecodingException(crypto_algorithm);
        }
        return decoded_string;
    }

    public static String encode(String decoded_string) throws InvalidPasswordEncodingException, UnsupportedCryptoAlgorithmException {
        return PasswordUtil.encode(decoded_string, PasswordCipherUtil.getSupportedCryptoAlgorithms()[0], (String)null);
    }

    public static String encode(String decoded_string, String crypto_algorithm) throws InvalidPasswordEncodingException, UnsupportedCryptoAlgorithmException {
        return PasswordUtil.encode(decoded_string, crypto_algorithm, (String)null);
    }

    public static String encode(String decoded_string, String crypto_algorithm, String crypto_key) throws InvalidPasswordEncodingException, UnsupportedCryptoAlgorithmException {
        HashMap<String, String> props = new HashMap<String, String>();
        if (crypto_key != null) {
            props.put(PROPERTY_CRYPTO_KEY, crypto_key);
        }
        return PasswordUtil.encode(decoded_string, crypto_algorithm, props);
    }

    public static String encode(String decoded_string, String crypto_algorithm, Map<String, String> properties) throws InvalidPasswordEncodingException, UnsupportedCryptoAlgorithmException {
        String encoded_string;
        if (!PasswordUtil.isValidCryptoAlgorithm(crypto_algorithm)) {
            throw new UnsupportedCryptoAlgorithmException();
        }
        if (decoded_string == null) {
            throw new InvalidPasswordEncodingException();
        }
        String current_crypto_algorithm = PasswordUtil.getCryptoAlgorithm(decoded_string);
        if (current_crypto_algorithm != null && current_crypto_algorithm.startsWith(crypto_algorithm) || PasswordUtil.isHashed(decoded_string)) {
            throw new InvalidPasswordEncodingException();
        }
        if (current_crypto_algorithm != null) {
            decoded_string = PasswordUtil.passwordDecode(decoded_string);
        }
        if (properties == null || !properties.containsKey(PROPERTY_NO_TRIM) || !"true".equalsIgnoreCase(properties.get(PROPERTY_NO_TRIM))) {
            decoded_string = decoded_string.trim();
        }
        if ((encoded_string = PasswordUtil.encode_password(decoded_string, crypto_algorithm.trim(), properties)) == null) {
            throw new InvalidPasswordEncodingException();
        }
        return encoded_string;
    }

    public static String getCryptoAlgorithm(String password) {
        int end;
        if (null == password) {
            return null;
        }
        String algorithm = null;
        String data = password.trim();
        if (data.length() >= 2 && '{' == data.charAt(0) && (end = data.indexOf(125, 1)) > 0) {
            algorithm = data.substring(1, end).trim();
        }
        return algorithm;
    }

    public static String getCryptoAlgorithmTag(String password) {
        int end;
        if (null == password) {
            return null;
        }
        String tag = null;
        String data = password.trim();
        if (data.length() >= 2 && '{' == data.charAt(0) && (end = data.indexOf(125, 1)) > 0) {
            tag = ++end == data.length() ? data : data.substring(0, end).trim();
        }
        return tag;
    }

    public static boolean isEncrypted(String encoded_string) {
        String algorithm = PasswordUtil.getCryptoAlgorithm(encoded_string);
        return PasswordUtil.isValidCryptoAlgorithm(algorithm);
    }

    public static boolean isValidCryptoAlgorithm(String crypto_algorithm) {
        if (crypto_algorithm != null) {
            String algorithm = crypto_algorithm.trim();
            if (algorithm.length() == 0) {
                return true;
            }
            String[] SUPPORTED_CRYPTO_ALGORITHMS = PasswordCipherUtil.getSupportedCryptoAlgorithms();
            for (int i = 0; i < SUPPORTED_CRYPTO_ALGORITHMS.length; ++i) {
                if (!algorithm.startsWith(SUPPORTED_CRYPTO_ALGORITHMS[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValidCryptoAlgorithmTag(String tag) {
        return PasswordUtil.isValidCryptoAlgorithm(PasswordUtil.getCryptoAlgorithm(tag));
    }

    public static boolean isHashed(String encoded_string) {
        String algorithm = PasswordUtil.getCryptoAlgorithm(encoded_string);
        return PasswordUtil.isValidAlgorithm(algorithm, PasswordCipherUtil.getSupportedHashAlgorithms());
    }

    private static boolean isValidAlgorithm(String cryptoAlgorithm, String[] supportList) {
        String algorithm;
        boolean value = false;
        if (cryptoAlgorithm != null && supportList != null && (algorithm = cryptoAlgorithm.trim()) != null && algorithm.length() > 0) {
            for (int i = 0; i < supportList.length; ++i) {
                if (!algorithm.startsWith(supportList[i])) continue;
                value = true;
                break;
            }
        }
        return value;
    }

    public static String passwordDecode(String encoded_string) {
        if (encoded_string == null) {
            return null;
        }
        String crypto_algorithm = PasswordUtil.getCryptoAlgorithm(encoded_string);
        if (crypto_algorithm == null) {
            return encoded_string;
        }
        return PasswordUtil.decode_password(PasswordUtil.removeCryptoAlgorithmTag(encoded_string), crypto_algorithm);
    }

    public static String passwordEncode(String decoded_string) {
        return PasswordUtil.passwordEncode(decoded_string, PasswordCipherUtil.getSupportedCryptoAlgorithms()[0]);
    }

    public static String passwordEncode(String decoded_string, String crypto_algorithm) {
        if (decoded_string == null) {
            return null;
        }
        String current_crypto_algorithm = PasswordUtil.getCryptoAlgorithm(decoded_string);
        if (current_crypto_algorithm != null && current_crypto_algorithm.equals(crypto_algorithm)) {
            if (PasswordUtil.isValidCryptoAlgorithm(current_crypto_algorithm)) {
                return decoded_string.trim();
            }
            return null;
        }
        if (current_crypto_algorithm != null) {
            if (!PasswordUtil.isValidCryptoAlgorithm(current_crypto_algorithm)) {
                logger.logp(Level.FINEST, PasswordUtil.class.getName(), "passwordEncode", "PASSWORDUTIL_INVALID_CRYPTO_ALGORITHM", current_crypto_algorithm);
                return null;
            }
            decoded_string = PasswordUtil.passwordDecode(decoded_string);
        }
        return PasswordUtil.encode_password(decoded_string.trim(), crypto_algorithm.trim(), null);
    }

    public static String removeCryptoAlgorithmTag(String password) {
        int end;
        if (null == password) {
            return null;
        }
        String rc = null;
        String data = password.trim();
        if (data.length() >= 2 && '{' == data.charAt(0) && (end = data.indexOf(125, 1)) > 0) {
            rc = ++end == data.length() ? EMPTY_STRING : data.substring(end).trim();
        }
        return rc;
    }

    private static byte[] convert_to_bytes(String string) {
        if (null == string) {
            return null;
        }
        if (0 == string.length()) {
            return EMPTY_BYTE_ARRAY;
        }
        return string.getBytes(StandardCharsets.UTF_8);
    }

    private static String convert_to_string(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        if (0 == bytes.length) {
            return EMPTY_STRING;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static byte[] convert_viewable_to_bytes(String string) {
        if (null == string) {
            return null;
        }
        if (0 == string.length()) {
            return EMPTY_BYTE_ARRAY;
        }
        return Base64Coder.base64Decode((byte[])PasswordUtil.convert_to_bytes(string));
    }

    private static String convert_viewable_to_string(byte[] bytes) {
        String string = null;
        if (bytes != null) {
            string = bytes.length == 0 ? EMPTY_STRING : PasswordUtil.convert_to_string(Base64Coder.base64Encode((byte[])bytes));
        }
        return string;
    }

    private static String decode_password(String encoded_string, String crypto_algorithm) {
        StringBuilder buffer = new StringBuilder();
        if (crypto_algorithm.length() == 0) {
            buffer.append(encoded_string);
        } else {
            String decoded_string = null;
            if (encoded_string.length() > 0) {
                byte[] encrypted_bytes = PasswordUtil.convert_viewable_to_bytes(encoded_string);
                logger.logp(Level.FINEST, PasswordUtil.class.getName(), "decode_password", "byte array before decoding\n" + PasswordHashGenerator.hexDump((byte[])encrypted_bytes));
                if (encrypted_bytes == null) {
                    logger.logp(Level.SEVERE, PasswordUtil.class.getName(), "decode_password", "PASSWORDUTIL_INVALID_BASE64_STRING");
                    return null;
                }
                if (encrypted_bytes.length > 0) {
                    byte[] decrypted_bytes = null;
                    try {
                        decrypted_bytes = PasswordCipherUtil.decipher((byte[])encrypted_bytes, (String)crypto_algorithm);
                    }
                    catch (InvalidPasswordCipherException e) {
                        String message = e.getMessage();
                        if (message != null && message.contains("FIPS 140-3")) {
                            logger.logp(Level.SEVERE, PasswordUtil.class.getName(), "decode_password", MessageUtils.getMessage((String)"PASSWORDUTIL_EXCEPTION_FIPS140_3_AES128_UNAVAILABLE_ALGORITHM", (Object[])new Object[0]), e);
                        } else {
                            logger.logp(Level.SEVERE, PasswordUtil.class.getName(), "decode_password", "PASSWORDUTIL_CYPHER_EXCEPTION", e);
                        }
                        return null;
                    }
                    catch (UnsupportedCryptoAlgorithmException e) {
                        logger.logp(Level.SEVERE, PasswordUtil.class.getName(), "decode_password", "PASSWORDUTIL_UNKNOWN_ALGORITHM_EXCEPTION", e);
                        return null;
                    }
                    catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                        logger.logp(Level.SEVERE, PasswordUtil.class.getName(), "decode_password", MessageUtils.getMessage((String)"PASSWORDUTIL_UNAVAILABLE_DECRYPTION_ALGORITHM_EXCEPTION", (Object[])new Object[0]), e);
                        return null;
                    }
                    if (decrypted_bytes != null && decrypted_bytes.length > 0) {
                        decoded_string = PasswordUtil.convert_to_string(decrypted_bytes);
                    }
                }
            }
            if (decoded_string != null && decoded_string.length() > 0) {
                buffer.append(decoded_string);
            }
        }
        return buffer.toString();
    }

    public static String encode_password(String decoded_string, String crypto_algorithm, Map<String, String> properties) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(CRYPTO_ALGORITHM_STARTED);
        if (crypto_algorithm.length() == 0) {
            buffer.append(CRYPTO_ALGORITHM_STOPPED).append(decoded_string);
        } else {
            String alias;
            byte[] decrypted_bytes;
            String encoded_string = null;
            EncryptedInfo info = null;
            if (decoded_string.length() > 0 && (decrypted_bytes = PasswordUtil.convert_to_bytes(decoded_string)).length > 0) {
                byte[] encrypted_bytes = null;
                boolean done = false;
                while (!done) {
                    try {
                        info = PasswordCipherUtil.encipher_internal((byte[])decrypted_bytes, (String)crypto_algorithm, properties);
                        if (info != null) {
                            encrypted_bytes = info.getEncryptedBytes();
                        }
                        done = true;
                    }
                    catch (InvalidPasswordCipherException e) {
                        logger.logp(Level.SEVERE, PasswordUtil.class.getName(), "encode_password", "PASSWORDUTIL_CYPHER_EXCEPTION", e);
                        return null;
                    }
                    catch (UnsupportedCryptoAlgorithmException e) {
                        logger.logp(Level.SEVERE, PasswordUtil.class.getName(), "encode_password", "PASSWORDUTIL_UNKNOWN_ALGORITHM_EXCEPTION", e);
                        return null;
                    }
                    catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                        logger.logp(Level.SEVERE, PasswordUtil.class.getName(), "encode_password", MessageUtils.getMessage((String)"PASSWORDUTIL_UNAVAILABLE_ENCRYPTION_ALGORITHM_EXCEPTION", (Object[])new Object[0]), e);
                        return null;
                    }
                }
                if (encrypted_bytes != null && encrypted_bytes.length > 0 && (encoded_string = PasswordUtil.convert_viewable_to_string(encrypted_bytes)) == null) {
                    return null;
                }
            }
            buffer.append(crypto_algorithm);
            String string = alias = null == info ? null : info.getKeyAlias();
            if (alias != null && 0 < alias.length()) {
                buffer.append(':').append(alias);
            }
            buffer.append(CRYPTO_ALGORITHM_STOPPED);
            if (encoded_string != null && encoded_string.length() > 0) {
                buffer.append(encoded_string);
            }
        }
        return buffer.toString();
    }
}

