/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.cics.impl;

import com.ibm.zosconnect.ui.common.exceptions.ResponseInterfaceDefaultValueException;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectMarkerAttributes;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectMarkerTypes;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectValidationError;
import com.ibm.zosconnect.ui.programinterface.controllers.datastructure.TranDataStructureController;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.CheckArrayCountersVisitor;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.CheckDatatypeOverridesVisitor;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.CheckFieldDefaultValuesVisitor;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.ProjectTreeFileHelper;
import com.ibm.zosconnect.ui.service.cics.CicsXlat;
import com.ibm.zosconnect.ui.service.cics.natures.CicsChannelServiceProjectNature;
import com.ibm.zosconnect.ui.service.cics.natures.CicsCommareaServiceProjectNature;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtension;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtensionProperty;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceProjectController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServicePropertiesValidator;
import com.ibm.zosconnect.ui.service.editors.CsvListWidget;
import com.ibm.zosconnect.ui.service.validation.AdvancedOptionsValidator;
import com.ibm.zosconnect.wv.CCSIDMappingsUtil;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.Message;
import com.ibm.zosconnect.wv.sar.common.ServiceArchiveConstants;
import com.ibm.zosconnect.wv.transaction.messages.walkers.IMessageVisitor;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalker;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IMessageManager;

public class CicsPropertiesValidator
implements IServicePropertiesValidator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public final String className = this.getClass().getName();
    private static final Pattern HTTP_HEADER_ILLEGAL_CHARS_PATTERN = Pattern.compile("(([[^\\x21-\\x7E]()<>@;:,\"\\\\/\\[\\]?={}])+)");
    public static final String CONNECTION_REF_KEY = "connectionRef";
    public static final String CCSID_KEY = "ccsid";
    public static final String BIDI_REF_KEY = "bidiConfigRef";
    public static final String TRANSID_KEY = "transid";
    public static final String TRANSID_USAGE_KEY = "transidUsage";
    public static final String USE_CONTEXT_CONTAINERS = "useContextContainers";
    public static final String HTTP_HEADERS = "httpHeaders";
    public static final String PROGRAM_NAME = "Program";
    public static final String TRANSACTION_CODE = "Transaction code";
    public static final String EXECUTABLE_NAME = "executableName";
    public static final String REQUEST_SI_NAME = "requestSIName";
    public static final String RESPONSE_SI_NAME = "responseSIName";
    public static final String IMS_TRAN_CODE_SPACE_DELIMITED = "imsTranCodeSpaceDelimited";
    public static final String TRIM_OUTPUT_LEADING_WHITESPACE = "trimOutputLeadingWhitespace";
    public static final String TRIM_OUTPUT_TRAILING_WHITESPACE = "trimOutputTrailingWhitespace";
    public static final String ESCAPE_OUTPUT_CONTROL_CHARACTERS = "escapeOutputControlCharacters";
    public static final String INITIALIZE_INPUT_FIELDS = "initializeInputFields";
    public static final String OMIT_OUTPUT_FIELDS_BY_VALUE = "omitOutputFieldsByValue";
    public static final String OMIT_OUTPUT_FIELDS_BY_VALUE_BYTE = "omitOutputFieldsByValueByte";
    public static final String OMIT_OUTPUT_EMPTY_TAGS = "omitOutputEmptyTags";
    public static final String ENFORCE_MIN_ARRAY_OCCURANCE = "enforceMinArrayOccurrence";
    public static final String ENFORCE_MIN_ARRAY_OCCURANCE_RESPONSE = "enforceMinArrayOccurrenceResponse";
    private final String ccsidInvalidForBidiMsgKey = "CICS_CCSID_INVALID_FOR_BIDI";

    public ServiceProjectValidationError validateConfigurationProperty(ServiceProjectController serviceController, IMessageManager messageMgr, HashMap<String, Control> configurationControls, IResource resource, ServiceExtensionProperty extensionProperty, String value) {
        ZCeeUILogger.entering((String)this.className, (String)"validateConfigurationProperty", (Object[])new Object[]{serviceController, messageMgr, configurationControls, resource, extensionProperty, value});
        boolean isRequired = extensionProperty.isRequired();
        String key = extensionProperty.getPropertyName();
        if (isRequired && (value == null || value.isEmpty())) {
            return CicsPropertiesValidator.getMissingRequiredPropertyError(resource, key);
        }
        ServiceProjectValidationError result = null;
        Control ccsidControl = configurationControls.get(CCSID_KEY);
        Control bidiConfigRefControl = configurationControls.get(BIDI_REF_KEY);
        switch (key) {
            case "bidiConfigRef": {
                String currCCSID;
                if (value == null || value.isEmpty() || !(ccsidControl instanceof Text) || "420".equals(currCCSID = XSwt.getText((Text)((Text)ccsidControl))) || "424".equals(currCCSID)) break;
                result = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"CICS_CCSID_INVALID_FOR_BIDI", (String[])new String[]{currCCSID}));
                break;
            }
            case "ccsid": {
                try {
                    int ccsidInt = Integer.parseInt(value);
                    String encodingfromCCSID = CCSIDMappingsUtil.getEncodingfromCCSID((int)ccsidInt);
                    if (encodingfromCCSID == null) {
                        result = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"CICS_CCSID_INVALID", (String[])new String[]{key}));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    result = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"CICS_CCSID_NON_NUMERIC", (String[])new String[]{key}));
                }
                if (!(bidiConfigRefControl instanceof Text)) break;
                Text bidiConfigRefText = (Text)bidiConfigRefControl;
                bidiConfigRefText.setText(bidiConfigRefText.getText());
                break;
            }
            case "transid": {
                if (value.length() <= 4) break;
                result = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"CICS_TRANSID_TOO_LONG", (String[])new String[]{key}));
                break;
            }
            case "transidUsage": {
                if (value.isEmpty() || value.equalsIgnoreCase("EIB_ONLY") || value.equalsIgnoreCase("EIB_AND_MIRROR")) break;
                result = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"CICS_TRANSIDUSAGE_INVALID", (String[])new String[]{key}));
                break;
            }
            case "useContextContainers": {
                if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) break;
                result = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"CICS_USE_CONTEXT_CONTAINERS_NOT_BOOLEAN", (String[])new String[]{key}));
                break;
            }
            case "httpHeaders": {
                String illegalCharacters = CicsPropertiesValidator.isHeaderNameValid(value);
                if (illegalCharacters.isEmpty()) break;
                result = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"CICS_HTTP_HEADERS_INVALID_CHAR", (String[])new String[]{key, illegalCharacters}));
                break;
            }
            default: {
                result = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"UNKNOWN_PROPERTY", (String[])new String[]{key}));
            }
            case "connectionRef": 
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateConfigurationProperty", (Object[])new Object[]{result});
        return result;
    }

    public ServiceProjectValidationError validateConfigurationProperty(ServiceProjectController serviceController, IResource resource, String key, String value, boolean isRequired, String propertyType) {
        ZCeeUILogger.entering((String)this.className, (String)"validateConfigutationProperty", (Object[])new Object[]{resource, key, value, propertyType});
        ServiceProjectValidationError result = null;
        if (isRequired && (value == null || value.isEmpty())) {
            return CicsPropertiesValidator.getMissingRequiredPropertyError(resource, key);
        }
        switch (key) {
            case "bidiConfigRef": {
                String currCCSID;
                if (value == null || value.isEmpty() || "420".equals(currCCSID = serviceController.getServiceModel().getValue(CCSID_KEY)) || "424".equals(currCCSID)) break;
                result = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"CICS_CCSID_INVALID_FOR_BIDI", (String[])new String[]{currCCSID}));
                break;
            }
            case "ccsid": {
                try {
                    int ccsidInt = Integer.parseInt(value);
                    String encodingfromCCSID = CCSIDMappingsUtil.getEncodingfromCCSID((int)ccsidInt);
                    if (encodingfromCCSID != null) break;
                    result = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"CICS_CCSID_INVALID", (String[])new String[]{key}));
                }
                catch (NumberFormatException numberFormatException) {
                    result = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"CICS_CCSID_NON_NUMERIC", (String[])new String[]{key}));
                }
                break;
            }
            case "transid": {
                if (value.length() <= 4) break;
                result = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"CICS_TRANSID_TOO_LONG", (String[])new String[]{key}));
                break;
            }
            case "transidUsage": {
                if (value.isEmpty() || value.equalsIgnoreCase("EIB_ONLY") || value.equalsIgnoreCase("EIB_AND_MIRROR")) break;
                result = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"CICS_TRANSIDUSAGE_INVALID", (String[])new String[]{key}));
                break;
            }
            case "useContextContainers": {
                if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) break;
                result = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"CICS_USE_CONTEXT_CONTAINERS_NOT_BOOLEAN", (String[])new String[]{key}));
                break;
            }
            case "httpHeaders": {
                String illegalCharacters = CicsPropertiesValidator.isHeaderNameValid(value);
                if (illegalCharacters.isEmpty()) break;
                result = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"CICS_HTTP_HEADERS_INVALID_CHAR", (String[])new String[]{key, illegalCharacters}));
                break;
            }
            default: {
                result = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"UNKNOWN_PROPERTY", (String[])new String[]{key}));
            }
            case "connectionRef": 
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateConfigutationProperty", (Object[])new Object[]{result});
        return result;
    }

    public List<ServiceProjectValidationError> validateDefinitionProperty(IResource resource, String key, String value) {
        ZCeeUILogger.entering((String)this.className, (String)"validateDefinitionProperty", (Object[])new Object[]{resource, key, value});
        List<Object> result = new ArrayList<ServiceProjectValidationError>();
        if (value == null && !key.equals(ENFORCE_MIN_ARRAY_OCCURANCE_RESPONSE) && !key.equals(IMS_TRAN_CODE_SPACE_DELIMITED)) {
            String msg = Xlat.error((String)"REQUIRED_SERVICE_PROPERTY_MISSING", (String[])new String[]{key});
            result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg));
            ZCeeUILogger.exiting((String)this.className, (String)"validateDefinitionProperty", (Object[])new Object[]{result});
            return result;
        }
        ServiceProjectValidationError error = null;
        AdvancedOptionsValidator advancedOptionsValidator = new AdvancedOptionsValidator();
        switch (key) {
            case "executableName": {
                if (value.isEmpty()) {
                    String msg = Xlat.error((String)"MUST_CONTAIN_1_CHARACTER", (String[])new String[]{PROGRAM_NAME});
                    result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg));
                    break;
                }
                if (value.length() <= 8) break;
                String msg = Xlat.error((String)"MUST_BE_LESS_THAN_CHARACTERS", (String[])new String[]{PROGRAM_NAME, "9"});
                error = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg);
                error.getAttributes().put("key", PROGRAM_NAME);
                error.getAttributes().put("value", value);
                result.add(error);
                break;
            }
            case "requestSIName": {
                result = this.validateRequestOrResponseFile(resource, value, "SERVICEEDIT_LABEL_REQUESTSI", false);
                break;
            }
            case "responseSIName": {
                result = this.validateRequestOrResponseFile(resource, value, "SERVICEEDIT_LABEL_RESPONSESI", true);
                break;
            }
            case "trimOutputLeadingWhitespace": {
                error = advancedOptionsValidator.validateTrimOutputLeadingWhitespace(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "trimOutputTrailingWhitespace": {
                error = advancedOptionsValidator.validateTrimOutputTrailingWhitespace(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "escapeOutputControlCharacters": {
                error = advancedOptionsValidator.validateEscapeOutputControlCharacters(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "initializeInputFields": {
                error = advancedOptionsValidator.validateInitializeInputFields(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "omitOutputFieldsByValue": {
                error = advancedOptionsValidator.validateOmitOutputFieldsByValue(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "omitOutputEmptyTags": {
                error = advancedOptionsValidator.validateOmitOutputEmptyTags(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "enforceMinArrayOccurrence": {
                error = advancedOptionsValidator.validateEnforceMinArrayOccurrence(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "enforceMinArrayOccurrenceResponse": {
                error = advancedOptionsValidator.validateEnforceMinArrayOccurrenceResponse(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            default: {
                result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"UNKNOWN_PROPERTY", (String[])new String[]{key})));
            }
            case "omitOutputFieldsByValueByte": 
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateDefinitionProperty", (Object[])new Object[]{result});
        return result;
    }

    public static String isHeaderNameValid(String name) {
        StringBuilder illegalCharacters = new StringBuilder();
        for (String header : CsvListWidget.getItems((String)name)) {
            Matcher m = HTTP_HEADER_ILLEGAL_CHARS_PATTERN.matcher(header);
            while (m.find()) {
                String illegalCharacter = m.group(1);
                illegalCharacters.append(illegalCharacter);
            }
        }
        return illegalCharacters.toString();
    }

    public List<ServiceProjectValidationError> validateRequest(IResource resource, String value) {
        return this.validateRequestOrResponseFile(resource, value, "SERVICEEDIT_LABEL_REQUESTSI", false);
    }

    public List<ServiceProjectValidationError> validateResponse(IResource resource, String value) {
        return this.validateRequestOrResponseFile(resource, value, "SERVICEEDIT_LABEL_RESPONSESI", true);
    }

    private List<ServiceProjectValidationError> validateRequestOrResponseFile(IResource resource, String fileName, String label, boolean isResponse) {
        ZCeeUILogger.entering((String)this.className, (String)"validateRequestOrResponseFile", (Object[])new Object[]{resource, fileName, label, "isResponse: " + isResponse});
        ArrayList<ServiceProjectValidationError> result = new ArrayList<ServiceProjectValidationError>();
        if (fileName.isEmpty()) {
            String msg = Xlat.error((String)"REQUEST_OR_RESPONSE_REQUIRED", (String[])new String[]{Xlat.label((String)label)});
            result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg));
            ZCeeUILogger.exiting((String)this.className, (String)"validateRequestOrResponseFile", (Object[])new Object[]{result});
            return result;
        }
        String filePath = "service-interfaces" + File.separator + fileName;
        if (!resource.getProject().getFile(filePath).exists()) {
            String errMsgInsert = Xlat.error((String)"PROJECT_FILE_MISSING_ERROR", (String[])new String[]{fileName, resource.getProject().getName()});
            String errorMsg = Xlat.error((String)"PROPERTY_ERROR", (String[])new String[]{Xlat.label((String)label), errMsgInsert});
            result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, errorMsg));
            ZCeeUILogger.exiting((String)this.className, (String)"validateRequestOrResponseFile", (Object[])new Object[]{result});
            return result;
        }
        try {
            ServiceProjectValidationError error;
            FieldType errorField;
            CheckArrayCountersVisitor visitor;
            IFile file = resource.getProject().getFolder("service-interfaces").getFile(fileName);
            Message msg = ProjectTreeFileHelper.unmarshallzCEEPgmMsg((IFile)file);
            ServiceArchiveConstants.SP_Type project_spType = null;
            String projectServiceTypeLabel = null;
            String serviceInterfaceServiceTypeLabel = null;
            try {
                if (CicsChannelServiceProjectNature.hasNature(resource.getProject())) {
                    serviceInterfaceServiceTypeLabel = ServiceExtension.getLabelUsingServiceInterfaceServiceType((String)msg.getServiceType());
                    projectServiceTypeLabel = CicsXlat.label("CICS_CHANNEL_SERVICE", new String[0]);
                    project_spType = ServiceArchiveConstants.SP_Type.CICS_CHANNEL;
                } else if (CicsCommareaServiceProjectNature.hasNature(resource.getProject())) {
                    serviceInterfaceServiceTypeLabel = ServiceExtension.getLabelUsingServiceInterfaceServiceType((String)msg.getServiceType());
                    projectServiceTypeLabel = CicsXlat.label("CICS_COMMAREA_SERVICE", new String[0]);
                    project_spType = ServiceArchiveConstants.SP_Type.CICS_COMM_AREA;
                }
            }
            catch (Exception e) {
                ZCeeUILogger.error((String)e.getMessage(), (Object[])new Object[0]);
            }
            if (!CicsChannelServiceProjectNature.hasNature(resource.getProject()) && !CicsCommareaServiceProjectNature.hasNature(resource.getProject())) {
                ZCeeUILogger.error((String)("Missing project nature for project " + resource.getProject().getName() + ". Unable to complete validation for Request or Response service interface."), (Object[])new Object[0]);
                ZCeeErrorDialog.openError((Exception)new Exception("Missing project nature for project " + resource.getProject().getName() + ". Unable to complete validation for Request or Response service interface."), (boolean)true);
            }
            if (msg.getServiceType() != null && !msg.getServiceType().equals(project_spType.toString())) {
                String errMsgInsert = Xlat.error((String)"SE_INCOMPATIBLE_SI_FILE", (String[])new String[]{serviceInterfaceServiceTypeLabel, projectServiceTypeLabel});
                String errorMsg = Xlat.error((String)"PROPERTY_ERROR", (String[])new String[]{Xlat.label((String)label), errMsgInsert});
                result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, errorMsg));
                ZCeeUILogger.exiting((String)this.className, (String)"validateRequestOrResponseFile", (Object[])new Object[]{result});
                return result;
            }
            if (isResponse) {
                CheckFieldDefaultValuesVisitor visitor2 = new CheckFieldDefaultValuesVisitor();
                try {
                    new MessageWalker().accept((IMessageVisitor)visitor2, msg.getMessage());
                }
                catch (ResponseInterfaceDefaultValueException responseInterfaceDefaultValueException) {
                    String error2 = Xlat.error((String)"RESPONSE_SI_DEFAULTVALUES", (String[])new String[]{fileName});
                    result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.SERVICEINTERFACE_PROBLEM.toString(), error2, null, null, Integer.valueOf(1)));
                }
            }
            List dataStructures = TranDataStructureController.getAllDataStructures((Message)msg);
            for (FieldType dataStructure : dataStructures) {
                visitor = new CheckArrayCountersVisitor();
                new MessageWalker().accept((IMessageVisitor)visitor, dataStructure);
                for (Map.Entry errorEntry : visitor.getFieldErrorMessages().entrySet()) {
                    errorField = (FieldType)errorEntry.getKey();
                    for (String errorMessage : (List)errorEntry.getValue()) {
                        error = new ServiceProjectValidationError((IResource)file, ServiceProjectMarkerTypes.SERVICEINTERFACE_PROBLEM, errorMessage);
                        error.setAttribute(ServiceProjectMarkerAttributes.FIELD_PATH, errorField.getPath());
                        result.add(error);
                    }
                }
            }
            for (FieldType dataStructure : dataStructures) {
                visitor = new CheckDatatypeOverridesVisitor(!isResponse);
                new MessageWalker().accept((IMessageVisitor)visitor, dataStructure);
                for (Map.Entry errorEntry : visitor.getFieldErrorMessages().entrySet()) {
                    errorField = (FieldType)errorEntry.getKey();
                    for (String errorMessage : (List)errorEntry.getValue()) {
                        error = new ServiceProjectValidationError((IResource)file, ServiceProjectMarkerTypes.SERVICEINTERFACE_PROBLEM, errorMessage);
                        error.setAttribute(ServiceProjectMarkerAttributes.FIELD_PATH, errorField.getPath());
                        result.add(error);
                    }
                }
            }
        }
        catch (JAXBException | CoreException e) {
            ZCeeUILogger.error((String)e.getMessage(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Object[])new Object[0]);
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateRequestOrResponseFile", (Object[])new Object[]{result});
        return result;
    }

    private static ServiceProjectValidationError getMissingRequiredPropertyError(IResource resource, String key) {
        return new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"MISSING_REQUIRED_PROPERTY", (String[])new String[]{key}));
    }
}

