/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.cics.impl;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectValidationError;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.EclipseLogger;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.ProjectTreeFileHelper;
import com.ibm.zosconnect.ui.service.cics.CicsXlat;
import com.ibm.zosconnect.ui.service.cics.impl.CicsPropertiesValidator;
import com.ibm.zosconnect.ui.service.cics.natures.CicsChannelServiceProjectNature;
import com.ibm.zosconnect.ui.service.cics.natures.CicsCommareaServiceProjectNature;
import com.ibm.zosconnect.ui.service.controllers.AdvancedDataConversionOptionsController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceModelController;
import com.ibm.zosconnect.ui.service.dialogs.AdvancedDataConversionOptionsDialog;
import com.ibm.zosconnect.ui.service.dialogs.ServiceInterfaceSelectionDialog;
import com.ibm.zosconnect.ui.service.dialogs.ServiceProjectSIDialog;
import com.ibm.zosconnect.ui.service.interfaces.IServiceOverviewComposite;
import com.ibm.zosconnect.ui.service.interfaces.IServiceProjectEditor;
import com.ibm.zosconnect.wv.metadata.transaction.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CicsCompositeImpl
implements IServiceOverviewComposite {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String className = this.getClass().getName();
    private FormToolkit formToolkit;
    private Composite parent;
    private IServiceProjectEditor spe;
    private Text txtProgNameText;
    private Label lblDescription;
    private Button btnComposeSI;
    private Button btnImportSI;
    private Label lblRequestSI;
    private Button btnEditRequestSI;
    private Button btnEditResponseSI;
    private Combo comboRequestSI;
    private Combo comboResponseSI;
    private Label lblSetAdvancedOptions;
    private Button btnAdvancedOptions;

    public List<String> getCustomActions() {
        ArrayList<String> listOfActions = new ArrayList<String>();
        listOfActions.add(CicsXlat.label("SERVICEEDIT_ACTIONS_PROGRAM", new String[0]));
        listOfActions.add(CicsXlat.label("SERVICEEDIT_ACTIONS_SERVICE_INTERFACE", new String[0]));
        return listOfActions;
    }

    public LinkedHashMap<Composite, String> getComposites(FormToolkit formToolkit, Composite parent, IServiceProjectEditor serviceProjectEditor) {
        this.formToolkit = formToolkit;
        this.parent = parent;
        this.spe = serviceProjectEditor;
        LinkedHashMap<Composite, String> listOfComposites = new LinkedHashMap<Composite, String>();
        listOfComposites.put(this.getProgramSectionComposite(), CicsXlat.label("CICS_EXECUTABLE_NAME", new String[0]));
        listOfComposites.put(this.getDefineReqRespServiceInterfaceComposite(), Xlat.label((String)"SERVICEEDIT_SECTION_SERVICEINTERFACE"));
        return listOfComposites;
    }

    private Composite getProgramSectionComposite() {
        ZCeeUILogger.entering((String)this.className, (String)"getProgramSectionComposite", (Object[])new Object[0]);
        Composite composite = this.formToolkit.createComposite(this.parent, 0);
        this.formToolkit.paintBordersFor(composite);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.formToolkit.createLabel(composite, CicsXlat.label("CICS_EXECUTABLE_NAME", new String[0]) + Xlat.colon(), 0);
        this.txtProgNameText = this.formToolkit.createText(composite, "", 0);
        GridData gd_txtProgNameText = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtProgNameText.widthHint = XSwt.getAverageCharWidth((Control)this.txtProgNameText) * 50;
        gd_txtProgNameText.horizontalIndent = 5;
        this.txtProgNameText.setLayoutData((Object)gd_txtProgNameText);
        this.txtProgNameText.setTextLimit(8);
        this.txtProgNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String key = "Program";
                CicsCompositeImpl.this.spe.getServiceProjectController().getServiceModel().setValue("executableName", CicsCompositeImpl.this.txtProgNameText.getText());
                List<ServiceProjectValidationError> errorValidation = new CicsPropertiesValidator().validateDefinitionProperty(CicsCompositeImpl.this.spe.getServiceProjectController().getServiceModel().getResource(), "executableName", CicsCompositeImpl.this.txtProgNameText.getText());
                if (errorValidation != null && !errorValidation.isEmpty()) {
                    CicsCompositeImpl.this.spe.getServiceProjectValidator().setControlToError(CicsCompositeImpl.this.spe.getMessageManager(), key, errorValidation.get(0), (Control)CicsCompositeImpl.this.txtProgNameText);
                } else {
                    CicsCompositeImpl.this.spe.getServiceProjectValidator().resetControlToError(CicsCompositeImpl.this.spe.getMessageManager(), key, (Control)CicsCompositeImpl.this.txtProgNameText);
                }
                CicsCompositeImpl.this.spe.setDirty(true);
            }
        });
        ZCeeUILogger.exiting((String)this.className, (String)"getProgramSectionComposite", (Object[])new Object[]{composite});
        return composite;
    }

    private Composite getDefineReqRespServiceInterfaceComposite() {
        ZCeeUILogger.entering((String)this.className, (String)"getDefineReqRespServiceInterfaceComposite", (Object[])new Object[0]);
        Composite composite = this.formToolkit.createComposite(this.parent, 0);
        this.formToolkit.paintBordersFor(composite);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.lblDescription = this.formToolkit.createLabel(composite, Xlat.label((String)"SERVICEEDIT_SERVICEINTERFACE_DESCRIPTION"), 0);
        this.lblDescription.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.btnComposeSI = new Button(composite, 0);
        this.formToolkit.adapt((Control)this.btnComposeSI, true, true);
        this.btnComposeSI.setText(Xlat.label((String)"SERVICEEDIT_BUTTON_COMPOSEDATASET"));
        this.btnComposeSI.setToolTipText(Xlat.label((String)"SERVICEEDIT_BUTTON_COMPOSEDATASET_TOOLTIP"));
        this.btnComposeSI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ServiceProjectSIDialog dialog = new ServiceProjectSIDialog(null);
                    if (dialog.open() == 0) {
                        String siName = dialog.getSiName();
                        if (siName == null || siName.isEmpty()) {
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Xlat.label((String)"CREATE_SI_ERROR_TITLE"), (String)Xlat.error((String)"NULL_NAME_SI_ERROR"));
                        } else if (CicsCompositeImpl.this.getSiFileNameList().contains(siName + ".si")) {
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Xlat.label((String)"CREATE_SI_ERROR_TITLE"), (String)Xlat.error((String)"DUPLICATE_SI_ERROR", (String[])new String[]{siName + ".si"}));
                        } else {
                            Message initialMsg = null;
                            if (CicsChannelServiceProjectNature.hasNature(CicsCompositeImpl.this.spe.getProject())) {
                                initialMsg = ProjectTreeFileHelper.createNewChannelProgramInterface((String)siName, (String)"");
                            } else if (CicsCommareaServiceProjectNature.hasNature(CicsCompositeImpl.this.spe.getProject())) {
                                initialMsg = ProjectTreeFileHelper.createNewCommareaProgramInterface((String)siName, (String)"");
                            }
                            IFile newPgmInterfaceFile = ProjectTreeFileHelper.marshallzCEEServiceInterfaceMsg((String)CicsCompositeImpl.this.spe.getProjectName(), (Message)initialMsg, (String)siName);
                            CicsCompositeImpl.this.spe.launchPgmInterfaceEditor(newPgmInterfaceFile);
                        }
                    }
                }
                catch (Exception exception) {
                    EclipseLogger.logError((Throwable)exception);
                }
            }
        });
        this.btnImportSI = new Button(composite, 0);
        this.btnImportSI.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.formToolkit.adapt((Control)this.btnImportSI, true, true);
        this.btnImportSI.setText(Xlat.label((String)"SERVICEEDIT_BUTTON_IMPORTDATASET"));
        this.btnImportSI.setToolTipText(Xlat.label((String)"SERVICEEDIT_BUTTON_IMPORTDATASET_TOOLTIP"));
        this.btnImportSI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    CicsCompositeImpl.this.serviceInterfaceSelection();
                }
                catch (Exception exception) {
                    EclipseLogger.logError((Throwable)exception);
                }
            }
        });
        this.lblRequestSI = this.formToolkit.createLabel(composite, Xlat.label((String)"SERVICEEDIT_LABEL_REQUESTSI") + Xlat.colon(), 0);
        GridData gd_lblRequestSI = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblRequestSI.widthHint = 200;
        this.lblRequestSI.setLayoutData((Object)gd_lblRequestSI);
        this.comboRequestSI = new Combo(composite, 8);
        this.updateComboOptions(this.comboRequestSI, true);
        GridData gd_req = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_req.widthHint = 400;
        this.comboRequestSI.setLayoutData((Object)gd_req);
        this.formToolkit.adapt((Composite)this.comboRequestSI);
        this.formToolkit.paintBordersFor((Composite)this.comboRequestSI);
        List<ServiceProjectValidationError> validationErrors = new CicsPropertiesValidator().validateRequest(this.spe.getServiceProjectController().getServiceModel().getResource(), this.comboRequestSI.getText());
        String key = "requestSIName";
        if (validationErrors != null && !validationErrors.isEmpty()) {
            ServiceProjectValidationError firstError = validationErrors.get(0);
            this.spe.getServiceProjectValidator().setControlToError(this.spe.getMessageManager(), key, firstError, (Control)this.comboRequestSI);
        } else {
            this.spe.getServiceProjectValidator().resetControlToError(this.spe.getMessageManager(), key, (Control)this.comboRequestSI);
        }
        this.comboRequestSI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!CicsCompositeImpl.this.spe.isLoading()) {
                    CicsCompositeImpl.this.validateRequestCombo();
                }
            }
        });
        this.btnEditRequestSI = new Button(composite, 0);
        this.btnEditRequestSI.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.formToolkit.adapt((Control)this.btnEditRequestSI, true, true);
        this.btnEditRequestSI.setText(Xlat.label((String)"SERVICEEDIT_BUTTON_EDIT"));
        this.btnEditRequestSI.setToolTipText(Xlat.label((String)"SERVICEEDIT_BUTTON_EDIT_TOOLTIP"));
        this.btnEditRequestSI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String siName = CicsCompositeImpl.this.comboRequestSI.getText();
                if (siName != null && !siName.isEmpty() && CicsCompositeImpl.this.getSiFileNameList().contains(siName)) {
                    try {
                        IFile newPgmInterfaceFile = ProjectTreeFileHelper.getzCEEProgramMsgFile((String)CicsCompositeImpl.this.spe.getProjectName(), (String)siName);
                        CicsCompositeImpl.this.spe.launchPgmInterfaceEditor(newPgmInterfaceFile);
                    }
                    catch (Exception e1) {
                        ZCeeUILogger.error((Throwable)e1);
                        ZCeeErrorDialog.openError((Exception)e1);
                    }
                }
            }
        });
        this.formToolkit.createLabel(composite, Xlat.label((String)"SERVICEEDIT_LABEL_RESPONSESI") + Xlat.colon(), 0);
        this.comboResponseSI = new Combo(composite, 8);
        this.updateComboOptions(this.comboResponseSI, false);
        GridData gd_resp = new GridData(0, 0x1000000, false, false, 1, 1);
        gd_resp.widthHint = 400;
        this.comboResponseSI.setLayoutData((Object)gd_resp);
        this.formToolkit.adapt((Composite)this.comboResponseSI);
        this.formToolkit.paintBordersFor((Composite)this.comboResponseSI);
        List<ServiceProjectValidationError> validationErrorsResp = new CicsPropertiesValidator().validateResponse(this.spe.getServiceProjectController().getServiceModel().getResource(), this.comboResponseSI.getText());
        String keyresp = "responseSIName";
        if (validationErrorsResp != null && !validationErrorsResp.isEmpty()) {
            ServiceProjectValidationError firstErrorResp = validationErrorsResp.get(0);
            this.spe.getServiceProjectValidator().setControlToError(this.spe.getMessageManager(), keyresp, firstErrorResp, (Control)this.comboResponseSI);
        } else {
            this.spe.getServiceProjectValidator().resetControlToError(this.spe.getMessageManager(), keyresp, (Control)this.comboResponseSI);
        }
        this.comboResponseSI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!CicsCompositeImpl.this.spe.isLoading()) {
                    CicsCompositeImpl.this.validateResponseCombo();
                }
            }
        });
        this.btnEditResponseSI = new Button(composite, 0);
        this.btnEditResponseSI.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.formToolkit.adapt((Control)this.btnEditResponseSI, true, true);
        this.btnEditResponseSI.setText(Xlat.label((String)"SERVICEEDIT_BUTTON_EDIT"));
        this.btnEditResponseSI.setToolTipText(Xlat.label((String)"SERVICEEDIT_BUTTON_EDIT_TOOLTIP"));
        this.lblSetAdvancedOptions = new Label(composite, 0);
        this.formToolkit.adapt((Control)this.lblSetAdvancedOptions, true, true);
        this.lblSetAdvancedOptions.setText(Xlat.label((String)"SERVICEEDIT_LABEL_ADVANCED_OPTIONS"));
        this.btnAdvancedOptions = new Button(composite, 0);
        this.btnAdvancedOptions.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.formToolkit.adapt((Control)this.btnAdvancedOptions, true, true);
        this.btnAdvancedOptions.setText(Xlat.label((String)"SERVICEEDIT_BUTTON_ADVANCED_OPTIONS"));
        this.btnAdvancedOptions.setToolTipText(Xlat.label((String)"SERVICEEDIT_BUTTON_ADVANCED_OPTIONS_TOOLTIP"));
        this.btnAdvancedOptions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    AdvancedDataConversionOptionsController selectAdvMobDataConvOpController = new AdvancedDataConversionOptionsController(CicsCompositeImpl.this.spe.getServiceProjectController().getServiceModel());
                    selectAdvMobDataConvOpController.saveAdvancedOptions();
                    Shell activeShell = Display.getDefault().getActiveShell();
                    AdvancedDataConversionOptionsDialog selAdvDialog = new AdvancedDataConversionOptionsDialog(activeShell, selectAdvMobDataConvOpController);
                    int result = selAdvDialog.open();
                    if (result == 0) {
                        CicsCompositeImpl.this.spe.setDirty(true);
                    }
                    if (result == 1) {
                        selectAdvMobDataConvOpController.restoreAdvancedOptions();
                    }
                }
                catch (Exception e1) {
                    ZCeeUILogger.error((Throwable)e1);
                    ZCeeErrorDialog.openError((Exception)e1);
                }
            }
        });
        composite.setTabList(new Control[]{this.btnComposeSI, this.btnImportSI, this.comboRequestSI, this.btnEditRequestSI, this.comboResponseSI, this.btnEditResponseSI, this.btnAdvancedOptions});
        this.btnEditResponseSI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String siName = CicsCompositeImpl.this.comboResponseSI.getText();
                if (siName != null && !siName.isEmpty() && CicsCompositeImpl.this.getSiFileNameList().contains(siName)) {
                    try {
                        IFile newPgmInterfaceFile = ProjectTreeFileHelper.getzCEEProgramMsgFile((String)CicsCompositeImpl.this.spe.getProjectName(), (String)siName);
                        CicsCompositeImpl.this.spe.launchPgmInterfaceEditor(newPgmInterfaceFile);
                    }
                    catch (Exception e1) {
                        ZCeeUILogger.error((Throwable)e1);
                        ZCeeErrorDialog.openError((Exception)e1);
                    }
                }
            }
        });
        ZCeeUILogger.exiting((String)this.className, (String)"getDefineReqRespServiceInterfaceComposite", (Object[])new Object[]{composite});
        return composite;
    }

    public void refreshPage(Properties properties) {
        ZCeeUILogger.entering((String)this.className, (String)"refreshPage", (Object[])new Object[0]);
        for (Object keyObj : properties.keySet()) {
            String key;
            switch (key = (String)keyObj) {
                case "executableName": {
                    this.txtProgNameText.setText(properties.getProperty(key));
                    break;
                }
                case "responseSIName": {
                    this.updateComboOptions(this.comboResponseSI, false);
                    this.validateResponseCombo();
                    break;
                }
                case "requestSIName": {
                    this.updateComboOptions(this.comboRequestSI, true);
                    this.validateRequestCombo();
                }
            }
        }
        ZCeeUILogger.exiting((String)this.className, (String)"refreshPage", (Object[])new Object[0]);
    }

    public List<String> getSiFileNameList() {
        ArrayList<String> fileNames = new ArrayList<String>();
        try {
            IResource[] iResourceArray = this.spe.getServiceProjectController().getFolder("service-interfaces").members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getFileExtension().equalsIgnoreCase("si")) {
                    fileNames.add(resource.getName());
                }
                ++n2;
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
        return fileNames;
    }

    private void serviceInterfaceSelection() {
        ServiceInterfaceSelectionDialog dialog = new ServiceInterfaceSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.spe.getServiceProjectController(), true);
        dialog.open();
    }

    private void updateComboOptions(Combo combo, boolean isRequestCombo) {
        ZCeeUILogger.entering((String)this.className, (String)"updateComboOptions", (Object[])new Object[]{combo, "isRequestCombo: " + isRequestCombo});
        combo.removeAll();
        for (String fileName : this.getSiFileNameList()) {
            combo.add(fileName);
        }
        IServiceModelController servModelCtrl = this.spe.getServiceProjectController().getServiceModel();
        if (isRequestCombo) {
            String modelRequestSIName = servModelCtrl.getServiceRequestSIName();
            List<String> comboRequestItems = Arrays.asList(this.comboRequestSI.getItems());
            if (modelRequestSIName != null && !modelRequestSIName.isEmpty() && comboRequestItems.contains(modelRequestSIName)) {
                this.comboRequestSI.setText(modelRequestSIName);
            } else if (!comboRequestItems.isEmpty()) {
                this.comboRequestSI.select(0);
            } else {
                this.comboRequestSI.clearSelection();
                this.comboRequestSI.setText("");
            }
            if (this.btnEditRequestSI != null) {
                String comboRequestSIName = this.comboRequestSI.getText();
                if (comboRequestSIName == null || comboRequestSIName.isEmpty()) {
                    this.btnEditRequestSI.setEnabled(false);
                    if (modelRequestSIName != null && !modelRequestSIName.isEmpty()) {
                        boolean tempLoading = this.spe.isLoading();
                        this.spe.setLoading(false);
                        this.spe.setDirty(true);
                        this.spe.setLoading(tempLoading);
                        servModelCtrl.setServiceRequestSIName("");
                    }
                } else {
                    this.btnEditRequestSI.setEnabled(true);
                }
            }
        } else {
            String modelResponseSIName = servModelCtrl.getServiceResponseSIName();
            List<String> comboResponseItems = Arrays.asList(this.comboResponseSI.getItems());
            if (modelResponseSIName != null && !modelResponseSIName.isEmpty() && comboResponseItems.contains(modelResponseSIName)) {
                this.comboResponseSI.setText(modelResponseSIName);
            } else if (!comboResponseItems.isEmpty()) {
                this.comboResponseSI.select(0);
            } else {
                this.comboResponseSI.clearSelection();
                this.comboResponseSI.setText("");
            }
            if (this.btnEditResponseSI != null) {
                String comboResponseSIName = this.comboResponseSI.getText();
                if (comboResponseSIName == null || comboResponseSIName.isEmpty()) {
                    this.btnEditResponseSI.setEnabled(false);
                    if (modelResponseSIName != null && !modelResponseSIName.isEmpty()) {
                        boolean tempLoading = this.spe.isLoading();
                        this.spe.setLoading(false);
                        this.spe.setDirty(true);
                        this.spe.setLoading(tempLoading);
                        servModelCtrl.setServiceResponseSIName("");
                    }
                } else {
                    this.btnEditResponseSI.setEnabled(true);
                }
            }
        }
        ZCeeUILogger.exiting((String)this.className, (String)"updateComboOptions", (Object[])new Object[0]);
    }

    private void validateRequestCombo() {
        List<ServiceProjectValidationError> validationErrors;
        ZCeeUILogger.entering((String)this.className, (String)"validateRequestCombo", (Object[])new Object[0]);
        if (this.comboRequestSI.getSelectionIndex() != -1 && !this.spe.getServiceProjectController().getServiceModel().getServiceRequestSIName().equals(this.comboRequestSI.getItem(this.comboRequestSI.getSelectionIndex()))) {
            this.spe.getServiceProjectController().getServiceModel().setServiceRequestSIName(this.comboRequestSI.getItem(this.comboRequestSI.getSelectionIndex()));
            boolean tempLoading = this.spe.isLoading();
            this.spe.setLoading(false);
            this.spe.setDirty(true);
            this.spe.setLoading(tempLoading);
        }
        if ((validationErrors = new CicsPropertiesValidator().validateRequest(this.spe.getServiceProjectController().getServiceModel().getResource(), this.comboRequestSI.getText())) != null && !validationErrors.isEmpty()) {
            ServiceProjectValidationError firstError = validationErrors.get(0);
            this.spe.getServiceProjectValidator().setControlToError(this.spe.getMessageManager(), "requestSIName", firstError, (Control)this.comboRequestSI);
        } else {
            this.spe.getServiceProjectValidator().resetControlToError(this.spe.getMessageManager(), "requestSIName", (Control)this.comboRequestSI);
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateRequestCombo", (Object[])new Object[0]);
    }

    private void validateResponseCombo() {
        List<ServiceProjectValidationError> validationErrorsResp;
        ZCeeUILogger.entering((String)this.className, (String)"validateResponseCombo", (Object[])new Object[0]);
        if (this.comboResponseSI.getSelectionIndex() != -1 && !this.spe.getServiceProjectController().getServiceModel().getServiceResponseSIName().equals(this.comboResponseSI.getItem(this.comboResponseSI.getSelectionIndex()))) {
            this.spe.getServiceProjectController().getServiceModel().setServiceResponseSIName(this.comboResponseSI.getItem(this.comboResponseSI.getSelectionIndex()));
            boolean tempLoading = this.spe.isLoading();
            this.spe.setLoading(false);
            this.spe.setDirty(true);
            this.spe.setLoading(tempLoading);
        }
        if ((validationErrorsResp = new CicsPropertiesValidator().validateResponse(this.spe.getServiceProjectController().getServiceModel().getResource(), this.comboResponseSI.getText())) != null && !validationErrorsResp.isEmpty()) {
            ServiceProjectValidationError firstError = validationErrorsResp.get(0);
            if (firstError.getSeverity().equals(1)) {
                this.spe.getServiceProjectValidator().setControlToWarning(this.spe.getMessageManager(), "responseSIName", firstError, (Control)this.comboResponseSI);
            } else {
                this.spe.getServiceProjectValidator().setControlToError(this.spe.getMessageManager(), "responseSIName", firstError, (Control)this.comboResponseSI);
            }
        } else {
            this.spe.getServiceProjectValidator().resetControlToError(this.spe.getMessageManager(), "responseSIName", (Control)this.comboResponseSI);
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateResponseCombo", (Object[])new Object[0]);
    }
}

