/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.validation;

import com.ibm.cics.common.util.Debug;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class ValidationUtil {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ValidationUtil.class);

    protected ValidationUtil() {
    }

    private static IMarker createMarker(String markerType, IResource resource, String message, int severity) throws CoreException {
        IMarker marker = resource.createMarker(markerType);
        marker.setAttribute("severity", severity);
        marker.setAttribute("org.eclipse.core.resources.problemmarker", true);
        marker.setAttribute("message", (Object)message);
        return marker;
    }

    public static IMarker createMarker(String markerType, IResource resource, String message, Integer lineNumber, Integer colNumber, int severity) throws CoreException {
        IMarker marker = ValidationUtil.createMarker(markerType, resource, message, severity);
        if (resource instanceof IFile && lineNumber != null) {
            marker.setAttribute("lineNumber", (Object)lineNumber);
            if (colNumber != null) {
                try {
                    marker.setAttribute("charStart", ValidationUtil.convertLineAndColumnNumberToCharacter((IFile)resource, lineNumber, colNumber));
                }
                catch (BadLocationException e) {
                    debug.event("createSevereError", (Object)e, (Object)lineNumber);
                }
            }
        }
        return marker;
    }

    public static IMarker createMarker(String markerType, IResource resource, String message, Integer lineNumber, Integer colNumber, int severity, Map<String, String> attributes) throws CoreException {
        IMarker marker = ValidationUtil.createMarker(markerType, resource, message, lineNumber, colNumber, severity);
        if (attributes != null && !attributes.isEmpty()) {
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                marker.setAttribute(attribute.getKey(), (Object)attribute.getValue());
            }
        }
        return marker;
    }

    private static int convertLineAndColumnNumberToCharacter(IFile file, int lineNumber, int columnNumber) throws BadLocationException, CoreException {
        try {
            ITextFileBuffer fileBuffer;
            FileBuffers.getTextFileBufferManager().connect(file.getFullPath(), LocationKind.IFILE, null);
            ITextFileBufferManager fileBufferManager = FileBuffers.createTextFileBufferManager();
            if (fileBufferManager != null && (fileBuffer = fileBufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE)) != null) {
                IDocument document = fileBuffer.getDocument();
                int lineOffset = document.getLineOffset(lineNumber - 1);
                int n = lineOffset + columnNumber;
                return n;
            }
            throw new BadLocationException();
        }
        finally {
            FileBuffers.getTextFileBufferManager().disconnect(file.getFullPath(), LocationKind.IFILE, null);
        }
    }
}

