/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.validation;

import com.ibm.zosconnect.ui.common.util.MapUtilz;
import com.ibm.zosconnect.ui.common.util.WorkspaceUtil;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectMarkerAttributes;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectMarkerTypes;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IResource;

public class ServiceProjectValidationError {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String markerType;
    private String message;
    private Integer lineNumber;
    private Integer columnNumber;
    private Integer severity;
    private IResource resource;
    private Map<String, String> attributes;

    public ServiceProjectValidationError(IResource resource, String markerType, String message, Integer lineNumber, Integer columnNumber) {
        this(resource, markerType, message, lineNumber, columnNumber, 2);
    }

    public ServiceProjectValidationError(IResource resource, String markerType, String message, Integer lineNumber, Integer columnNumber, Integer severity) {
        this.resource = resource;
        this.markerType = markerType;
        this.message = message;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.severity = severity;
        this.attributes = new HashMap<String, String>();
    }

    public ServiceProjectValidationError(IResource resource, String errorType, String message) {
        this(resource, errorType, message, null, null, 2);
    }

    public ServiceProjectValidationError(IResource resource, ServiceProjectMarkerTypes marker, String message) {
        this(resource, marker.toString(), message, null, null, 2);
    }

    public String getMarkerType() {
        return this.markerType;
    }

    public String getMessage() {
        return this.message;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Integer getColumnNumber() {
        return this.columnNumber;
    }

    public IResource getResource() {
        return this.resource;
    }

    public Integer getSeverity() {
        return this.severity;
    }

    public void setAttribute(ServiceProjectMarkerAttributes attribute, String value) {
        this.attributes.put(attribute.toString(), value);
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setMarkerType(String markerType) {
        this.markerType = markerType;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setColumnNumber(Integer columnNumber) {
        this.columnNumber = columnNumber;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public void setSeverity(Integer severity) {
        this.severity = severity;
    }

    public String toString() {
        return this.message;
    }

    public String getBareMessage() {
        return this.message;
    }

    public boolean equals(Object other) {
        ServiceProjectValidationError otherError;
        boolean equals = false;
        equals = other instanceof ServiceProjectValidationError ? StringUtils.equals((CharSequence)this.markerType, (CharSequence)(otherError = (ServiceProjectValidationError)other).getMarkerType()) && StringUtils.equals((CharSequence)this.message, (CharSequence)otherError.getMessage()) && WorkspaceUtil.equals(this.resource, otherError.getResource()) && ObjectUtils.compare((Comparable)this.lineNumber, (Comparable)otherError.getLineNumber()) == 0 && ObjectUtils.compare((Comparable)this.columnNumber, (Comparable)otherError.getColumnNumber()) == 0 && ObjectUtils.compare((Comparable)this.severity, (Comparable)otherError.getSeverity()) == 0 && MapUtilz.equals(this.attributes, otherError.getAttributes()) : super.equals(other);
        return equals;
    }
}

