/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.validation;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.Xlat;
import java.io.IOException;
import java.io.StringReader;

public class PosixPortableValidator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String DOUBLE_SPACE = "  ";
    private static final String SPACE = " ";

    public static String validate(String filename, MessageInsertType type) {
        String messageTypeInsert = type == MessageInsertType.API ? Xlat.error("API_NAME_INSERT") : (type == MessageInsertType.SERVICE ? Xlat.error("SERVICE_NAME_INSERT") : Xlat.error("FILE_NAME_INSERT"));
        if (filename.isEmpty()) {
            return Xlat.error("MUST_CONTAIN_1_CHARACTER", messageTypeInsert);
        }
        if (filename.length() > 255) {
            return Xlat.error("MUST_BE_LESS_THAN_CHARACTERS", messageTypeInsert, "256");
        }
        if (filename.startsWith(SPACE)) {
            return Xlat.error("MAY_NOT_START_WITH_SPACE", messageTypeInsert);
        }
        if (filename.endsWith(SPACE)) {
            return Xlat.error("MAY_NOT_END_WITH_SPACE", messageTypeInsert);
        }
        if (filename.contains(DOUBLE_SPACE)) {
            return Xlat.error("MAY_ONLY_HAVE_SINGLE_SPACES", messageTypeInsert);
        }
        StringReader reader = new StringReader(filename);
        try {
            int character = reader.read();
            while (character != -1) {
                if (character >= 65 & character <= 90 || character >= 97 & character <= 122 || character >= 48 && character <= 57 || character == 46 || character == 95 || character == 45 || character == 32) {
                    character = reader.read();
                    continue;
                }
                String valueOf = String.valueOf((char)character);
                return Xlat.error("MUST_NOT_CONTAIN_CHARACTER", messageTypeInsert, valueOf);
            }
        }
        catch (IOException e) {
            ZCeeUILogger.error("PosixPortableValidator.validate", e, new Object[0]);
        }
        return null;
    }

    public static enum MessageInsertType {
        API,
        SERVICE,
        FILE;

    }
}

