/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.validation;

import com.ibm.msl.mapping.Mapping;
import com.ibm.msl.mapping.util.MappingResourceImpl;
import com.ibm.msl.mapping.validators.MappingValidationProblem;
import com.ibm.zosconnect.ui.common.util.ArrayUtilz;
import com.ibm.zosconnect.ui.common.util.URIUtilz;
import com.ibm.zosconnect.ui.common.validation.MappingProblemTypes;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class MappingValidationProblem2
extends MappingValidationProblem {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String path;
    private String method;
    private String operationId;
    private String service;
    private MappingProblemTypes type;
    private String fileTypeString;
    private IPath mappingFileLocation;

    public MappingValidationProblem2(int severity, String message, MappingProblemTypes type) {
        super(severity, 0, message, null);
        this.type = type;
    }

    public MappingValidationProblem2(int severity, String message, MappingProblemTypes type, String fileType) {
        super(severity, 0, message, null);
        this.type = type;
        this.fileTypeString = fileType;
    }

    public MappingValidationProblem2(int severity, String message, MappingProblemTypes type, IPath mappingFileLocation, String fileType) {
        super(severity, 0, message, null);
        this.type = type;
        this.mappingFileLocation = mappingFileLocation;
        this.fileTypeString = fileType;
    }

    public MappingValidationProblem2(int severity, String message, MappingProblemTypes type, EObject eObject, IPath mappingFileLocation, String fileType) {
        super(severity, 0, message, eObject);
        this.type = type;
        this.mappingFileLocation = mappingFileLocation;
        this.fileTypeString = fileType;
    }

    public MappingValidationProblem2(int severity, String message, MappingProblemTypes type, IPath mappingFileLocation) {
        super(severity, 0, message, null);
        this.type = type;
        this.mappingFileLocation = mappingFileLocation;
    }

    public MappingValidationProblem2(int severity, String message, MappingProblemTypes type, EObject eObject, IPath mappingFileLocation) {
        super(severity, 0, message, eObject);
        this.type = type;
        this.mappingFileLocation = mappingFileLocation;
    }

    public MappingValidationProblem2(int severity, int category, String message, MappingProblemTypes type, EObject eObject) {
        super(severity, category, message, eObject);
        this.type = type;
    }

    public String getFileTypeString() {
        return this.fileTypeString;
    }

    public void setFileTypeString(String fileType) {
        this.fileTypeString = fileType;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String opid) {
        this.operationId = opid;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public MappingProblemTypes getType() {
        return this.type;
    }

    public void setType(MappingProblemTypes type) {
        this.type = type;
    }

    public IPath getResourceLocation() {
        return this.mappingFileLocation;
    }

    public void setResourceLocation(IPath mappingFileLocation) {
        this.mappingFileLocation = mappingFileLocation;
    }

    public String getProblemID() {
        return super.getProblemID();
    }

    public int getSeverity() {
        return super.getSeverity();
    }

    public int getCategory() {
        return super.getCategory();
    }

    public String getMessage() {
        return super.getMessage();
    }

    public EObject getObject() {
        return super.getObject();
    }

    public IResource getMappingFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(this.mappingFileLocation);
    }

    public void createMarker() throws CoreException {
        String objectUri;
        Integer lineNumber;
        IMarker marker;
        IMarker[] markers;
        IResource mappingFile = this.getMappingFile();
        if (mappingFile == null || !mappingFile.exists()) {
            return;
        }
        IMarker[] iMarkerArray = markers = mappingFile.findMarkers("com.ibm.msl.mapping.mappingProblem", true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            marker = iMarkerArray[n2];
            if (marker.exists() && StringUtils.equals((CharSequence)this.getMessage(), (CharSequence)MappingValidationProblem2.getMessage(marker))) {
                return;
            }
            ++n2;
        }
        marker = mappingFile.createMarker("com.ibm.msl.mapping.mappingProblem");
        marker.setAttribute("severity", this.getSeverity());
        String message = StringUtils.trimToEmpty((String)this.getMessage());
        if (!message.isEmpty()) {
            marker.setAttribute("message", (Object)message);
        }
        if ((lineNumber = this.getLineNumber()) != null) {
            marker.setAttribute("lineNumber", (Object)lineNumber);
        }
        if (!(objectUri = StringUtils.trimToEmpty((String)this.getObjectUri())).isEmpty()) {
            marker.setAttribute("objectId", (Object)objectUri);
        }
    }

    public static String getMessage(IMarker marker) {
        return marker.getAttribute("message", "");
    }

    public static Integer getSeverity(IMarker marker) {
        return marker.getAttribute("severity", -1);
    }

    public static void deleteFileMarkers(IPath mappingFileLocation) throws CoreException {
        IFile mappingFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(mappingFileLocation);
        if (mappingFile == null || !mappingFile.exists()) {
            return;
        }
        mappingFile.deleteMarkers("com.ibm.msl.mapping.mappingProblem", true, 2);
    }

    public static void deleteFileMarkers(IPath mappingFileLocation, Mapping mapping) throws CoreException {
        IFile mappingFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(mappingFileLocation);
        if (mappingFile == null || !mappingFile.exists()) {
            return;
        }
        IMarker[] markers = mappingFile.findMarkers("com.ibm.msl.mapping.mappingProblem", true, 2);
        if (ArrayUtilz.notEmpty(markers)) {
            String mappingObjectUri = URIUtilz.getEObjectURI((EObject)mapping);
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                String markerObjectUri = marker.getAttribute("objectId", "");
                if (StringUtils.equals((CharSequence)mappingObjectUri, (CharSequence)markerObjectUri)) {
                    marker.delete();
                }
                ++n2;
            }
        }
    }

    public String getObjectUri() {
        String retVal = null;
        EObject eObject = super.getObject();
        if (eObject != null) {
            retVal = URIUtilz.getEObjectURI(eObject);
        }
        return retVal;
    }

    public Integer getLineNumber() {
        Resource res;
        Integer retVal = null;
        EObject eObject = super.getObject();
        if (eObject != null && (res = eObject.eResource()) instanceof MappingResourceImpl) {
            retVal = ((MappingResourceImpl)res).getLineNumber(eObject);
        }
        return retVal;
    }

    public static boolean hasErrorMarkers(IFile mappingFile) throws CoreException {
        IMarker[] markers;
        if (mappingFile == null || !mappingFile.exists()) {
            return false;
        }
        IMarker[] iMarkerArray = markers = mappingFile.findMarkers("com.ibm.msl.mapping.mappingProblem", true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker.exists() && MappingValidationProblem2.getSeverity(marker).equals(2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

