/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.validation;

import com.ibm.zosconnect.ui.common.validation.MappingProblemTypes;
import com.ibm.zosconnect.ui.common.validation.MappingValidationProblem2;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class ApiResponseValidationProblem
extends MappingValidationProblem2 {
    private Integer responseCode;

    public ApiResponseValidationProblem(int severity, String message, MappingProblemTypes type, IPath packageXmlFile, String fileType, String operationId, Integer responseCode) {
        super(severity, message, type, packageXmlFile, fileType);
        this.setOperationId(operationId);
        this.setResponseCode(responseCode);
    }

    @Override
    public void createMarker() throws CoreException {
        Integer responseCode;
        String operationId;
        IMarker marker;
        IMarker[] markers;
        IResource packageXmlFile = this.getMappingFile();
        if (packageXmlFile == null || !packageXmlFile.exists()) {
            return;
        }
        IMarker[] iMarkerArray = markers = packageXmlFile.findMarkers("com.ibm.zosconnect.ui.apiResponseProblemType", true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            marker = iMarkerArray[n2];
            if (marker.exists() && StringUtils.equals((CharSequence)this.getMessage(), (CharSequence)ApiResponseValidationProblem.getMessage(marker)) && StringUtils.equals((CharSequence)this.getOperationId(), (CharSequence)ApiResponseValidationProblem.getOperationId(marker)) && this.getResponseCode().equals(ApiResponseValidationProblem.getResponseCode(marker))) {
                return;
            }
            ++n2;
        }
        marker = packageXmlFile.createMarker("com.ibm.zosconnect.ui.apiResponseProblemType");
        marker.setAttribute("severity", this.getSeverity());
        String message = StringUtils.trimToEmpty((String)this.getMessage());
        if (!message.isEmpty()) {
            marker.setAttribute("message", (Object)message);
        }
        if (!(operationId = StringUtils.trimToEmpty((String)this.getOperationId())).isEmpty()) {
            marker.setAttribute("operationId", (Object)operationId);
        }
        if ((responseCode = this.getResponseCode()) != null) {
            marker.setAttribute("responseCode", (Object)responseCode);
        }
        if (!operationId.isEmpty() && responseCode != null) {
            marker.setAttribute("location", (Object)(operationId + ":" + String.valueOf(responseCode)));
        }
    }

    public static void deleteFileMarkers(IFile packageXmlFile) throws CoreException {
        IMarker[] markers;
        if (packageXmlFile == null || !packageXmlFile.exists()) {
            return;
        }
        IMarker[] iMarkerArray = markers = packageXmlFile.findMarkers("com.ibm.zosconnect.ui.apiResponseProblemType", true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker.exists()) {
                marker.delete();
            }
            ++n2;
        }
    }

    public static boolean hasErrorMarkers(IFile packageXmlFile, String operationId, Integer responseCode) throws CoreException {
        if (packageXmlFile != null && packageXmlFile.exists()) {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = packageXmlFile.findMarkers("com.ibm.zosconnect.ui.apiResponseProblemType", true, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (marker.exists() && ApiResponseValidationProblem.getSeverity(marker).equals(2) && ApiResponseValidationProblem.getOperationId(marker).equals(operationId) && ApiResponseValidationProblem.getResponseCode(marker).equals(responseCode)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isType(IMarker marker) throws CoreException {
        return "com.ibm.zosconnect.ui.apiResponseProblemType".equals(marker.getType());
    }

    public static String getOperationId(IMarker marker) {
        return marker.getAttribute("operationId", "");
    }

    public static Integer getResponseCode(IMarker marker) {
        return marker.getAttribute("responseCode", -1);
    }

    public Integer getResponseCode() {
        if (this.responseCode == null) {
            return new Integer(-1);
        }
        return this.responseCode;
    }

    public void setResponseCode(Integer responseCode) {
        this.responseCode = responseCode;
    }
}

