/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.validation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;

public class ApiProjectValidationError {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String markerType;
    private String message;
    private Integer lineNumber;
    private Integer columnNumber;
    private Integer severity;
    private IResource resource;
    private Map<String, String> attributes;

    public ApiProjectValidationError(IResource resource, String markerType, String message, Integer lineNumber, Integer columnNumber) {
        this(resource, markerType, message, lineNumber, columnNumber, 2);
    }

    public ApiProjectValidationError(IResource resource, String markerType, String message, Integer lineNumber, Integer columnNumber, Integer severity) {
        this.resource = resource;
        this.markerType = markerType;
        this.message = message;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.severity = severity;
        this.attributes = new HashMap<String, String>();
    }

    public ApiProjectValidationError(IResource resource, String errorType, String message) {
        this(resource, errorType, message, null, null, 2);
    }

    public ApiProjectValidationError(IResource resource, String message) {
        this(resource, "com.ibm.zosconnect.service.ui.propertiesproblem", message, null, null, 2);
    }

    public ApiProjectValidationError(IResource resource, String message, boolean flag) {
        this(resource, "com.ibm.zosconnect.ui.capabilitiesproblem", message, null, null, 2);
    }

    public String getMarkerType() {
        return this.markerType;
    }

    public String getMessage() {
        return this.message;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Integer getColumnNumber() {
        return this.columnNumber;
    }

    public IResource getResource() {
        return this.resource;
    }

    public Integer getSeverity() {
        return this.severity;
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setMarkerType(String markerType) {
        this.markerType = markerType;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setColumnNumber(Integer columnNumber) {
        this.columnNumber = columnNumber;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public void setSeverity(Integer severity) {
        this.severity = severity;
    }

    public String toString() {
        return this.message;
    }

    public String getBareMessage() {
        return this.message;
    }
}

