/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.validation;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;

public class ApiDuplicatePathsProblem {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IFile packageXmlFile;
    private String path;
    private String message;
    private String projectName;

    public ApiDuplicatePathsProblem(String projectName, String path, String message, IFile packageXmlFile) {
        this.projectName = projectName;
        this.packageXmlFile = packageXmlFile;
        this.path = path;
        this.message = message;
    }

    public void createMarker() throws CoreException {
        IMarker marker;
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = this.packageXmlFile.findMarkers("com.ibm.zosconnect.ui.apiDuplicatePathsProblemType", true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            marker = iMarkerArray[n2];
            if (marker.exists() && StringUtils.equals((CharSequence)StringUtils.trimToEmpty((String)this.message), (CharSequence)ApiDuplicatePathsProblem.getMessage(marker)) && StringUtils.equals((CharSequence)this.path, (CharSequence)ApiDuplicatePathsProblem.getApiPath(marker)) && StringUtils.equals((CharSequence)this.projectName, (CharSequence)ApiDuplicatePathsProblem.getProjectName(marker))) {
                return;
            }
            ++n2;
        }
        marker = this.packageXmlFile.createMarker("com.ibm.zosconnect.ui.apiDuplicatePathsProblemType");
        marker.setAttribute("severity", 2);
        String msg = StringUtils.trimToEmpty((String)this.message);
        if (!msg.isEmpty()) {
            marker.setAttribute("message", (Object)msg);
        }
        marker.setAttribute("apiPath", (Object)this.path);
        marker.setAttribute("projectName", (Object)this.projectName);
    }

    public static void deleteFileMarkers(IFile packageXmlFile) throws CoreException {
        IMarker[] markers;
        if (packageXmlFile == null || !packageXmlFile.exists()) {
            return;
        }
        IMarker[] iMarkerArray = markers = packageXmlFile.findMarkers("com.ibm.zosconnect.ui.apiDuplicatePathsProblemType", true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker.exists()) {
                marker.delete();
            }
            ++n2;
        }
    }

    public static String getProjectName(IMarker marker) {
        return marker.getAttribute("projectName", "");
    }

    public static String getApiPath(IMarker marker) {
        return marker.getAttribute("apiPath", "");
    }

    public static String getMessage(IMarker marker) {
        return marker.getAttribute("message", "");
    }
}

