/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util.xsd.walker;

import com.ibm.zosconnect.ui.common.util.xsd.walker.ZosConnectXsdXmlQName;
import java.util.Stack;

public class ZosConnectXsdXmlXPath
implements Cloneable {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Stack<ZosConnectXsdXmlQName> segmentStack = new Stack();

    public ZosConnectXsdXmlXPath() {
    }

    private ZosConnectXsdXmlXPath(Stack<ZosConnectXsdXmlQName> segmentStack) {
        this.segmentStack = segmentStack;
    }

    public String getValue(boolean makeRoot, boolean makeQualified, boolean resolveNSPrefix) {
        StringBuffer result = new StringBuffer();
        if (makeRoot) {
            result.append("/");
        }
        int i = 0;
        while (i < this.segmentStack.size()) {
            ZosConnectXsdXmlQName segment = (ZosConnectXsdXmlQName)this.segmentStack.get(i);
            if (segment.isXmlAttribute()) {
                result.append("@");
            }
            if (makeQualified) {
                String qualifier = segment.getPrefix();
                if (qualifier == null || qualifier.isEmpty() || resolveNSPrefix) {
                    qualifier = segment.getNamespaceURI();
                }
                if (qualifier != null && !qualifier.isEmpty()) {
                    result.append(qualifier + ":");
                }
            }
            result.append(segment.getLocalPart());
            if (++i >= this.segmentStack.size()) continue;
            result.append("/");
        }
        return result.toString();
    }

    public void push(ZosConnectXsdXmlQName segment) {
        this.segmentStack.push(segment);
    }

    public ZosConnectXsdXmlQName pop() {
        return this.segmentStack.pop();
    }

    public ZosConnectXsdXmlQName peek() {
        return this.segmentStack.peek().clone();
    }

    public int getDepth() {
        return this.segmentStack.size();
    }

    public void purge() {
        this.segmentStack.clear();
    }

    public boolean isXmlAttribute() {
        boolean isXmlAttribute = false;
        if (!this.segmentStack.isEmpty()) {
            isXmlAttribute = this.segmentStack.peek().isXmlAttribute();
        }
        return isXmlAttribute;
    }

    public ZosConnectXsdXmlXPath clone() {
        Stack clone_1 = (Stack)this.segmentStack.clone();
        ZosConnectXsdXmlXPath clone_2 = new ZosConnectXsdXmlXPath(clone_1);
        return clone_2;
    }
}

