/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util.xsd.walker;

import com.ibm.zosconnect.ui.common.util.xsd.IZosConnectXsdSimpleTypes;
import com.ibm.zosconnect.ui.common.util.xsd.walker.IZosConnectXsdWalkerUtil;
import com.ibm.zosconnect.ui.common.util.xsd.walker.ZosConnectXsdXmlQName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDContentTypeCategory;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;

public class ZosConnectXsdWalkerUtil
implements IZosConnectXsdWalkerUtil {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static boolean isMemberSequence(XSDElementDeclaration xsdEle) {
        return ZosConnectXsdWalkerUtil.isModelGroupCompositorMember(xsdEle, 2);
    }

    public static boolean isMemberChoice(XSDElementDeclaration xsdEle) {
        return ZosConnectXsdWalkerUtil.isModelGroupCompositorMember(xsdEle, 1);
    }

    public static boolean isOfTypeAnyType(XSDElementDeclaration xsdEle) {
        boolean isAnyType = false;
        XSDTypeDefinition xsdType = xsdEle.getType();
        if (xsdType instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)xsdType;
            isAnyType = ZosConnectXsdWalkerUtil.isOfTypeAnyType((XSDTypeDefinition)complexType);
        }
        return isAnyType;
    }

    public static boolean isOfTypeAnyType(XSDTypeDefinition xsdType) {
        boolean isAnyType = false;
        String typeName = xsdType.getTargetNamespace() + ":" + xsdType.getName();
        if (typeName.equals(XSD_ANY_TYPE)) {
            isAnyType = true;
        }
        return isAnyType;
    }

    public static boolean isModelGroupCompositorMember(XSDElementDeclaration xsdEle, int compositorType) {
        XSDModelGroup xsdModGrp;
        XSDCompositor xsdComp;
        XSDParticle xsdPart;
        boolean isMember = false;
        if (xsdEle.eContainer() instanceof XSDParticle && (xsdPart = (XSDParticle)xsdEle.eContainer()).eContainer() instanceof XSDModelGroup && (xsdComp = (xsdModGrp = (XSDModelGroup)xsdPart.eContainer()).getCompositor()).getValue() == compositorType) {
            isMember = true;
        }
        return isMember;
    }

    public static boolean isMemberVariableOccurrenceModelGroup(XSDElementDeclaration xsdEle) {
        XSDParticle xsdEleModGrpPart;
        XSDModelGroup xsdEleModGrp;
        XSDParticle xsdElePart;
        boolean isMember = false;
        if (xsdEle.eContainer() instanceof XSDParticle && (xsdElePart = (XSDParticle)xsdEle.eContainer()).eContainer() instanceof XSDModelGroup && (xsdEleModGrp = (XSDModelGroup)xsdElePart.eContainer()).eContainer() instanceof XSDParticle && (xsdEleModGrpPart = (XSDParticle)xsdEleModGrp.eContainer()).getMinOccurs() != xsdEleModGrpPart.getMaxOccurs()) {
            isMember = true;
        }
        return isMember;
    }

    private static boolean haveSameType(XSDElementDeclaration left, XSDElementDeclaration right) {
        boolean haveSameType = false;
        XSDTypeDefinition leftType = left.getType();
        XSDTypeDefinition rightType = right.getType();
        if ((leftType instanceof XSDComplexTypeDefinition && rightType instanceof XSDComplexTypeDefinition || leftType instanceof XSDSimpleTypeDefinition && rightType instanceof XSDSimpleTypeDefinition) && ZosConnectXsdWalkerUtil.areSameType(leftType, rightType)) {
            haveSameType = true;
        }
        return haveSameType;
    }

    private static boolean areSameType(XSDTypeDefinition left, XSDTypeDefinition right) {
        boolean areSameType = false;
        String leftNmsp = UUID.randomUUID().toString();
        String leftName = UUID.randomUUID().toString();
        String rightNmsp = UUID.randomUUID().toString();
        String rightName = UUID.randomUUID().toString();
        if (left.getTargetNamespace() != null && !left.getTargetNamespace().isEmpty()) {
            leftNmsp = left.getTargetNamespace();
        }
        if (right.getTargetNamespace() != null && !right.getTargetNamespace().isEmpty()) {
            rightNmsp = right.getTargetNamespace();
        }
        if (left.getName() != null && !left.getName().isEmpty()) {
            leftName = left.getName();
        }
        if (right.getName() != null && !right.getName().isEmpty()) {
            rightName = right.getName();
        }
        if (leftNmsp.equals(rightNmsp) && leftName.equals(rightName)) {
            areSameType = true;
        }
        return areSameType;
    }

    public static boolean isContainedByElement(XSDElementDeclaration parentXsdEle, XSDElementDeclaration childXsdEle) {
        if (parentXsdEle.equals(childXsdEle)) {
            return false;
        }
        boolean isChild = false;
        if (parentXsdEle.getType() instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition parentType = (XSDComplexTypeDefinition)parentXsdEle.getType();
            List<XSDComplexTypeDefinition> complexTypes = ZosConnectXsdWalkerUtil.getAllComplexTypes(parentType);
            Iterator<XSDComplexTypeDefinition> complexIt = complexTypes.iterator();
            while (!isChild && complexIt.hasNext()) {
                XSDComplexTypeDefinition complexType = complexIt.next();
                TreeIterator complexTree = complexType.eAllContents();
                while (!isChild && complexTree.hasNext()) {
                    EObject treeObject = (EObject)complexTree.next();
                    if (!(treeObject instanceof XSDElementDeclaration)) continue;
                    XSDElementDeclaration treeXsdEle = (XSDElementDeclaration)treeObject;
                    if (treeXsdEle.isElementDeclarationReference()) {
                        treeXsdEle = treeXsdEle.getResolvedElementDeclaration();
                    }
                    if (!treeXsdEle.equals(childXsdEle)) continue;
                    isChild = true;
                }
            }
        }
        return isChild;
    }

    public static boolean hasAttributes(XSDElementDeclaration xsdEle) {
        boolean hasAttributes = false;
        XSDTypeDefinition xsdType = xsdEle.getType();
        if (!(xsdType instanceof XSDComplexTypeDefinition)) {
            return hasAttributes;
        }
        XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)xsdType;
        EList attUses = complexType.getAttributeUses();
        Iterator attIt = attUses.iterator();
        while (attIt.hasNext() && !hasAttributes) {
            XSDAttributeUse attUse = (XSDAttributeUse)attIt.next();
            if (attUse.getAttributeDeclaration() == null) continue;
            hasAttributes = true;
        }
        return hasAttributes;
    }

    public static ArrayList<XSDAttributeDeclaration> getAttributeDeclarations(XSDElementDeclaration xsdEle) {
        ArrayList<XSDAttributeDeclaration> atts = new ArrayList<XSDAttributeDeclaration>();
        XSDTypeDefinition xsdType = xsdEle.getType();
        if (!(xsdType instanceof XSDComplexTypeDefinition)) {
            return atts;
        }
        XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)xsdType;
        EList attUses = complexType.getAttributeUses();
        for (XSDAttributeUse attUse : attUses) {
            XSDAttributeDeclaration att = attUse.getAttributeDeclaration();
            if (att == null) continue;
            atts.add(att);
        }
        return atts;
    }

    public static ZosConnectXsdXmlQName getQName(XSDFeature xsdFeat) {
        String namespaceURI = xsdFeat.getTargetNamespace();
        String localPart = xsdFeat.getName();
        String prefix = "";
        boolean isXmlAttr = xsdFeat instanceof XSDAttributeDeclaration;
        if (xsdFeat.getSchema() != null) {
            Map pfx2tnsMap = xsdFeat.getSchema().getQNamePrefixToNamespaceMap();
            for (Map.Entry entry : pfx2tnsMap.entrySet()) {
                if (!((String)entry.getValue()).equals(namespaceURI)) continue;
                prefix = (String)entry.getKey();
                break;
            }
        }
        return new ZosConnectXsdXmlQName(namespaceURI, localPart, prefix, isXmlAttr);
    }

    public static int getMinOccurs(XSDElementDeclaration xsdEle) {
        int minOccurs = 1;
        if (xsdEle.eContainer() instanceof XSDParticle) {
            XSDParticle xsdPart = (XSDParticle)xsdEle.eContainer();
            minOccurs = xsdPart.getMinOccurs();
        }
        return minOccurs;
    }

    public static int getMaxOccurs(XSDElementDeclaration xsdEle) {
        int maxOccurs = 1;
        if (xsdEle.eContainer() instanceof XSDParticle) {
            XSDParticle xsdPart = (XSDParticle)xsdEle.eContainer();
            maxOccurs = xsdPart.getMaxOccurs();
        }
        return maxOccurs;
    }

    public static boolean isLeafElement(XSDElementDeclaration xsdEle) {
        XSDComplexTypeDefinition cType;
        XSDContentTypeCategory cTypeCon;
        boolean isLeafEle = false;
        XSDTypeDefinition type = xsdEle.getType();
        if (type instanceof XSDSimpleTypeDefinition) {
            isLeafEle = true;
        } else if (type instanceof XSDComplexTypeDefinition && ((cTypeCon = (cType = (XSDComplexTypeDefinition)type).getContentTypeCategory()).getValue() == 1 || cTypeCon.getValue() == 0)) {
            isLeafEle = true;
        }
        return isLeafEle;
    }

    public static boolean isCompositeElement(XSDElementDeclaration xsdEle) {
        XSDComplexTypeDefinition cType;
        XSDContentTypeCategory cTypeCon;
        boolean isCompositeEle = false;
        XSDTypeDefinition type = xsdEle.getType();
        if (type instanceof XSDComplexTypeDefinition && ((cTypeCon = (cType = (XSDComplexTypeDefinition)type).getContentTypeCategory()).getValue() == 3 || cTypeCon.getValue() == 2)) {
            isCompositeEle = true;
        }
        return isCompositeEle;
    }

    public static List<XSDComplexTypeDefinition> getAllComplexTypes(XSDComplexTypeDefinition complexType) {
        ArrayList<XSDComplexTypeDefinition> baseTypes = new ArrayList<XSDComplexTypeDefinition>();
        XSDTypeDefinition baseType = complexType.getBaseTypeDefinition();
        while (baseType != null && !ZosConnectXsdWalkerUtil.isOfTypeAnyType(baseType) && !baseType.isCircular()) {
            if (baseType instanceof XSDComplexTypeDefinition) {
                baseTypes.add(0, (XSDComplexTypeDefinition)baseType);
            }
            baseType = baseType.getBaseType();
        }
        baseTypes.add(complexType);
        return baseTypes;
    }

    public static ArrayList<XSDFeature> getPreOrderContentTree(XSDElementDeclaration xsdEle) throws Exception {
        ArrayList<XSDFeature> preorder = new ArrayList<XSDFeature>();
        Stack<XSDElementDeclaration> parents = new Stack<XSDElementDeclaration>();
        ZosConnectXsdWalkerUtil.getPreorderContentTree(xsdEle, parents, preorder);
        return preorder;
    }

    private static void getPreorderContentTree(XSDElementDeclaration currEle, Stack<XSDElementDeclaration> parents, ArrayList<XSDFeature> preorder) throws Exception {
        if (currEle.isElementDeclarationReference()) {
            currEle = currEle.getResolvedElementDeclaration();
        }
        ZosConnectXsdWalkerUtil.getPreorderContentTree_popParentElementStack(parents, currEle);
        if (ZosConnectXsdWalkerUtil.isCompositeElement(currEle)) {
            parents.push(currEle);
        }
        preorder.add((XSDFeature)currEle);
        XSDTypeDefinition currType = currEle.getType();
        if (currType instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition currComplexType = (XSDComplexTypeDefinition)currType;
            XSDWildcard anyAtt = currComplexType.getAttributeWildcard();
            if (anyAtt != null) {
                String typeName = IZosConnectXsdSimpleTypes.XSD_TNS_PFX + "anyAttribute";
                String eleName = currEle.getTargetNamespace() + ":" + currEle.getName();
                throw new Exception("ERROR_XSD_UNSUPPORTED_XSD_WILDCARD");
            }
            EList attrUses = currComplexType.getAttributeUses();
            for (XSDAttributeUse attrUse : attrUses) {
                XSDAttributeDeclaration attr = attrUse.getAttributeDeclaration();
                if (attr == null) continue;
                preorder.add((XSDFeature)attr);
            }
            List<XSDComplexTypeDefinition> allComplexTypes = ZosConnectXsdWalkerUtil.getAllComplexTypes(currComplexType);
            for (XSDComplexTypeDefinition nextComplexType : allComplexTypes) {
                XSDParticle particle;
                ArrayList<XSDParticle> allParticles = new ArrayList<XSDParticle>();
                if (nextComplexType.getContent() instanceof XSDParticle && (particle = (XSDParticle)nextComplexType.getContent()).getContent() instanceof XSDModelGroup) {
                    XSDModelGroup modelGroup = (XSDModelGroup)particle.getContent();
                    ZosConnectXsdWalkerUtil.getPreorderContentTree_getAllParticles(modelGroup, allParticles);
                }
                for (XSDParticle nextParticle : allParticles) {
                    XSDParticleContent particleContent = nextParticle.getContent();
                    if (particleContent != null && particleContent instanceof XSDElementDeclaration) {
                        XSDElementDeclaration childEle = (XSDElementDeclaration)particleContent;
                        if (childEle.isElementDeclarationReference()) {
                            childEle = childEle.getResolvedElementDeclaration();
                        }
                        currType = childEle.getType();
                        if (ZosConnectXsdWalkerUtil.isCompositeElement(childEle)) {
                            boolean isRecursive = false;
                            int i = 0;
                            while (i < parents.size() && !isRecursive) {
                                if (ZosConnectXsdWalkerUtil.haveSameType((XSDElementDeclaration)parents.get(i), childEle)) {
                                    isRecursive = true;
                                }
                                ++i;
                            }
                            if (isRecursive) {
                                String typeName = currType.getTargetNamespace() + ":" + currType.getName();
                                String eleName = currEle.getTargetNamespace() + ":" + currEle.getName();
                                throw new Exception("ERROR_XSD_COMPLEX_TYPE_RECURSION");
                            }
                        }
                        ZosConnectXsdWalkerUtil.getPreorderContentTree(childEle, parents, preorder);
                        continue;
                    }
                    if (particleContent == null || !(particleContent instanceof XSDWildcard)) continue;
                    String typeName = IZosConnectXsdSimpleTypes.XSD_TNS_PFX + "any";
                    String eleName = currEle.getTargetNamespace() + ":" + currEle.getName();
                    throw new Exception("ERROR_XSD_UNSUPPORTED_XSD_WILDCARD");
                }
                ZosConnectXsdWalkerUtil.getPreorderContentTree_popParentElementStack(parents, currEle);
            }
        }
    }

    private static void getPreorderContentTree_popParentElementStack(Stack<XSDElementDeclaration> parentElementStack, XSDElementDeclaration childElement) {
        boolean popping = true;
        while (popping && !parentElementStack.isEmpty()) {
            XSDElementDeclaration parentElement = parentElementStack.peek();
            if (!ZosConnectXsdWalkerUtil.isContainedByElement(parentElement, childElement)) {
                parentElementStack.pop();
                continue;
            }
            popping = false;
        }
    }

    private static void getPreorderContentTree_getAllParticles(XSDModelGroup modelGroup, List<XSDParticle> allParts) {
        for (XSDParticle particle : modelGroup.getParticles()) {
            if (particle.getContent() instanceof XSDModelGroup) {
                XSDModelGroup nestedModelGroup = (XSDModelGroup)particle.getContent();
                ZosConnectXsdWalkerUtil.getPreorderContentTree_getAllParticles(nestedModelGroup, allParts);
                continue;
            }
            allParts.add(particle);
        }
    }
}

