/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util.xsd.walker;

import com.ibm.zosconnect.ui.common.exceptions.ZosConnectStopWalkException;
import com.ibm.zosconnect.ui.common.util.xsd.walker.IZosConnectXsdVisitor;
import com.ibm.zosconnect.ui.common.util.xsd.walker.IZosConnectXsdWalker;
import com.ibm.zosconnect.ui.common.util.xsd.walker.ZosConnectXsdWalkerUtil;
import com.ibm.zosconnect.ui.common.util.xsd.walker.ZosConnectXsdXmlXPath;
import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class ZosConnectXsdWalker
implements IZosConnectXsdWalker {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private XSDElementDeclaration globalElement = null;
    private ArrayList<XSDFeature> rootElementContents = null;
    private XSDElementDeclaration currentElement = null;
    private XSDTypeDefinition currentElementType = null;
    private XSDAttributeDeclaration currentAttribute = null;
    private XSDSimpleTypeDefinition currentAttributeType = null;
    private Stack<XSDElementDeclaration> parentElements = new Stack();
    private ZosConnectXsdXmlXPath currentXPath = new ZosConnectXsdXmlXPath();

    private ZosConnectXsdWalker() {
    }

    public ZosConnectXsdWalker(XSDElementDeclaration globalElement) {
        this.globalElement = globalElement;
    }

    @Override
    public void accept(IZosConnectXsdVisitor visitor) throws Exception {
        try {
            if (this.rootElementContents == null) {
                this.rootElementContents = ZosConnectXsdWalkerUtil.getPreOrderContentTree(this.globalElement);
            }
            visitor.startOfWalk(this.globalElement);
            for (XSDFeature xsdFeat : this.rootElementContents) {
                if (xsdFeat instanceof XSDElementDeclaration) {
                    ArrayList<XSDAttributeDeclaration> xsdAtts;
                    XSDComplexTypeDefinition compType;
                    this.currentElement = (XSDElementDeclaration)xsdFeat;
                    this.currentElementType = this.currentElement.getType();
                    boolean popping = true;
                    while (popping && !this.parentElements.isEmpty()) {
                        XSDElementDeclaration parentElement = this.parentElements.peek();
                        if (!ZosConnectXsdWalkerUtil.isContainedByElement(parentElement, this.currentElement)) {
                            this.parentElements.pop();
                            this.currentXPath.pop();
                            continue;
                        }
                        popping = false;
                    }
                    int minOccurs = ZosConnectXsdWalkerUtil.getMinOccurs(this.currentElement);
                    int maxOccurs = ZosConnectXsdWalkerUtil.getMaxOccurs(this.currentElement);
                    if (ZosConnectXsdWalkerUtil.isLeafElement(this.currentElement)) {
                        this.currentXPath.push(ZosConnectXsdWalkerUtil.getQName((XSDFeature)this.currentElement));
                        if (this.currentElementType instanceof XSDSimpleTypeDefinition) {
                            XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)this.currentElementType;
                            visitor.visitLeafElement(this.currentXPath.clone(), this.currentElement, simpleType, minOccurs, maxOccurs);
                            this.currentXPath.pop();
                            continue;
                        }
                        if (!(this.currentElementType instanceof XSDComplexTypeDefinition)) continue;
                        compType = (XSDComplexTypeDefinition)this.currentElementType;
                        xsdAtts = ZosConnectXsdWalkerUtil.getAttributeDeclarations(this.currentElement);
                        visitor.visitLeafElement(this.currentXPath.clone(), this.currentElement, compType, minOccurs, maxOccurs, xsdAtts);
                        this.parentElements.push(this.currentElement);
                        continue;
                    }
                    if (!ZosConnectXsdWalkerUtil.isCompositeElement(this.currentElement)) continue;
                    this.currentXPath.push(ZosConnectXsdWalkerUtil.getQName((XSDFeature)this.currentElement));
                    compType = (XSDComplexTypeDefinition)this.currentElementType;
                    xsdAtts = ZosConnectXsdWalkerUtil.getAttributeDeclarations(this.currentElement);
                    visitor.visitCompositeElement(this.currentXPath.clone(), this.currentElement, compType, minOccurs, maxOccurs, xsdAtts);
                    this.parentElements.push(this.currentElement);
                    continue;
                }
                if (!(xsdFeat instanceof XSDAttributeDeclaration)) continue;
                this.currentAttribute = (XSDAttributeDeclaration)xsdFeat;
                this.currentAttributeType = (XSDSimpleTypeDefinition)this.currentAttribute.getType();
                this.currentXPath.push(ZosConnectXsdWalkerUtil.getQName((XSDFeature)this.currentAttribute));
                if (ZosConnectXsdWalkerUtil.isLeafElement(this.currentElement)) {
                    visitor.visitLeafElementAttribute(this.currentXPath.clone(), this.currentElement, this.currentAttribute, this.currentAttributeType);
                } else if (ZosConnectXsdWalkerUtil.isCompositeElement(this.currentElement)) {
                    visitor.visitCompositeElementAttribute(this.currentXPath.clone(), this.currentElement, this.currentAttribute, this.currentAttributeType);
                }
                this.currentXPath.pop();
            }
            visitor.endOfWalk(this.globalElement);
        }
        catch (ZosConnectStopWalkException zosConnectStopWalkException) {
            // empty catch block
        }
    }
}

