/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util.xsd;

import com.ibm.zosconnect.api.mapping.annotations.ArrayFormat;
import com.ibm.zosconnect.api.mapping.annotations.ZosConnectMappingAnnotations;
import com.ibm.zosconnect.api.mapping.jsd.JsonSchemaPrimitiveType;
import com.ibm.zosconnect.api.mapping.jsd.JsonSchemaPrimitiveTypeFormat;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.util.xsd.IZosConnectXsdSimpleTypes;
import com.ibm.zosconnect.ui.common.util.xsd.ZosConnectXsdSimpleTypes;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.w3c.dom.Element;

public class ZosConnectXsdUtil {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static IZosConnectXsdSimpleTypes xsdSimpleTypes = ZosConnectXsdSimpleTypes.getInstance();

    public static boolean isJsonInputTns(String tns) {
        boolean retVal = false;
        if (StringUtils.startsWith((CharSequence)tns, (CharSequence)"http://www.ibm.com/zosConnect/2.0/mapping/JSON/input/")) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean hasJsonInputTns(XSDElementDeclaration element) {
        boolean retVal = false;
        if (element != null) {
            String tns = "";
            tns = StringUtils.isBlank((CharSequence)element.getTargetNamespace()) ? element.getSchema().getTargetNamespace() : element.getTargetNamespace();
            retVal = ZosConnectXsdUtil.isJsonInputTns(tns);
        }
        return retVal;
    }

    public static boolean isJsonOutputTns(String tns) {
        boolean retVal = false;
        if (StringUtils.startsWith((CharSequence)tns, (CharSequence)"http://www.ibm.com/zosConnect/2.0/mapping/JSON/output/")) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean hasJsonOutputTns(XSDElementDeclaration element) {
        boolean retVal = false;
        if (element != null) {
            String tns = "";
            tns = StringUtils.isBlank((CharSequence)element.getTargetNamespace()) ? element.getSchema().getTargetNamespace() : element.getTargetNamespace();
            retVal = ZosConnectXsdUtil.isJsonOutputTns(tns);
        }
        return retVal;
    }

    public static boolean isHttpInputTns(String tns) {
        boolean retVal = false;
        if (StringUtils.startsWith((CharSequence)tns, (CharSequence)"http://www.ibm.com/zosConnect/2.0/mapping/HTTP/input/")) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isHttpOutputTns(String tns) {
        boolean retVal = false;
        if (StringUtils.startsWith((CharSequence)tns, (CharSequence)"http://www.ibm.com/zosConnect/2.0/mapping/HTTP/output/")) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isHttpInputHeadersGroup(XSDElementDeclaration ele) {
        boolean retVal = false;
        if (ele != null && StringUtils.equals((CharSequence)ele.getName(), (CharSequence)"Headers") && StringUtils.equals((CharSequence)ele.getType().getName(), (CharSequence)"HeadersType") && StringUtils.startsWith((CharSequence)ele.getType().getTargetNamespace(), (CharSequence)"http://www.ibm.com/zosConnect/2.0/mapping/HTTP/input/")) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isHttpOutputHeadersGroup(XSDElementDeclaration ele) {
        boolean retVal = false;
        if (ele != null && StringUtils.equals((CharSequence)ele.getName(), (CharSequence)"Headers") && StringUtils.equals((CharSequence)ele.getType().getName(), (CharSequence)"HeadersType") && StringUtils.startsWith((CharSequence)ele.getType().getTargetNamespace(), (CharSequence)"http://www.ibm.com/zosConnect/2.0/mapping/HTTP/output/")) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isHttpInputQueryParametersGroup(XSDElementDeclaration ele) {
        boolean retVal = false;
        if (ele != null && StringUtils.equals((CharSequence)ele.getName(), (CharSequence)"QueryParameters") && StringUtils.equals((CharSequence)ele.getType().getName(), (CharSequence)"QueryParametersType") && StringUtils.startsWith((CharSequence)ele.getType().getTargetNamespace(), (CharSequence)"http://www.ibm.com/zosConnect/2.0/mapping/HTTP/input/")) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isHttpInputPathParametersGroup(XSDElementDeclaration ele) {
        boolean retVal = false;
        if (ele != null && StringUtils.equals((CharSequence)ele.getName(), (CharSequence)"PathParameters") && StringUtils.equals((CharSequence)ele.getType().getName(), (CharSequence)"PathParametersType") && StringUtils.startsWith((CharSequence)ele.getType().getTargetNamespace(), (CharSequence)"http://www.ibm.com/zosConnect/2.0/mapping/HTTP/input/")) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isHttpParametersGroup(XSDElementDeclaration ele) {
        boolean retVal = false;
        if (ZosConnectXsdUtil.isHttpInputHeadersGroup(ele)) {
            retVal = true;
        } else if (ZosConnectXsdUtil.isHttpInputPathParametersGroup(ele)) {
            retVal = true;
        } else if (ZosConnectXsdUtil.isHttpInputQueryParametersGroup(ele)) {
            retVal = true;
        } else if (ZosConnectXsdUtil.isHttpOutputHeadersGroup(ele)) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isHttpRequestGroup(XSDElementDeclaration ele) {
        boolean retVal = false;
        if (ele != null && StringUtils.equals((CharSequence)ele.getName(), (CharSequence)"HTTPRequest") && StringUtils.equals((CharSequence)ele.getType().getName(), (CharSequence)"HTTPRequestType") && StringUtils.startsWith((CharSequence)ele.getType().getTargetNamespace(), (CharSequence)"http://www.ibm.com/zosConnect/2.0/mapping/HTTP/input/")) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isHttpResponseGroup(XSDElementDeclaration ele) {
        boolean retVal = false;
        if (ele != null && StringUtils.equals((CharSequence)ele.getName(), (CharSequence)"HTTPResponse") && StringUtils.equals((CharSequence)ele.getType().getName(), (CharSequence)"HTTPResponseType") && StringUtils.startsWith((CharSequence)ele.getType().getTargetNamespace(), (CharSequence)"http://www.ibm.com/zosConnect/2.0/mapping/HTTP/output/")) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isHttpInputBody(XSDElementDeclaration ele) {
        boolean retVal = false;
        if (ele != null && StringUtils.equals((CharSequence)ele.getName(), (CharSequence)"Body") && StringUtils.equals((CharSequence)ele.getType().getName(), (CharSequence)"BodyType") && StringUtils.startsWith((CharSequence)ele.getType().getTargetNamespace(), (CharSequence)"http://www.ibm.com/zosConnect/2.0/mapping/HTTP/input/")) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isHttpOutputBody(XSDElementDeclaration ele) {
        boolean retVal = false;
        if (ele != null && StringUtils.equals((CharSequence)ele.getName(), (CharSequence)"Body") && StringUtils.equals((CharSequence)ele.getType().getName(), (CharSequence)"BodyType") && StringUtils.startsWith((CharSequence)ele.getType().getTargetNamespace(), (CharSequence)"http://www.ibm.com/zosConnect/2.0/mapping/HTTP/output/")) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isHttpInputOrOutputBody(XSDElementDeclaration ele) {
        boolean retVal = false;
        if (ZosConnectXsdUtil.isHttpInputBody(ele)) {
            retVal = true;
        } else if (ZosConnectXsdUtil.isHttpOutputBody(ele)) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isArrayElement(XSDElementDeclaration element) {
        int max;
        XSDParticle particle;
        boolean result = false;
        if (element != null && element.eContainer() instanceof XSDParticle && (particle = (XSDParticle)element.eContainer()).isSetMaxOccurs() && ((max = particle.getMaxOccurs()) > 1 || max == -1)) {
            result = true;
        }
        return result;
    }

    public static boolean isComplexElement(XSDElementDeclaration ele) {
        boolean retVal = false;
        if (ele != null && ele.getTypeDefinition() instanceof XSDComplexTypeDefinition) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isSimpleElement(XSDElementDeclaration ele) {
        boolean retVal = false;
        if (ele != null && ele.getTypeDefinition() instanceof XSDSimpleTypeDefinition) {
            retVal = true;
        }
        return retVal;
    }

    public static String stripTnsPrefix(String qualifiedName) {
        String retVal = "";
        if (!StringUtils.isBlank((CharSequence)qualifiedName)) {
            int colon = qualifiedName.lastIndexOf(":");
            retVal = colon != -1 ? StringUtils.substring((String)qualifiedName, (int)(colon + 1)) : qualifiedName;
        }
        return retVal;
    }

    public static String getBuiltInOrDerivedTypeName(XSDSimpleTypeDefinition simpleType) {
        String retVal = simpleType.getName();
        int simpleTypeId = xsdSimpleTypes.getBuiltInOrDerivedTypeID(simpleType);
        String simpleTypeName = xsdSimpleTypes.getBuiltInOrDerivedTypeName(simpleTypeId);
        if (!StringUtils.isBlank((CharSequence)simpleTypeName)) {
            retVal = simpleTypeName;
        }
        return retVal;
    }

    public static boolean isRequired(XSDComponent component) {
        boolean result = true;
        if (component != null) {
            result = ZosConnectXsdUtil.getMinOccurs(component) > 0;
        }
        return result;
    }

    public static boolean isArray(XSDComponent component) {
        boolean result = true;
        if (component != null) {
            int maxOccurs = ZosConnectXsdUtil.getMaxOccurs((EObject)component);
            result = maxOccurs > 1 || maxOccurs == -1;
        }
        return result;
    }

    public static int getMinOccurs(XSDComponent component) {
        if (component != null) {
            if (component.eContainer() instanceof XSDAttributeUse) {
                return ((XSDAttributeUse)component.eContainer()).getUse() == XSDAttributeUseCategory.REQUIRED_LITERAL ? 1 : 0;
            }
            if (component.eContainer() instanceof XSDParticle) {
                XSDParticle particle = (XSDParticle)component.eContainer();
                int min = 1;
                if (particle.isSetMinOccurs()) {
                    min = particle.getMinOccurs();
                }
                return min;
            }
            if (component instanceof XSDAttributeDeclaration) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public static int getMaxOccurs(EObject eobject) {
        int max = 1;
        if (eobject instanceof XSDComponent) {
            if (!(eobject.eContainer() instanceof XSDParticle)) {
                if (eobject instanceof XSDWildcard) {
                    return 1;
                }
                return max;
            }
            XSDParticle particle = (XSDParticle)eobject.eContainer();
            if (particle.isSetMaxOccurs()) {
                max = particle.getMaxOccurs();
            }
        }
        return max;
    }

    public static void setAppInfoAttVal(XSDElementDeclaration element, String name, String value, String source) {
        EList appInfoList;
        XSDAnnotation xsdAnnot = element.getAnnotation();
        if (xsdAnnot == null) {
            xsdAnnot = XSDFactory.eINSTANCE.createXSDAnnotation();
            element.setAnnotation(xsdAnnot);
        }
        if ((appInfoList = xsdAnnot.getApplicationInformation(source)).isEmpty()) {
            Element appInfo = xsdAnnot.createApplicationInformation(source);
            appInfo.setAttribute(name, value);
            xsdAnnot.getElement().appendChild(appInfo);
        } else {
            Element appInfo = (Element)appInfoList.get(0);
            appInfo.setAttribute(name, value);
            xsdAnnot.getElement().appendChild(appInfo);
        }
        element.updateElement();
    }

    public static void removeAppInfoAtt(XSDElementDeclaration element, String name, String source) {
        EList appInfoList;
        XSDAnnotation xsdAnnot = element.getAnnotation();
        if (xsdAnnot == null) {
            xsdAnnot = XSDFactory.eINSTANCE.createXSDAnnotation();
            element.setAnnotation(xsdAnnot);
        }
        if (!(appInfoList = xsdAnnot.getApplicationInformation(source)).isEmpty()) {
            Element appInfo = (Element)appInfoList.get(0);
            appInfo.removeAttribute(name);
        }
        if (appInfoList.size() == 1) {
            element.setAnnotation(null);
        }
        element.updateElement();
    }

    public static String getAppInfoAttVal(XSDElementDeclaration element, String name, String source) {
        EList appInfoList;
        String attVal = "";
        XSDAnnotation xsdAnnot = element.getAnnotation();
        if (xsdAnnot != null && !(appInfoList = xsdAnnot.getApplicationInformation(source)).isEmpty()) {
            Element appInfo = (Element)appInfoList.get(0);
            attVal = appInfo.getAttribute(name);
        }
        return attVal;
    }

    public static ArrayFormat getArrayFormatAppInfo(XSDElementDeclaration element) {
        ArrayFormat arrayFormat = null;
        String arrayFormatStr = ZosConnectXsdUtil.getAppInfoAttVal(element, ZosConnectMappingAnnotations.ARRAY_FORMAT.value(), "http://www.ibm.com/zosConnect/2.0/mapping/TypeInfo");
        if (StringUtils.isNotBlank((CharSequence)arrayFormatStr)) {
            arrayFormat = ArrayFormat.fromValue((String)arrayFormatStr);
        }
        return arrayFormat;
    }

    public static void setArrayFormatAppInfo(XSDElementDeclaration element, ArrayFormat arrayFormat) {
        if (arrayFormat == null) {
            ZosConnectXsdUtil.removeArrayFormatAppInfo(element);
        } else {
            ZosConnectXsdUtil.setAppInfoAttVal(element, ZosConnectMappingAnnotations.ARRAY_FORMAT.value(), arrayFormat.value(), "http://www.ibm.com/zosConnect/2.0/mapping/TypeInfo");
        }
    }

    public static void removeArrayFormatAppInfo(XSDElementDeclaration element) {
        ZosConnectXsdUtil.removeAppInfoAtt(element, ZosConnectMappingAnnotations.ARRAY_FORMAT.value(), "http://www.ibm.com/zosConnect/2.0/mapping/TypeInfo");
    }

    public static JsonSchemaPrimitiveTypeFormat getJsonSchemaPrimitiveTypeFormatAppInfo(XSDElementDeclaration element) {
        JsonSchemaPrimitiveTypeFormat jsonTypeFormat = null;
        String jsonTypeFormatStr = ZosConnectXsdUtil.getAppInfoAttVal(element, ZosConnectMappingAnnotations.JSON_SCHEMA_PRIMITIVE_TYPE_FORMAT.value(), "http://www.ibm.com/zosConnect/2.0/mapping/TypeInfo");
        if (StringUtils.isNotBlank((CharSequence)jsonTypeFormatStr)) {
            jsonTypeFormat = JsonSchemaPrimitiveTypeFormat.fromValue((String)jsonTypeFormatStr);
        }
        return jsonTypeFormat;
    }

    public static void setJsonSchemaPrimitiveTypeFormatAppInfo(XSDElementDeclaration element, JsonSchemaPrimitiveTypeFormat jsonTypeFormat) {
        if (jsonTypeFormat == null) {
            ZosConnectXsdUtil.removeJsonSchemaPrimitiveTypeFormatAppInfo(element);
        } else {
            ZosConnectXsdUtil.setAppInfoAttVal(element, ZosConnectMappingAnnotations.JSON_SCHEMA_PRIMITIVE_TYPE_FORMAT.value(), jsonTypeFormat.value(), "http://www.ibm.com/zosConnect/2.0/mapping/TypeInfo");
        }
    }

    public static void removeJsonSchemaPrimitiveTypeFormatAppInfo(XSDElementDeclaration element) {
        ZosConnectXsdUtil.removeAppInfoAtt(element, ZosConnectMappingAnnotations.JSON_SCHEMA_PRIMITIVE_TYPE_FORMAT.value(), "http://www.ibm.com/zosConnect/2.0/mapping/TypeInfo");
    }

    public static JsonSchemaPrimitiveType getJsonSchemaPrimitiveTypeAppInfo(XSDElementDeclaration element) {
        JsonSchemaPrimitiveType jsonType = null;
        String jsonTypeStr = ZosConnectXsdUtil.getAppInfoAttVal(element, ZosConnectMappingAnnotations.JSON_SCHEMA_PRIMITIVE_TYPE.value(), "http://www.ibm.com/zosConnect/2.0/mapping/TypeInfo");
        if (StringUtils.isNotBlank((CharSequence)jsonTypeStr)) {
            jsonType = JsonSchemaPrimitiveType.fromValue((String)jsonTypeStr);
        }
        return jsonType;
    }

    public static void setJsonSchemaPrimitiveTypeAppInfo(XSDElementDeclaration element, JsonSchemaPrimitiveType jsonType) {
        if (jsonType == null) {
            ZosConnectXsdUtil.removeJsonSchemaPrimitiveTypeAppInfo(element);
        } else {
            ZosConnectXsdUtil.setAppInfoAttVal(element, ZosConnectMappingAnnotations.JSON_SCHEMA_PRIMITIVE_TYPE.value(), jsonType.value(), "http://www.ibm.com/zosConnect/2.0/mapping/TypeInfo");
        }
    }

    public static void removeJsonSchemaPrimitiveTypeAppInfo(XSDElementDeclaration element) {
        ZosConnectXsdUtil.removeAppInfoAtt(element, ZosConnectMappingAnnotations.JSON_SCHEMA_PRIMITIVE_TYPE.value(), "http://www.ibm.com/zosConnect/2.0/mapping/TypeInfo");
    }

    public static boolean isFirstEleInModelGroup(XSDElementDeclaration element) {
        XSDModelGroup modelGroup;
        EList modelGroupContents;
        XSDParticle elementPart;
        boolean retVal = false;
        if (element.eContainer() instanceof XSDParticle && (elementPart = (XSDParticle)element.eContainer()).eContainer() instanceof XSDModelGroup && ListUtilz.notEmpty(modelGroupContents = (modelGroup = (XSDModelGroup)elementPart.eContainer()).getContents()) && modelGroupContents.indexOf((Object)elementPart) == 0) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isLastEleInModelGroup(XSDElementDeclaration element) {
        XSDModelGroup modelGroup;
        EList modelGroupContents;
        XSDParticle elementPart;
        boolean retVal = false;
        if (element.eContainer() instanceof XSDParticle && (elementPart = (XSDParticle)element.eContainer()).eContainer() instanceof XSDModelGroup && ListUtilz.notEmpty(modelGroupContents = (modelGroup = (XSDModelGroup)elementPart.eContainer()).getContents())) {
            int modelGroupSize = modelGroupContents.size();
            if (modelGroupContents.indexOf((Object)elementPart) == modelGroupSize - 1) {
                retVal = true;
            }
        }
        return retVal;
    }
}

