/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util.xsd;

import com.ibm.zosconnect.ui.common.util.xsd.IZosConnectXsdSimpleTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class ZosConnectXsdSimpleTypes
implements IZosConnectXsdSimpleTypes {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static IZosConnectXsdSimpleTypes instance = null;
    private ArrayList<String> StringTypeGroup = null;
    private ArrayList<String> DecimalTypeGroup = null;
    private ArrayList<String> DateTimeTypeGroup = null;
    private ArrayList<String> FloatTypeGroup = null;
    private ArrayList<String> BinaryTypeGroup = null;
    private ArrayList<String> UriTypeGroup = null;
    private ArrayList<String> OtherTypeGroup = null;
    private HashMap<String, Integer> typeName2IdMap = new HashMap();
    private HashMap<Integer, String> id2TypeNameMap = new HashMap();

    private ZosConnectXsdSimpleTypes() {
        this.doLoadStringTypeGroup();
        this.doLoadDecimalTypeGroup();
        this.doLoadDateTimeTypeGroup();
        this.doLoadBinaryTypeGroup();
        this.doLoadFloatTypeGroup();
        this.doLoadUriTypeGroup();
        this.doLoadOtherTypeGroup();
    }

    public static IZosConnectXsdSimpleTypes getInstance() {
        if (instance == null) {
            instance = new ZosConnectXsdSimpleTypes();
        }
        return instance;
    }

    private void doLoadStringTypeGroup() {
        this.StringTypeGroup = new ArrayList();
        this.StringTypeGroup.add(XSD_PRIMITIVE_string);
        this.typeName2IdMap.put(XSD_PRIMITIVE_string, 1);
        this.id2TypeNameMap.put(1, XSD_PRIMITIVE_string);
        this.StringTypeGroup.add(XSD_DERIVED_normalizedString);
        this.typeName2IdMap.put(XSD_DERIVED_normalizedString, 20);
        this.id2TypeNameMap.put(20, XSD_DERIVED_normalizedString);
        this.StringTypeGroup.add(XSD_DERIVED_token);
        this.typeName2IdMap.put(XSD_DERIVED_token, 21);
        this.id2TypeNameMap.put(21, XSD_DERIVED_token);
        this.StringTypeGroup.add(XSD_DERIVED_language);
        this.typeName2IdMap.put(XSD_DERIVED_language, 22);
        this.id2TypeNameMap.put(22, XSD_DERIVED_language);
        this.StringTypeGroup.add(XSD_DERIVED_name);
        this.typeName2IdMap.put(XSD_DERIVED_name, 23);
        this.id2TypeNameMap.put(23, XSD_DERIVED_name);
        this.StringTypeGroup.add(XSD_DERIVED_NMTOKEN);
        this.typeName2IdMap.put(XSD_DERIVED_NMTOKEN, 24);
        this.id2TypeNameMap.put(24, XSD_DERIVED_NMTOKEN);
        this.StringTypeGroup.add(XSD_DERIVED_NMTOKENS);
        this.typeName2IdMap.put(XSD_DERIVED_NMTOKENS, 25);
        this.id2TypeNameMap.put(25, XSD_DERIVED_NMTOKENS);
        this.StringTypeGroup.add(XSD_DERIVED_NCName);
        this.typeName2IdMap.put(XSD_DERIVED_NCName, 26);
        this.id2TypeNameMap.put(26, XSD_DERIVED_NCName);
        this.StringTypeGroup.add(XSD_DERIVED_ID);
        this.typeName2IdMap.put(XSD_DERIVED_ID, 27);
        this.id2TypeNameMap.put(27, XSD_DERIVED_ID);
        this.StringTypeGroup.add(XSD_DERIVED_IDREF);
        this.typeName2IdMap.put(XSD_DERIVED_IDREF, 28);
        this.id2TypeNameMap.put(28, XSD_DERIVED_IDREF);
        this.StringTypeGroup.add(XSD_DERIVED_IDREFS);
        this.typeName2IdMap.put(XSD_DERIVED_IDREFS, 29);
        this.id2TypeNameMap.put(29, XSD_DERIVED_IDREFS);
        this.StringTypeGroup.add(XSD_DERIVED_ENTITY);
        this.typeName2IdMap.put(XSD_DERIVED_ENTITY, 30);
        this.id2TypeNameMap.put(30, XSD_DERIVED_ENTITY);
        this.StringTypeGroup.add(XSD_DERIVED_ENTITIES);
        this.typeName2IdMap.put(XSD_DERIVED_ENTITIES, 31);
        this.id2TypeNameMap.put(31, XSD_DERIVED_ENTITIES);
    }

    private void doLoadDecimalTypeGroup() {
        this.DecimalTypeGroup = new ArrayList();
        this.DecimalTypeGroup.add(XSD_PRIMITIVE_decimal);
        this.typeName2IdMap.put(XSD_PRIMITIVE_decimal, 2);
        this.id2TypeNameMap.put(2, XSD_PRIMITIVE_decimal);
        this.DecimalTypeGroup.add(XSD_DERIVED_integer);
        this.typeName2IdMap.put(XSD_DERIVED_integer, 32);
        this.id2TypeNameMap.put(32, XSD_DERIVED_integer);
        this.DecimalTypeGroup.add(XSD_DERIVED_nonPositiveInteger);
        this.typeName2IdMap.put(XSD_DERIVED_nonPositiveInteger, 33);
        this.id2TypeNameMap.put(33, XSD_DERIVED_nonPositiveInteger);
        this.DecimalTypeGroup.add(XSD_DERIVED_long);
        this.typeName2IdMap.put(XSD_DERIVED_long, 34);
        this.id2TypeNameMap.put(34, XSD_DERIVED_long);
        this.DecimalTypeGroup.add(XSD_DERIVED_nonNegativeInteger);
        this.typeName2IdMap.put(XSD_DERIVED_nonNegativeInteger, 35);
        this.id2TypeNameMap.put(35, XSD_DERIVED_nonNegativeInteger);
        this.DecimalTypeGroup.add(XSD_DERIVED_negativeInteger);
        this.typeName2IdMap.put(XSD_DERIVED_negativeInteger, 36);
        this.id2TypeNameMap.put(36, XSD_DERIVED_negativeInteger);
        this.DecimalTypeGroup.add(XSD_DERIVED_int);
        this.typeName2IdMap.put(XSD_DERIVED_int, 37);
        this.id2TypeNameMap.put(37, XSD_DERIVED_int);
        this.DecimalTypeGroup.add(XSD_DERIVED_unsignedLong);
        this.typeName2IdMap.put(XSD_DERIVED_unsignedLong, 38);
        this.id2TypeNameMap.put(38, XSD_DERIVED_unsignedLong);
        this.DecimalTypeGroup.add(XSD_DERIVED_positiveInteger);
        this.typeName2IdMap.put(XSD_DERIVED_positiveInteger, 39);
        this.id2TypeNameMap.put(39, XSD_DERIVED_positiveInteger);
        this.DecimalTypeGroup.add(XSD_DERIVED_short);
        this.typeName2IdMap.put(XSD_DERIVED_short, 40);
        this.id2TypeNameMap.put(40, XSD_DERIVED_short);
        this.DecimalTypeGroup.add(XSD_DERIVED_unsignedInt);
        this.typeName2IdMap.put(XSD_DERIVED_unsignedInt, 41);
        this.id2TypeNameMap.put(41, XSD_DERIVED_unsignedInt);
        this.DecimalTypeGroup.add(XSD_DERIVED_byte);
        this.typeName2IdMap.put(XSD_DERIVED_byte, 42);
        this.id2TypeNameMap.put(42, XSD_DERIVED_byte);
        this.DecimalTypeGroup.add(XSD_DERIVED_unsignedShort);
        this.typeName2IdMap.put(XSD_DERIVED_unsignedShort, 43);
        this.id2TypeNameMap.put(43, XSD_DERIVED_unsignedShort);
        this.DecimalTypeGroup.add(XSD_DERIVED_unsignedByte);
        this.typeName2IdMap.put(XSD_DERIVED_unsignedByte, 44);
        this.id2TypeNameMap.put(44, XSD_DERIVED_unsignedByte);
    }

    private void doLoadDateTimeTypeGroup() {
        this.DateTimeTypeGroup = new ArrayList();
        this.DateTimeTypeGroup.add(XSD_PRIMITIVE_duration);
        this.typeName2IdMap.put(XSD_PRIMITIVE_duration, 3);
        this.id2TypeNameMap.put(3, XSD_PRIMITIVE_duration);
        this.DateTimeTypeGroup.add(XSD_PRIMITIVE_dateTime);
        this.typeName2IdMap.put(XSD_PRIMITIVE_dateTime, 4);
        this.id2TypeNameMap.put(4, XSD_PRIMITIVE_dateTime);
        this.DateTimeTypeGroup.add(XSD_PRIMITIVE_time);
        this.typeName2IdMap.put(XSD_PRIMITIVE_time, 5);
        this.id2TypeNameMap.put(5, XSD_PRIMITIVE_time);
        this.DateTimeTypeGroup.add(XSD_PRIMITIVE_date);
        this.typeName2IdMap.put(XSD_PRIMITIVE_date, 6);
        this.id2TypeNameMap.put(6, XSD_PRIMITIVE_date);
        this.DateTimeTypeGroup.add(XSD_PRIMITIVE_gYearMonth);
        this.typeName2IdMap.put(XSD_PRIMITIVE_gYearMonth, 7);
        this.id2TypeNameMap.put(7, XSD_PRIMITIVE_gYearMonth);
        this.DateTimeTypeGroup.add(XSD_PRIMITIVE_gYear);
        this.typeName2IdMap.put(XSD_PRIMITIVE_gYear, 8);
        this.id2TypeNameMap.put(8, XSD_PRIMITIVE_gYear);
        this.DateTimeTypeGroup.add(XSD_PRIMITIVE_gMonthDay);
        this.typeName2IdMap.put(XSD_PRIMITIVE_gMonthDay, 9);
        this.id2TypeNameMap.put(9, XSD_PRIMITIVE_gMonthDay);
        this.DateTimeTypeGroup.add(XSD_PRIMITIVE_gDay);
        this.typeName2IdMap.put(XSD_PRIMITIVE_gDay, 10);
        this.id2TypeNameMap.put(10, XSD_PRIMITIVE_gDay);
        this.DateTimeTypeGroup.add(XSD_PRIMITIVE_gMonth);
        this.typeName2IdMap.put(XSD_PRIMITIVE_gMonth, 11);
        this.id2TypeNameMap.put(11, XSD_PRIMITIVE_gMonth);
    }

    private void doLoadFloatTypeGroup() {
        this.FloatTypeGroup = new ArrayList();
        this.FloatTypeGroup.add(XSD_PRIMITIVE_float);
        this.typeName2IdMap.put(XSD_PRIMITIVE_float, 15);
        this.id2TypeNameMap.put(15, XSD_PRIMITIVE_float);
        this.FloatTypeGroup.add(XSD_PRIMITIVE_double);
        this.typeName2IdMap.put(XSD_PRIMITIVE_double, 16);
        this.id2TypeNameMap.put(16, XSD_PRIMITIVE_double);
    }

    private void doLoadBinaryTypeGroup() {
        this.BinaryTypeGroup = new ArrayList();
        this.BinaryTypeGroup.add(XSD_PRIMITIVE_base64Binary);
        this.typeName2IdMap.put(XSD_PRIMITIVE_base64Binary, 13);
        this.id2TypeNameMap.put(13, XSD_PRIMITIVE_base64Binary);
        this.BinaryTypeGroup.add(XSD_PRIMITIVE_hexBinary);
        this.typeName2IdMap.put(XSD_PRIMITIVE_hexBinary, 14);
        this.id2TypeNameMap.put(14, XSD_PRIMITIVE_hexBinary);
    }

    private void doLoadUriTypeGroup() {
        this.UriTypeGroup = new ArrayList();
        this.UriTypeGroup.add(XSD_PRIMITIVE_anyURI);
        this.typeName2IdMap.put(XSD_PRIMITIVE_anyURI, 17);
        this.id2TypeNameMap.put(17, XSD_PRIMITIVE_anyURI);
        this.UriTypeGroup.add(XSD_PRIMITIVE_QName);
        this.typeName2IdMap.put(XSD_PRIMITIVE_QName, 18);
        this.id2TypeNameMap.put(18, XSD_PRIMITIVE_QName);
    }

    private void doLoadOtherTypeGroup() {
        this.OtherTypeGroup = new ArrayList();
        this.OtherTypeGroup.add(XSD_PRIMITIVE_boolean);
        this.typeName2IdMap.put(XSD_PRIMITIVE_boolean, 12);
        this.id2TypeNameMap.put(12, XSD_PRIMITIVE_boolean);
        this.OtherTypeGroup.add(XSD_PRIMITIVE_NOTATION);
        this.typeName2IdMap.put(XSD_PRIMITIVE_NOTATION, 19);
        this.id2TypeNameMap.put(19, XSD_PRIMITIVE_NOTATION);
    }

    @Override
    public ArrayList<String> getStringTypeGroup() {
        return this.StringTypeGroup;
    }

    @Override
    public ArrayList<String> getDecimalTypeGroup() {
        return this.DecimalTypeGroup;
    }

    @Override
    public ArrayList<String> getDateTimeTypeGroup() {
        return this.DateTimeTypeGroup;
    }

    @Override
    public ArrayList<String> getFloatTypeGroup() {
        return this.FloatTypeGroup;
    }

    @Override
    public ArrayList<String> getBinaryTypeGroup() {
        return this.BinaryTypeGroup;
    }

    @Override
    public ArrayList<String> getUriTypeGroup() {
        return this.UriTypeGroup;
    }

    @Override
    public ArrayList<String> getOtherTypeGroup() {
        return this.OtherTypeGroup;
    }

    @Override
    public boolean isStringType(XSDSimpleTypeDefinition simpleType) {
        return this.isGroupMember(simpleType, this.StringTypeGroup);
    }

    @Override
    public boolean isDecimalType(XSDSimpleTypeDefinition simpleType) {
        return this.isGroupMember(simpleType, this.DecimalTypeGroup);
    }

    @Override
    public boolean isDateTimeType(XSDSimpleTypeDefinition simpleType) {
        return this.isGroupMember(simpleType, this.DateTimeTypeGroup);
    }

    @Override
    public boolean isBinaryType(XSDSimpleTypeDefinition simpleType) {
        return this.isGroupMember(simpleType, this.BinaryTypeGroup);
    }

    @Override
    public boolean isFloatType(XSDSimpleTypeDefinition simpleType) {
        return this.isGroupMember(simpleType, this.FloatTypeGroup);
    }

    @Override
    public boolean isUriType(XSDSimpleTypeDefinition simpleType) {
        return this.isGroupMember(simpleType, this.UriTypeGroup);
    }

    @Override
    public boolean isOtherType(XSDSimpleTypeDefinition simpleType) {
        return this.isGroupMember(simpleType, this.OtherTypeGroup);
    }

    @Override
    public int getBuiltInOrDerivedTypeID(XSDSimpleTypeDefinition simpleType) {
        Set<String> types = this.typeName2IdMap.keySet();
        XSDSimpleTypeDefinition descendType = simpleType;
        String typeName = descendType.getTargetNamespace() + ":" + descendType.getName();
        if (typeName.equals(XSD_ANY_SIMPLE_TYPE)) {
            return -1;
        }
        boolean foundBuiltInType = types.contains(typeName);
        while (!foundBuiltInType && descendType != null) {
            if ((descendType = descendType.getBaseTypeDefinition()) == null) {
                return -1;
            }
            typeName = descendType.getTargetNamespace() + ":" + descendType.getName();
            foundBuiltInType = types.contains(typeName);
        }
        Integer typeId = this.typeName2IdMap.get(typeName);
        return typeId == null ? -1 : typeId;
    }

    @Override
    public String getBuiltInOrDerivedTypeName(int typeID) {
        return this.id2TypeNameMap.get(typeID);
    }

    private boolean isGroupMember(XSDSimpleTypeDefinition simpleType, ArrayList<String> group) {
        int typeId = this.getBuiltInOrDerivedTypeID(simpleType);
        String typeName = this.getBuiltInOrDerivedTypeName(typeId);
        return group.contains(typeName);
    }
}

