/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util.xml;

import com.ibm.zosconnect.ui.common.util.xml.Xml10ValidateCharResult;
import java.util.stream.IntStream;

public class Xml10Validator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2023. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static Xml10ValidateCharResult validateChar(String xmlText, boolean isName) {
        Xml10ValidateCharResult result = new Xml10ValidateCharResult();
        result.setValid(true);
        if (xmlText != null && !xmlText.isEmpty()) {
            IntStream codePointStream = xmlText.codePoints();
            int[] codePoints = codePointStream.toArray();
            int cpIdx = 0;
            while (cpIdx < codePoints.length && result.isValid()) {
                int cp = codePoints[cpIdx];
                if (!(cp >= 32 && cp <= 55295 || cp >= 57344 && cp <= 65533 || cp >= 65536 && cp <= 0x10FFFF || cp == 9 && !isName || cp == 10 && !isName || cp == 13 && !isName)) {
                    result.setValid(false);
                    result.setCodePoint(cp);
                    result.setCodePointIndex(cpIdx);
                }
                ++cpIdx;
            }
        }
        return result;
    }

    public static String removeInvalidChar(String xmlText, boolean isName) {
        String result = xmlText;
        if (xmlText != null && !xmlText.isEmpty()) {
            StringBuilder sb = new StringBuilder(xmlText.length());
            IntStream codePointStream = xmlText.codePoints();
            int[] codePoints = codePointStream.toArray();
            int cpIdx = 0;
            while (cpIdx < codePoints.length) {
                int cp = codePoints[cpIdx];
                if (cp >= 32 && cp <= 55295 || cp >= 57344 && cp <= 65533 || cp >= 65536 && cp <= 0x10FFFF || cp == 9 && !isName || cp == 10 && !isName || cp == 13 && !isName) {
                    sb.append(Character.toChars(cp));
                }
                ++cpIdx;
            }
            result = sb.toString();
        }
        return result;
    }
}

