/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util.swt;

import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.swt.AbstractControlBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridDataBuilder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableItem;

public class TableComboBuilder
extends AbstractControlBuilder<TableCombo> {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String text;
    private String toolTipText;
    private List<String[]> items = new ArrayList<String[]>();
    private Boolean showTableHeader;
    private Boolean showTableLines;
    private Integer displayColumnIndex;
    private Integer columns;

    public TableComboBuilder text(String text) {
        this.text = text;
        return this;
    }

    public TableComboBuilder showTableHeader(Boolean showTableHeader) {
        this.showTableHeader = showTableHeader;
        return this;
    }

    public TableComboBuilder showTableLines(Boolean showTableLines) {
        this.showTableLines = showTableLines;
        return this;
    }

    public TableComboBuilder displayColumnIndex(int displayColumnIndex) {
        this.displayColumnIndex = displayColumnIndex;
        return this;
    }

    public TableComboBuilder columns(int columns) {
        this.columns = columns;
        return this;
    }

    public TableComboBuilder item(String[] item) {
        this.items.add(item);
        return this;
    }

    public TableComboBuilder items(List<String[]> items) {
        this.items.addAll(items);
        return this;
    }

    public TableComboBuilder toolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        return this;
    }

    @Override
    public TableCombo build(Composite parent) {
        TableCombo control = new TableCombo(parent, this.getStyle().intValue());
        GridDataBuilder gridDataBuilder = this.getGridDataBuilder();
        GridData gridData = gridDataBuilder.build();
        control.setLayoutData((Object)gridData);
        if (this.text != null) {
            control.setText(this.text);
        }
        if (this.toolTipText != null) {
            control.setToolTipText(this.toolTipText);
        }
        if (this.showTableHeader != null) {
            control.setShowTableHeader(this.showTableHeader.booleanValue());
        }
        if (this.showTableLines != null) {
            control.setShowTableLines(this.showTableLines.booleanValue());
        }
        if (this.displayColumnIndex != null) {
            control.setDisplayColumnIndex(this.displayColumnIndex.intValue());
        }
        if (this.columns != null) {
            control.defineColumns(this.columns.intValue());
        }
        for (String[] item : this.items) {
            TableItem tableItem = new TableItem(control.getTable(), 0);
            tableItem.setText(item);
            if (gridDataBuilder.isSetWidthHint()) continue;
            gridData.widthHint = Math.max(gridData.widthHint, XSwt.getTextExtent((Control)control, (double)1.33, (String[])item).x);
        }
        this.setCommonAttrs((Control)control, this);
        XSwt.addTabTraverseListener((Control)control);
        return control;
    }
}

