/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util.swt;

import com.ibm.zosconnect.ui.common.util.swt.AbstractWidgetBuilder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class MenuItemBuilder
extends AbstractWidgetBuilder<MenuItem> {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Image image;
    private String text;
    private List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();

    public MenuItemBuilder text(String text) {
        this.text = text;
        return this;
    }

    public MenuItemBuilder image(Image image) {
        this.image = image;
        return this;
    }

    public MenuItemBuilder listener(SelectionListener listener) {
        this.selectionListeners.add(listener);
        return this;
    }

    @Override
    public MenuItem build(Widget parent) {
        MenuItem item = new MenuItem((Menu)parent, this.getStyle().intValue());
        if (this.text != null) {
            item.setText(this.text);
        }
        if (this.image != null) {
            item.setImage(this.image);
        }
        for (SelectionListener listener : this.selectionListeners) {
            item.addSelectionListener(listener);
        }
        item.setEnabled(this.getEnabled().booleanValue());
        return item;
    }
}

