/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util.swt;

import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.swt.AbstractFormControlBuilder;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FormStyledTextBuilder
extends AbstractFormControlBuilder<StyledText> {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String text;
    private String toolTipText;
    private Integer leftMargin;
    private Integer rightMargin;

    public FormStyledTextBuilder(FormToolkit toolkit) {
        super(toolkit);
    }

    public FormStyledTextBuilder text(String text) {
        this.text = text;
        return this;
    }

    public FormStyledTextBuilder text(String text, String defaultText) {
        this.text = StringUtils.isNotBlank((CharSequence)text) ? text : defaultText;
        return this;
    }

    public FormStyledTextBuilder toolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        return this;
    }

    public FormStyledTextBuilder toolTipText(String toolTipText, String defaultToolTipText) {
        this.toolTipText = StringUtils.isNotBlank((CharSequence)toolTipText) ? toolTipText : defaultToolTipText;
        return this;
    }

    public FormStyledTextBuilder leftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
        return this;
    }

    public FormStyledTextBuilder rightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
        return this;
    }

    @Override
    public StyledText build(Composite parent) {
        StyledText control = new StyledText(parent, this.getStyle().intValue());
        GridData gridData = this.getGridDataBuilder().build();
        control.setLayoutData((Object)gridData);
        if (this.leftMargin != null) {
            control.setLeftMargin(this.leftMargin.intValue());
        }
        if (this.rightMargin != null) {
            control.setRightMargin(this.rightMargin.intValue());
        }
        if (this.text != null) {
            control.setText(this.text);
        }
        if (this.toolTipText != null) {
            control.setToolTipText(this.toolTipText);
        }
        this.getToolkit().adapt((Control)control, true, true);
        this.setCommonAttrs((Control)control, this);
        XSwt.addTabTraverseListener((Control)control);
        return control;
    }
}

