/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util.swt;

import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.swt.AbstractFormControlBuilder;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FormLabelBuilder
extends AbstractFormControlBuilder<Label> {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String text;
    private String toolTipText;
    private Image image;

    public FormLabelBuilder(FormToolkit toolkit) {
        super(toolkit);
    }

    public FormLabelBuilder text(String text) {
        this.text = text;
        return this;
    }

    public FormLabelBuilder text(Integer text) {
        this.text = String.valueOf(text);
        return this;
    }

    public FormLabelBuilder toolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        return this;
    }

    public FormLabelBuilder image(Image image) {
        this.image = image;
        return this;
    }

    @Override
    public Label build(Composite parent) {
        Label control = this.getToolkit().createLabel(parent, this.text == null ? "" : this.text, this.getStyle().intValue());
        GridData gridData = this.getGridDataBuilder().build();
        control.setLayoutData((Object)gridData);
        if (this.toolTipText != null) {
            control.setToolTipText(this.toolTipText);
        }
        if (this.image != null) {
            control.setImage(this.image);
        }
        control.setBackground(null);
        this.setCommonAttrs((Control)control, this);
        XSwt.addTabTraverseListener((Control)control);
        return control;
    }
}

