/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util.swt;

import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.swt.AbstractFormControlBuilder;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class FormImageHyperlinkBuilder
extends AbstractFormControlBuilder<ImageHyperlink> {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String text;
    private String toolTipText;
    private String href;
    private Image image;
    private Image hoverImage;

    public FormImageHyperlinkBuilder(FormToolkit toolkit) {
        super(toolkit);
    }

    public FormImageHyperlinkBuilder text(String text) {
        this.text = text;
        return this;
    }

    public FormImageHyperlinkBuilder toolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        return this;
    }

    public FormImageHyperlinkBuilder href(String href) {
        this.href = href;
        return this;
    }

    public FormImageHyperlinkBuilder image(Image image) {
        this.image = image;
        return this;
    }

    public FormImageHyperlinkBuilder hoverImage(Image hoverImage) {
        this.hoverImage = hoverImage;
        return this;
    }

    @Override
    public ImageHyperlink build(Composite parent) {
        ImageHyperlink control = this.getToolkit().createImageHyperlink(parent, this.getStyle().intValue());
        GridData gridData = this.getGridDataBuilder().build();
        control.setLayoutData((Object)gridData);
        if (this.text != null) {
            control.setText(this.text);
        }
        if (this.toolTipText != null) {
            control.setToolTipText(this.toolTipText);
        }
        if (this.href != null) {
            control.setHref((Object)this.href);
        }
        if (this.image != null) {
            control.setImage(this.image);
        }
        if (this.hoverImage != null) {
            control.setHoverImage(this.hoverImage);
        }
        control.setBackground(null);
        this.setCommonAttrs((Control)control, this);
        XSwt.addTabTraverseListener((Control)control);
        return control;
    }
}

